/*************************************************************************
 *
 *  $RCSfile: ipi_2s.cxx,v $
 *
 *  $Revision: 1.5.12.3 $
 *
 *  last change: $Author: mh $ $Date: 2003/01/30 20:06:19 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include <precomp.h>
#include "ipi_2s.hxx"


// NOT FULLY DEFINED SERVICES
#include <algorithm>
#include <string.h>
#include <ary/idl/i_enum.hxx>
#include <ary/idl/i_exception.hxx>
#include <ary/idl/i_function.hxx>
#include <ary/idl/i_interface.hxx>
#include <ary/idl/i_module.hxx>
#include <ary/idl/i_property.hxx>
#include <ary/idl/i_service.hxx>
#include <ary/idl/i_singleton.hxx>
#include <ary/idl/i_struct.hxx>
#include <ary/idl/i_structelem.hxx>
#include <ary/idl/i_typedef.hxx>
#include <store/st_access.hxx>
#include <namesort.hxx>
#include <nametreenode.hxx>
#include "i_nnfinder.hxx"
#include "is_ce.hxx"
#include "is_type.hxx"
#include "it_ce.hxx"
#include "it_explicit.hxx"
#include "it_sequence.hxx"
#include "it_xnameroom.hxx"


                         
namespace ary
{
namespace idl
{

inline Service *
SecondariesPilot_Inst::lhf_SearchService( Type_id i_nType )
{
    return store::search_access( my_CeStorage(), 
                                 lhf_Search_CeFromTypeId(i_nType), 
                                 T2T<Service>() );
}
        
inline Interface *
SecondariesPilot_Inst::lhf_SearchInterface( Type_id i_nType )
{
    return store::search_access( my_CeStorage(), 
                                 lhf_Search_CeFromTypeId(i_nType), 
                                 T2T<Interface>() );
}
        
inline Struct *
SecondariesPilot_Inst::lhf_SearchStruct( Type_id i_nType )
{
    return store::search_access( my_CeStorage(), 
                                 lhf_Search_CeFromTypeId(i_nType), 
                                 T2T<Struct>() );
}
        
inline Exception *
SecondariesPilot_Inst::lhf_SearchException( Type_id i_nType )
{
    return store::search_access( my_CeStorage(), 
                                 lhf_Search_CeFromTypeId(i_nType), 
                                 T2T<Exception>() );
}

inline const Ce_Storage &
SecondariesPilot_Inst::my_CeStorage() const
    { return *pCeStorage; }

inline const Type_Storage &
SecondariesPilot_Inst::my_TypeStorage() const
    { return *pTypeStorage; }

inline Ce_Storage &
SecondariesPilot_Inst::my_CeStorage()
    { return *pCeStorage; }

inline Type_Storage &
SecondariesPilot_Inst::my_TypeStorage()
    { return *pTypeStorage; }

SecondariesPilot_Inst::SecondariesPilot_Inst( Ce_Storage &      i_rCes,
                                              Type_Storage &    i_rTypes )
    :   pCeStorage(&i_rCes),
        pTypeStorage(&i_rTypes)
{
}

SecondariesPilot_Inst::~SecondariesPilot_Inst()
{
}

void
SecondariesPilot_Inst::do_Connect_Types2Ces()
{
    for ( store::RootFilterIterator<Type_Storage::unit, ExplicitType>
            it = my_TypeStorage().Container().Begin();
          it;
          ++it )
    {
        ExplicitType &
            rType = ref_cast((*it).Entity(), T2T<ExplicitType>());
        Ce_id
            nRelatedCe = lhf_Search_CeForType(rType);
        if (nRelatedCe.IsValid())
        {
            Ce_Type * pNew = new Ce_Type(nRelatedCe);
            pNew->Set_Id(rType.Id());
            (*it).Set_Entity(*pNew);
        }
    }   // end for
}

void
SecondariesPilot_Inst::do_Gather_CrossReferences()
{             
    gather_Synonyms();

    for ( store::RootIterator<Ce_Storage::unit>
            it = my_CeStorage().Container().Begin();
          it;
          ++it )
    {                                         
        (*it).Entity().Visit( static_cast<CeHost& >(*this) );
    }   // end for
    
    sort_All2s();
}

namespace
{       

enum E_LinkMode        
{
    link2descr,
    link2ref
};
   
}
    
    
void        
SecondariesPilot_Inst::do_Read_Links2DevManual( csv::bstream & i_file )
{
    StreamLock  aLine(300);
    StreamStr & rLine = aLine();

    
    String      sCurLink;
    String      sCurLinkUI;
    E_LinkMode  eCurMode = link2ref;
    
	int lineCount = 0;


    while (NOT i_file.eod())
    {   
		++lineCount;

        rLine.reset();
        rLine.operator_read_line(i_file);
                  
        if ( *rLine.c_str() >= 'a' )
        {
            assign_CurLink(rLine.begin(), sCurLink, sCurLinkUI, eCurMode == link2descr, lineCount);
        }
        else if ( strncmp(rLine.c_str(),"LINK:",5) == 0 )
        {
            sCurLink = rLine.c_str()+5;
            sCurLinkUI.clear();
        }
        else if ( strncmp(rLine.c_str(),"DESCR:",6) == 0 )
        {
            sCurLinkUI = rLine.c_str()+6;
        }
        else if ( strncmp(rLine.c_str(),"TOPIC:",6) == 0 )
        {
            eCurMode = link2descr;
        }
        else if ( strncmp(rLine.c_str(),"REF:",4) == 0 )
        {
            eCurMode = link2ref;
        }
        else if (*rLine.c_str() >= 32)
        {
            assign_CurLink(rLine.begin(), sCurLink, sCurLinkUI, eCurMode == link2descr, lineCount);
        }
    }   // end while                 
}
          

struct OrderCeIdsByName
{                   
                    OrderCeIdsByName(
                        const Ce_Storage::container &
                                                i_storage )
                                                : rStorage(i_storage),
                                                  aNameComparison() {}
                    
    bool            operator()(
                        Ce_id                   i_ce1,
                        Ce_id                   i_ce2 ) const
    {
        return aNameComparison( rStorage[i_ce1].Entity().LocalName(),
                                rStorage[i_ce2].Entity().LocalName() );
    }
                            
  private:
    const Ce_Storage::container &
                    rStorage;  
    CompareCeNames  aNameComparison;                    
};


const int C_nLowerUpperDiff = 'a'-'A';
                
void
SecondariesPilot_Inst::inq_Get_AlphabeticalIndex(
                            std::vector<Ce_id> &            o_rResult,
                            alphabetical_index::E_Letter    i_cLetter ) const
{                                  
    // Establishing filter:
    char filter[256];     
    
    int nLetter = i_cLetter;
    memset(filter, 0, 256);
    filter[i_cLetter] = 1;
    if ( i_cLetter != alphabetical_index::non_alpha )
        filter[int(i_cLetter) - C_nLowerUpperDiff] = 1;
                                                   
    // Gather entities which start with i_cLetter:
    o_rResult.reserve(1000);
    typedef store::RootConstIterator<Ce_Storage::unit>     Iter;
    for ( Iter it = my_CeStorage().Container().Begin();
          it;
          ++it )
    {
        if ( filter[*(*it).Entity().LocalName().c_str()] == 1 )
            o_rResult.push_back( (*it).Entity().CeId() );
    }
                                 
    // Sort:                                                   
    OrderCeIdsByName    aIdOrdering(my_CeStorage().Container());
    std::sort( o_rResult.begin(),
               o_rResult.end(),
               aIdOrdering ); 
}

void        
SecondariesPilot_Inst::do_Service( const CodeEntity & i_rData )
{
    const Service &
        rService = ary_cast<Service>(i_rData);

    // Interfaces
    Dyn_StdConstIterator<CommentedReference>
        pSupportedInterfaces;
    rService.Get_SupportedInterfaces(pSupportedInterfaces);

    for ( StdConstIterator<CommentedReference> &
                itInfc = *pSupportedInterfaces;
          BOOL_OF(itInfc);
          ++itInfc )
    {
        for ( Interface * pIfc = lhf_SearchInterface((*itInfc).first);
              pIfc != 0;
              pIfc = lhf_SearchInterface(pIfc->Base()) )
        {                     
            insert_into2s( pIfc->Secondaries(), 
                           interface_2s_ExportingServices,
                           rService.CeId(),
                           true );
        }   // end for
    }   // end for

    // Services
    recursive_AssignIncludingService(rService.CeId(), rService);
}

void        
SecondariesPilot_Inst::do_Interface( const CodeEntity &  i_rData )
{
    const Interface &
        rIfc = ary_cast<Interface>(i_rData);
    recursive_AssignDerivedInterface(rIfc.CeId(), rIfc);
}

void        
SecondariesPilot_Inst::do_Struct( const CodeEntity &  i_rData )
{
    const Struct &
        rStruct = ary_cast<Struct>(i_rData);
    recursive_AssignDerivedStruct(rStruct.CeId(), rStruct);
}

void        
SecondariesPilot_Inst::do_Exception( const CodeEntity &  i_rData )
{
    const Exception &
        rException = ary_cast<Exception>(i_rData);
    recursive_AssignDerivedException(rException.CeId(), rException);
}

void        
SecondariesPilot_Inst::do_Typedef( const CodeEntity &  i_rData )
{
    const Typedef &
        rTypedef = ary_cast<Typedef>(i_rData);
}

void        
SecondariesPilot_Inst::do_Singleton( const CodeEntity &  i_rData )
{                                
    const Singleton &
        rSingleton = ary_cast<Singleton>(i_rData);

    Service *
        pServ = lhf_SearchService(rSingleton.AssociatedService());
    if (pServ != 0)                      
    {
        insert_into2s( pServ->Secondaries(), 
                       service_2s_InstantiatingSingletons,
                       rSingleton.CeId() );
    }
}

void        
SecondariesPilot_Inst::do_Function( const CodeEntity & i_rData )
{
    const Function &
        rFunction = ary_cast<Function>(i_rData);
                            
    recursive_AssignFunction_toCeAsReturn(rFunction.CeId(), rFunction.ReturnType());
    
    for ( Function::ParamList::const_iterator itp = rFunction.Parameters().begin();
          itp != rFunction.Parameters().end();
          ++itp )
    {
        recursive_AssignFunction_toCeAsParameter(rFunction.CeId(), (*itp).Type());
    }   // end for (itp)
    
    for ( Function::ExceptionList::const_iterator itx = rFunction.Exceptions().begin();
          itx != rFunction.Exceptions().end();
          ++itx )
    {
        Exception *
            pX = lhf_SearchException(*itx);
        if (pX != 0)        
        {
            pX->Secondaries().
                    Access_List(exception_2s_RaisingFunctions).
                            push_back(rFunction.CeId());
        }
    }   // end for (itx)
}       

void        
SecondariesPilot_Inst::do_StructElement( const CodeEntity & i_rData )
{
    const StructElement &
        rStructElement = ary_cast<StructElement>(i_rData);
                            
    recursive_AssignStructElement_toCeAsDataType(rStructElement.CeId(), rStructElement.Type());
}

void        
SecondariesPilot_Inst::do_Property( const CodeEntity & i_rData )
{
    const Property &
        rProperty = ary_cast<Property>(i_rData);

    recursive_AssignStructElement_toCeAsDataType(rProperty.CeId(), rProperty.Type());
}

Ce_id
SecondariesPilot_Inst::lhf_Search_CeForType( const ExplicitType & i_rType ) const
{
    const ExplicitNameRoom &
        rExplicitNameRoom = store::find( my_TypeStorage(),
                                         i_rType.NameRoom(),
                                         T2T<ExplicitNameRoom>() );
    Find_ModuleNode
        rNodeFinder( my_CeStorage(),
                     rExplicitNameRoom.NameChain_Begin(),
                     rExplicitNameRoom.NameChain_End(),
                     i_rType.Name() );

    if ( rExplicitNameRoom.IsAbsolute() )
    {
        const Module &
            rGlobalNamespace = store::find( my_CeStorage(),
                                            Ce_id(predefined::ce_GlobalNamespace),
                                            T2T<Module>() );
        return Search_SubTree(  rGlobalNamespace,
                                rNodeFinder );
    }
    else
    {
        const Module &
            rStartModule = store::find( my_CeStorage(),
                                        i_rType.ModuleOfOccurrence(),
                                        T2T<Module>() );
        Ce_id ret = Search_SubTree_UpTillRoot( rStartModule,
											   rNodeFinder );
		return ret;
    }   // endif (rExplicitNameRoom.IsAbsolute()) else
}

Ce_id               
SecondariesPilot_Inst::lhf_Search_CeFromTypeId( Type_id i_nType ) const
{
    const Ce_Type *
        pType = store::search( my_TypeStorage(), i_nType, T2T<Ce_Type>() );
    return pType != 0
                ?   pType->RelatedCe()
                :   Ce_id_Null();
}

void
SecondariesPilot_Inst::assign_CurLink( char *              i_text,
                                       const String &      i_link,
                                       const String &      i_linkUI,
                                       bool                i_isDescr,  
                                       int                 i_lineCount )
{
    const ary::idl::Module *
        pModule = &store::find(my_CeStorage(), Ce_id(predefined::ce_GlobalNamespace), T2T<Module>());

    char * pPastNext = 0;
    char * pNext = i_text;
    for ( ;
          (pPastNext = strstr(pNext,".")) != 0;
          pNext = pPastNext + 1 )
    {
        String sNext(pNext, pPastNext-pNext);
        Ce_id nModule = pModule->Search_Name(sNext);
        if (nModule.IsValid())
        {          
            pModule = store::search( my_CeStorage(),
                                     nModule,
                                     T2T<Module>() );
        }               
        else
        {
            pModule = 0;
        }
        
        if (pModule == 0)
        {
            Cerr() << "Warning: Invalid line nr. "
                   << i_lineCount
                   << " in DevelopersGuide reference file:\n"
                   << reinterpret_cast< const char* >(i_text)
                   << "\n" 
                   << Endl();
            return;
        }
    }   // end for

    pPastNext = strchr(pNext,':');
    bool bMember = pPastNext != 0;
    String sCe( pNext, (bMember ? csv::str::size(pPastNext-pNext) : csv::str::maxsize) );

//  KORR_FUTURE
//  String sMember(bMember ? pPastNext+1, "");

    Ce_id nCe = pModule->Search_Name(sCe);
    if (NOT nCe.IsValid())
    {
        Cerr() << "Warning: Invalid line nr. "
               << i_lineCount
               << " in DevelopersGuide reference file:\n"
               << reinterpret_cast< const char* >(i_text)
               << "\n" 
               << Endl();
        return;
    }

    CodeEntity &
        rCe = my_CeStorage()[nCe].Entity();
    if (NOT bMember)
    {
        if (i_isDescr)
            rCe.Secondaries().Add_Link2DescriptionInManual(i_link, i_linkUI);
        else
            rCe.Secondaries().Add_Link2RefInManual(i_link, i_linkUI);
        return;
    }
    else
    {
    // KORR_FUTURE
    //   Provisorial just doing nothing (or may be
    //   adding a link at main Ces lists).
//    if (i_isDescr)
//        rCe.Secondaries().Add_Link2DescriptionInManual(i_link);
//    else        
//        rCe.Secondaries().Add_Link2RefInManual(i_link);
    }
}

void                
SecondariesPilot_Inst::gather_Synonyms()
{
    for ( store::RootFilterIterator<Ce_Storage::unit, Typedef>
            itTd = my_CeStorage().Container().Begin();
          itTd;
          ++itTd )
    {       
        const Typedef &
                rTypedef = ary_cast<Typedef>((*itTd).Entity());
                
        recursive_AssignAsSynonym(rTypedef.CeId(), rTypedef);                
    }   // end for (itTd)
}

void                
SecondariesPilot_Inst::recursive_AssignAsSynonym( Ce_id               i_synonymousTypedefsId,
                                                  const Typedef &     i_TypedefToCheck )
{
    Ce_id 
        nCe = lhf_Search_CeFromTypeId(i_TypedefToCheck.DefiningType());   
    if (NOT nCe.IsValid())
        return;
    CodeEntity &
        rCe = my_CeStorage()[nCe].Entity();                 
        
    switch (rCe.ClassId())  // KORR_FUTURE: make this faster, remove switch.
    {
        case Interface::class_id:
                    rCe.Secondaries().Access_List(interface_2s_SynonymTypedefs).push_back(i_synonymousTypedefsId);
                    break;
        case Struct::class_id:
                    rCe.Secondaries().Access_List(struct_2s_SynonymTypedefs).push_back(i_synonymousTypedefsId);
                    break;
        case Enum::class_id:
                    rCe.Secondaries().Access_List(enum_2s_SynonymTypedefs).push_back(i_synonymousTypedefsId);
                    break;
        case Typedef::class_id:
                    rCe.Secondaries().Access_List(typedef_2s_SynonymTypedefs).push_back(i_synonymousTypedefsId);
                    recursive_AssignAsSynonym( i_synonymousTypedefsId,
                                               static_cast< Typedef& >(rCe) ); 
                    break;
                // default: do nothing.                               
    }
}

void                
SecondariesPilot_Inst::recursive_AssignIncludingService( Ce_id               i_includingServicesId,
                                                         const Service &     i_ServiceToCheckItsIncludes )
{
    Dyn_StdConstIterator<CommentedReference>
        pIncludedServices;
    i_ServiceToCheckItsIncludes.Get_IncludedServices(pIncludedServices);

    for ( StdConstIterator<CommentedReference> &
                itServ = *pIncludedServices;
          itServ;
          ++itServ )
    {       
        Service *
            pServ = lhf_SearchService((*itServ).first);
        if (pServ != 0)
        {                      
            insert_into2s( pServ->Secondaries(),
                           service_2s_IncludingServices,
                           i_includingServicesId,
                           true );
            recursive_AssignIncludingService(i_includingServicesId, *pServ);
        }
    }   // end for
}

void                
SecondariesPilot_Inst::recursive_AssignDerivedInterface( Ce_id               i_nDerived,
                                                         const Interface &   i_parent )
{
    Type_id
        nBase = i_parent.Base();
    if (nBase.IsValid())
    {              
        Interface *
            pIfc = lhf_SearchInterface(nBase);
        if (pIfc == 0)
            return;

        insert_into2s( pIfc->Secondaries(), 
                       interface_2s_Derivations,
                       i_nDerived );
        recursive_AssignDerivedInterface(i_nDerived, *pIfc);
    }
}
                                                        
void                
SecondariesPilot_Inst::recursive_AssignDerivedStruct( Ce_id            i_nDerived,
                                                      const Struct &   i_parent )
{
    Type_id
        nBase = i_parent.Base();
    if (nBase.IsValid())
    {              
        Struct *
            pStruct = lhf_SearchStruct(nBase);
        if (pStruct == 0)
            return;

        insert_into2s( pStruct->Secondaries(), 
                       struct_2s_Derivations,
                       i_nDerived );
        recursive_AssignDerivedStruct(i_nDerived, *pStruct);
    }
}
                                                        
void                
SecondariesPilot_Inst::recursive_AssignDerivedException( Ce_id               i_nDerived,
                                                         const Exception &   i_parent )
{
    Type_id
        nBase = i_parent.Base();
    if (nBase.IsValid())
    {              
        Exception *
            pExc = lhf_SearchException(nBase);
        if (pExc == 0)
            return;

        insert_into2s( pExc->Secondaries(), 
                       exception_2s_Derivations,
                       i_nDerived );
        recursive_AssignDerivedException(i_nDerived, *pExc);
    }
}

void                
SecondariesPilot_Inst::recursive_AssignFunction_toCeAsReturn( Ce_id         i_nFunction, 
                                                              Type_id       i_nReturnType )
{
    Ce_id 
        nCe = lhf_Search_CeFromTypeId(i_nReturnType);   
    if (NOT nCe.IsValid())
        return;
        
    CodeEntity &
        rCe = my_CeStorage()[nCe].Entity();                 
    switch (rCe.ClassId())  // KORR_FUTURE: make this faster, remove switch.
    {
        case Interface::class_id:
                    rCe.Secondaries().Access_List(interface_2s_AsReturns).push_back(i_nFunction);
                    break;
        case Struct::class_id:
                    rCe.Secondaries().Access_List(struct_2s_AsReturns).push_back(i_nFunction);
                    break;
        case Enum::class_id:
                    rCe.Secondaries().Access_List(enum_2s_AsReturns).push_back(i_nFunction);
                    break;
        case Typedef::class_id:
                    rCe.Secondaries().Access_List(typedef_2s_AsReturns).push_back(i_nFunction);
                    recursive_AssignFunction_toCeAsReturn( i_nFunction,
                                                           static_cast< Typedef& >(rCe).DefiningType() ); 
                    break;
        // default: do nothing.                               
    }
}
                                                              
void                
SecondariesPilot_Inst::recursive_AssignFunction_toCeAsParameter( Ce_id      i_nFunction, 
                                                                 Type_id    i_nParameterType )
{
    Ce_id 
        nCe = lhf_Search_CeFromTypeId(i_nParameterType);   
    if (NOT nCe.IsValid())
        return;
        
    CodeEntity &
        rCe = my_CeStorage()[nCe].Entity();                 
    switch (rCe.ClassId())  // KORR_FUTURE: make this faster, remove switch.
    {
        case Interface::class_id:
                    rCe.Secondaries().Access_List(interface_2s_AsParameters).push_back(i_nFunction);
                    break;
        case Struct::class_id:
                    rCe.Secondaries().Access_List(struct_2s_AsParameters).push_back(i_nFunction);
                    break;
        case Enum::class_id:
                    rCe.Secondaries().Access_List(enum_2s_AsParameters).push_back(i_nFunction);
                    break;
        case Typedef::class_id:
                    rCe.Secondaries().Access_List(typedef_2s_AsParameters).push_back(i_nFunction);
                    recursive_AssignFunction_toCeAsParameter( i_nFunction,
                                                              static_cast< Typedef& >(rCe).DefiningType() ); 
                    break;
        // default: do nothing.                               
    }
}

void                
SecondariesPilot_Inst::recursive_AssignStructElement_toCeAsDataType( Ce_id   i_nDataElement, 
                                                                     Type_id i_nDataType )
{
    Ce_id 
        nCe = lhf_Search_CeFromTypeId(i_nDataType);   
    if (NOT nCe.IsValid())
        return;
        
    CodeEntity &
        rCe = my_CeStorage()[nCe].Entity();                 
    switch (rCe.ClassId())  // KORR_FUTURE: make this faster, remove switch.
    {
        case Interface::class_id:
                    rCe.Secondaries().Access_List(interface_2s_AsDataTypes).push_back(i_nDataElement);
                    break;
        case Struct::class_id:
                    rCe.Secondaries().Access_List(struct_2s_AsDataTypes).push_back(i_nDataElement);
                    break;
        case Enum::class_id:
                    rCe.Secondaries().Access_List(enum_2s_AsDataTypes).push_back(i_nDataElement);
                    break;
        case Typedef::class_id:
                    rCe.Secondaries().Access_List(typedef_2s_AsDataTypes).push_back(i_nDataElement);
                    recursive_AssignFunction_toCeAsParameter( i_nDataElement,
                                                              static_cast< Typedef& >(rCe).DefiningType() ); 
                    break;
        // default: do nothing.                               
    }   // end switch
}                                                                 
                                                        
void                
SecondariesPilot_Inst::insert_into2s( Ce_2s &             o_out,
                                      int                 i_listIndex,
                                      Ce_id               i_nCe,
                                      bool                i_bNeedsToEnsureSingle )
{       
    std::vector<Ce_id> &
        rOut = o_out.Access_List(i_listIndex);
    if (i_bNeedsToEnsureSingle)
    {
        if (std::find(rOut.begin(),rOut.end(),i_nCe) != rOut.end())
            return;
    }       
    rOut.push_back(i_nCe);
}

void                
SecondariesPilot_Inst::sort_All2s()
{
    OrderCeIdsByName    
        aIdOrdering(my_CeStorage().Container());

    for ( store::RootIterator<Ce_Storage::unit>
            it = my_CeStorage().Container().Begin();
          it;
          ++it )
    {                       
        Ce_2s &
            r2s = (*it).Entity().Secondaries();
        int iCount = r2s.CountXrefLists();
        for (int i = 0; i < iCount; ++i)
        {
            std::sort( r2s.Access_List(i).begin(),
                       r2s.Access_List(i).end(), 
                       aIdOrdering );
        }   // end for (i)
    }   // end for (it)
}
                                      
                                                  

}   // namespace idl
}   // namespace ary

