/*************************************************************************
 *
 *  $RCSfile: ipi_2s.hxx,v $
 *
 *  $Revision: 1.4.12.1 $
 *
 *  last change: $Author: mh $ $Date: 2003/01/27 17:00:38 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef ARY_IDL_IPI_2S_HXX
#define ARY_IDL_IPI_2S_HXX


// USED SERVICES
    // BASE CLASSES
#include <ary/idl/ip_2s.hxx>
#include <ary/idl/ihost_ce.hxx>
    // PARAMETERS


namespace ary
{
namespace idl
{

class Ce_Storage;
class Type_Storage;
class Module;
class ExplicitType;
class Interface;
class Typedef;
class Service;
class Struct;
class Exception;
class Ce_2s;

enum E_2s_of_Service
{
    service_2s_IncludingServices,
    service_2s_InstantiatingSingletons
};

enum E_2s_of_Interface
{
    interface_2s_Derivations,
    interface_2s_ExportingServices,
    interface_2s_SynonymTypedefs,
//    interface_2s_UsingTypedefs,
    interface_2s_AsReturns,
//    interface_2s_AsIndirectReturns,
    interface_2s_AsParameters,
//    interface_2s_AsIndirectParameters,
    interface_2s_AsDataTypes
};

enum E_2s_of_Struct
{
    struct_2s_Derivations,
    struct_2s_SynonymTypedefs,
//    struct_2s_UsingTypedefs,
    struct_2s_AsReturns,
//    struct_2s_AsIndirectReturns,
    struct_2s_AsParameters,
//    struct_2s_AsIndirectParameters,
    struct_2s_AsDataTypes
};

enum E_2s_of_Enum
{
    enum_2s_SynonymTypedefs,
//    enum_2s_UsingTypedefs,
    enum_2s_AsReturns,
//    enum_2s_AsIndirectReturns,
    enum_2s_AsParameters,
//    enum_2s_AsIndirectParameters,
    enum_2s_AsDataTypes
};

enum E_2s_of_Typedef
{
    typedef_2s_SynonymTypedefs,
//    typedef_2s_UsingTypedefs,
    typedef_2s_AsReturns,
//    typedef_2s_AsIndirectReturns,
    typedef_2s_AsParameters,
//    typedef_2s_AsIndirectParameters,
    typedef_2s_AsDataTypes
};

enum E_2s_of_Exceptions
{
    exception_2s_Derivations,
    exception_2s_RaisingFunctions
};



/** This class scans the parsed data and produces several
    secondary data like cross references and alphabetical indices.

    In this declaration "Secondaries" or "2s" mean those secondary data.
    
    @see Ce_2s
*/
class SecondariesPilot_Inst : public SecondariesPilot,
                              private CeHost
{
  public:
    // LIFECYCLE
                        SecondariesPilot_Inst(
                            Ce_Storage &        i_rCes,
                            Type_Storage &      i_rTypes );
    virtual             ~SecondariesPilot_Inst();

    // OPERATIONS

  private:
    // Interface SecondariesPilot:
    virtual void        do_Connect_Types2Ces();
    virtual void        do_Gather_CrossReferences();
    virtual void        do_Read_Links2DevManual(
                            csv::bstream &      i_file );
    virtual void        inq_Get_AlphabeticalIndex(
                            std::vector<Ce_id> &
                                                o_rResult,
                            alphabetical_index::E_Letter
                                                i_cLetter) const;
    // Interface CeHost These are the points to gather cross 
    //   references:
    virtual void        do_Service(
                            const CodeEntity &  i_rData );
    virtual void        do_Interface(
                            const CodeEntity &  i_rData );
    virtual void        do_Struct(
                            const CodeEntity &  i_rData );
    virtual void        do_Exception(
                            const CodeEntity &  i_rData );
    virtual void        do_Typedef(
                            const CodeEntity &  i_rData );
    virtual void        do_Singleton(
                            const CodeEntity &  i_rData );
    virtual void        do_Function(
                            const CodeEntity &  i_rData );
    virtual void        do_StructElement(
                            const CodeEntity &  i_rData );
    virtual void        do_Property(
                            const CodeEntity &  i_rData );

    // Locals
    const Ce_Storage &  my_CeStorage() const;
    const Type_Storage &
                        my_TypeStorage() const;
    Ce_Storage &        my_CeStorage();
    Type_Storage &      my_TypeStorage();

    Ce_id               lhf_Search_CeForType(
                            const ExplicitType &
                                                i_rType ) const;
    Ce_id               lhf_Search_CeFromTypeId(
                            Type_id             i_nType ) const;
    Service *           lhf_SearchService(
                            Type_id             i_nServ );
    Interface *         lhf_SearchInterface(
                            Type_id             i_nIfc );
    Struct *            lhf_SearchStruct(
                            Type_id             i_nIfc );
    Exception *         lhf_SearchException(
                            Type_id             i_nIfc );
    void                assign_CurLink(
                            char *              i_text,
                            const String &      i_link, 
                            const String &      i_linkUI, 
                            bool                i_isDescr,      /// @descr true: description, false: reference.
                            int                 i_lineCount  );
    void                gather_Synonyms(); 
    void                recursive_AssignAsSynonym(
                            Ce_id               i_synonymousTypedefsId,
                            const Typedef &     i_TypedefToCheck );
    void                recursive_AssignIncludingService(
                            Ce_id               i_includingServicesId,
                            const Service &     i_ServiceToCheckItsIncludes );
    void                recursive_AssignDerivedInterface(
                            Ce_id               i_nDerived,
                            const Interface &   i_parent );
    void                recursive_AssignDerivedStruct(
                            Ce_id               i_nDerived,
                            const Struct &      i_parent );
    void                recursive_AssignDerivedException(
                            Ce_id               i_nDerived,
                            const Exception &   i_parent );
    void                recursive_AssignFunction_toCeAsReturn(
                            Ce_id               i_nFunction, 
                            Type_id             i_nReturnType );
    void                recursive_AssignFunction_toCeAsParameter(
                            Ce_id               i_nFunction, 
                            Type_id             i_nParameterType ); 
                            
    /** @param i_nDataElement
        May be the ID of an struct element as well as an exception element 
        or a property.
    */                            
    void                recursive_AssignStructElement_toCeAsDataType(
                            Ce_id               i_nDataElement, 
                            Type_id             i_nDataType );
    void                insert_into2s(
                            Ce_2s &             o_out,
                            int                 i_listIndex,
                            Ce_id               i_nCe,
                            bool                i_bNeedsToEnsureSingle = false );
    /// Sorts secondry production lists alphabetical.                            
    void                sort_All2s();                            
                        

   // DATA
    Ce_Storage *        pCeStorage;
    Type_Storage *      pTypeStorage;
};




// IMPLEMENTATION


}   // namespace idl
}   // namespace ary



#endif

