/*************************************************************************
 *
 *  $RCSfile: dynrset.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: kso $ $Date: 2001/04/05 09:52:39 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

/**************************************************************************
								TODO
 **************************************************************************

 *************************************************************************/

#ifndef _COM_SUN_STAR_UCB_COMMAND_HPP_
#include <com/sun/star/ucb/Command.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_LISTACTIONTYPE_HPP_
#include <com/sun/star/ucb/ListActionType.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_OPENCOMMANDARGUMENT2_HPP_
#include <com/sun/star/ucb/OpenCommandArgument2.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_WELCOMEDYNAMICRESULTSETSTRUCT_HPP_
#include <com/sun/star/ucb/WelcomeDynamicResultSetStruct.hpp>
#endif

#ifndef _CPPUHELPER_INTERFACECONTAINER_HXX_
#include <cppuhelper/interfacecontainer.hxx>
#endif

#ifndef _COM_SUN_STAR_UCB_XCACHEDDYNAMICRESULTSETSTUBFACTORY_HPP_
#include <com/sun/star/ucb/XCachedDynamicResultSetStubFactory.hpp>
#endif

#ifndef _COM_SUN_STAR_UCB_XSOURCEINITIALIZATION_HPP_
#include <com/sun/star/ucb/XSourceInitialization.hpp>
#endif

#ifndef _CNTWIDS_HRC
#include <svtools/cntwids.hrc>
#endif

//#ifndef _TOOLS_DEBUG_HXX
//#include <tools/debug.hxx>
//#endif

#include "dynrset.hxx"

#ifndef _RSULTSET_HXX
#include "rsultset.hxx"
#endif

using namespace com::sun::star::lang;
using namespace com::sun::star::sdbc;
using namespace com::sun::star::ucb;
using namespace com::sun::star::uno;
using namespace cppu;
using namespace rtl;

using namespace chaos;

//=========================================================================

//  The mutex to synchronize access to containers.
static osl::Mutex& getContainerMutex()
{
	static osl::Mutex* pMutex = NULL;
	if( !pMutex )
	{
		osl::Guard< osl::Mutex > aGuard( osl::Mutex::getGlobalMutex() );
		if( !pMutex )
		{
			static osl::Mutex aMutex;
			pMutex = &aMutex;
		}
	}

	return *pMutex;
}

//=========================================================================
//=========================================================================
//
// DynamicResultSet Implementation.
//
//=========================================================================
//=========================================================================

DynamicResultSet::DynamicResultSet(
					  const Reference< XMultiServiceFactory >& rxSMgr,
					  ChaosContent* pOwner,
					  const Command& rCommand,
					  const Reference< XCommandEnvironment >& Environment )
: m_xSMgr( rxSMgr ),
  m_xResultSet( new ResultSet( rxSMgr, pOwner, rCommand, Environment ) ),
  m_pDisposeEventListeners( 0 ),
  m_bStatic( sal_False )
{
}

//=========================================================================
// virtual
DynamicResultSet::~DynamicResultSet()
{
	delete m_pDisposeEventListeners;
}

//=========================================================================
//
// XInterface methods.
//
//=========================================================================

XINTERFACE_IMPL_4( DynamicResultSet,
				   XTypeProvider,
				   XServiceInfo,
				   XComponent, /* base of XDynamicResultSet */
				   XDynamicResultSet );

//=========================================================================
//
// XTypeProvider methods.
//
//=========================================================================

XTYPEPROVIDER_IMPL_3( DynamicResultSet,
					  XTypeProvider,
				   	  XServiceInfo,
					  XDynamicResultSet );

//=========================================================================
//
// XServiceInfo methods.
//
//=========================================================================

XSERVICEINFO_NOFACTORY_IMPL_1( DynamicResultSet,
					 		   OUString::createFromAscii(
								"com.sun.star.comp.chaos.DynamicResultSet" ),
					 		   OUString::createFromAscii(
								DYNAMICRESULTSET_SERVICE_NAME ) );

//=========================================================================
//
// XComponent methods.
//
//=========================================================================

// virtual
void SAL_CALL DynamicResultSet::dispose()
	throw( RuntimeException )
{
	vos::OGuard aGuard( m_aMutex );

	if ( m_pDisposeEventListeners && m_pDisposeEventListeners->getLength() )
	{
		EventObject aEvt;
		aEvt.Source = static_cast< XComponent * >( this );
		m_pDisposeEventListeners->disposeAndClear( aEvt );
	}
}

//=========================================================================
// virtual
void SAL_CALL DynamicResultSet::addEventListener(
							const Reference< XEventListener >& Listener )
	throw( RuntimeException )
{
	vos::OGuard aGuard( m_aMutex );

	if ( !m_pDisposeEventListeners )
		m_pDisposeEventListeners =
					new OInterfaceContainerHelper( getContainerMutex() );

	m_pDisposeEventListeners->addInterface( Listener );
}

//=========================================================================
// virtual
void SAL_CALL DynamicResultSet::removeEventListener(
							const Reference< XEventListener >& Listener )
	throw( RuntimeException )
{
	vos::OGuard aGuard( m_aMutex );

	if ( m_pDisposeEventListeners )
		m_pDisposeEventListeners->removeInterface( Listener );
}

//=========================================================================
//
// XDynamicResultSet methods.
//
//=========================================================================

// virtual
Reference< XResultSet > SAL_CALL DynamicResultSet::getStaticResultSet()
	throw( ListenerAlreadySetException,	RuntimeException )
{
	vos::OGuard aGuard( m_aMutex );

	if ( m_xListener.is() )
		throw ListenerAlreadySetException();
	else
		m_bStatic = sal_True;

	return m_xResultSet.getBodyPtr();
}

//=========================================================================
// virtual
void SAL_CALL DynamicResultSet::setListener(
					const Reference< XDynamicResultSetListener >& Listener )
	throw( ListenerAlreadySetException,	RuntimeException )
{
	vos::OClearableGuard aGuard( m_aMutex );

	if ( m_bStatic || m_xListener.is() )
		throw ListenerAlreadySetException();

	m_xListener = Listener;

	//////////////////////////////////////////////////////////////////////
	// Create "welcome event" and send it to listener.
	//////////////////////////////////////////////////////////////////////

	// Note: We only have the implementation for a static result set at the
	//       moment (src590). The dynamic result sets passed to the listener
	//       are a fake. This implementation will never call "notify" at the
	//       listener to propagate any changes!!!

	Any aInfo;
	aInfo <<= WelcomeDynamicResultSetStruct(
					m_xResultSet.getBodyPtr() /* "old" */,
					m_xResultSet.getBodyPtr() /* "new" */ );

	Sequence< ListAction > aActions( 1 );
	aActions.getArray()[ 0 ] = ListAction( 0, // Position; not used
			    						   0, // Count; not used
			    						   ListActionType::WELCOME,
			   							   aInfo );
	aGuard.clear();

	Listener->notify(
				ListEvent( static_cast< OWeakObject * >( this ), aActions ) );
}

//=========================================================================
// virtual
sal_Int16 SAL_CALL DynamicResultSet::getCapabilities()
	throw( RuntimeException )
{
	// Never set ContentResultSetCapability::SORTED
	// 	- Underlying ChaosContent cannot provide sorted data...
	return 0;
}

//=========================================================================
// virtual
void SAL_CALL DynamicResultSet::connectToCache(
		const Reference< XDynamicResultSet > & xCache )
		throw( ListenerAlreadySetException,
			   AlreadyInitializedException,
			   ServiceNotFoundException,
			   RuntimeException )
{
	//@todo check this implementation
	if( m_xListener.is() )
		throw ListenerAlreadySetException();
	if( m_bStatic )
		throw ListenerAlreadySetException();

	Reference< XSourceInitialization > xTarget( xCache, UNO_QUERY );
	if( xTarget.is() && m_xSMgr.is() )
	{
		Reference< XCachedDynamicResultSetStubFactory > xStubFactory;
		try
		{
			xStubFactory = Reference< XCachedDynamicResultSetStubFactory >(
				m_xSMgr->createInstance(
					OUString::createFromAscii(
						"com.sun.star.ucb.CachedDynamicResultSetStubFactory" ) ),
				UNO_QUERY );
		}
		catch ( Exception const & )
		{
		}

		if( xStubFactory.is() )
		{
			Sequence< NumberedSortingInfo > * pSortingInfo = 0;

			// The commands "open", "update" and "synchronize" each have an
			// OpenCommandArgument2 containing sorting information, but only
			// the "open" command will return a result set; the "search"
			// command will return a restult set, but its SearchCommandArgument
			// contains no sorting information.  So, only in the case of an
			// open command do we need to extract the sorting information from
			// the command's argument:
			Command const & rCommand = m_xResultSet->accessCommand();
			OpenCommandArgument2 aOpenArg;
			if ((rCommand.Handle == WID_OPEN
				 || rCommand.Name.compareToAscii("open") == 0)
				&& (rCommand.Argument >>= aOpenArg))
				pSortingInfo = &aOpenArg.SortingInfo;

			if (pSortingInfo)
				xStubFactory->connectToCache(this, xCache, *pSortingInfo, 0);
			else
				xStubFactory->connectToCache(this, xCache, 0, 0);
			return;
		}
	}
	throw ServiceNotFoundException();
}

