/*************************************************************************
 *
 *  $RCSfile: cntsrch.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SFXCANCEL_HXX
#include <svtools/cancel.hxx>
#endif
#ifndef _SVTOOLS_CTYPEITM_HXX
#include <svtools/ctypeitm.hxx>
#endif

#ifndef _CASTMACS_HXX
#include <castmacs.hxx>
#endif
#ifndef _CNTRNMGR_HXX
#include <cntrnmgr.hxx>
#endif
#ifndef _CNTSRCH_HXX
#include <cntsrch.hxx>
#endif
#ifndef _CNTVNODE_HXX
#include <cntvnode.hxx>
#endif
#ifndef _CSTRITEM_HXX
#include <cstritem.hxx>
#endif
#ifndef _CHAOS_INIMGR_HXX
#include <inimgr.hxx>
#endif

using namespace chaos;

//============================================================================
//
//  class CntSearchWrapper
//
//============================================================================

BOOL CntSearchWrapper::result(CntNode * pNode, const String & rURL)
{
	BOOL bContinue = reportMatch(pNode, rURL);
	if (!bContinue)
	{
		m_eState = STATE_CANCEL;
		wakeUp();
	}
	return bContinue;
}

//============================================================================
BOOL CntSearchWrapper::startWaitingJob(ULONG nIndex)
{
	CntSearchWaitingJob_Impl * pWaitingJob = m_aWaitingJobs.Remove(nIndex);
	if (pWaitingJob->isInitialLocation())
	{
		CntAnchorRef xAnchor(new CntAnchor(0, pWaitingJob->getURL()));
		BOOL bOk = !xAnchor->GetError();
		if (!bOk && m_nUnsuccessfulCount != -1)
		{
			if (m_nUnsuccessfulCount++)
				m_aUnsuccessfulLocations.AppendAscii(
					RTL_CONSTASCII_STRINGPARAM( ", " ) );
			m_aUnsuccessfulLocations += pWaitingJob->getURL();
		}
		if (m_nUnsuccessfulCount >= 0
			&& !(m_aWaitingJobs.Count()
				 && m_aWaitingJobs.GetObject(0)->isInitialLocation()))
		{
			if (m_nUnsuccessfulCount
				&& !reportUnsuccessful(m_nUnsuccessfulCount,
									   m_aUnsuccessfulLocations))
				return FALSE;
			m_nUnsuccessfulCount = -1;
			m_aUnsuccessfulLocations.Erase();
		}
		if (bOk)
		{
			CntSearchData * pData = pWaitingJob->takeData();
			if (pData->DoFollowIndirections())
			{
				static const USHORT aGetDataRanges[]
				 = { WID_CONTENT_TYPE, WID_CONTENT_TYPE,
					 WID_TARGET_URL, WID_TARGET_URL, 0 };
				xAnchor->Put(CntWIDSetItem(WID_GETDATA, aGetDataRanges));
				String aTargetURL(ITEMSET_VALUE(xAnchor, CntStringItem,
												WID_TARGET_URL));
				if (aTargetURL.Len())
				{
					if (INSECURE_DYNAMIC_CAST(const CntContentTypeItem *,
											  &xAnchor->
											    Get(WID_CONTENT_TYPE))->
						  GetEnumValue()
						 == CONTENT_TYPE_X_CNT_FSYSFOLDER)
						++m_nWaitingFSysFolderJobCount;
					m_aWaitingJobs.
					 Insert(new CntSearchWaitingJob_Impl
							     (aTargetURL,
								  pData->createSameLevel()),
							LIST_APPEND);
				}
			}
			startingJob();
			CntSearchRunningJob_Impl * pRunningJob
			 = new CntSearchRunningJob_Impl;
			m_aRunningJobs.Insert(pRunningJob, LIST_APPEND);
			pRunningJob->start(*this, xAnchor, pData,
							   LINK(this, CntSearchWrapper, errorHandler));
		}
	}
	else
	{
		CntAnchorRef xAnchor(new CntAnchor(pWaitingJob->getParent(),
										   pWaitingJob->getNode()));
		if (!xAnchor->GetError())
		{
			CntSearchRunningJob_Impl * pRunningJob
			 = new CntSearchRunningJob_Impl;
			if (INSECURE_DYNAMIC_CAST(const CntContentTypeItem *,
									  &pWaitingJob->
									    getNode()->Get(WID_CONTENT_TYPE))->
				  GetEnumValue()
				 == CONTENT_TYPE_X_CNT_FSYSFOLDER)
			{
				m_pRunningFSysFolderJob = pRunningJob;
				pRunningJob->markAsFSysFolderJob();
			}
			m_aRunningJobs.Insert(pRunningJob, LIST_APPEND);
			pRunningJob->start(*this, xAnchor, pWaitingJob->takeData(),
							   LINK(this, CntSearchWrapper, errorHandler));
		}
	}
	delete pWaitingJob;
	return m_eState < STATE_DONE;
}

//============================================================================
void CntSearchWrapper::cancelJobs()
{
	while (m_aRunningJobs.Count())
	{
		CntSearchRunningJob_Impl * pRunningJob
		 = m_aRunningJobs.Remove(m_aRunningJobs.Count() - 1);
		pRunningJob->cancel(*this);
		delete pRunningJob;
	}
	for (ULONG i = m_aWaitingJobs.Count(); i;)
		delete m_aWaitingJobs.Remove(--i);
}

//============================================================================
IMPL_LINK(CntSearchWrapper, errorHandler, CntErrorData *, pData)
{
	return handleError(pData);
}

//============================================================================
void CntSearchWrapper::execute()
{
	for (;;)
		switch (m_eState)
		{
			case STATE_INIT:
			{
				const List * pLocations;
				const CntSearchData * pData;
				if (!initialize(pLocations, pData))
					return;

				for (USHORT i = 0; i < pLocations->Count(); ++i)
					m_aWaitingJobs.
					 Insert(new CntSearchWaitingJob_Impl
							     (*INSECURE_DYNAMIC_CAST(const String *,
														 pLocations->
														  GetObject(i)),
								  new CntSearchData(*pData)),
							LIST_APPEND);
				m_nUnsuccessfulCount = 0;

				m_pRunningFSysFolderJob = 0;
				m_nWaitingFSysFolderJobCount = 0;

				m_eState = STATE_START;
			}
			case STATE_START:
			{
				startTimeSlice();
				while (m_aRunningJobs.Count() < MAX_SIMULTANEOUS_JOBS
					   && m_aWaitingJobs.Count()
					   && m_aWaitingJobs.GetObject(0)->isInitialLocation())
					if (!startWaitingJob(0) || endTimeSlice())
						return;
				m_eState = STATE_RECURSIVE;
			}
			case STATE_RECURSIVE:
				if (canStartWaitingJob())
				{
					startTimeSlice();
					for (;;)
					{
						for (ULONG i = 0; i < m_aWaitingJobs.Count(); ++i)
						{
							CntSearchWaitingJob_Impl * pWaitingJob
							 = m_aWaitingJobs.GetObject(i);
							if (pWaitingJob->isInitialLocation())
							{
								if (!startWaitingJob(i))
									return;
								break;
							}
							else if (INSECURE_DYNAMIC_CAST
									    (const CntContentTypeItem *,
										 &pWaitingJob->
										   getNode()->Get(WID_CONTENT_TYPE))->
									   GetEnumValue()
									  != CONTENT_TYPE_X_CNT_FSYSFOLDER)
							{
								if (!startWaitingJob(i))
									return;
								break;
							}
							else if (!m_pRunningFSysFolderJob)
							{
								--m_nWaitingFSysFolderJobCount;
								if (!startWaitingJob(i))
									return;
								break;
							}
						}
						if (!canStartWaitingJob())
							break;
						if (endTimeSlice())
							return;
					}
				}
				if (!(m_aRunningJobs.Count() || m_aWaitingJobs.Count()))
				{
					allJobsDone();
					m_eState = STATE_DONE;
					break;
				}
				m_eState = STATE_IDLE;
				return;

			case STATE_CANCEL:
				cancelJobs();
				m_eState = STATE_DONE;
			case STATE_DONE:
				done();
			case STATE_CANCELED:
				return;
		}
}

//============================================================================
BOOL CntSearchWrapper::notify(SfxBroadcaster & rBroadcaster,
							  const SfxHint & rHint)
{
	if (m_eState <= STATE_IDLE)
	{
		const CntSearchMatchedURLHint * pMatchedURLHint
		 = PTR_CAST(CntSearchMatchedURLHint, &rHint);
		if (pMatchedURLHint)
		{
			String aURL(pMatchedURLHint->getURL());
			CntNodeRef xNode(CNT_RNM()->Query(aURL));
			if (xNode.Is())
				result(&xNode, aURL);
			return TRUE;
		}
	}

	if (m_eState < STATE_CANCELED)
	{
		const CntStatusHint * pStatusHint = PTR_CAST(CntStatusHint, &rHint);
		if (pStatusHint)
		{
			CntStatus nStatus = pStatusHint->GetStatus();
			if (nStatus == CNT_STATUS_DONE
				 && pStatusHint->GetRequest()->Which() == WID_SEARCH
				|| nStatus == CNT_STATUS_ERROR
				   && pStatusHint->GetError() == ERRCODE_ABORT)
			{
				SfxCancellable * pCancel = pStatusHint->GetCancelable();
				for (ULONG i = 0; i < m_aRunningJobs.Count(); ++i)
				{
					CntSearchRunningJob_Impl * pRunningJob
					 = m_aRunningJobs.GetObject(i);
					if (pRunningJob->is(*pCancel))
					{
						if (pRunningJob == m_pRunningFSysFolderJob)
							m_pRunningFSysFolderJob = 0;
						m_aRunningJobs.Remove(i);
						pRunningJob->end(*this);
						delete pRunningJob;
						if (m_eState == STATE_IDLE)
						{
							m_eState = STATE_RECURSIVE;
							wakeUp();
						}
						return TRUE;
					}
				}
			}
		}
	}

	return FALSE;
}

//============================================================================
void CntSearchWrapper::cancel()
{
	m_eState = STATE_CANCELED;
	cancelJobs();
}

//============================================================================
//
//  class CntSearchRunningJob_Impl
//
//============================================================================

void CntSearchRunningJob_Impl::start(CntSearchWrapper & rWrapper,
									 CntAnchorRef & rTheAnchor,
									 CntSearchData * pTheData,
									 const Link & rErrorHandler)
{
	cancel(rWrapper);

	m_pData = pTheData;
	m_xAnchor = rTheAnchor;

	if (!m_pData->DoObeyFolderViewRestrictions())
		m_xAnchor->
		 CntInterface::Put(CntFolderViewModeItem(WID_FOLDERVIEW_MODE,
												 CNT_VIEW_ALL_FOLDERS),
						   WID_FOLDERVIEW_MODE);
	if (!m_pData->DoObeyDocViewRestrictions())
	{
		m_xAnchor->
		 CntInterface::Put(CntMsgViewModeItem(WID_MESSAGEVIEW_MODE,
											  CNT_VIEW_ALL_ARTICLES),
						   WID_MESSAGEVIEW_MODE);
		m_xAnchor->CntInterface::Put(CntBoolItem(WID_SHOW_MSGS_HAS_TIMELIMIT,
												 FALSE),
									 WID_SHOW_MSGS_HAS_TIMELIMIT);
	}
	rWrapper.startListening(*m_xAnchor);
	m_xAnchor->RegisterErrorHandler(rErrorHandler);
	m_xAnchor->Put(CntSearchDataItem(WID_SEARCH, *m_pData), &m_pCancel);
}

//============================================================================
void CntSearchRunningJob_Impl::end(CntSearchWrapper & rWrapper)
{
	if (m_xAnchor.Is())
	{
		rWrapper.endListening(*m_xAnchor);
		m_xAnchor->DeregisterErrorHandler();
	}
	m_xAnchor = 0;
	delete m_pData;
	m_pData = 0;
}

//============================================================================
void CntSearchRunningJob_Impl::cancel(CntSearchWrapper & rWrapper)
{
	if (m_xAnchor.Is())
		rWrapper.endListening(*m_xAnchor);
	if (m_pCancel)
		m_pCancel->Cancel();
	if (m_xAnchor.Is())
		m_xAnchor->DeregisterErrorHandler();
	m_xAnchor = 0;
	delete m_pData;
	m_pData = 0;
}

//============================================================================
//
//  class CntSearchMatchedURLHint
//
//============================================================================

TYPEINIT1(CntSearchMatchedURLHint, SfxHint);

