/*************************************************************************
 *
 *  $RCSfile: cntvnode.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _FSYS_HXX //autogen
#include <tools/fsys.hxx>
#endif
#ifndef _SFX_WHITER_HXX //autogen
#include <svtools/whiter.hxx>
#endif
#ifndef _SFXITEMITER_HXX //autogen
#include <svtools/itemiter.hxx>
#endif
#ifndef _SVTOOLS_CENUMITM_HXX
#include <svtools/cenumitm.hxx>
#endif
#ifndef _SVTOOLS_CTYPEITM_HXX //autogen
#include <svtools/ctypeitm.hxx>
#endif

#ifndef _CNTRNMGR_HXX
#include <cntrnmgr.hxx>
#endif
#ifndef _CNTSTGND_HXX
#include <cntstgnd.hxx>
#endif
#ifndef _CNTJOB_HXX
#include <cntjob.hxx>
#endif

#ifndef _CHAOS_STORITEM_HXX
#include <storitem.hxx>
#endif
#ifndef _CSTRITEM_HXX
#include <cstritem.hxx>
#endif
#ifndef _ILSTITEM_HXX
#include <ilstitem.hxx>
#endif

#include <cntvnode.hxx>

using namespace chaos;

//============================================================================

#ifdef _CHAOS_STORITEM_REF
SV_IMPL_REF( CntStoreItemSet );
#endif

//============================================================================
//
// CntViewBase Implementation.
//
//============================================================================

// static
BOOL CntViewBase::IsViewURL( const String& rURL )
{
	BOOL bRoot = FALSE;
	return IsViewURL( bRoot, rURL );
}

//============================================================================
// static
BOOL CntViewBase::IsViewURL( BOOL& bRoot, const String& rURL )
{
	if ( rURL.Len() == 0 )
		return FALSE;

	const CntViewTypesList*	pViewTypes = CNT_RNM()->GetViewTypesList();
	String aURL( rURL );
	aURL.ToLowerAscii();

	ULONG nCount = pViewTypes->Count();
	for ( ULONG n = 0; n < nCount; ++n )
	{
		String aCurr( *pViewTypes->GetObject( n ) );
		aCurr.ToLowerAscii();

		WildCard aRootWild( aCurr );
		if ( aRootWild.Matches( aURL ) )
		{
			// Make sure URL is not a Sub View URL ending with the
			// current pattern. ( e.g. file:///...scc#...scc )
			if ( aURL.Search( CNT_VIEW_URL_DELIMITER ) == STRING_NOTFOUND )
			{
				// Root.
				bRoot = TRUE;
				return TRUE;
			}
		}

		aCurr += CNT_VIEW_URL_DELIMITER;
		aCurr += '*';

		WildCard aSubWild( aCurr );
		if ( aSubWild.Matches( aURL ) )
		{
			// Sub.
			bRoot = FALSE;
			return TRUE;
		}
	}

	return FALSE;
}

//============================================================================
// static
BOOL CntViewBase::IsRootViewURL( const String& rURL )
{
	if ( rURL.Len() == 0 )
		return FALSE;

	const CntViewTypesList*	pViewTypes = CNT_RNM()->GetViewTypesList();
	String aURL( rURL );
	aURL.ToLowerAscii();

	ULONG nCount = pViewTypes->Count();
	for ( ULONG n = 0; n < nCount; ++n )
	{
		String aCurr( *pViewTypes->GetObject( n ) );
		aCurr.ToLowerAscii();

		WildCard aRootWild( aCurr );
		if ( aRootWild.Matches( aURL ) )
		{
			// Make sure URL is not a Sub View URL ending with the
			// current pattern. ( e.g. file:///...scc#...scc )
			if ( aURL.Search( CNT_VIEW_URL_DELIMITER ) == STRING_NOTFOUND )
				return TRUE;
		}
	}

	return FALSE;
}

//============================================================================
// static
BOOL CntViewBase::IsSubViewURL( const String& rURL )
{
	if ( rURL.Len() == 0 )
		return FALSE;

	const CntViewTypesList*	pViewTypes = CNT_RNM()->GetViewTypesList();
	String aURL( rURL );
	aURL.ToLowerAscii();

	ULONG nCount = pViewTypes->Count();
	for ( ULONG n = 0; n < nCount; ++n )
	{
		String aCurr( *pViewTypes->GetObject( n ) );
		aCurr.ToLowerAscii();
		aCurr += CNT_VIEW_URL_DELIMITER;
		aCurr += '*';

		WildCard aSubWild( aCurr );
		if ( aSubWild.Matches( aURL ) )
			return TRUE;
	}

	return FALSE;
}

//============================================================================
// static
BOOL CntViewBase::IsValidViewURL( const String& rURL )
{
	String aURL( rURL );
	if ( !NormalizeURL( aURL ) )
	{
		// Invalid URL.
		return FALSE;
	}

	BOOL bRoot = FALSE;
	if ( !IsViewURL( bRoot, aURL ) )
	{
		// No View URL at all.
		return FALSE;
	}

	if ( bRoot )
	{
		// Valid Root View URL.
		return TRUE;
	}

	// Sub View URL. Check consistency...

	// Get Root View URL and Service URL from given Sub View URL.
	String aRootURL( aURL );

	xub_StrLen nPos = aRootURL.Search( CNT_VIEW_URL_DELIMITER );
	String aServiceURL( aRootURL.Copy( nPos ) );
	aRootURL.Erase( nPos );

	aServiceURL.Erase( 0, 1 );

	CntNodeRef xNode( CNT_RNM()->Query( aRootURL ) );
	if ( !xNode.Is() )
		return FALSE;

	// Get Service URL from root node.
	const String& rRootServiceURL = OWN_URL( xNode->GetMostReferedNode() );

	if ( aServiceURL == rRootServiceURL )
	{
		// View URL's to root nodes never have the Service URL appended.
		return FALSE;
	}

	if ( aServiceURL.Search( rRootServiceURL ) != 0 )
	{
		// Given Service URL does not match the object. (e.g. The
		// root anchor points to an IMAP-Account, but given Service URL
		// points to a Newsgroup)
		return FALSE;
	}

	// Valid Sub View URL.
	return TRUE;
}

//============================================================================
// static
BOOL CntViewBase::ViewFileExists( const String& rURL )
{
	if ( rURL.Len() == 0 )
		return FALSE;

	String aRootURL( GetRootViewURL( rURL ) );
	if ( aRootURL.Len() == 0 )
		return FALSE;

	DirEntry aDirEntry( aRootURL, FSYS_STYLE_URL  );
	if ( !aDirEntry.Exists() )
		return FALSE;

	return TRUE;
}

//============================================================================
// static
String CntViewBase::GetRootViewURL( const String& rViewURL )
{
	if ( rViewURL.Len() == 0 )
		return String();

	BOOL bRoot = FALSE;
	if ( IsViewURL( bRoot, rViewURL ) )
	{
		String aURL( rViewURL );
		if ( !bRoot )
			aURL.Erase( aURL.Search( CNT_VIEW_URL_DELIMITER ) );

		return aURL;
	}

	return String();
}

//============================================================================
// static
String CntViewBase::GetServiceURL( const String& rViewURL )
{
	if ( rViewURL.Len() == 0 )
		return String();

	BOOL bRoot = FALSE;
	if ( IsViewURL( bRoot, rViewURL ) )
	{
		if ( !bRoot )
		{
			String aURL( rViewURL );

			// Fuer Nicht-Storage-View-URL's ( z.B. Datenbank ) ist
			// die Service-URL immer gleich der View-URL!!!
			if ( CntViewStorageNode::IsSubViewURL( aURL ) )
				aURL.Erase( 0, aURL.Search( CNT_VIEW_URL_DELIMITER ) + 1 );

			return aURL;
		}
	}

	return String();
}

//============================================================================
// static
String CntViewBase::MakeViewURL( const String& rRootViewURL,
                                 const String& rServiceURL, BOOL bValidate )
{
	if ( bValidate && !( rRootViewURL.Len() && rServiceURL.Len() ) )
		return String();

	String aViewURL( rRootViewURL );
	aViewURL += CNT_VIEW_URL_DELIMITER;
	aViewURL += rServiceURL;

#ifdef DBG_UTIL
	bValidate = TRUE;
#endif

	if ( bValidate && !IsValidViewURL( aViewURL ) )
	{
		DBG_ERROR( "CntViewBase::MakeViewURL - Invalid URL!" );
		return String();
	}

	return aViewURL;
}

//============================================================================
// static
CntNode* CntViewBase::MakeViewNode( CntNode* pResultedNode,
									CntNode* pHintReceiver )
{
	if ( !pResultedNode || !pHintReceiver )
		return NULL;

	BOOL bIsFolder =
			!ITEMSET_VALUE( pResultedNode, CntBoolItem, WID_FLAG_IS_DOCUMENT );
	bIsFolder |=
			ITEMSET_VALUE( pResultedNode, CntBoolItem, WID_FLAG_IS_FOLDER );

	if ( !bIsFolder )
	{
		// Resulted node is not a folder.
		return NULL;
	}

	const String& rURL = OWN_URL( pResultedNode );
	if ( IsViewURL( rURL ) )
	{
		// Resulted node already has a View URL.
		return NULL;
	}

	if ( pHintReceiver->GetMostReferedNode()->GetRootNode() !=
		 pResultedNode->GetMostReferedNode()->GetRootNode() )
	{
		// Receiver and resulted node have different root nodes.
		return NULL;
	}

	CntNode* pRoot = pHintReceiver->GetRootNode();
	const String& rRootURL = OWN_URL( pRoot );
	if ( !IsRootViewURL( rRootURL ) )
	{
		// Receiver's root node has no View URL.
		return NULL;
	}

	// Everything okay, make a View URL and construct a node for it.
	const String& rServiceURL = OWN_URL( pResultedNode->GetMostReferedNode() );
	String aViewURL( MakeViewURL( rRootURL, rServiceURL ) );

	CntNode* pFastQuery = pRoot;
	if ( pFastQuery != pHintReceiver )
		pFastQuery = pHintReceiver->GetParent();

	CntNode* pViewNode = pFastQuery->Query( aViewURL );
	if ( !pViewNode )
		pViewNode = pRoot->Query( aViewURL );

	return pViewNode;
}

//============================================================================
//
// CntViewNode Implementation.
//
//============================================================================

TYPEINIT1_AUTOFACTORY( CntViewNode, CntNode );

//============================================================================
CNT_NODE_SUBCLASS_IMPL( CntViewNode )
{
	// register possible children
	CntNodeFactory* pFac =
			new CntNodeFactory( '*', UniString(), StaticType() );
	InsertFactory( pFac );
}

//============================================================================
CntViewNode::CntViewNode()
: CntNode( NULL ),
  m_bGetDataDone( FALSE )
{
}

//============================================================================
// virtual
CntViewNode::~CntViewNode()
{
}

//============================================================================
// virtual
CntNode* CntViewNode::Initialize( CntNode* pParent, const String& rNodeURL )
{
	DBG_ASSERT( pParent &&
	            ( pParent->ISA( CntViewStorageNode ) ||
	              pParent->ISA( CntViewNode ) ),
	            "CntViewNode::Initialize - Invalid parent!" );

	CntNodeRef xRefNode( NULL );
	String aReferedURL(
			rNodeURL.Copy( rNodeURL.Search( CNT_VIEW_URL_DELIMITER ) + 1 ) );
	if ( aReferedURL.Len() )
	{
		xRefNode = CNT_RNM()->Query( aReferedURL );
		if ( !xRefNode.Is() )
			return NULL;

		// Note: Because I'm unable to get the right URL for the refered
		//       node at this point ( child delimiter unknown ), a node
		//       for the whole refered URL was queried. This' correct
		//       refered node will be in parent chain of that node.
		//		 Following code gets the right refered node from the chain.

		ULONG nMyDepth = 0;
		CntNode* pTmp = pParent;
		while ( pTmp )
		{
			++nMyDepth;
			pTmp = pTmp->GetParent();
		}

		ULONG nRefDepth = 0;
		pTmp = xRefNode->GetParent();
		while ( pTmp )
		{
			++nRefDepth;
			pTmp = pTmp->GetParent();
		}

		DBG_ASSERT( nRefDepth >= nMyDepth,
					"CntViewNode::Initialize - Node chain incorrect!!!" );

		if ( nRefDepth > nMyDepth )
		{
			pTmp = &xRefNode;

			ULONG nDiff = nRefDepth - nMyDepth;
			while ( nDiff )
			{
				--nDiff;
				pTmp = pTmp->GetParent();
			}

			xRefNode = pTmp;
		}
	}

	CntNode* pRef = xRefNode->ISA( CntStorageNode )
				  ? xRefNode->GetReferedNode()
				  : &xRefNode;

	// Set own child delimiters to these of refered node.
	SetChildDelims( pRef->GetChildDelims() );

	// Connect to refered node.
	SetReferedNode( xRefNode );

	//////////////////////////////////////////////////////////////////////
	// Restore (inherited) View Data
	//////////////////////////////////////////////////////////////////////

	// Restore own "hard" view properties.
	String aPropsName( xRefNode->GetMostReferedNode()->GetPropertyKey() );
	CntViewStorageNode* pRoot = (CntViewStorageNode*)GetRootNode();

	pRoot->acquireStorage();

	CntStoreItemSetRef xViewSet(
						pRoot->openItemSet( aPropsName, STREAM_STD_READ ) );
	if ( xViewSet.Is() )
	{
		SfxItemIter aIter( *xViewSet );
		const SfxPoolItem* pItem = aIter.FirstItem();
		while ( pItem )
		{
			USHORT nWhich = pItem->Which();
			if ( GetItemState( nWhich ) > SFX_ITEM_DISABLED )
				CntNode::Put( *pItem, nWhich );
			else
				xViewSet->ClearItem( nWhich );

			pItem = aIter.NextItem();
		}

		xViewSet.Clear();
	}


	// Restore inherited view data.
	CntNode*     pMostRef = xRefNode->GetMostReferedNode();
	CntDefaults* pDefs    = pMostRef->GetDefaults();
	CntDefaults* pParDefs =	pParent->GetMostReferedNode()->GetDefaults();

	// Construct own URL - GetChildDefaultsItem() needs it.
	String aOwnURL( rNodeURL );
	ConstructOwnURL_Impl( aOwnURL );
	CntNode::Put( CntStringItem( WID_OWN_URL, aOwnURL ), WID_OWN_URL );

	const CntItemListItem* pDefsItem = GetChildDefaultsItem();
	const INetContentType  eType     = pMostRef->GetCreator()->GetId();

	SfxWhichIter aIter( *pMostRef );
	USHORT nWhich = aIter.FirstWhich();
	while ( nWhich )
	{
			 // Item in my ranges?
		if ( ( GetItemState( nWhich ) > SFX_ITEM_DISABLED ) &&
			 // Value not already set as "hard" property?
			 ( GetItemState( nWhich, FALSE ) < SFX_ITEM_SET ) &&
			 // Auto inherited?
		     pMostRef->IsItemFlag( nWhich, CNT_ITEM_AUTO_INHERIT ) &&
			 // View Prop?
			 pMostRef->IsItemFlag( nWhich, CNT_ITEM_AUTO_VIEWPROP ) )
		{
			BOOL bUsedDefs = FALSE;
			if ( pDefsItem )
			{
				const SfxPoolItem* pItem = pDefsItem->Get( nWhich );
				if ( pItem )
				{
					CntNode* pCurr = pParent;
					while ( pCurr )
					{
						const INetContentType eCurrType =
						   pCurr->GetMostReferedNode()->GetCreator()->GetId();
						if ( eCurrType != eType )
						{
							pCurr = NULL;
							break;
						}

						// Is Item sticky in parent?
						aPropsName =
							pCurr->GetMostReferedNode()->GetPropertyKey();
						xViewSet =
							pRoot->openItemSet( aPropsName, STREAM_STD_READ );
						if ( xViewSet.Is() )
						{
							SfxItemState eState =
									xViewSet->GetItemState( nWhich, FALSE );

							xViewSet.Clear();

							if ( eState == SFX_ITEM_SET )
								break;

						}

						pCurr = pCurr->GetParent();
					}

					if ( !pCurr )
					{
						CntNode::Put( *pItem, pItem->Which() );
						bUsedDefs = TRUE;
					}
				}
			}

			if ( !bUsedDefs )
			{
				if ( ( GetItemState( nWhich ) > SFX_ITEM_DISABLED ) &&
				     ( pParent->GetItemState( nWhich ) > SFX_ITEM_DISABLED ) )
				{
					const SfxPoolItem& rItem = pParent->Get( nWhich );
					if ( rItem != Get( nWhich ) )
					{
						if ( pDefs && pParDefs )
						{
							// Unequal class defaults -> item cannot be
							// inherited from parent.
							if ( pDefs->Get( nWhich ) == pParDefs->Get( nWhich ) )
								CntNode::Put( rItem, nWhich );
						}
					}
				}
			}
		}

		nWhich = aIter.NextWhich();
	}

	pRoot->releaseStorage();

	return CntNode::Initialize( pParent, rNodeURL );;
}

//============================================================================
//virtual
void CntViewNode::SetReferedNode( CntNode* pNode )
{
	// set own ranges to ranges of refered node
	SetRanges( pNode->GetRanges() );

	CntNode* pOld = GetReferedNode();
	if ( pOld && ( pOld != pNode ) )
	{
		CntNode* pRef = pNode->ISA( CntStorageNode )
					  ? pNode->GetReferedNode()
					  : pNode;

		// Set own child delimiters to these of refered node.
		SetChildDelims( pRef->GetChildDelims() );

		// Adapt own URL to pNode's
		String aNewURL( OWN_URL( GetRootNode() ) );
		aNewURL += CNT_VIEW_URL_DELIMITER;
		aNewURL += OWN_URL( pRef );

		if ( OWN_URL( this ) != aNewURL )
		{
			// Re-Initialize with new URL.
			CntNode::Put( CntStringItem( WID_OWN_URL, aNewURL ), WID_OWN_URL );
			CntNode::Initialize( GetParent(), aNewURL );
		}
	}

	CntNode::SetReferedNode( pNode );
}

//============================================================================
// virtual
void CntViewNode::GetOwnURL( String& rOwnURL )
{
	CntNode* pParent = GetParent();
	if ( !pParent )
		return;

	String aParentURL( OWN_URL( pParent ) );
	if ( pParent->IsRootNode() )
	{
		aParentURL += CNT_VIEW_URL_DELIMITER;
		aParentURL += OWN_URL( pParent->GetMostReferedNode() );
	}

	xub_StrLen nSearchPos = rOwnURL.Match( aParentURL );

	// If my URL part starts with a child delimiter of my parent,
	// it must be skipped in further processing.

	if ( rOwnURL.GetChar( nSearchPos ) == rOwnURL.GetChar( nSearchPos - 1 ) )
		nSearchPos++;

	String aDelims = pParent->GetChildDelims();
	xub_StrLen nDelims = aDelims.Len();
	sal_Unicode aFinal  = rOwnURL.GetChar( nSearchPos );
	xub_StrLen n;
	for ( n = 0; n < nDelims; ++n )
	{
		if ( aFinal == aDelims.GetChar( n ) )
		{
			nSearchPos++;
			break;
		}
	}

	//////////////////////////////////////////////////////////////////////
   	// Search a child delimiter of 'this' in rOwnURL, cut it at that pos.
   	//////////////////////////////////////////////////////////////////////

   	const String& rDelims = GetChildDelims();
   	nDelims = rDelims.Len();
   	for ( n = 0; n < nDelims; ++n )
   	{
   		sal_Unicode cCurrDel = rDelims.GetChar( n );

   		xub_StrLen nPos = rOwnURL.Search( cCurrDel, nSearchPos );
   		if ( nPos != STRING_NOTFOUND )
   		{
   			// Do not cut a final '/'!
   			if ( rOwnURL.GetChar( nPos ) != '/' )
   				nPos--;

   			// Gotcha!
   			rOwnURL.Erase( nPos + 1 );
   			break;
   		}
   	}
}

//----------------------------------------------------------------------------
const SfxPoolItem* CntViewNode::InsertJob( CntNodeJob *pJob )
{
    const SfxPoolItem* pReq   = pJob->GetRequest();
    USHORT nWhich = pReq->Which();
    switch ( nWhich )
    {
        case WID_GETDATA:
			if ( m_bGetDataDone )
			{
				pJob->Done();
				return NULL;
			}

			m_bGetDataDone = TRUE;
			break;

        default:
            break;
    }

    return CntNode::InsertJob( pJob );
}

//============================================================================
// virtual
void CntViewNode::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
{
	//////////////////////////////////////////////////////////////////////
	// CntNodeHint handling.
	//////////////////////////////////////////////////////////////////////

	if ( rHint.ISA( CntNodeHint ) )
	{
		const CntNodeHint *pNodeHint = (const CntNodeHint*)&rHint;
		switch ( pNodeHint->GetAction() )
		{
			case CNT_ACTION_EXCHANGED:
				m_bGetDataDone = FALSE;
				break;

			default:
				break;
		}
	}

	CntNode::Notify( rBC, rHint );
}

//============================================================================
//
// HARDCORE Stuff for automatic inherited properties...
//
//============================================================================

const CntItemListItem* GetChildDefaultsItem_Impl(
				const CntItemListItem& rAllDefsItem, INetContentType eType )
{
	USHORT nCount = rAllDefsItem.Count();
	for ( USHORT n = 0; n < nCount; ++n )
	{
		const CntItemListItem* pDefsItem =
				(const CntItemListItem*)&(rAllDefsItem[ n ]);
		const CntContentTypeItem* pTypeItem =
				(const CntContentTypeItem*)pDefsItem->Get( WID_CONTENT_TYPE );
		if ( pTypeItem )
		{
			const INetContentType eCurrType = pTypeItem->GetEnumValue();
			if ( eCurrType == eType )
			{
				return pDefsItem;
			}
		}
	}
	return NULL;
}

//============================================================================
const CntItemListItem* GetChildDefaultsItem_Impl( CntNode* pSource,
												  INetContentType eType )
{
	const CntItemListItem& rAllDefsItem = (const CntItemListItem&)
							pSource->GetRootNode()->Get( WID_CHILD_DEFAULTS );
	return GetChildDefaultsItem_Impl( rAllDefsItem, eType );
}

//============================================================================
void UpdateChildDefaultsItem_Impl( CntNode* pSource, INetContentType eType,
								   const SfxPoolItem& rItem )
{
	const CntItemListItem& rAllDefsItem = (const CntItemListItem&)
							pSource->GetRootNode()->Get( WID_CHILD_DEFAULTS );
	CntItemListItem aAllDefsItem( rAllDefsItem, pSource->GetPool() );

	const CntItemListItem* pDefsItem =
								GetChildDefaultsItem_Impl( pSource, eType );
	CntItemListItem* pMyDefsItem = NULL;
	if ( !pDefsItem )
	{
		pMyDefsItem = new CntItemListItem(
									WID_CHILD_DEFAULTS, pSource->GetPool() );
		pMyDefsItem->Append( new CntContentTypeItem(
									WID_CONTENT_TYPE, eType ) );
	}
	else
		pMyDefsItem = new CntItemListItem( *pDefsItem, pSource->GetPool() );

	USHORT nCount = aAllDefsItem.Count();
	for ( USHORT n = 0; n < nCount; ++n )
	{
		CntItemListItem* pDefsItem = (CntItemListItem*)&(aAllDefsItem[ n ]);
		const CntContentTypeItem* pTypeItem =
				(const CntContentTypeItem*)pDefsItem->Get( WID_CONTENT_TYPE );
		if ( pTypeItem )
		{
			const INetContentType eCurrType = pTypeItem->GetEnumValue();
			if ( eCurrType == eType )
			{
				aAllDefsItem.Remove( n );
				break;
			}
		}
	}

	nCount = pMyDefsItem->Count();
	for ( USHORT m = 1; m < nCount; ++m )
	{
		const SfxPoolItem& rCurr = (*pMyDefsItem)[ m ];
		if ( rCurr.Which() == rItem.Which() )
		{
			pMyDefsItem->Remove( m );
			break;
		}
	}

	pMyDefsItem->Append( rItem.Clone() );
	aAllDefsItem.Append( pMyDefsItem );

	// Set and store new item.
	CntStorageNode* pStorage = (CntStorageNode*)pSource->GetRootNode();

	// assemble name of propterty-stream
	String aPropsName( pStorage->GetMostReferedNode()->GetPropertyKey() );

	// get property-set
	pStorage->attrib( aPropsName, 0,
					  CNTDIRENTRY_ATTRIB_HIDDEN | CNTDIRENTRY_ATTRIB_CREATE );
	CntStoreItemSetRef xSet( pStorage->openItemSet( aPropsName,
													STREAM_STD_READWRITE ) );
	if ( xSet.Is() )
		xSet->Put( aAllDefsItem );

	pStorage->CntNode::Put( aAllDefsItem, WID_CHILD_DEFAULTS );
}

//============================================================================
// static
void CntViewNode::PutChildViewDefaults( CntNode* pTarget,
										const CntItemListItem& rDefs,
										BOOL bInitialized /* = TRUE */ )
{
	if ( !CntViewBase::IsViewURL( OWN_URL( pTarget ) ) )
		return;

	const INetContentType eType =
					pTarget->GetMostReferedNode()->GetCreator()->GetId();
	switch ( eType )
	{
		case CONTENT_TYPE_X_CNT_NEWSBOX:
		{
			const CntItemListItem* pDefsItem =
					GetChildDefaultsItem_Impl( rDefs,
										   	   CONTENT_TYPE_X_CNT_NEWSGROUP );
			if ( !pDefsItem )
				break;

			const SfxPoolItem* pItem = pDefsItem->Get( WID_MESSAGEVIEW_MODE );
			if ( pItem )
				pTarget->CntNode::Put( *pItem, pItem->Which() );

			pItem = pDefsItem->Get( WID_SHOW_MSGS_HAS_TIMELIMIT );
			if ( pItem )
				pTarget->CntNode::Put( *pItem, pItem->Which() );

			pItem = pDefsItem->Get( WID_SHOW_MSGS_TIMELIMIT );
			if ( pItem )
				pTarget->CntNode::Put( *pItem, pItem->Which() );

			CntAnchorRef xAnchor( NULL );

			pItem = pDefsItem->Get( WID_UPDATE_ENABLED );
			if ( pItem )
			{
				if ( bInitialized )
				{
					xAnchor = new CntAnchor( NULL, pTarget );
					xAnchor->Put( *pItem );
				}
				else
					pTarget->CntNode::Put( *pItem, pItem->Which() );
			}

			pItem = pDefsItem->Get( WID_AUTOUPDATE_INTERVAL );
			if ( pItem )
			{
				if ( bInitialized )
				{
					if ( !xAnchor.Is() )
						xAnchor = new CntAnchor( NULL, pTarget );

					xAnchor->Put( *pItem );
				}
				else
					pTarget->CntNode::Put( *pItem, pItem->Which() );
			}

			break;
		}

		case CONTENT_TYPE_X_CNT_IMAPBOX:
		{
			const CntItemListItem* pDefsItem =
					GetChildDefaultsItem_Impl( rDefs,
										   	   CONTENT_TYPE_X_CNT_IMAPFOLDER );
			if ( !pDefsItem )
				break;

			const SfxPoolItem* pItem = pDefsItem->Get( WID_MESSAGEVIEW_MODE );
			if ( pItem )
				pTarget->CntNode::Put( *pItem, pItem->Which() );

			pItem = pDefsItem->Get( WID_SHOW_MSGS_HAS_TIMELIMIT );
			if ( pItem )
				pTarget->CntNode::Put( *pItem, pItem->Which() );

			pItem = pDefsItem->Get( WID_SHOW_MSGS_TIMELIMIT );
			if ( pItem )
				pTarget->CntNode::Put( *pItem, pItem->Which() );

			CntAnchorRef xAnchor( NULL );

			pItem = pDefsItem->Get( WID_UPDATE_ENABLED );
			if ( pItem )
			{
				if ( bInitialized )
				{
					xAnchor = new CntAnchor( NULL, pTarget );
					xAnchor->Put( *pItem );
				}
				else
					pTarget->CntNode::Put( *pItem, pItem->Which() );
			}

			pItem = pDefsItem->Get( WID_AUTOUPDATE_INTERVAL );
			if ( pItem )
			{
				if ( bInitialized )
				{
					if ( !xAnchor.Is() )
						xAnchor = new CntAnchor( NULL, pTarget );

					xAnchor->Put( *pItem );
				}
				else
					pTarget->CntNode::Put( *pItem, pItem->Which() );
			}

			break;
		}

		case CONTENT_TYPE_X_CNT_FSYSBOX:
		{
			const CntItemListItem* pDefsItem =
					GetChildDefaultsItem_Impl( rDefs,
										   	   CONTENT_TYPE_X_CNT_FSYSFOLDER );
			if ( !pDefsItem )
				break;

			const SfxPoolItem* pItem = pDefsItem->Get( WID_MESSAGEVIEW_MODE );
			if ( pItem &&
				 // Note: Property is only available in Value-Added-Mode!
			     ( pTarget->GetItemState(
				 			WID_MESSAGEVIEW_MODE ) > SFX_ITEM_DISABLED ) )
				pTarget->CntNode::Put( *pItem, pItem->Which() );

			break;
		}

		default:
			break;
	}
}

//============================================================================
// static
void CntViewNode::SyncChildViewDefaults( CntNode* pSource,
										 const SfxPoolItem& rItem )
{
	if ( !CntViewBase::IsViewURL( OWN_URL( pSource ) ) )
		return;

	USHORT nWhich = rItem.Which();

	const INetContentType eType =
					pSource->GetMostReferedNode()->GetCreator()->GetId();
	switch ( eType )
	{
		case CONTENT_TYPE_X_CNT_NEWSBOX:
		{
			if ( ( nWhich == WID_MESSAGEVIEW_MODE ) ||
				 ( nWhich == WID_SHOW_MSGS_HAS_TIMELIMIT ) ||
				 ( nWhich == WID_SHOW_MSGS_TIMELIMIT ) ||
				 ( nWhich == WID_UPDATE_ENABLED ) ||
				 ( nWhich == WID_AUTOUPDATE_INTERVAL ) )
				UpdateChildDefaultsItem_Impl(
							pSource, CONTENT_TYPE_X_CNT_NEWSGROUP, rItem );

			break;
		}

		case CONTENT_TYPE_X_CNT_IMAPBOX:
		{
			if ( ( nWhich == WID_MESSAGEVIEW_MODE ) ||
				 ( nWhich == WID_SHOW_MSGS_HAS_TIMELIMIT ) ||
				 ( nWhich == WID_SHOW_MSGS_TIMELIMIT ) ||
				 ( nWhich == WID_UPDATE_ENABLED ) ||
				 ( nWhich == WID_AUTOUPDATE_INTERVAL ) )
				UpdateChildDefaultsItem_Impl(
							pSource, CONTENT_TYPE_X_CNT_IMAPFOLDER, rItem );

			break;
		}

		case CONTENT_TYPE_X_CNT_FSYSBOX:
		{
			if ( nWhich == WID_MESSAGEVIEW_MODE )
				UpdateChildDefaultsItem_Impl(
						pSource, CONTENT_TYPE_X_CNT_FSYSFOLDER, rItem );

			break;
		}

		default:
			break;
	}
}

