/*************************************************************************
 *
 *  $RCSfile: imapmesg.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:13:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CHAOS_IMAPMESG_HXX
#define CHAOS_IMAPMESG_HXX

#ifndef _CNTMSGNODE_HXX
#include <cntmsgnd.hxx>
#endif

class INetIMAPFetchResponse;

namespace chaos {

class CntIMAPMbox;

//============================================================================
class CntIMAPMesgNode: public CntMessageNode
{
	bool m_bInitialized;
	bool m_bDeleted;
	bool m_bInheritedKeepBodyFlag;

	static bool skipNumber(const String & rText, xub_StrLen & rOffset,
						   sal_uInt32 & rValue);

	CntIMAPMesgNode();

public:
	TYPEINFO();

	CntIMAPMbox & getParentMbox();

	bool initialize(CntNodeJob & rJob, bool bCreate = false,
					const INetIMAPFetchResponse * pFetchData = 0,
					const SfxItemSet * pImportData = 0);

	bool isDeleted() const { return m_bDeleted; }

	void setDeleted(bool bTheDeleted) { m_bDeleted = bTheDeleted; }

	void storeProperty(CntNodeJob & rJob, const SfxPoolItem & rItem);

	bool hasKeepBodyFlag() const { return !m_bInheritedKeepBodyFlag; }

	String getDataStreamID() const;

	String getBodyStreamID() const;

	static String createMesgDirID(sal_uInt32 nUIDValidity,
								  sal_uInt32 nMesgUID);

	static String createDataStreamID(const String & rMboxURL,
									 sal_uInt32 nUIDValidity,
									 sal_uInt32 nMesgUID);

	static String createBodyStreamID(const String & rMboxURL,
									 sal_uInt32 nUIDValidity,
									 sal_uInt32 nMesgUID);

	static String createBodyStreamID(const String & rMesgURL);

	static bool isMesgDirID(const String & rMesgDirID,
							sal_uInt32 & rUIDValidity, sal_uInt32 & rMesgUID);

	void setBodyProperties(CntNodeJob & rJob);

	/** Check for an offline available message body and restore it.

		@param rJob  Some job to supply the cache node.

		@return  True if the node has a WID_MESSAGEBODY item or the cache
		contains a message body for this node (which will also be restored as
		a WID_MESSAGEBODY by this method).
	 */
	bool getBody(CntNodeJob & rJob);

	/** Check for the need to download the message body.

		@param rJob  Some job to supply the cache node.

		@return  True if the message should be kept locally
		(WID_MESSAGE_STOREMODE), but it is not available locally.
	 */
	bool mustDownloadBody(CntNodeJob & rJob);

	void setKeepBodyFlag(CntNodeJob & rJob, bool bStore);

	virtual void GetOwnURL(String & rURL) {}
};

}

#endif // CHAOS_IMAPMESG_HXX

