/*************************************************************************
 *
 *  $RCSfile: cntapi.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:41 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CNTAPI_HXX
#define _CNTAPI_HXX 1

#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_XINTERFACE_HPP_
#include <com/sun/star/uno/XInterface.hpp>
#endif

#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif

#ifndef _CNTBASE_HXX
#include <cntbase.hxx>
#endif
#ifndef _CHAOS_CNTRLDEF_HXX
#include <cntrldef.hxx>
#endif
#ifndef _CNTVWITM_HXX
#include <cntvwitm.hxx>
#endif

class  CntBoolItem;
class  SfxUShortRanges;

namespace chaos {

struct CntThreadData;
struct CntErrorData;
struct CntAnchor_Impl;
class  ChaosTaskBase;
class  CntThreadList;
class  CntThreadingItem;
class  CntItemListItem;
class  CntNodeRule;
class  CntNodeJob;
class  PosEntryFinder;
class  ImplOpenData;

#define ANCHOR_NOT_FOUND ULONG_MAX

#if _SOLAR__PRIVATE
struct CntAnchor_Impl
{
	vos::OMutex		maMutex;
};
#endif

//=========================================================================

class CntAnchor : public CntInterface
{
private:
	friend class CntThreadList;
	friend class ImplOpenData;

	CntNodeRef					_xNode;
	List* 						_pSubAnchors;
	CntAnchor*					_pParentAnchor;
	CntAnchor*					_pThreader;
	CntThreadData*				_pCntThreadData;
	BOOL						_bIsThreaded	: 1;
	BOOL						_bGetDataDone	: 1;
	BOOL						_bIgnoreFilterdMsg : 1;
	BOOL						_bIsInserted	: 1;
	BOOL						_bIgnoreNodes	: 1;
	BOOL						_bMarkedAsRead	: 1;
	BOOL						_bDontThread	: 1;
	BOOL						_bLocked		: 1;
	BOOL						_bIsOpen		: 1;
	BOOL						_bIsExpanded	: 1;
	BOOL						_bMarkedAsRoot	: 1;
	BOOL						_bIsVisible		: 1;
	BOOL						_bNeedRelease	: 1;
	BOOL						_bInitSubAnchors: 1;
	BOOL						_bHasRules		: 1;
	BOOL						_bShowFolders	: 1;
	BOOL						_bShowDocuments	: 1;
	BOOL						_bIsDocument	: 1;
	BOOL						_bUsesNewView	: 1;
	BOOL						_bInOpen		: 1;
	BOOL						_bIsVisibleRoot : 1;
	BOOL						_bExpanding		: 1;
	BOOL						_bCleanupParents: 1;
	BOOL						_bNotifyExpanded: 1;
	BOOL						_bFolderFirst	: 1;
	BOOL						_bCollectAnchors: 1;
	BOOL						_bIsRootAnchor	: 1;
	BOOL						_bNotifyAll		: 1;
	BOOL						_bCheckedForRoot: 1;
	ErrCode						_nError;
	ULONG						_nSeenCount;
	ULONG						_nTotalChildren;
	ULONG						_nSortingInfo;
	ULONG						_nOpenCount;
	PosEntryFinder*				_pSearchData;
	CntAnchor*					_pChildList;
	CntAnchor*					_pNextBrother;
	SfxPoolItem*				_pChangedItem;
	ImplOpenData*				_pOpenData;
	CntAnchor_Impl*				_pImpData;

								CntAnchor( const CntAnchor& ); // n.i.
    CntAnchor&					operator=( const CntAnchor& ); // n.i.

	const String 				GetViewURL_Impl() const;
	const SfxPoolItem* 			PutItem_Impl( const SfxPoolItem& rProp,
										  	  USHORT nWhich,
											  BOOL bMakePersist,
										      CntNodeJob* pJob,
											  const Link* pErrorHandler,
										      SfxCancellable** pCancellable,
											  ChaosTaskBase * pTaskBase = 0 );

	ULONG						FindPos( CntAnchor *pAnchor, BOOL &rFound );
	BOOL						FindNext( CntAnchor **pResult, ULONG nStartPos,
										  BOOL bUnRead ) const;
	BOOL						FindPrev( CntAnchor **pResult, ULONG nStartPos,
										  BOOL bUnRead ) const;
	void						RemoveFromChildList( CntAnchor *pChild );
	void						CheckAnchor( const SfxPoolItem& rChangedItem );
	void						ExpandChildren( CntOpenMode	eOpenMode );
	void						HandleUnsubscribe();
	void						MoveAnchor( CntAnchor* pAnchor );
	const CntAnchor*			GetSortParent() const;
#if _SOLAR__PRIVATE
	vos::OMutex*				GetMutex() const { return &(_pImpData->maMutex); }
#endif
								DECL_LINK( HandleError, CntErrorData* );
protected:
	virtual						~CntAnchor();
	virtual void				Changed( const SfxPoolItem& rOld,
										 const SfxPoolItem& rNew);
public:
								TYPEINFO();

								CntAnchor( CntAnchor* pParent,
										   const String& rURL,
										   BOOL bCheckURL = TRUE );
#if _SOLAR__PRIVATE
								CntAnchor( CntAnchor* pParent,
										   CntNode* pNode );
#endif

	FASTBOOL					IsItemFlag( USHORT nWID, USHORT nFlag ) const;

	// Has anchor error(s)?
	ErrCode						GetError() { return _nError; }

	// Access to parent anchor
	CntAnchor*					GetParent() const { return _pParentAnchor; }
	BOOL						IsRootAnchor( BOOL bResolveLinks = FALSE ) const;

	// Access to subanchors
	void 						InsertSubAnchor( CntAnchor *pNewAnchor,
												 CntAnchor *pThreader,
												 CntNodeJob* pJob );
	void 						RemoveSubAnchor( CntAnchor *pAnchor,
												 BOOL bRelease = TRUE );
	void						RemoveSubAnchors( BOOL bBroadcast );
	BOOL						DeleteAnchor();
	ULONG						SubAnchorCount() const
								{ return _pSubAnchors
										 ? _pSubAnchors->Count()
										 : 0; }
	CntAnchor*					GetSubAnchor( ULONG nPos ) const;
	CntAnchor*					operator[]( ULONG nPos )
								{ return GetSubAnchor( nPos ); }
	CntAnchor*					GetAnchor( ULONG nAbsPos ) const;
	ULONG						AnchorCount() const;
	ULONG						GetAbsPos() const;
	USHORT						GetDepth( CntAnchor *pRoot ) const;
	CntAnchor*					GetAbsParent( BOOL bIgnoreSelf = FALSE ) const;
	CntAnchor*					GetRoot() const;
	void						Expand( BOOL bRecursive = FALSE,
										BOOL bNotify = FALSE );
	void						Expand( CntOpenMode eOpenMode,
										BOOL bRecursive = FALSE,
										BOOL bNotify = FALSE );
	void						Collapse( BOOL bRecursive = FALSE );
	void 						SetOpenMode( CntOpenMode eOpenMode );
	CntOpenMode					GetOpenMode() const;
	void 						MakeRootVisible();
	void						SetExpanded( BOOL bExpanded )
								{ _bIsExpanded = bExpanded; }
	CntAnchor*					GetNextAnchor( BOOL bUnRead,
											   BOOL bMakeVisible,
											   BOOL bForward,
											   BOOL bIgnoreSelf = FALSE );
	void						MarkAsRoot() { _bMarkedAsRoot = TRUE; }

	// Access to node
	CntNode*					GetNode() const { return _xNode; }
	ErrCode 					SetNode( CntNode* pNode );

	// Access to URL's
	const String 				GetViewURL( BOOL bStrict = FALSE ) const;
	const String 				GetParentViewURL( BOOL bStrict = FALSE ) const;
	const String 				GetRootViewURL( BOOL bStrict = FALSE ) const;
	static BOOL					IsViewURL( const String& rURL );
	static const String			ToViewURL( const String& rRootViewURL,
										   const String& rServiceURL );
	static BOOL					ToServiceURL     ( String& rViewURL );
	static BOOL					ToPresentationURL( String& rViewURL );

	const String&				GetServiceURL() const;
	const String 				GetParentServiceURL() const;
	const String& 				GetRootServiceURL() const;

	const String				GetPresentationURL() const;
	const String        		GetCaseSensitiveFileURL() const;

	//  Threading ...
	void						DontThread() { _bDontThread = TRUE; }
	void 						InsertThreaded( CntAnchor *pChildAnchor,
												CntAnchor *pNewAnchor,
												CntNodeJob* pJob,
												BOOL *pThreadIt = NULL );
	void						ChangeThreadingMode( CntAnchor *pParent,
													 BOOL bThreadIt );
	CntThreadList*				GetItemList( const CntThreadingItem& rItem,
											 ULONG nIndex );
	void						ChangeParent( CntAnchor *pNewParent,
											  CntAnchor *pThreader = NULL );
	void						CopyChildren( CntAnchor *pOldParent );
	CntAnchor*					GetThreader() const { return _pThreader; }
	CntAnchor*					GetTParent() const;

	void						MarkThread( const SfxPoolItem &rItem );
	BOOL						DeleteChildren( CntItemListItem* pListItem );
	void						DeleteAllChildren( BOOL bMessages );
	void						RemoveFromLists();

	// "Seen" state ...
	CntSeenStatus				GetSeenStatus() const;
	void						CheckSeenStatus( BOOL bForceUpdate = FALSE );

	// Sorting ...
	int							Compare( const CntAnchor *pAnchor,
	                                     BOOL bPtrs = FALSE ) const;
	void						RecalcDate( CntAnchor *pAnchor );
	void						ReSort();

	// Filtering ...
	BOOL						ApplyRules( CntAnchor *pNewAnchor,
											BOOL &bChecked );
	BOOL						HandleAction( CntNodeAction eAction,
											  CntAnchor *pNewNode );
	BOOL						GetViewProperties( const CntAnchor *pNewAnchor,
												   USHORT &rWID,
												   BOOL	&rTwoItems,
												   BOOL	&rUseOr,
												   SfxPoolItem **pCompare );
	BOOL						CheckViewMode( CntAnchor *pNewAnchor );
	void						CreateAndApplyRule( USHORT nWID );
	void						ApplyOneRule( const CntNodeRule& rRule );
	BOOL						FilterOldMsgs( CntNode *pChildNode );

	// SfxItemSet Put Interface ...
    virtual const SfxPoolItem*  Put( const SfxPoolItem& rProp, USHORT nWhich );
    const SfxPoolItem*          Put( const SfxPoolItem& rProp )
                                { return Put( rProp, rProp.Which() ); }
	virtual int					Put( const SfxItemSet& rSet,
									 BOOL bInvalidAsDefault = TRUE );

	// Own extended Put Interface...
    const SfxPoolItem*          Put( const SfxPoolItem& rProp,
									 SfxCancellable** pCancellable );
    const SfxPoolItem*          Put( const SfxPoolItem& rProp,
									 const Link& rErrorHandler,
									 SfxCancellable** pCancellable,
									 ChaosTaskBase * pTaskBase = 0 );
	const SfxPoolItem*			Put_NonPersist( const SfxPoolItem& rProp );
	const SfxPoolItem*          PutInterface( const SfxPoolItem& rProp )
	{ return CntInterface::Put(	rProp, rProp.Which() );	}
#if _SOLAR__PRIVATE
    const SfxPoolItem*          Put( CntNodeJob* pJob );
#endif

	// SfxListener Interface ...
	virtual void				Notify( SfxBroadcaster& rBC,
										const SfxHint& rHint );

	// ...
	BOOL						CheckNode( CntNode *pNode );
	BOOL						CheckAndInsertInNode( CntNode *pNode );
	void						RemoveFromNode();

	// ...
	void						MakeVisible( BOOL bVisible )
								{ _bIsVisible = bVisible; }
	BOOL						IsOpen() const
								{ return _bIsOpen ? TRUE : FALSE; }
	BOOL						IsInOpen() const
								{ return _bInOpen ? TRUE : FALSE; }
	BOOL						IsExpanded() const
								{ return _bIsExpanded ? TRUE : FALSE; }
	BOOL						IsVisible() const
								{ return _bIsVisible ? TRUE : FALSE; }
	SfxPoolItem*				GetChangedItem() const
								{ return _pChangedItem; }
	void						SetChangedItem( SfxPoolItem* pItem )
								{ _pChangedItem = pItem; }
	BOOL						GetFolderFirst() const
								{ return _bFolderFirst; }
	void						SetFolderFirst( BOOL bValue )
								{ _bFolderFirst = bValue; }
	BOOL						GetCollectAnchors() const
								{ return _bCollectAnchors; }
	void						SetCollectAnchors( BOOL bValue )
								{ _bCollectAnchors = bValue; }
	BOOL						IsNotifyAll() const
								{ return _bNotifyAll; }
	void						SetNotifyAll( BOOL bValue )
								{ _bNotifyAll = bValue; }

	BOOL						IsComponent() const;
	void						GetAllRanges( SfxUShortRanges& rRange ) const;
	SfxItemSet*					CloneItems() const;

	// Error handling
	BOOL						RegisterErrorHandler( const Link& rLink );
	BOOL						DeregisterErrorHandler();
	const Link* 				QueryErrorHandler() const;

	//////////////////////////////////////////////////////////////////////
	// Helper methods...
	//////////////////////////////////////////////////////////////////////

	BOOL						IsPseudoAnchor() const
								{ return _xNode.Is() ? FALSE : TRUE; }

	// OutTray...
	BOOL						OutTrayViewWanted( String& rOutURL );
	static const String&		GetOutTrayURL();

	void						SetInitSubAnchors()
									{ _bInitSubAnchors = TRUE; }
	ULONG						GetOpenCount() { return _nOpenCount; }
	void						SetOpenCount( ULONG nCount )
									{ _nOpenCount = nCount;}

#ifdef DBG_UTIL
	void						CheckChildList();
#else
	void						CheckChildList() {;}
#endif

	com::sun::star::uno::Reference<
			com::sun::star::uno::XInterface > getInterface() const;
};

SV_IMPL_REF( CntAnchor );

//=========================================================================

enum CntSaverAction {
	CNT_ACTION_NONE,
	CNT_ACTION_COPY,
	CNT_ACTION_MOVE,
	CNT_ACTION_DELETE,
	CNT_ACTION_LINK,
	CNT_ACTION_FORWARD
};

class CntAnchorSaverHint : public SfxHint
{
private:
	ULONG					_nErrorCode;
	CntAnchor*  			_pAnchor;
	CntSaverAction			_eAction;
	String					_aDestination;

						 	// n.i.
							CntAnchorSaverHint ( const CntAnchorSaverHint& );
							// n.i.
	CntAnchorSaverHint& 	operator= ( const CntAnchorSaverHint& );

public:
							TYPEINFO();

							CntAnchorSaverHint( ULONG nErrorCode,
												CntAnchor *pAnchor = NULL )
							: _nErrorCode( nErrorCode ),
							  _eAction( CNT_ACTION_NONE ),
							  _pAnchor( pAnchor )
							{}
							CntAnchorSaverHint( CntAnchor *pAnchor,
												CntSaverAction eAction,
												const String& rDestination );

							CntAnchorSaverHint( ULONG nErrorCode,
												CntAnchor *pAnchor,
												const String& rDestination )
							: _nErrorCode(nErrorCode),
							  _pAnchor( pAnchor ),
							  _eAction( CNT_ACTION_NONE ),
							  _aDestination( rDestination)
							  {}

	ULONG					GetErrorCode() const   { return _nErrorCode; }
	CntAnchor*				GetAnchor() const 	   { return _pAnchor; }
	const CntSaverAction	GetAction() const 	   { return _eAction; }
	const String&			GetDestination() const { return _aDestination; }
};

//=========================================================================

class CntAnchorHint : public SfxHint
{
private:
	CntAnchor*  			_pAnchor;
	CntAction				_eAction;
	CntNodeJob*				_pJob;

							CntAnchorHint ( const CntAnchorHint& ); // n.i.
	CntAnchorHint& 			operator= ( const CntAnchorHint& ); // n.i.

public:
							TYPEINFO();

							CntAnchorHint( CntAnchor *pAnchor,
										   CntAction eAction,
										   CntNodeJob* pJob );
	virtual					~CntAnchorHint();

	CntAnchor*				GetAnchor() const { return _pAnchor; }
	const CntAction			GetAction() const { return _eAction; }
#if _SOLAR__PRIVATE
	CntNodeJob* 			GetJob() const { return _pJob; }
#endif
};

//=========================================================================

class CntAnchorViewHint : public SfxHint
{
private:
	ULONG					_nAbsPos;
	ULONG					_nCount;
	CntAction				_eAction;
	USHORT					_nWhich;

public:
							TYPEINFO();

							CntAnchorViewHint( CntAction eAction,
											   ULONG nAbsPos, ULONG nCount,
											   USHORT nWhich = 0 )
							: _nAbsPos(nAbsPos),
							  _nCount(nCount),
							  _eAction(eAction),
							  _nWhich( nWhich )
							{}

	const CntAction			GetAction() const { return _eAction; }
	ULONG					GetAbsPos() const { return _nAbsPos; }
	ULONG					GetCount() const  { return _nCount; }
	USHORT					GetWhichID() const{ return _nWhich; }
};

//=========================================================================

class CntAnchorItem : public SfxPoolItem
{
private:
	CntAnchorRef			_xAnchor;

							CntAnchorItem( const CntAnchorItem &rOrig );
public:
							TYPEINFO();

							CntAnchorItem( USHORT nID,
										   CntAnchor * pAnchor );

	CntAnchor*				GetValue() const { return _xAnchor; }

	virtual int 			operator==( const SfxPoolItem& ) const;
	virtual SfxPoolItem*	Clone( SfxItemPool *pPool = NULL ) const;
};

SV_DECL_REF_LIST(XX_Anchor,CntAnchor*)
SV_IMPL_REF_LIST(XX_Anchor,CntAnchor*)

SV_DECL_REF(SfxAnchorList)

class SfxAnchorList : public SvRefBase, public XX_AnchorMemberList
{
public:
			SfxAnchorList( USHORT nIniSize=5, USHORT nResize=50) :
				XX_AnchorMemberList( nIniSize, nResize ) {}
};

SV_IMPL_REF(SfxAnchorList)

}

#endif
