/*************************************************************************
 *
 *  $RCSfile: flstitem.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CHAOS_FLSTITEM_HXX
#define CHAOS_FLSTITEM_HXX

#ifndef _SFXPOOLITEM_HXX
#include <svtools/poolitem.hxx>
#endif

#ifndef _CNTBASE_HXX
#include <cntbase.hxx>
#endif

namespace chaos {

//========================================================================
#define CNTFOLDER_SUBSCR 1
#define CNTFOLDER_NEW 2
#define CNTFOLDER_REMOVED 4
#define CNTFOLDER_DO_PURGE 8

//============================================================================
class CntFolderEntry
{
	String m_sTitle;
	String m_sID;
	void * m_pUserData;
	sal_uInt16 m_nFlags;
	sal_uInt16 m_nSavedFlags;

public:
	inline CntFolderEntry(const String & rTheTitle,
						  sal_Bool bSubscribed = sal_False);

	inline CntFolderEntry(const String & rTheTitle, const String & rTheID,
						  sal_Bool bSubscribed = sal_False);

	inline CntFolderEntry(const String & rTheTitle, const String & rTheID,
						  sal_uInt16 nTheFlags);

	operator const String &() const { return m_sTitle; }

	const String & getID() const { return m_sID; }

	inline StringCompare Compare(const String & rTheTitle,
								 const String & rTheID);

	void * GetUserData() const { return m_pUserData; }

	void SetUserData(void * pTheUserData) { m_pUserData = pTheUserData; }

	sal_Bool IsSubscribed() const
	{ return (m_nFlags & CNTFOLDER_SUBSCR) != 0; }

	inline void Subscribe(sal_Bool bSubscribe = sal_True);

	sal_uInt16 GetFlags() const { return m_nFlags; }

	void SetFlags(sal_uInt16 nTheFlags) { m_nFlags = nTheFlags; }

	void SaveFlags() { m_nSavedFlags = m_nFlags; }

	void RestoreFlags() { m_nFlags = m_nSavedFlags; }

	sal_uInt16 GetSavedFlags() const { return m_nSavedFlags; }
};

inline CntFolderEntry::CntFolderEntry(const String & rTheTitle,
									  sal_Bool bSubscribed):
	m_sTitle(rTheTitle),
	m_pUserData(0),
	m_nFlags(bSubscribed ? CNTFOLDER_SUBSCR : 0),
	m_nSavedFlags(0)
{}

inline CntFolderEntry::CntFolderEntry(const String & rTheTitle,
									  const String & rTheID,
									  sal_Bool bSubscribed):
	m_sTitle(rTheTitle),
	m_sID(rTheID),
	m_pUserData(0),
	m_nFlags(bSubscribed ? CNTFOLDER_SUBSCR : 0),
	m_nSavedFlags(0)
{}

inline CntFolderEntry::CntFolderEntry(const String & rTheTitle,
									  const String & rTheID,
									  sal_uInt16 nTheFlags):
	m_sTitle(rTheTitle),
	m_sID(rTheID),
	m_pUserData(0),
	m_nFlags(nTheFlags),
	m_nSavedFlags(0)
{}

inline StringCompare CntFolderEntry::Compare(const String & rTheTitle,
											 const String & rTheID)
{
	StringCompare eCompare = m_sTitle.CompareTo(rTheTitle);
	return eCompare == COMPARE_EQUAL ? m_sID.CompareTo(rTheID) : eCompare;
}

inline void CntFolderEntry::Subscribe(sal_Bool bSubscribe)
{
	if (bSubscribe)
		m_nFlags |= CNTFOLDER_SUBSCR;
	else
		m_nFlags &= ~CNTFOLDER_SUBSCR;
}

//============================================================================
class CntFolderList: private List
{
public:
	List::Count;

	CntFolderEntry * GetObject(ULONG nIndex) const
	{ return SAL_STATIC_CAST(CntFolderEntry *, List::GetObject(nIndex)); }

	sal_Bool find(const String & rTitle, const String & rID, ULONG & rIndex);

	void Insert(CntFolderEntry * pEntry);

	CntFolderEntry * Remove(ULONG nIndex)
	{ return SAL_STATIC_CAST(CntFolderEntry *, List::Remove(nIndex)); }

	void SaveFlags();

	void RestoreFlags();
};

//============================================================================
class CntFolderListItem: public SfxPoolItem
{
public:
	enum Command { GET, GET_SUBSCRIBED, SET };

private:
	Command m_eCommand;
	CntFolderList * m_pList;

	void clear();

public:
	TYPEINFO();

	inline CntFolderListItem(USHORT nWhich, sal_Bool bGetSubscribedOnly);

	CntFolderListItem(USHORT nWhich, CntFolderList * pSetList):
		SfxPoolItem(nWhich), m_eCommand(SET), m_pList(pSetList) {}

	CntFolderListItem(const CntFolderListItem & rItem);

	virtual ~CntFolderListItem();

	virtual int operator ==(const SfxPoolItem & rItem) const;

	virtual	BOOL QueryValue(com::sun::star::uno::Any& rVal,
							BYTE nMemberId = 0) const;

	virtual	BOOL PutValue(const com::sun::star::uno::Any& rVal,
						  BYTE nMemberId = 0);

	virtual SfxPoolItem * Clone(SfxItemPool * = 0) const
	{ return new CntFolderListItem(*this); }

	Command getCommand() const { return m_eCommand; }

	inline CntFolderList * takeList() const;
};

inline CntFolderListItem::CntFolderListItem(USHORT nWhich,
											sal_Bool bGetSubscribedOnly):
	SfxPoolItem(nWhich),
	m_eCommand(bGetSubscribedOnly ? GET_SUBSCRIBED : GET),
	m_pList(0)
{}

inline CntFolderList * CntFolderListItem::takeList() const
{
	CntFolderList * pTheList = SAL_CONST_CAST(CntFolderListItem *, this)->
	                            m_pList;
	SAL_CONST_CAST(CntFolderListItem *, this)->m_pList = 0;
	return pTheList;
}

}

#endif // CHAOS_FLSTITEM_HXX

