/*************************************************************************
 *
 *  $RCSfile: imap.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CHAOS_IMAP_HXX
#define _CHAOS_IMAP_HXX

#ifndef _CNTNODE_HXX
#include <cntnode.hxx>
#endif

namespace chaos {

class CntIMAPAcnt;
class CntIMAPFldr;
class CntIMAPMbox;

//============================================================================
class CntIMAPFldrNode: public CntNode
{
	CntIMAPFldr * m_pFldr;

protected:
	inline CntIMAPFldrNode(const USHORT * pRanges, CntIMAPFldr * pFldr);

	virtual ~CntIMAPFldrNode();

public:
	TYPEINFO();

	const CntIMAPFldr & getFldr() const { return *m_pFldr; }

	CntIMAPFldr & getFldr() { return *m_pFldr; }
};

inline CntIMAPFldrNode::CntIMAPFldrNode(const USHORT * pRanges,
										CntIMAPFldr * pFldr):
	CntNode(pRanges), m_pFldr(pFldr)
{
	DBG_ASSERT(pRanges && pFldr,
			   "CntIMAPFldrNode::CntIMAPFldrNode(): Null args");
}

//============================================================================
class CntIMAPAcntNode: public CntIMAPFldrNode
{
	CNT_NODE_SUBCLASS_DECL();

private:
	CntIMAPAcntNode();

public:
	TYPEINFO();

	const CntIMAPAcnt & getAcnt() const
	{ return (const CntIMAPAcnt &) getFldr(); }
		// should be a static_cast if CntIMAPFldr and CntIMAPAcnt were
		// completely defined here

	CntIMAPAcnt & getAcnt()
	{ return (CntIMAPAcnt &) getFldr(); }
		// should be a static_cast if CntIMAPFldr and CntIMAPAcnt were
		// completely defined here

	virtual FASTBOOL IsItemFlag(USHORT nWhich, USHORT nFlag) const;

	virtual void GetOwnURL(String & rURL);

	virtual void SetConnMode(CntConnMode eConnMode);

	virtual const SfxPoolItem * JobArrived(CntNodeJob * pJob);

	virtual BOOL JobFinished(CntNodeJob * pJob);

	virtual const SfxPoolItem * InsertJob(CntNodeJob * pJob);

	virtual const SfxPoolItem * ExecuteJob(CntNodeJob * pJob);

	static bool makeCanonicURL(const String & rURL, String & rCanonicURL);
};

//============================================================================
class CntIMAPMboxNode: public CntIMAPFldrNode
{
	CNT_NODE_SUBCLASS_DECL();

private:
	CntIMAPMboxNode();

public:
	TYPEINFO();

	const CntIMAPMbox & getMbox() const
	{ return (const CntIMAPMbox &) getFldr(); }
		// should be a static_cast if CntIMAPFldr and CntIMAPMbox were
		// completely defined here

	CntIMAPMbox & getMbox()
	{ return (CntIMAPMbox &) getFldr(); }
		// should be a static_cast if CntIMAPFldr and CntIMAPMbox were
		// completely defined here

	virtual FASTBOOL IsItemFlag(USHORT nWhich, USHORT nFlag) const;

	virtual void GetOwnURL(String & rURL);

	virtual const SfxPoolItem * InsertJob(CntNodeJob * pJob);

	virtual const SfxPoolItem * ExecuteJob(CntNodeJob * pJob);
};

}

#endif // _CHAOS_IMAP_HXX

