/*************************************************************************
 *
 *  $RCSfile: layitem.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _LAYITEM_HXX
#define _LAYITEM_HXX

#ifndef _SVTOOLS_CINTITEM_HXX
#include <svtools/cintitem.hxx>
#endif

namespace chaos {

// define ----------------------------------------------------------------

#define LAYOUT_NUM1			((USHORT)0x0000)
#define LAYOUT_NUM2			((USHORT)0x0001)
#define LAYOUT_NUM3			((USHORT)0x0002)
#define LAYOUT_NUM4			((USHORT)0x0003)
#define LAYOUT_PREVIEW		((USHORT)0x0010)
#define LAYOUT_INFO			((USHORT)0x0020)

#define LAYOUT_MAILNEWS		(LAYOUT_NUM1 | LAYOUT_PREVIEW | LAYOUT_INFO)

#define LAYOUT_NUMBER		((USHORT)0x000F)

// class CntLayoutItem ---------------------------------------------------

class CntLayoutItem : public CntUInt16Item
{
public:
	CntLayoutItem( USHORT nWhich = 0, UINT16 nValue = 0 ) :
		CntUInt16Item( nWhich, nValue ) {}

	inline USHORT	GetLayout() const;
	void			SetLayout( USHORT nLayout );
	inline BOOL		IsPreview() const;
	void	   		SetPreview( BOOL bPreview );
	inline BOOL		IsInfo() const;
	void			SetInfo( BOOL bInfo );
};

// inlines ---------------------------------------------------------------

inline USHORT CntLayoutItem::GetLayout() const
{
	return ( (USHORT)GetValue() & LAYOUT_NUMBER );
}

inline BOOL CntLayoutItem::IsPreview() const
{
	return ( ( (USHORT)GetValue() & LAYOUT_PREVIEW ) == LAYOUT_PREVIEW );
}

inline BOOL CntLayoutItem::IsInfo() const
{
	return ( ( (USHORT)GetValue() & LAYOUT_INFO ) == LAYOUT_INFO );
}

}

#endif

