/*************************************************************************
 *
 *  $RCSfile: cntccitm.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:44 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_UCB_COMMAND_HPP_
#include <com/sun/star/ucb/Command.hpp>
#endif

#ifndef _CNTCCITM_HXX
#include "cntccitm.hxx"
#endif

using namespace chaos;

/*=======================================================================
 *
 * CntCmpCommandItem implementation.
 *
 *=====================================================================*/

TYPEINIT1_AUTOFACTORY( CntCmpCommandItem, SfxPoolItem );

//------------------------------------------------------------------------
CntCmpCommandItem::CntCmpCommandItem( USHORT nWhich, const String& rCommand )
: SfxPoolItem( nWhich ),
  _aCommand( rCommand )
{
}

//------------------------------------------------------------------------
// virtual
int CntCmpCommandItem::operator==( const SfxPoolItem& rItem ) const
{
	const CntCmpCommandItem& rOther = (const CntCmpCommandItem&)rItem;

	if ( ( _aCommand != rOther._aCommand ) ||
	     ( _aArgs != rOther._aArgs ) ||
		 ( &_xSelection != &rOther._xSelection ) )
		return 0;

	return 1;
}

//------------------------------------------------------------------------
// virtual
SfxPoolItem* CntCmpCommandItem::Clone( SfxItemPool* pPool /* = NULL */ ) const
{
	CntCmpCommandItem* pNew = new CntCmpCommandItem( Which(),
													 _aCommand,
													 _aArgs );
	pNew->_xSelection = &_xSelection;
	return pNew;
}

//----------------------------------------------------------------------------
// virtual
BOOL CntCmpCommandItem::PutValue( const com::sun::star::uno::Any& rVal,
					   		 	  BYTE nMemberId )
{
	com::sun::star::ucb::Command aCommand;
	if ( rVal >>= aCommand )
	{
		_aCommand = aCommand.Name;
		_aArgs    = aCommand.Argument;
		return TRUE;
	}

	DBG_ERROR( "CntCmpCommandItem::PutValue - Wrong type!" );
	return FALSE;
}

//----------------------------------------------------------------------------
// virtual
BOOL CntCmpCommandItem::QueryValue( com::sun::star::uno::Any& rVal,
							 		BYTE nMemberId ) const
{
	com::sun::star::ucb::Command aCommand;

	aCommand.Name     = _aCommand;
	aCommand.Handle   = -1;
	aCommand.Argument = GetArguments();

	rVal <<= aCommand;
	return TRUE;
}

