/*************************************************************************
 *
 *  $RCSfile: cnttritm.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:44 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif
#ifndef _COM_SUN_STAR_UCB_TRANSFERINFO_HPP_
#include <com/sun/star/ucb/TransferInfo.hpp>
#endif

#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif

#ifndef _CNTTRITM_HXX
#include <cnttritm.hxx>
#endif

using namespace chaos;

namespace chaos {

//============================================================================
class CntTransferItemImp
{
public:
	String m_aTargetTitle;
	SvLockBytesRef m_xSourceData;
	INetContentType m_eSourceType;

	inline CntTransferItemImp(const String & rTheTargetTitle,
							  SvLockBytes * pTheSourceData = 0,
							  INetContentType eTheSourceType
							   = CONTENT_TYPE_UNKNOWN);

	inline BOOL operator ==(const CntTransferItemImp & rOther) const;
};

inline CntTransferItemImp::CntTransferItemImp(const String & rTheTargetTitle,
											  SvLockBytes * pTheSourceData,
											  INetContentType eTheSourceType):
	m_aTargetTitle(rTheTargetTitle),
	m_xSourceData(pTheSourceData),
	m_eSourceType(eTheSourceType)
{}

inline BOOL CntTransferItemImp::operator ==(const CntTransferItemImp & rOther)
	const
{
	return &m_xSourceData == &rOther.m_xSourceData
	       && m_eSourceType == rOther.m_eSourceType
	       && m_aTargetTitle == rOther.m_aTargetTitle;
}

}

//============================================================================
TYPEINIT1_AUTOFACTORY( CntTransferItem, SfxPoolItem );

//============================================================================
CntTransferItem::CntTransferItem(void)
: m_pImp( NULL ),
  m_eReplaceType( REPLACE_ERROR ),
  m_bMoveOperation( FALSE )
{
}

//============================================================================
CntTransferItem::CntTransferItem( USHORT nWhich,
								  const String& rTheSourceURL,
								  BOOL bMoveOperation,
								  ReplaceType eReplaceMode )
: SfxPoolItem( nWhich ),
  m_pImp( NULL ),
  m_aSourceURL(rTheSourceURL),
  m_eReplaceType( eReplaceMode ),
  m_bMoveOperation( bMoveOperation )
{}

//============================================================================
CntTransferItem::CntTransferItem( USHORT nWhich,
								  const String& rTheSourceURL,
								  const String& rTargetTitle,
								  BOOL bMoveOperation,
								  ReplaceType eReplaceMode )
: SfxPoolItem( nWhich ),
  m_pImp(new CntTransferItemImp(rTargetTitle)),
  m_aSourceURL(rTheSourceURL),
  m_eReplaceType( eReplaceMode ),
  m_bMoveOperation( bMoveOperation )
{}

//============================================================================
CntTransferItem::CntTransferItem( USHORT nWhich,
								  SvLockBytes* pSourceData,
								  const String& rTargetTitle,
								  ReplaceType eReplaceMode )
: SfxPoolItem( nWhich ),
  m_pImp(new CntTransferItemImp(rTargetTitle, pSourceData)),
  m_eReplaceType( eReplaceMode ),
  m_bMoveOperation( FALSE )
{}

//============================================================================
CntTransferItem::CntTransferItem( USHORT nWhich,
								  SvLockBytes* pSourceData,
								  INetContentType eSourceType,
								  const String& rTargetTitle,
								  ReplaceType eReplaceMode )
: SfxPoolItem( nWhich ),
  m_pImp(new CntTransferItemImp(rTargetTitle, pSourceData, eSourceType)),
  m_eReplaceType( eReplaceMode ),
  m_bMoveOperation( FALSE )
{}

//============================================================================
CntTransferItem::CntTransferItem( const CntTransferItem& rNewItem )
: SfxPoolItem( rNewItem.Which() ),
  m_pImp(rNewItem.m_pImp ? new CntTransferItemImp(*rNewItem.m_pImp) : 0),
  m_aSourceURL(rNewItem.m_aSourceURL),
  m_eReplaceType( rNewItem.m_eReplaceType ),
  m_bMoveOperation( rNewItem.m_bMoveOperation )
{
}

//============================================================================
CntTransferItem::CntTransferItem( USHORT nWhich, SvStream& rStream,
								  USHORT nVersion )
: SfxPoolItem( nWhich ),
  m_pImp( NULL )
{
	ULONG  nType;
	USHORT bMove;

	readUnicodeString(rStream, m_aSourceURL, nVersion >= 1);
	rStream >> nType >> bMove;

	m_eReplaceType   = (ReplaceType)nType;
	m_bMoveOperation = bMove;
}

//============================================================================
// virtual
CntTransferItem::~CntTransferItem(void)
{
	delete m_pImp;
}

//============================================================================
// virtual
int CntTransferItem::operator==(const SfxPoolItem& rItem) const
{
	const CntTransferItem * pOther = PTR_CAST(CntTransferItem, &rItem);
	return pOther
		   && m_eReplaceType == pOther->m_eReplaceType
		   && m_bMoveOperation == pOther->m_bMoveOperation
	       && (!(m_pImp || pOther->m_pImp)
			   || m_pImp && pOther->m_pImp && *m_pImp == *pOther->m_pImp)
	       && m_aSourceURL == pOther->m_aSourceURL;
}

//============================================================================
// virtual
USHORT CntTransferItem::GetVersion(USHORT) const
{
	return 1; // because it uses SfxPoolItem::read/writeUnicodeString()
}

//============================================================================
// virtual
SfxPoolItem* CntTransferItem::Clone (SfxItemPool *pPool) const
{
	return new CntTransferItem (*this);
}

//============================================================================
// virtual
SfxPoolItem* CntTransferItem::Create(SvStream& rStream, USHORT nVersion) const
{
	return new CntTransferItem(Which(), rStream, nVersion);
}

//============================================================================
// virtual
SvStream& CntTransferItem::Store(SvStream &rStream, USHORT nItemVersion ) const
{
	writeUnicodeString(rStream, m_aSourceURL);
	rStream << (ULONG)m_eReplaceType << m_bMoveOperation;
	return rStream;
}

//============================================================================
// virtual
BOOL CntTransferItem::PutValue( const com::sun::star::uno::Any& rVal,
						   		BYTE nMemberId )
{
	com::sun::star::ucb::TransferInfo aInfo;
	if ( rVal >>= aInfo )
	{
		m_bMoveOperation = aInfo.MoveData;
		m_eReplaceType   = (ReplaceType)aInfo.NameClash;
		m_aSourceURL     = String(aInfo.SourceURL);

		if ( m_pImp )
		{
			m_pImp->m_aTargetTitle = String(aInfo.NewTitle);
		}
		else if ( aInfo.NewTitle.getLength() )
		{
			m_pImp = new CntTransferItemImp( aInfo.NewTitle );
		}
		return TRUE;
	}

	DBG_ERROR( "CntTransferItem::PutValue - Wrong type!" );
	return FALSE;
}

//============================================================================
// virtual
BOOL CntTransferItem::QueryValue( com::sun::star::uno::Any& rVal,
							 	  BYTE nMemberId ) const
{
	sal_Bool bMove = m_bMoveOperation;
	com::sun::star::ucb::TransferInfo aInfo(
						bMove,
						m_aSourceURL,
						m_pImp ? rtl::OUString(m_pImp->m_aTargetTitle) :
						         rtl::OUString(),
						m_eReplaceType );
	rVal <<= aInfo;
	return TRUE;
}

//============================================================================
SvLockBytes * CntTransferItem::getSourceData() const
{
	DBG_ASSERT(getSpec() == SPEC_DATA_TITLE,
			   "CntTransferItem::getSourceData(): no source data");
	return m_pImp->m_xSourceData;
}

//============================================================================
INetContentType CntTransferItem::getSourceType() const
{
	DBG_ASSERT(getSpec() == SPEC_DATA_TITLE,
			   "CntTransferItem::getSourceType(): no source type");
	return m_pImp->m_eSourceType;
}

//============================================================================
const String & CntTransferItem::getTargetTitle() const
{
	DBG_ASSERT(getSpec() != SPEC_URL,
			   "CntTransferItem::getTargetTitle(): no target title");
	return m_pImp->m_aTargetTitle;
}

