/*************************************************************************
 *
 *  $RCSfile: cnftpimp.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mhu $ $Date: 2001/07/25 12:49:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _INETFTP_HXX
#include <inet/inetftp.hxx>
#endif
#ifndef _INET_WRAPPER_HXX
#include <inet/wrapper.hxx>
#endif
#ifndef _ADRPARSE_HXX
#include <svtools/adrparse.hxx>
#endif
#ifndef _SVTOOLS_CINTITEM_HXX
#include <svtools/cintitem.hxx>
#endif
#ifndef TOOLS_INETMIME_HXX
#include <tools/inetmime.hxx>
#endif

#ifndef _CNTMMITM_HXX
#include <cntmmitm.hxx>
#endif
#ifndef _CNTNFTP_HXX
#include <cntnftp.hxx>
#endif
#ifndef _CNTPOOL_HXX
#include <cntpool.hxx>
#endif
#ifndef _CNTRESID_HXX
#include <cntresid.hxx>
#endif
#ifndef _CNTRNMGR_HXX
#include <cntrnmgr.hxx>
#endif
#ifndef _CNTSTGND_HXX
#include <cntstgnd.hxx>
#endif
#ifndef _CSTRITEM_HXX
#include <cstritem.hxx>
#endif
#ifndef _CHAOS_INIMGR_HXX
#include <inimgr.hxx>
#endif
#ifndef _CHAOS_MBXFORMT_HXX
#include <mbxformt.hxx>
#endif
#ifndef _PROCHAOS_HRC
#include <prochaos.hrc>
#endif
#ifndef _CHAOS_STORITEM_HXX
#include <storitem.hxx>
#endif
#ifndef _ULSTITEM_HXX
#include <ulstitem.hxx>
#endif

#ifndef CHAOS_CNFTPFLD_HXX
#include <cnftpfld.hxx>
#endif

using namespace chaos;

SV_IMPL_REF(CntStoreItemSet);

//============================================================================
/** The ranges array for FTP box directory entries.
 */
static USHORT const aCntFTPBoxDirectoryEntryRanges[]
	= { WID_FTP_SERVERSYSTEM, WID_FTP_SERVERSYSTEM,
			// i.e., WID_SEND_PUBLIC_PROT_ID, WID_SEND_PUBLIC_PROT_ID
		WID_FTP_LASTCACHENAME, WID_FTP_LASTCACHENAME, 0 };
			// i.e., WID_LAST_CACHENAME, WID_LAST_CACHENAME

/** The ranges array for FTP folder directory entries.
 */
static USHORT const aCntFTPFolderDirectoryEntryRanges[]
	= { WID_FTP_TARGET_FOLDER, WID_FTP_TARGET_FOLDER,
			// i.e., WID_REPLY_TO, WID_REPLY_TO
		WID_DATE_CREATED, WID_DATE_CREATED,
		WID_TOTALCONTENTCOUNT, WID_TOTALCONTENTCOUNT,
		WID_FOLDER_COUNT, WID_FOLDER_COUNT, 0 };

/** The ranges array for FTP folder user data entries.
 */
static USHORT const aCntFTPFolderUserDataEntryRanges[]
	= { WID_SEENCONTENTCOUNT, WID_SEENCONTENTCOUNT,
		WID_MARKED_DOCUMENT_COUNT, WID_MARKED_DOCUMENT_COUNT, 0 };

/** The ranges array for FTP document directory entries.
 */
static USHORT const aCntFTPDocDirectoryEntryRanges[]
	= { WID_FTP_RETR_DOCUMENT_SIZE, WID_FTP_RETR_DOCUMENT_SIZE,
			// i.e., WID_REFERER_COUNT, WID_REFERER_COUNT
		WID_DATE_CREATED, WID_FTP_RETR_DATE_CREATED,
			// i.e., WID_DATE_CREATED, WID_DATE_MODIFIED
		WID_MESSAGE_STOREMODE, WID_MESSAGE_STOREMODE,
		WID_FTP_CACHENAME, WID_FTP_CACHENAME,
			// i.e., WID_LOCALBASE, WID_LOCALBASE
		WID_DOCUMENT_SIZE, WID_DOCUMENT_SIZE, 0 };

/** The ranges array for FTP document refcount cache entries.
 */
static USHORT const aCntFTPDocRefcountCacheEntryRanges[]
	= { WID_FTP_CACHEREFS, WID_FTP_CACHEREFS, 0 };
			// i.e., WID_SEENCONTENTCOUNT, WID_SEENCONTENTCOUNT

//============================================================================
//
//  CntFTPURL
//
//============================================================================

// static
String CntFTPURL::getSlashFPath(String const & rURL)
{
	xub_StrLen nSlash = rURL.Search('/', 6);
	if (nSlash == STRING_NOTFOUND)
		return String();
	else
	{
		xub_StrLen nSemicolon = rURL.Search(';', nSlash + 1);
		return rURL.Copy(nSlash,
						 nSemicolon == STRING_NOTFOUND ? STRING_LEN :
						                                 nSemicolon - nSlash);
	}
}

//============================================================================
// static
void CntFTPURL::getSlashFPath(String const & rURL, String & rSlashFPath,
							  xub_StrLen & rSlash)
{
	rSlash = rURL.Search('/', 6);
	if (rSlash == STRING_NOTFOUND)
		rSlashFPath.Erase();
	else
	{
		xub_StrLen nSemicolon = rURL.Search(';', rSlash + 1);
		rSlashFPath = rURL.Copy(rSlash,
								nSemicolon == STRING_NOTFOUND ? STRING_LEN :
								                                nSemicolon
								                                    - rSlash);
	}
}

//============================================================================
// static
String CntFTPURL::getFPath(String const & rURL)
{
	xub_StrLen nSlash = rURL.Search('/', 6);
	if (nSlash == STRING_NOTFOUND)
		return String();
	else
	{
		xub_StrLen nSemicolon = rURL.Search(';', nSlash + 1);
		return rURL.Copy(nSlash + 1,
						 nSemicolon == STRING_NOTFOUND ? STRING_LEN :
						                                 nSemicolon - nSlash
						                                     - 1);
	}
}

//============================================================================
// static
String CntFTPURL::replaceSlashFPath(String const & rURL,
									String const & rSlashFPath)
{
	DBG_ASSERT(rSlashFPath.Len() && rSlashFPath.GetChar(0) == '/',
			   "CntFTPURL::replaceSlashFPath(): Bad rSlashFPath");

	xub_StrLen nSlash = rURL.Search('/', 6);
	String aNewURL(rURL, 0, nSlash);
	aNewURL += rSlashFPath;
	if (nSlash != STRING_NOTFOUND)
	{
		xub_StrLen nSemicolon = rURL.Search(';', nSlash + 1);
		if (nSemicolon != STRING_NOTFOUND)
			aNewURL += rURL.Copy(nSemicolon);
	}
	return aNewURL;
}

//============================================================================
// static
String CntFTPURL::prependBaseToFPath(String const & rURL,
									 String const & rBase)
{
	DBG_ASSERT(rBase.Len() && rBase.GetChar(0) == '/'
			   && rBase.GetChar(rBase.Len() - 1) == '/',
			   "CntFTPURL::prependBaseToFPath(): Bad rBase");

	xub_StrLen nSlash = rURL.Search('/', 6);
	String aNewURL(rURL, 0, nSlash);
	aNewURL += rBase;
	if (nSlash != STRING_NOTFOUND)
		aNewURL += rURL.Copy(nSlash + 1);
	return aNewURL;
}

//============================================================================
//
//  CntFTPImp
//
//============================================================================

// static
sal_Bool CntFTPImp::terminationCallback(inet::INetFTPConnection * pConnection,
										sal_Int32, sal_Char const *,
										void * pData)
{
	DBG_ASSERT(pData, "CntFTPImp::terminationCallback(): Bad data");
	CntFTPImp * pThis = static_cast< CntFTPImp * >(pData);

	DBG_ASSERT(pConnection == pThis->m_xConnection.getBodyPtr(),
			   "CntFTPImp::terminationCallback(): Bad connection");
	pThis->m_bConnectionTerminated = true;
	return true;
}

//============================================================================
// static
void CntFTPImp::getFolderStorageSets(CntNode & rFolderNode, bool bGetDirSet,
									 CntStoreItemSetRef & rFolderDirSet,
									 bool bGetUserSet,
									 CntStoreItemSetRef & rFolderUserSet)
{
	rFolderDirSet.Clear();
	rFolderUserSet.Clear();
	CntNodeRef
		xParentDirNode(bGetDirSet ? GetDirectory(rFolderNode.GetParent()) :
					                0);
	CntNodeRef
		xParentUserNode(bGetUserSet ? GetUserData(rFolderNode.GetParent()) :
						              0);
	if (xParentDirNode.Is() || xParentUserNode.Is())
	{
		String aFolderID(RTL_CONSTASCII_USTRINGPARAM(
			                 CNT_FTP_FOLDER_ENTRY_PREFIX));
		aFolderID += GetName(&rFolderNode);
		if (xParentDirNode.Is())
			rFolderDirSet = static_cast< CntStorageNode * >(&xParentDirNode)->
				                openItemSet(aCntFTPFolderDirectoryEntryRanges,
											aFolderID, STREAM_STD_WRITE);
		if (xParentUserNode.Is())
			rFolderUserSet
				= static_cast< CntStorageNode * >(&xParentUserNode)->
				      openItemSet(aCntFTPFolderUserDataEntryRanges, aFolderID,
								  STREAM_STD_WRITE);
	}
}

//============================================================================
CntFTPImp::CntFTPImp(CntFTPBoxNode & rTheFTPBoxNode):
	rFTPBoxNode(rTheFTPBoxNode),
	bInitialized(false),
	eConnMode(CNT_CONN_MODE_OFFLINE),
	m_bConnectionLocked(false),
	m_eConnectionState(CONNECTION_DOWN),
	m_bConnectionTerminated(false),
	m_bLoginAccount(false)
{}

//============================================================================
CntFTPImp::~CntFTPImp()
{
	if (m_xConnection.isValid())
	{
		m_xConnection->abort();
		m_xConnection = 0;
	}
}

//============================================================================
void CntFTPImp::initialize(CntNodeJob & rJob)
{
	if (!bInitialized && !rFTPBoxNode.IsDummy())
	{
		CntStorageNode * pDirectory = rJob.GetCacheNode(false);
		SfxPoolItem const * pItem;
		bool bGetUser;
		if (pDirectory
			&& pDirectory->GetItemState(WID_USERNAME, false, &pItem)
			       == SFX_ITEM_SET)
		{
			rFTPBoxNode.Put(*pItem);
			bGetUser = false;
		}
		else
			bGetUser = true;
		bool bGetPassword;
		if (pDirectory
			&& pDirectory->GetItemState(WID_PASSWORD, false, &pItem)
			       == SFX_ITEM_SET)
		{
			rFTPBoxNode.Put(*pItem);
			bGetPassword = false;
		}
		else
			bGetPassword = true;
		bool bGetHostPort;
		if (pDirectory
			&& pDirectory->GetItemState(WID_SERVERNAME, false, &pItem)
			       == SFX_ITEM_SET)
		{
			rFTPBoxNode.Put(*pItem);
			bGetHostPort = false;
		}
		else
			bGetHostPort = true;
		if (bGetUser || bGetPassword || bGetHostPort)
		{
			INetURLObject aURL(OWN_URL(&rFTPBoxNode));
			aURL.makePortCanonic();
			if (bGetUser && aURL.HasUserData())
				rFTPBoxNode.
					Put(CntStringItem(
						    WID_USERNAME,
							aURL.GetUser(
								     INetURLObject::DECODE_WITH_CHARSET)));
			if (bGetPassword && aURL.hasPassword())
				rFTPBoxNode.
					Put(CntStringItem(
						    WID_PASSWORD,
							aURL.GetPass(
								     INetURLObject::DECODE_WITH_CHARSET)));
			if (bGetHostPort)
				rFTPBoxNode.
					Put(CntStringItem(
						    WID_SERVERNAME,
							aURL.GetHostPort(
								     INetURLObject::DECODE_WITH_CHARSET)));
		}
		if (pDirectory
			&& pDirectory->GetItemState(WID_FTP_ACCOUNT, false, &pItem)
			       == SFX_ITEM_SET)
			rFTPBoxNode.Put(*pItem);
		else
			rFTPBoxNode.ClearItem(WID_FTP_ACCOUNT);
		if (pDirectory)
		{
			if (pDirectory->GetItemState(WID_MESSAGE_STOREMODE, false, &pItem)
				    == SFX_ITEM_SET)
				rFTPBoxNode.Put(*pItem);
			rFTPBoxNode.Put(pDirectory->Get(WID_SERVERBASE));
		}

		CntStoreItemSetRef xItemSet;
		if (pDirectory)
			xItemSet
				= pDirectory->
				      openItemSet(String::CreateFromAscii(
						              RTL_CONSTASCII_STRINGPARAM(
										  CNT_FTP_BOX_DIRECTORY_ENTRY_NAME)),
								  STREAM_STD_READWRITE | STREAM_NOCREATE);
		if (xItemSet.Is())
		{
			rFTPBoxNode.Put(xItemSet->Get(WID_FTP_SERVERSYSTEM));
			xItemSet.Clear();
		}
		else
		{
			if (pDirectory)
			{
				xItemSet
					= pDirectory->
					      openItemSet(
							  aCntFTPBoxDirectoryEntryRanges,
							  String::CreateFromAscii(
								  RTL_CONSTASCII_STRINGPARAM(
									  CNT_FTP_BOX_DIRECTORY_ENTRY_NAME)));
				if (xItemSet.Is())
				{
					xItemSet->Put(CntStringItem(WID_SERVERBASE, String()));
					xItemSet->Put(CntUInt16Item(WID_FTP_SERVERSYSTEM,
												SYSTEM_UNKNOWN));
					xItemSet->Put(CntStringItem(WID_FTP_LASTCACHENAME,
												String()));
					xItemSet.Clear();
					pDirectory->
						attrib(String::CreateFromAscii(
							       RTL_CONSTASCII_STRINGPARAM(
									   CNT_FTP_BOX_DIRECTORY_ENTRY_NAME)),
							   0,
							   CNTDIRENTRY_ATTRIB_CREATE
							       | CNTDIRENTRY_ATTRIB_HIDDEN);
				}
			}
			rFTPBoxNode.Put(CntUInt16Item(WID_FTP_SERVERSYSTEM,
										  SYSTEM_UNKNOWN));
		}

		CntNodeRef xTarget;
		String aBase(GetServerBase());
		if (aBase.Len() > 0)
		{
			String aURL(OWN_URL(&rFTPBoxNode));
			if (aURL.GetChar(aURL.Len() - 1) != '/')
				aURL += '/';
			aURL += aBase.Copy(1);
			xTarget = rFTPBoxNode.Query(aURL);
		}
		rFTPBoxNode.SetTarget(&xTarget);
		CopyFolderData(&xTarget, &rFTPBoxNode);

		bInitialized = true;
	}
}

//============================================================================
void CntFTPImp::checkAnonymous()
{
	if (GetUserName().Len() == 0 && GetPassword().Len() == 0)
	{
		rFTPBoxNode.
			Put(CntStringItem(WID_USERNAME,
							  String::CreateFromAscii(
								  RTL_CONSTASCII_STRINGPARAM("anonymous"))));
		SvAddressParser aAddress(CntRootNodeMgr::Get()->GetIniManager()->
			                           getEntry(CNT_KEY_ADDRESS_EMAIL));
		rFTPBoxNode.Put(CntStringItem(WID_PASSWORD,
									  aAddress.Count() == 0 ?
									      String() :
									      aAddress.GetEmailAddress(0)));
	}
}

//============================================================================
bool CntFTPImp::changeUserHost(CntNodeJob & rJob, String const * pUser,
							   String const * pHost)
{
	String aNewUser;
	if (pUser)
		aNewUser = *pUser;
	else
	{
		CntStorageNode * pDirectory = rJob.GetDirectoryNode(false);
		aNewUser = ITEMSET_VALUE(pDirectory ?
								     static_cast< CntNode * >(pDirectory) :
								     static_cast< CntNode * >(&rFTPBoxNode),
								 CntStringItem, WID_USERNAME);
	}
	String aNewHost;
	if (pHost)
		aNewHost = *pHost;
	else
	{
		CntStorageNode * pDirectory = rJob.GetDirectoryNode(false);
		aNewHost = ITEMSET_VALUE(pDirectory ?
								     static_cast< CntNode * >(pDirectory) :
								     static_cast< CntNode * >(&rFTPBoxNode),
								 CntStringItem, WID_SERVERNAME);
	}

	String aNewBoxURL(RTL_CONSTASCII_USTRINGPARAM("ftp://"));
	if (aNewUser.Len() > 0)
	{
		aNewBoxURL += INetURLObject::encode(aNewUser,
											INetURLObject::PART_USER_PASSWORD,
											'%', INetURLObject::ENCODE_ALL);
		aNewBoxURL += '@';
	}
	aNewBoxURL += aNewHost;
	aNewBoxURL += '/';
	CntNodeRef xNewBoxNode(CntRootNodeMgr::Get()->Query(aNewBoxURL));

	if (xNewBoxNode.Is())
		if (&xNewBoxNode == &rFTPBoxNode)
		{
			forceDirectoryStorage();
			return false;
		}
		else
		{
			rJob.Result(xNewBoxNode, CNT_ACTION_EXCHANGED);
			rJob.Done();
			return true;
		}
	else
	{
		rJob.Cancel();
		return true;
	}
}

//============================================================================
void CntFTPImp::changeBase(CntNodeJob & rJob, String const & rExternalBase)
{
	initialize(rJob);
	forceDirectoryStorage();

	String aInternalBase;
	if (rExternalBase.Len() > 0)
		aInternalBase = MapToInternalPath(&rJob, rExternalBase);
	else if (GetServerBase().Len() > 0)
	{
		if (m_eConnectionState != CONNECTION_DOWN)
			m_eConnectionState = CONNECTION_CLOSE;
	}
	SetServerBase(rJob, aInternalBase);
}

//============================================================================
bool CntFTPImp::initializeConnection(bool bToClose)
{
	if (m_bConnectionTerminated)
	{
		m_eConnectionState = CONNECTION_DOWN;
		m_bConnectionTerminated = false;
	}
	if (m_eConnectionState == CONNECTION_DOWN)
		m_xConnection = 0;
	if (m_xConnection.isEmpty() && !bToClose)
	{
		inet::INetWrapper * pWrapper;
		if (CntRootNodeMgr::Get()->getINetWrapper(pWrapper))
			pWrapper->newINetFTPConnection(m_xConnection);
		if (m_xConnection.isValid())
		{
			m_xConnection->setTerminateCallback(terminationCallback, this);
			m_eConnectionState = CONNECTION_INITIALIZED;
		}
	}
	return m_xConnection.isValid() != false;
}

//============================================================================
void CntFTPImp::clearTransferCallback()
{
	if (m_xConnection.isValid())
		m_xConnection->setTransferCallback(0, 0);
}

//============================================================================
void CntFTPImp::abortConnection(bool bTransfering)
{
	m_eConnectionState = CONNECTION_DOWN;
	if (m_xConnection.isValid())
	{
		if (bTransfering)
			m_xConnection->abortTransfer();
		m_xConnection->abort();
		m_xConnection = 0;
	}
}

//============================================================================
void CntFTPImp::GetFolderNodeData(CntFTPFolderNode * pNode)
{
	if (!pNode)
	{
		DBG_ERROR("CntFTPImp::GetFolderNodeData(): !pNode");
		return;
	}

	if (pNode->getImp().setNodeInitialized())
	{
		// Set WID_REAL_URL, which can change every time the base path
		// changes:
		String aURL;
		if (ITEMSET_VALUE(pNode, CntUInt32Item, WID_FSYS_FLAGS)
			    & CNT_FLAG_LINK)
		{
			String aPath(ITEMSET_VALUE(pNode, CntStringItem,
									   WID_FTP_TARGET_FOLDER));
			if (aPath.Len() == 0)
				aURL = OWN_URL(pNode);
			else
			{
				aURL = OWN_URL(&rFTPBoxNode);
				aURL += aPath.Copy(1);
			}
		}
		else if (IsProxyFolder(pNode))
			aURL = getProxyTargetURL(*pNode);
		else
			aURL = OWN_URL(pNode);
		pNode->Put(CntStringItem(WID_REAL_URL, MapToExternalURL(aURL)));
	}
	else
	{
		// Special handling for root folder node:
		CntNode * pParent = pNode->GetParent();
		if (pParent->ISA(CntFTPBoxNode))
		{
			pNode->DisableItem(WID_DELETE);
			pNode->DisableItem(WID_DATE_CREATED);
			if (CntUShortListItem const * pOldList
				    = static_cast< CntUShortListItem const * >(
						  &pNode->Get(WID_RENAME)))
			{
				CntUShortListItem aNewList(WID_RENAME);
				for (USHORT i = 0; i < pOldList->Count(); ++i)
				{
					USHORT nWhich = (*pOldList)[i];
					if (nWhich != WID_TITLE)
						aNewList.Append(nWhich);
				}
				pNode->Put(aNewList);
			}
		}

		// Set WID_TITLE and WID_REAL_NAME:
		String aName;
		SfxPoolItem const * pItem;
		if (pNode->GetItemState(WID_TITLE, true, &pItem) == SFX_ITEM_SET)
			aName = ITEM_VALUE(CntStringItem, *pItem);
		else
		{
			aName = GetName(pNode);
			pNode->Put(CntStringItem(WID_TITLE, aName));
		}
		pNode->Put(CntStringItem(WID_REAL_NAME, aName));

		String aFolderID(RTL_CONSTASCII_USTRINGPARAM(
			                 CNT_FTP_FOLDER_ENTRY_PREFIX));
		aFolderID += aName;

		// Set WID_FLAG_READONLY, WID_FSYS_FLAGS, WID_DATE_CREATED,
		// WID_TOTALCONTENTCOUNT, WID_FOLDER_COUNT, and WID_FTP_TARGET_FOLDER:
		bool bLink = false;
		bool bProxy = IsProxyFolder(pNode);
		CntNodeRef xParentDirNode(GetDirectory(pParent));
		if (xParentDirNode.Is())
		{
			UINT32 nFolderDirAttribs;
			if (!static_cast< CntStorageNode * >(&xParentDirNode)->
				     attrib(aFolderID, 0, 0, nFolderDirAttribs))
			{
#if 0 // no WID_FLAG_READONLY
				pNode->Put(CntBoolItem(
					           WID_FLAG_READONLY,
							   (nFolderDirAttribs
								        & CNTDIRENTRY_ATTRIB_FTP_READONLY)
							       != 0));
#endif // no WID_FLAG_READONLY
				bLink = (nFolderDirAttribs & CNTDIRENTRY_ATTRIB_FTP_LINK)
					        != 0;
				pNode->Put(CntUInt32Item(WID_FSYS_FLAGS,
										 bLink ? CNT_FLAG_LINK : 0));
			}

			CntStoreItemSetRef
				xFolderDirSet(static_cast< CntStorageNode * >(
					                  &xParentDirNode)->
							      openItemSet(
									  aCntFTPFolderDirectoryEntryRanges,
									  aFolderID, STREAM_STD_READ));
			if (xFolderDirSet.Is())
			{
				if (xFolderDirSet->GetItemState(WID_DATE_CREATED, true,
												&pItem)
					    == SFX_ITEM_SET)
					pNode->Put(*pItem);
				if (!(bLink || bProxy))
				{
					if (xFolderDirSet->GetItemState(WID_TOTALCONTENTCOUNT,
													true, &pItem)
						    == SFX_ITEM_SET)
						pNode->Put(*pItem);
					if (xFolderDirSet->GetItemState(WID_FOLDER_COUNT, true,
													&pItem)
						    == SFX_ITEM_SET)
						pNode->Put(*pItem);
				}
				if (bLink
					&& xFolderDirSet->GetItemState(WID_FTP_TARGET_FOLDER,
												   true, &pItem)
					       == SFX_ITEM_SET)
					pNode->Put(*pItem);
			}
		}

		if (!(bLink || bProxy))
		{
			// Set WID_SEENCONTENTCOUNT and WID_MARKED_DOCUMENT_COUNT:
			CntNodeRef xParentUserNode(GetUserData(pParent));
			if (xParentUserNode.Is())
			{
				CntStoreItemSetRef
					xFolderUserSet(static_cast< CntStorageNode * >(
						                   &xParentUserNode)->
								       openItemSet(
										   aCntFTPFolderUserDataEntryRanges,
										   aFolderID, STREAM_STD_READ));
				if (xFolderUserSet.Is())
				{
					if (xFolderUserSet->GetItemState(WID_SEENCONTENTCOUNT,
													 true, &pItem)
						    == SFX_ITEM_SET)
						pNode->Put(*pItem);
					if (xFolderUserSet->
						        GetItemState(WID_MARKED_DOCUMENT_COUNT, true,
											 &pItem)
						    == SFX_ITEM_SET)
						pNode->Put(*pItem);
				}
			}

			// Set WID_IS_READ and WID_IS_MARKED:
			bool bDocCountKnown
				= pNode->GetItemState(WID_TOTALCONTENTCOUNT, true, &pItem)
				      == SFX_ITEM_SET;
			UINT32 nDocCount
				= bDocCountKnown ? ITEM_VALUE(CntUInt32Item, *pItem) : 0;
			pNode->Put(CntBoolItem(WID_IS_READ,
								   bDocCountKnown
								   && ITEMSET_VALUE(pNode, CntUInt32Item,
													WID_SEENCONTENTCOUNT)
								          >= nDocCount));
			pNode->Put(CntBoolItem(WID_IS_MARKED,
								   nDocCount
								   && ITEMSET_VALUE(pNode, CntUInt32Item,
													WID_MARKED_DOCUMENT_COUNT)
								          >= nDocCount));
		}

		// Set WID_MESSAGE_STOREMODE:
		if (bLink)
			pNode->DisableItem(WID_MESSAGE_STOREMODE);
		else if (!bProxy)
		{
			CntNodeRef xFolderDirNode(GetDirectory(pNode));
			if (xFolderDirNode.Is()
				&& xFolderDirNode->GetItemState(WID_MESSAGE_STOREMODE, true,
												&pItem)
				       == SFX_ITEM_SET)
				pNode->Put(*pItem);
		}

		// Set WID_REAL_URL and copy link/proxy data:
		if (bLink || bProxy)
		{
			CntNodeRef xTarget;
			if (bLink)
			{
				String aPath(ITEMSET_VALUE(pNode, CntStringItem,
										   WID_FTP_TARGET_FOLDER));
				if (aPath.Len() > 0)
				{
					String aURL(OWN_URL(&rFTPBoxNode));
					aURL += aPath.Copy(1);
					xTarget = rFTPBoxNode.Query(aURL);
				}
			}
			else
				xTarget = GetProxyTarget(pNode);
			pNode->SetTarget(&xTarget);
			CopyFolderData(&xTarget, pNode);
		}
		else
			pNode->Put(CntStringItem(WID_REAL_URL,
									 MapToExternalURL(OWN_URL(pNode))));

		// Let those nodes that redirect to this node start listening on this
		// node:
		for (CntFTPRedirectionPointer const * p
				 = GetRedirectionPointers(OWN_URL(pNode));
			 p; p = p->GetNext())
			if (CntNode * pPointerNode
				    = CntRootNodeMgr::Get()->Query(p->GetPointerURL(), false))
				pPointerNode->StartListening(*pNode, true);
	}
}

//============================================================================
void CntFTPImp::GetDocNodeData(CntFTPDocNode * pNode)
{
	if (!pNode)
	{
		DBG_ERROR("CntFTPImp::GetDocNodeData(): Bad node");
		return;
	}

	// Set WID_REAL_URL, which can change every time the base path changes:
	pNode->Put(CntStringItem(WID_REAL_URL, MapToExternalURL(OWN_URL(pNode))));

	if (pNode->m_bInitialized)
		return;

	// Set WID_TITLE and WID_REAL_NAME:
	String aID(RTL_CONSTASCII_USTRINGPARAM(CNT_FTP_DOC_ENTRY_PREFIX));
	SfxPoolItem const * pItem;
	if (pNode->GetItemState(WID_TITLE, false, &pItem) == SFX_ITEM_SET)
		aID += ITEM_VALUE(CntStringItem, *pItem);
	else
	{
		String aName(GetName(pNode));
		pNode->Put(CntStringItem(WID_TITLE, aName));
		pNode->Put(CntStringItem(WID_REAL_NAME, aName));
		aID += aName;
	}

	// Set WID_FLAG_READONLY, WID_FSYS_FLAGS, WID_DATE_CREATED,
	// WID_DOCUMENT_SIZE, and WID_MESSAGE_STOREMODE:
	CntNode * pParent = pNode->GetParent();
	CntNodeRef xDirectory(GetDirectory(pParent));
	if (xDirectory.Is())
	{
		UINT32 nAttrib;
		if (static_cast< CntStorageNode * >(&xDirectory)->attrib(aID, 0, 0,
																 nAttrib)
			    == ERRCODE_NONE)
		{
#if 0 // No WID_FLAG_READONLY
			pNode->Put(CntBoolItem(WID_FLAG_READONLY,
								   (nAttrib & CNTDIRENTRY_ATTRIB_FTP_READONLY)
								       != 0));
#endif // No WID_FLAG_READONLY
			pNode->Put(CntUInt32Item(WID_FSYS_FLAGS,
									 nAttrib & CNTDIRENTRY_ATTRIB_FTP_LINK ?
									     CNT_FLAG_LINK : 0));
		}

		CntStoreItemSetRef
			xItemSet(static_cast< CntStorageNode * >(&xDirectory)->
					     openItemSet(aID,
									 STREAM_STD_READWRITE | STREAM_NOCREATE));
		SfxPoolItem const * pItem;
		if (xItemSet.Is()
			&& xItemSet->GetItemState(WID_DATE_CREATED, false, &pItem)
			       == SFX_ITEM_SET)
			pNode->Put(*pItem);
		else
			pNode->ClearItem(WID_DATE_CREATED);
		if (xItemSet.Is()
			&& xItemSet->GetItemState(WID_DOCUMENT_SIZE, false, &pItem)
			       == SFX_ITEM_SET)
			pNode->Put(*pItem);
		else
			pNode->ClearItem(WID_DOCUMENT_SIZE);
		if (xItemSet.Is()
			&& xItemSet->GetItemState(WID_MESSAGE_STOREMODE, false, &pItem)
			       == SFX_ITEM_SET)
			pNode->Put(*pItem);
		else
			pNode->ClearItem(WID_MESSAGE_STOREMODE);
	}
	else
	{
#if 0 // No WID_FLAG_READONLY
		pNode->ClearItem(WID_FLAG_READONLY);
#endif // No WID_FLAG_READONLY
		pNode->ClearItem(WID_FSYS_FLAGS);
		pNode->ClearItem(WID_DATE_CREATED);
		pNode->ClearItem(WID_DOCUMENT_SIZE);
		pNode->ClearItem(WID_MESSAGE_STOREMODE);
	}

	// Set WID_IS_READ and WID_IS_MARKED:
	CntNodeRef xUserData(GetUserData(pParent));
	if (xUserData.Is())
	{
		UINT32 nAttrib = 0;
		static_cast< CntStorageNode * >(&xUserData)->attrib(aID, 0, 0,
															nAttrib);
		pNode->Put(CntBoolItem(WID_IS_READ,
							   (nAttrib & CNTDIRENTRY_ATTRIB_FTP_READ) != 0));
		pNode->Put(CntBoolItem(WID_IS_MARKED,
							   (nAttrib & CNTDIRENTRY_ATTRIB_MARKED) != 0));
	}
	else
	{
		pNode->ClearItem(WID_IS_READ);
		pNode->ClearItem(WID_IS_MARKED);
	}

	pNode->m_bInitialized = true;
}

//============================================================================
void CntFTPImp::CopyFolderData(CntNode * pSource, CntNode * pDestination)
{
	if (pSource)
		GetFolderNodeData(PTR_CAST(CntFTPFolderNode, pSource));
	SfxPoolItem const * pItem;
	if (pSource
		&& pSource->GetItemState(WID_TOTALCONTENTCOUNT, false, &pItem)
		       == SFX_ITEM_SET)
		pDestination->Put(*pItem);
	else
		pDestination->ClearItem(WID_TOTALCONTENTCOUNT);
	if (pSource
		&& pSource->GetItemState(WID_SEENCONTENTCOUNT, false, &pItem)
		       == SFX_ITEM_SET)
		pDestination->Put(*pItem);
	else
		pDestination->ClearItem(WID_SEENCONTENTCOUNT);
	if (pSource
		&& pSource->GetItemState(WID_IS_READ, false, &pItem) == SFX_ITEM_SET)
		pDestination->Put(*pItem);
	else
		pDestination->ClearItem(WID_IS_READ);
	if (pSource
		&& pSource->GetItemState(WID_IS_MARKED, false, &pItem)
		       == SFX_ITEM_SET)
		pDestination->Put(*pItem);
	else
		pDestination->ClearItem(WID_IS_MARKED);
	if (pSource
		&& pSource->GetItemState(WID_FOLDER_COUNT, false, &pItem)
		       == SFX_ITEM_SET)
		pDestination->Put(*pItem);
	else
		pDestination->ClearItem(WID_FOLDER_COUNT);
	if (IsProxyFolder(pDestination))
		if (pSource)
		{
			if (pSource->GetItemState(WID_MESSAGE_STOREMODE, true, &pItem)
				    == SFX_ITEM_SET)
				pDestination->Put(*pItem);
			else if (pDestination->GetItemState(WID_MESSAGE_STOREMODE, true,
												&pItem)
					     == SFX_ITEM_SET)
				pSource->Put(*pItem);
		}
// 		else
// 			pDestination->ClearItem(WID_MESSAGE_STOREMODE);
	if (pSource
		&& pSource->GetItemState(WID_REAL_URL, false, &pItem) == SFX_ITEM_SET)
		pDestination->Put(*pItem);
	else
		pDestination->
			Put(CntStringItem(WID_REAL_URL,
							  MapToExternalURL(OWN_URL(pDestination))));
}

//============================================================================
// static
void CntFTPImp::updateFolderCountsInit(CntNode & rFolderNode, bool bStore)
{
	rFolderNode.Put(CntUInt32Item(WID_FOLDER_COUNT, 0));
	rFolderNode.Put(CntUInt32Item(WID_TOTALCONTENTCOUNT, 0));
	rFolderNode.Put(CntUInt32Item(WID_SEENCONTENTCOUNT, 0));
	rFolderNode.Put(CntUInt32Item(WID_MARKED_DOCUMENT_COUNT, 0));
	rFolderNode.Put(CntBoolItem(WID_IS_READ, true));
	rFolderNode.Put(CntBoolItem(WID_IS_MARKED, false));

	if (bStore)
	{
		CntStoreItemSetRef xFolderDirSet;
		CntStoreItemSetRef xFolderUserSet;
		getFolderStorageSets(rFolderNode, true, xFolderDirSet, true,
							 xFolderUserSet);
		if (xFolderDirSet.Is())
		{
			xFolderDirSet->Put(CntUInt32Item(WID_FOLDER_COUNT, 0));
			xFolderDirSet->Put(CntUInt32Item(WID_TOTALCONTENTCOUNT, 0));
		}
		if (xFolderUserSet.Is())
		{
			xFolderUserSet->Put(CntUInt32Item(WID_SEENCONTENTCOUNT, 0));
			xFolderUserSet->Put(CntUInt32Item(WID_MARKED_DOCUMENT_COUNT, 0));
		}
	}
}

//============================================================================
// static
void CntFTPImp::updateFolderCountsAddFolder(CntNode & rFolderNode,
											bool bStore)
{
	if (rFolderNode.GetItemState(WID_TOTALCONTENTCOUNT) == SFX_ITEM_SET)
	{
		UINT32 nFolderCount
			= ITEMSET_VALUE(&rFolderNode, CntUInt32Item, WID_FOLDER_COUNT)
			      + 1;

		rFolderNode.Put(CntUInt32Item(WID_FOLDER_COUNT, nFolderCount));

		if (bStore)
		{
			CntStoreItemSetRef xFolderDirSet;
			CntStoreItemSetRef xFolderUserSet;
			getFolderStorageSets(rFolderNode, true, xFolderDirSet, false,
								 xFolderUserSet);
			if (xFolderDirSet.Is())
				xFolderDirSet->Put(CntUInt32Item(WID_FOLDER_COUNT,
												 nFolderCount));
		}
	}
}

//============================================================================
// static
void CntFTPImp::updateFolderCountsRemoveFolder(CntNode & rFolderNode,
											   bool bStore)
{
	if (rFolderNode.GetItemState(WID_TOTALCONTENTCOUNT) == SFX_ITEM_SET)
	{
		UINT32 nFolderCount
			= ITEMSET_VALUE(&rFolderNode, CntUInt32Item, WID_FOLDER_COUNT);
		if (nFolderCount > 0)
			--nFolderCount;

		rFolderNode.Put(CntUInt32Item(WID_FOLDER_COUNT, nFolderCount));

		if (bStore)
		{
			CntStoreItemSetRef xFolderDirSet;
			CntStoreItemSetRef xFolderUserSet;
			getFolderStorageSets(rFolderNode, true, xFolderDirSet, false,
								 xFolderUserSet);
			if (xFolderDirSet.Is())
				xFolderDirSet->Put(CntUInt32Item(WID_FOLDER_COUNT,
												 nFolderCount));
		}
	}
}

//============================================================================
// static
void CntFTPImp::updateFolderCountsAddDoc(CntNode & rFolderNode, bool bDocRead,
										 bool bDocMarked, bool bStore)
{
	SfxPoolItem const * pItem;
	if (rFolderNode.GetItemState(WID_TOTALCONTENTCOUNT, true, &pItem)
		    == SFX_ITEM_SET)
	{
		UINT32 nDocCount = ITEM_VALUE(CntUInt32Item, *pItem) + 1;
		UINT32 nReadDocCount = ITEMSET_VALUE(&rFolderNode, CntUInt32Item,
											 WID_SEENCONTENTCOUNT);
		if (bDocRead)
			++nReadDocCount;
		UINT32 nMarkedDocCount = ITEMSET_VALUE(&rFolderNode, CntUInt32Item,
											   WID_MARKED_DOCUMENT_COUNT);
		if (bDocMarked)
			++nMarkedDocCount;
		bool bFolderRead = nReadDocCount == nDocCount;
		bool bFolderMarked = nDocCount > 0 && nMarkedDocCount == nDocCount;

		rFolderNode.Put(CntUInt32Item(WID_TOTALCONTENTCOUNT, nDocCount));
		rFolderNode.Put(CntUInt32Item(WID_SEENCONTENTCOUNT, nReadDocCount));
		rFolderNode.Put(CntUInt32Item(WID_MARKED_DOCUMENT_COUNT,
									  nMarkedDocCount));
		rFolderNode.Put(CntBoolItem(WID_IS_READ, bFolderRead));
		rFolderNode.Put(CntBoolItem(WID_IS_MARKED, bFolderMarked));

		if (bStore)
		{
			CntStoreItemSetRef xFolderDirSet;
			CntStoreItemSetRef xFolderUserSet;
			getFolderStorageSets(rFolderNode, true, xFolderDirSet, true,
								 xFolderUserSet);
			if (xFolderDirSet.Is())
				xFolderDirSet->Put(CntUInt32Item(WID_TOTALCONTENTCOUNT,
												 nDocCount));
			if (xFolderUserSet.Is())
			{
				xFolderUserSet->Put(CntUInt32Item(WID_SEENCONTENTCOUNT,
												  nReadDocCount));
				xFolderUserSet->Put(CntUInt32Item(WID_MARKED_DOCUMENT_COUNT,
												  nMarkedDocCount));
			}
		}
	}
}

//============================================================================
// static
void CntFTPImp::updateFolderCountsRemoveDoc(CntNode & rFolderNode,
											CntNode const & rDocNode,
											bool bStore)
{
	SfxPoolItem const * pItem;
	if (rFolderNode.GetItemState(WID_TOTALCONTENTCOUNT, true, &pItem)
		    == SFX_ITEM_SET)
	{
		UINT32 nDocCount = ITEM_VALUE(CntUInt32Item, *pItem);
		if (nDocCount > 0)
			--nDocCount;
		UINT32 nReadDocCount = ITEMSET_VALUE(&rFolderNode, CntUInt32Item,
											 WID_SEENCONTENTCOUNT);
		if (nReadDocCount > 0
			&& ITEMSET_VALUE(&rDocNode, CntBoolItem, WID_IS_READ))
			--nReadDocCount;
		UINT32 nMarkedDocCount = ITEMSET_VALUE(&rFolderNode, CntUInt32Item,
											   WID_MARKED_DOCUMENT_COUNT);
		if (nMarkedDocCount > 0
			&& ITEMSET_VALUE(&rDocNode, CntBoolItem, WID_IS_MARKED))
			--nMarkedDocCount;
		bool bFolderRead = nReadDocCount == nDocCount;
		bool bFolderMarked = nDocCount > 0 && nMarkedDocCount == nDocCount;

		rFolderNode.Put(CntUInt32Item(WID_TOTALCONTENTCOUNT, nDocCount));
		rFolderNode.Put(CntUInt32Item(WID_SEENCONTENTCOUNT, nReadDocCount));
		rFolderNode.Put(CntUInt32Item(WID_MARKED_DOCUMENT_COUNT,
									  nMarkedDocCount));
		rFolderNode.Put(CntBoolItem(WID_IS_READ, bFolderRead));
		rFolderNode.Put(CntBoolItem(WID_IS_MARKED, bFolderMarked));

		if (bStore)
		{
			CntStoreItemSetRef xFolderDirSet;
			CntStoreItemSetRef xFolderUserSet;
			getFolderStorageSets(rFolderNode, true, xFolderDirSet, true,
								 xFolderUserSet);
			if (xFolderDirSet.Is())
				xFolderDirSet->Put(CntUInt32Item(WID_TOTALCONTENTCOUNT,
												 nDocCount));
			if (xFolderUserSet.Is())
			{
				xFolderUserSet->Put(CntUInt32Item(WID_SEENCONTENTCOUNT,
												  nReadDocCount));
				xFolderUserSet->Put(CntUInt32Item(WID_MARKED_DOCUMENT_COUNT,
												  nMarkedDocCount));
			}
		}
	}
}

//============================================================================
// static
void CntFTPImp::updateFolderCountsFlagDoc(CntNode & rFolderNode,
										  bool bFlagRead, bool bFlagState,
										  bool bStore)
{
	SfxPoolItem const * pItem;
	if (rFolderNode.GetItemState(WID_TOTALCONTENTCOUNT, true, &pItem)
		    == SFX_ITEM_SET)
	{
		UINT32 nDocCount = ITEM_VALUE(CntUInt32Item, *pItem);
		UINT32 nFlagCount = ITEMSET_VALUE(&rFolderNode, CntUInt32Item,
										  bFlagRead ?
										      WID_SEENCONTENTCOUNT :
										      WID_MARKED_DOCUMENT_COUNT);
		if (bFlagState)
			++nFlagCount;
		else if (nFlagCount > 0)
			--nFlagCount;
		bool bFolderFlag
			= (bFlagRead || nDocCount > 0) && nFlagCount == nDocCount;

		rFolderNode.Put(CntUInt32Item(bFlagRead ? WID_SEENCONTENTCOUNT :
									              WID_MARKED_DOCUMENT_COUNT,
									  nFlagCount));
		rFolderNode.Put(CntBoolItem(bFlagRead ? WID_IS_READ : WID_IS_MARKED,
									bFolderFlag));

		if (bStore)
		{
			CntStoreItemSetRef xFolderDirSet;
			CntStoreItemSetRef xFolderUserSet;
			getFolderStorageSets(rFolderNode, false, xFolderDirSet, true,
								 xFolderUserSet);
			if (xFolderUserSet.Is())
				xFolderUserSet->
					Put(CntUInt32Item(bFlagRead ? WID_SEENCONTENTCOUNT :
												  WID_MARKED_DOCUMENT_COUNT,
									  nFlagCount));
		}
	}
}

//============================================================================
// static
void CntFTPImp::updateFolderCountsStore(CntNode & rFolderNode)
{
	CntStoreItemSetRef xFolderDirSet;
	CntStoreItemSetRef xFolderUserSet;
	getFolderStorageSets(rFolderNode, true, xFolderDirSet, true,
						 xFolderUserSet);
	if (xFolderDirSet.Is() || xFolderUserSet.Is())
	{
		SfxPoolItem const * pItem;
		if (rFolderNode.GetItemState(WID_TOTALCONTENTCOUNT, true, &pItem)
			    == SFX_ITEM_SET)
		{
			if (xFolderDirSet.Is())
			{
				xFolderDirSet->Put(rFolderNode.Get(WID_FOLDER_COUNT));
				xFolderDirSet->Put(*pItem);
			}
			if (xFolderUserSet.Is())
			{
				xFolderUserSet->Put(rFolderNode.Get(WID_SEENCONTENTCOUNT));
				xFolderUserSet->
				 Put(rFolderNode.Get(WID_MARKED_DOCUMENT_COUNT));
			}
		}
		else
		{
			if (xFolderDirSet.Is())
			{
				xFolderDirSet->ClearItem(WID_FOLDER_COUNT);
				xFolderDirSet->ClearItem(WID_TOTALCONTENTCOUNT);
			}
			if (xFolderUserSet.Is())
			{
				xFolderUserSet->ClearItem(WID_SEENCONTENTCOUNT);
				xFolderUserSet->ClearItem(WID_MARKED_DOCUMENT_COUNT);
			}
		}
	}
}

//============================================================================
void CntFTPImp::FlagFolder(CntNode * pNode, SfxPoolItem const * pRequest)
{
	GetFolderNodeData(PTR_CAST(CntFTPFolderNode, pNode));
	CntFTPFolderImp & rFolderImp
		= static_cast< CntFTPFolderNode * >(pNode)->getImp();
	String aFolderURL(OWN_URL(pNode));

	CntNodeRef xFolderDirNode(GetDirectory(pNode));
	if (xFolderDirNode.Is())
	{
		rFolderImp.
			storeChildren(*static_cast< CntStorageNode * >(&xFolderDirNode));

		for (CntStorageIterator aIterator;;)
		{
			String
				aChildDirID(static_cast< CntStorageNode * >(&xFolderDirNode)->
							    iter(aIterator));
			if (aChildDirID.Len() == 0)
				break;

			String aChildName;
			bool bChildDoc;
			if (ParseID(aChildDirID, aChildName, bChildDoc) && bChildDoc)
			{
				String aDocURL(aFolderURL);
				aDocURL += CntFTPURL::encodeFSegment(aChildName);
				CntNodeRef xDocNode(pNode->Query(aDocURL));
				if (xDocNode.Is())
					FlagDoc(&xDocNode, pRequest);
			}
		}
	}
	else
		for (ULONG i = 0; i < rFolderImp.getChildCount(); ++i)
		{
			CntFTPFolderChildEntry const & rChildEntry
				= rFolderImp.getChild(i);
			if (rChildEntry.isDoc())
			{
				String aDocURL(aFolderURL);
				aDocURL += CntFTPURL::encodeFSegment(rChildEntry.getName());
				CntNodeRef xDocNode(pNode->Query(aDocURL));
				if (xDocNode.Is())
					FlagDoc(&xDocNode, pRequest);
			}
		}
}

//============================================================================
void CntFTPImp::FlagDoc(CntNode * pNode, SfxPoolItem const * pRequest)
{
	GetDocNodeData(PTR_CAST(CntFTPDocNode, pNode));
	if (ITEMSET_VALUE(pNode, CntBoolItem, pRequest->Which())
		    != ITEM_VALUE(CntBoolItem, *pRequest))
	{
		forceUserDataStorage();
		CntNodeRef xFolderUserNode = GetUserData(pNode->GetParent());
		if (xFolderUserNode.Is())
		{
			UINT32 nAttrib = pRequest->Which() == WID_IS_READ ?
				                 CNTDIRENTRY_ATTRIB_FTP_READ :
				                 CNTDIRENTRY_ATTRIB_MARKED;
			String aDocUserID(RTL_CONSTASCII_USTRINGPARAM(
				                  CNT_FTP_DOC_ENTRY_PREFIX));
			aDocUserID += GetName(pNode);
			if (ITEM_VALUE(CntBoolItem, *pRequest))
				static_cast< CntStorageNode * >(&xFolderUserNode)->
					attrib(aDocUserID, 0,
						   CNTDIRENTRY_ATTRIB_CREATE | nAttrib);
			else
			{
				UINT32 nAttribs;
				if (!(static_cast< CntStorageNode * >(&xFolderUserNode)->
					      attrib(aDocUserID, 0, 0, nAttribs)
					  || nAttribs & ~(nAttrib | CNTDIRENTRY_ATTRIB_CREATE)))
				{
					static_cast< CntStorageNode * >(&xFolderUserNode)->
						attrib(aDocUserID,
							   CNTDIRENTRY_ATTRIB_CREATE
							       | CNTDIRENTRY_ATTRIB_MARKED,
							   0);
					static_cast< CntStorageNode * >(&xFolderUserNode)->
						remove(aDocUserID);
				}
				else
					static_cast< CntStorageNode * >(&xFolderUserNode)->
						attrib(aDocUserID, nAttrib, 0);
			}
		}
		pNode->Put(*pRequest);
		updateFolderCountsFlagDoc(*pNode->GetParent(),
								  pRequest->Which() == WID_IS_READ,
								  ITEM_VALUE(CntBoolItem, *pRequest) != false,
								  true);
	}
}

//============================================================================
void CntFTPImp::SetDocNodePersistence(CntNodeJob * pJob)
{
	CntNode * pNode = pJob->GetSubject();
	SfxPoolItem const * pRequest = pJob->GetRequest();
	GetDocNodeData(PTR_CAST(CntFTPDocNode, pNode));
	CntNodeRef xDirectory(GetDirectory(pNode->GetParent()));
	if (xDirectory.Is())
	{
		String aID(RTL_CONSTASCII_USTRINGPARAM(CNT_FTP_DOC_ENTRY_PREFIX));
		aID += GetName(pNode);
		CntStoreItemSetRef
			xItemSet(static_cast< CntStorageNode * >(&xDirectory)->
					     openItemSet(aCntFTPDocDirectoryEntryRanges, aID));
		if (xItemSet.Is())
			xItemSet->Put(*pRequest);
	}
	pNode->Put(*pRequest);
	pJob->Done();
}

//============================================================================
bool CntFTPImp::KeepDocPersistent(CntNode * pNode)
{
	CntNodeRef xBoxRedirectNode;
	GetFTPBoxNode().GetTarget(xBoxRedirectNode);
	GetDocNodeData(PTR_CAST(CntFTPDocNode, pNode));
	for (;;)
	{
		if (pNode == &xBoxRedirectNode)
			return ITEMSET_VALUE(&xBoxRedirectNode, CntMsgStoreModeItem,
								 WID_MESSAGE_STOREMODE)
				       == CNT_MESSAGE_STOREMODE_LOCAL;
		SfxPoolItem const * pItem;
		if (pNode->GetItemState(WID_MESSAGE_STOREMODE, false, &pItem)
			    == SFX_ITEM_SET)
			return ITEM_VALUE(CntMsgStoreModeItem, *pItem)
				       == CNT_MESSAGE_STOREMODE_LOCAL;
		pNode = pNode->GetParent();
		if (!pNode)
			break;
		CntFTPFolderNode * pFolder = PTR_CAST(CntFTPFolderNode, pNode);
		if (!pFolder)
			break;
		GetFolderNodeData(pFolder);
	}
	return ITEM_VALUE(CntMsgStoreModeItem,
					  CntItemPool::Get()->
					      GetDefaultItem(WID_MESSAGE_STOREMODE))
		       == CNT_MESSAGE_STOREMODE_LOCAL;
}

//============================================================================
String CntFTPImp::GetUserName() const
{
	SfxPoolItem const * pItem;
	if (rFTPBoxNode.GetItemState(WID_USERNAME, false, &pItem) == SFX_ITEM_SET)
		return ITEM_VALUE(CntStringItem, *pItem);
	else
		return String();
}

//============================================================================
String CntFTPImp::GetPassword() const
{
	SfxPoolItem const * pItem;
	if (rFTPBoxNode.GetItemState(WID_PASSWORD, false, &pItem) == SFX_ITEM_SET)
		return ITEM_VALUE(CntStringItem, *pItem);
	else
		return String();
}

//============================================================================
String CntFTPImp::GetAccount() const
{
	SfxPoolItem const * pItem;
	if (rFTPBoxNode.GetItemState(WID_FTP_ACCOUNT, false, &pItem)
		    == SFX_ITEM_SET)
		return ITEM_VALUE(CntStringItem, *pItem);
	else
		return String();
}

//============================================================================
String CntFTPImp::GetServerNameAndPort() const
{
	SfxPoolItem const * pItem;
	if (rFTPBoxNode.GetItemState(WID_SERVERNAME, false, &pItem)
		    == SFX_ITEM_SET)
		return ITEM_VALUE(CntStringItem, *pItem);
	else
		return String();
}

//============================================================================
void CntFTPImp::GetServerNameAndPort(String & rServerName, USHORT & rPort)
	const
{
	SfxPoolItem const * pItem;
	if (rFTPBoxNode.GetItemState(WID_SERVERNAME, false, &pItem)
		    == SFX_ITEM_SET)
		CntMBXFormat::decomposeDomainAndPort(ITEM_VALUE(CntStringItem,
														*pItem),
											 rServerName, rPort);
	else
	{
		rServerName.Erase();
		rPort = 0;
	}
}

//============================================================================
String CntFTPImp::GetServerBase() const
{
	return ITEMSET_VALUE(&rFTPBoxNode, CntStringItem, WID_SERVERBASE);
}

//============================================================================
void CntFTPImp::SetServerBase(CntNodeJob & rJob, String const & rBase)
{
	rFTPBoxNode.Put(CntStringItem(WID_SERVERBASE, rBase));
	CntStorageNode * pCache = rJob.GetCacheNode(false);
	if (pCache)
		pCache->Put(CntStringItem(WID_SERVERBASE, rBase));

	CntNodeRef xBaseNode;
	if (rBase.Len() > 0)
	{
		String aURL(OWN_URL(&rFTPBoxNode));
		if (aURL.GetChar(aURL.Len() - 1) != '/')
			aURL += '/';
		aURL += rBase.Copy(1);
		xBaseNode = rFTPBoxNode.Query(aURL);
	}
	rFTPBoxNode.SetTarget(&xBaseNode);
	CopyFolderData(&xBaseNode, &rFTPBoxNode);
}

//============================================================================
bool CntFTPImp::IsProxyFolder(CntNode const * pFolder) const
{
	ServerSystem eSystem = ServerSystem(ITEMSET_VALUE(&rFTPBoxNode,
													  CntUInt16Item,
													  WID_FTP_SERVERSYSTEM));
	String aSlashFPath(CntFTPURL::getSlashFPath(OWN_URL(pFolder)));
	if (aSlashFPath.Len() == 0)
		return true;
	xub_StrLen nSlash = aSlashFPath.Search('/', 1);
	if (nSlash == STRING_NOTFOUND)
		return true;

	switch (eSystem)
	{
		case SYSTEM_UNIX:
			return !(nSlash == 4 && aSlashFPath.GetChar(1) == '%'
					 && aSlashFPath.GetChar(2) == '2'
					 && aSlashFPath.GetChar(3) == 'F');

		case SYSTEM_DOS:
			// For backwards compatibility, not only accept paths with a first
			// segment of "%5C" as absolute, but also those with a first
			// segment of "\" or with a first segment consisting of a letter
			// ("A"--"Z" or "a"--"z") followed by "%3A":
			return !(nSlash == 4 && aSlashFPath.GetChar(1) == '%'
					     && aSlashFPath.GetChar(2) == '5'
					     && aSlashFPath.GetChar(3) == 'C'
					 || nSlash == 2 && aSlashFPath.GetChar(1) == '\\'
					 || nSlash == 5
					    && INetMIME::isAlpha(aSlashFPath.GetChar(1))
					    && aSlashFPath.GetChar(2) == '%'
					    && aSlashFPath.GetChar(3) == '3'
					    && aSlashFPath.GetChar(4) == 'A');

		case SYSTEM_VMS:
			return !(nSlash > 14 && aSlashFPath.GetChar(nSlash - 13) == ':'
					 && aSlashFPath.GetChar(nSlash - 12) == '%'
					 && aSlashFPath.GetChar(nSlash - 11) == '5'
					 && aSlashFPath.GetChar(nSlash - 10) == 'B'
					 && aSlashFPath.GetChar(nSlash - 9) == '0'
					 && aSlashFPath.GetChar(nSlash - 8) == '0'
					 && aSlashFPath.GetChar(nSlash - 7) == '0'
					 && aSlashFPath.GetChar(nSlash - 6) == '0'
					 && aSlashFPath.GetChar(nSlash - 5) == '0'
					 && aSlashFPath.GetChar(nSlash - 4) == '0'
					 && aSlashFPath.GetChar(nSlash - 3) == '%'
					 && aSlashFPath.GetChar(nSlash - 2) == '5'
					 && aSlashFPath.GetChar(nSlash - 1) == 'D');

		default: // SYSTEM_UNKNOWN, SYSTEM_NONHIER
			return false;
	}
}

//============================================================================
String CntFTPImp::getProxyTargetURL(CntNode const & rProxy)
{
	String aTargetURL(OWN_URL(&rProxy));
	String aHirarchicalBasePath(GetServerBase());
	if (aHirarchicalBasePath.Len() > 0)
		aTargetURL = CntFTPURL::prependBaseToFPath(aTargetURL,
												   aHirarchicalBasePath);
	return aTargetURL;
}

//============================================================================
CntNode * CntFTPImp::GetProxyTarget(CntNode const * pProxy)
{
	CntNodeRef xBase;
	rFTPBoxNode.GetTarget(xBase);
	if (!xBase.Is())
		return 0;
	String aURL(OWN_URL(&xBase));
	aURL += CntFTPURL::getFPath(OWN_URL(pProxy));
	return rFTPBoxNode.Query(aURL);
}

//============================================================================
void CntFTPImp::ChaseRedirection(CntNode * pStartNode, CntNode * pCurrentNode,
								 LinkMode eLinkMode,
								 CntNodeRef & rTargetPointer,
								 CntNodeRef & rTargetNode)
{
	if (pCurrentNode && pCurrentNode->ISA(CntFTPDocNode))
	{
		rTargetPointer = pCurrentNode;
		rTargetNode = pCurrentNode;
	}
	else
	{
		rTargetPointer = PTR_CAST(CntFTPRedirectNode, pCurrentNode);
		for (rTargetNode = rTargetPointer; rTargetNode.Is();)
		{
			if (rTargetNode->ISA(CntFTPFolderNode))
				GetFolderNodeData(static_cast< CntFTPFolderNode * >(
					&rTargetNode));
			bool bProxy = IsProxyFolder(&rTargetNode);
			if (!bProxy)
			{
				if (eLinkMode == LINK_NO
					|| !(ITEMSET_VALUE(&rTargetNode, CntUInt32Item,
									   WID_FSYS_FLAGS)
						     & CNT_FLAG_LINK))
					break;
				if (eLinkMode == LINK_REFRESH)
				{
					rTargetNode.Clear();
					break;
				}
			}
			rTargetPointer = rTargetNode;
			static_cast< CntFTPRedirectNode * >(&rTargetNode)->
				GetTarget(rTargetNode);
			rTargetNode = PTR_CAST(CntFTPRedirectNode, &rTargetNode);
			if (!rTargetNode.Is() && bProxy)
				rTargetNode = PTR_CAST(CntFTPRedirectNode,
									   GetProxyTarget(&rTargetPointer));
		}
		if (rTargetNode.Is())
			for (CntNodeRef xNode(PTR_CAST(CntFTPRedirectNode, pStartNode));
				 xNode.Is() && &xNode != &rTargetNode;)
			{
				CopyFolderData(&rTargetNode, &xNode);
				CntNodeRef xNext;
				static_cast< CntFTPRedirectNode * >(&xNode)->GetTarget(xNext);
				xNode = PTR_CAST(CntFTPRedirectNode, &xNext);
			}
	}
}

//============================================================================
String CntFTPImp::FindUnusedCacheName(CntNodeJob * pJob,
									  CntStorageNode * pCache)
{
	String aName;
	CntStorageNode * pDirectory = pJob->GetDirectoryNode(false);
	if (pDirectory)
	{
		pDirectory = PTR_CAST(CntStorageNode, pDirectory->GetRootNode());
		if (pDirectory)
		{
			CntStoreItemSetRef
				xItemSet(pDirectory->
						     openItemSet(
								 String::CreateFromAscii(
									 RTL_CONSTASCII_STRINGPARAM(
										 CNT_FTP_BOX_DIRECTORY_ENTRY_NAME)),
								 STREAM_STD_READWRITE | STREAM_NOCREATE));
			if (xItemSet.Is())
				aName = ITEMSET_VALUE(&xItemSet, CntStringItem,
									  WID_FTP_LASTCACHENAME);
		}
	}
	for (;;)
	{
		if (aName.Len() == 0)
			aName = '0';
		else
			aName = String::CreateFromInt64(aName.ToInt64() + 1);
		if (!pCache)
			break;
		String aID(RTL_CONSTASCII_USTRINGPARAM(
			           CNT_FTP_DOC_CONTENTS_CACHE_ENTRY_PREFIX));
		aID += aName;
		SvStream * pStream = pCache->openStream(aID, STREAM_STD_READ);
		if (!pStream)
			break;
		delete pStream;
	}
	if (pDirectory)
	{
		CntStoreItemSetRef
			xItemSet(pDirectory->
					     openItemSet(
							 String::CreateFromAscii(
								 RTL_CONSTASCII_STRINGPARAM(
									 CNT_FTP_BOX_DIRECTORY_ENTRY_NAME)),
							 STREAM_STD_READWRITE | STREAM_NOCREATE));
		if (xItemSet.Is())
			xItemSet->Put(CntStringItem(WID_FTP_LASTCACHENAME, aName));
	}
	return aName;
}

//============================================================================
String CntFTPImp::MapToInternalPath(CntNodeJob * pJob,
									String const & rSystemPath)
{
	ServerSystem eSystem = ServerSystem(ITEMSET_VALUE(&rFTPBoxNode,
													  CntUInt16Item,
													  WID_FTP_SERVERSYSTEM));
	if (eSystem == SYSTEM_UNKNOWN || eSystem >= SYSTEM_END)
	{
		if (getConnection())
			switch (getConnection()->getListType())
			{
				case inet::INetFTPConnection::LIST_TYPE_UNKNOWN:
					eSystem = SYSTEM_NONHIER;
					break;

				case inet::INetFTPConnection::LIST_TYPE_DOS:
					eSystem = SYSTEM_DOS;
					break;

				case inet::INetFTPConnection::LIST_TYPE_UNIX:
					eSystem = SYSTEM_UNIX;
					break;

				case inet::INetFTPConnection::LIST_TYPE_VMS:
					eSystem = SYSTEM_VMS;
					break;
			}
		if (eSystem == SYSTEM_UNKNOWN || eSystem >= SYSTEM_END)
			if (rSystemPath.Len() >= 1 && rSystemPath.GetChar(0) == '\\'
				|| rSystemPath.Len() == 2
				   && INetMIME::isAlpha(rSystemPath.GetChar(0))
				   && rSystemPath.GetChar(1) == ':'
				|| rSystemPath.Len() > 2
				   && INetMIME::isAlpha(rSystemPath.GetChar(0))
				   && rSystemPath.GetChar(1) == ':'
				   && (rSystemPath.GetChar(2) == '/'
					   || rSystemPath.GetChar(2) == '\\'))
				eSystem = SYSTEM_DOS;
			else
			{
				xub_StrLen nOpenBrack = rSystemPath.Search('[');
				if (nOpenBrack != STRING_NOTFOUND && nOpenBrack > 0
					&& rSystemPath.GetChar(nOpenBrack - 1) == ':')
					eSystem = SYSTEM_VMS;
				else if (rSystemPath.Search('/') != STRING_NOTFOUND)
					eSystem = SYSTEM_UNIX;
				else
					eSystem = SYSTEM_NONHIER;
			}

		rFTPBoxNode.Put(CntUInt16Item(WID_FTP_SERVERSYSTEM, eSystem));
		if (CntStorageNode * pBoxDirNode = pJob->GetCacheNode(false))
		{
			CntStoreItemSetRef
				xBoxDirSet(pBoxDirNode->
						       openItemSet(
								   aCntFTPBoxDirectoryEntryRanges,
								   String::CreateFromAscii(
									   RTL_CONSTASCII_STRINGPARAM(
										   CNT_FTP_BOX_DIRECTORY_ENTRY_NAME)),
								   STREAM_STD_WRITE));
			if (xBoxDirSet.Is())
				xBoxDirSet->Put(CntUInt16Item(WID_FTP_SERVERSYSTEM, eSystem));
		}
	}

	String aSlashFPath('/');
	switch (eSystem)
	{
		case SYSTEM_UNIX:
			aSlashFPath.AppendAscii(RTL_CONSTASCII_STRINGPARAM("%2F"));
			if (rSystemPath.Len() > 0
				&& (rSystemPath.Len() > 1 || rSystemPath.GetChar(0) != '/'))
			{
				aSlashFPath += '/';
				sal_Unicode const * p = rSystemPath.GetBuffer();
				sal_Unicode const * pEnd = p + rSystemPath.Len();
				if (*p == '/')
					++p;
				while (p != pEnd)
				{
					sal_uInt32 nUTF32 = INetMIME::getUTF32Character(p, pEnd);
					if (nUTF32 == '/')
					{
						if (p != pEnd)
							aSlashFPath += '/';
					}
					else
						INetURLObject::appendUCS4(aSlashFPath, nUTF32,
												  INetURLObject::ESCAPE_NO,
												  false,
												  INetURLObject::PART_PCHAR,
												  '%', RTL_TEXTENCODING_UTF8,
												  false);
				}
			}
			break;

		case SYSTEM_DOS:
		{
			// All DOS like FPath's start with "%5C/":
			aSlashFPath.AppendAscii(RTL_CONSTASCII_STRINGPARAM("%5C/"));

			// If the system path consists of either a drive letter ("A"--"Z"
			// or "a"--"z"), followed by ":", or a drive letter ("A"--"Z" or
			// "a"--"z"), followed by ":", followed by either "/" or "\",
			// optionally followed by more stuff, add the drive letter
			// followed by ":%5C/" to the FPath:
			xub_StrLen i;
			if (rSystemPath.Len() >= 2
				&& INetMIME::isAlpha(rSystemPath.GetChar(0))
				&& rSystemPath.GetChar(1) == ':'
				&& (rSystemPath.Len() == 2 || rSystemPath.GetChar(2) == '/'
					|| rSystemPath.GetChar(2) == '\\'))
			{
				aSlashFPath += rSystemPath.GetChar(0);
				aSlashFPath.AppendAscii(RTL_CONSTASCII_STRINGPARAM(":%5C/"));
				i = rSystemPath.Len() == 2 ? 2 : 3;
			}
			else
				i = rSystemPath.Len() >= 1
				    && (rSystemPath.GetChar(0) == '/'
						    || rSystemPath.GetChar(0) == '\\') ?
					    1 : 0;

			// Divide the remaining system path into segments, separated from
			// one another and optinally followed by "/" or "\"; encode each
			// segment and add it to the FPath, following each segment by "/":
			sal_Unicode const * p = rSystemPath.GetBuffer();
			sal_Unicode const * pEnd = p + rSystemPath.Len();
			for (p += i; p != pEnd;)
			{
				sal_uInt32 nUTF32 = INetMIME::getUTF32Character(p, pEnd);
				if (nUTF32 == '/' || nUTF32 == '\\')
					aSlashFPath += '/';
				else
					INetURLObject::appendUCS4(aSlashFPath, nUTF32,
											  INetURLObject::ESCAPE_NO, false,
											  INetURLObject::PART_PCHAR, '%',
											  RTL_TEXTENCODING_UTF8, false);
			}
			break;
		}

		case SYSTEM_VMS:
		{
			xub_StrLen nOpenBrack = rSystemPath.Search('[');
			if (nOpenBrack == STRING_NOTFOUND)
				nOpenBrack = rSystemPath.Len();
			DBG_ASSERT(nOpenBrack > 0
					   && rSystemPath.GetChar(nOpenBrack - 1) == ':',
					   "CntFTPImp::MapToInternalPath(): Bad VMS path");
			sal_Unicode const * pBegin = rSystemPath.GetBuffer();
			sal_Unicode const * pEnd = pBegin + nOpenBrack;
			for (sal_Unicode const * p = pBegin; p != pEnd;)
				INetURLObject::appendUCS4(aSlashFPath,
										  INetMIME::getUTF32Character(p,
																	  pEnd),
										  INetURLObject::ESCAPE_NO, false,
										  INetURLObject::PART_PCHAR, '%',
										  RTL_TEXTENCODING_UTF8, false);
			aSlashFPath.
				AppendAscii(RTL_CONSTASCII_STRINGPARAM("%5B000000%5D/"));
			if (nOpenBrack < rSystemPath.Len())
			{
				pEnd = pBegin + rSystemPath.Len();
				for (sal_Unicode const * p = pBegin + nOpenBrack + 1;
					 p != pEnd;)
				{
					sal_uInt32 nUTF32 = INetMIME::getUTF32Character(p, pEnd);
					if (nUTF32 == ']')
						break;
					else if (nUTF32 == '.')
						aSlashFPath += '/';
					else
						INetURLObject::appendUCS4(aSlashFPath, nUTF32,
												  INetURLObject::ESCAPE_NO,
												  false,
												  INetURLObject::PART_PCHAR,
												  '%', RTL_TEXTENCODING_UTF8,
												  false);
				}
			}
			break;
		}

		default:
			aSlashFPath
				+= INetURLObject::encode(rSystemPath,
										 INetURLObject::PART_PCHAR, '%',
										 INetURLObject::ENCODE_ALL);
			break;
	}

	if (aSlashFPath.GetChar(aSlashFPath.Len() - 1) != '/')
		aSlashFPath += '/';
	return aSlashFPath;
}

//============================================================================
bool CntFTPImp::ParseNodeURL(String const & rExternalURL, String & rNodeURL,
							 String * pFTPPath, String * pFTPName,
							 bool bSplit)
{
	ServerSystem eSystem = ServerSystem(ITEMSET_VALUE(&rFTPBoxNode,
													  CntUInt16Item,
													  WID_FTP_SERVERSYSTEM));
	String aSlashFPath(CntFTPURL::getSlashFPath(rExternalURL));

	bool bCompleteURL;
	switch (eSystem)
	{
		case SYSTEM_UNIX:
			bCompleteURL = aSlashFPath.Len() >= 5
				           && aSlashFPath.GetChar(1) == '%'
				           && aSlashFPath.GetChar(2) == '2'
				           && aSlashFPath.GetChar(3) == 'F'
				           && aSlashFPath.GetChar(4) == '/';
			break;

		case SYSTEM_DOS:
			bCompleteURL = aSlashFPath.Len() >= 5
				           && aSlashFPath.GetChar(1) == '%'
				           && aSlashFPath.GetChar(2) == '5'
				           && aSlashFPath.GetChar(3) == 'C'
				           && aSlashFPath.GetChar(4) == '/';
			break;

		case SYSTEM_VMS:
		{
			xub_StrLen nSlash = aSlashFPath.Search('/', 1);
			bCompleteURL = nSlash != STRING_NOTFOUND && nSlash > 14
			               && aSlashFPath.GetChar(nSlash - 13) == ':'
			               && aSlashFPath.GetChar(nSlash - 12) == '%'
			               && aSlashFPath.GetChar(nSlash - 11) == '5'
			               && aSlashFPath.GetChar(nSlash - 10) == 'B'
			               && aSlashFPath.GetChar(nSlash - 9) == '0'
			               && aSlashFPath.GetChar(nSlash - 8) == '0'
			               && aSlashFPath.GetChar(nSlash - 7) == '0'
			               && aSlashFPath.GetChar(nSlash - 6) == '0'
			               && aSlashFPath.GetChar(nSlash - 5) == '0'
			               && aSlashFPath.GetChar(nSlash - 4) == '0'
			               && aSlashFPath.GetChar(nSlash - 3) == '%'
			               && aSlashFPath.GetChar(nSlash - 2) == '5'
			               && aSlashFPath.GetChar(nSlash - 1) == 'D';
			break;
		}

		default:
			bCompleteURL = aSlashFPath.Search('/', 1) != STRING_NOTFOUND;
			break;
	}

	if (bCompleteURL)
		rNodeURL = rExternalURL;
	else
	{
		String aInternalSlashFPath(GetServerBase());
		if (aInternalSlashFPath.Len() == 0)
			return false;
		if (aInternalSlashFPath.GetChar(aInternalSlashFPath.Len() - 1) != '/')
			aInternalSlashFPath += '/';
		if (aSlashFPath.Len() != 0)
			aInternalSlashFPath += aSlashFPath.Copy(1);
		aSlashFPath = aInternalSlashFPath;
		rNodeURL = CntFTPURL::replaceSlashFPath(rExternalURL, aSlashFPath);
	}

	if (pFTPPath || pFTPName)
	{
		bool bFinalDir = aSlashFPath.GetChar(aSlashFPath.Len() - 1) == '/';
		if (bFinalDir)
			aSlashFPath.Erase(aSlashFPath.Len() - 1);

		String aName;
		if (bSplit)
		{
			xub_StrLen nSlashPos = aSlashFPath.Len() - 1;
			while (aSlashFPath.GetChar(nSlashPos) != '/')
				--nSlashPos;
			aName = aSlashFPath.Copy(nSlashPos + 1);
			aSlashFPath.Erase(nSlashPos);
			bFinalDir = true;
		}

		aSlashFPath.Erase(0, 1);
		bool bPathLeft = aSlashFPath.Len() != 0;
		if (pFTPPath && !bPathLeft)
			pFTPPath->Erase();

		switch (eSystem)
		{
			case SYSTEM_UNIX:
				if (pFTPPath && bPathLeft)
				{
					if (aSlashFPath.Len() >= 4
						&& aSlashFPath.GetChar(0) == '%'
						&& aSlashFPath.GetChar(1) == '2'
						&& aSlashFPath.GetChar(2) == 'F'
						&& aSlashFPath.GetChar(3) == '/')
						aSlashFPath.Erase(0, 3);
					*pFTPPath = INetURLObject::decode(
						            aSlashFPath, '%',
									INetURLObject::DECODE_WITH_CHARSET);
				}
				if (pFTPName)
					*pFTPName
						= INetURLObject::decode(
							  aName, '%', INetURLObject::DECODE_WITH_CHARSET);
				break;

			case SYSTEM_DOS:
				if (pFTPPath && bPathLeft)
				{
					pFTPPath->Erase();
					xub_StrLen nSegment;
					if (aSlashFPath.Len() >= 3
						&& aSlashFPath.GetChar(0) == '%'
						&& aSlashFPath.GetChar(1) == '5'
						&& aSlashFPath.GetChar(2) == 'C'
						&& (aSlashFPath.Len() == 3
							|| aSlashFPath.GetChar(3) == '/'))
					{
						if (aSlashFPath.Len() >= 9
							&& INetMIME::isAlpha(aSlashFPath.GetChar(4))
							&& aSlashFPath.GetChar(5) == ':'
							&& aSlashFPath.GetChar(6) == '%'
							&& aSlashFPath.GetChar(7) == '5'
							&& aSlashFPath.GetChar(8) == 'C'
							&& (aSlashFPath.Len() == 9
								|| aSlashFPath.GetChar(9) == '/'))
						{
							*pFTPPath = aSlashFPath.Copy(4, 2);
							*pFTPPath += '\\';
							nSegment = aSlashFPath.Len() == 9 ? 9 : 10;
						}
						else
						{
							if (!bSplit || aSlashFPath.Len() > 3)
								*pFTPPath += '\\';
							nSegment = aSlashFPath.Len() == 3 ? 3 : 4;
						}
					}
					else
					{
						*pFTPPath += '\\';
						nSegment = 0;
					}
					while (nSegment < aSlashFPath.Len())
					{
						xub_StrLen nSlash = aSlashFPath.Search('/', nSegment);
						if (nSlash == STRING_NOTFOUND)
							nSlash = aSlashFPath.Len();
						*pFTPPath
							+= INetURLObject::decode(
								   aSlashFPath.Copy(nSegment,
													nSlash - nSegment),
								   '%', INetURLObject::DECODE_WITH_CHARSET);
						*pFTPPath += '\\';
						nSegment = nSlash + 1;
					}
				}
				if (pFTPName)
					*pFTPName
						= INetURLObject::decode(
							  aName, '%', INetURLObject::DECODE_WITH_CHARSET);
				break;

			case SYSTEM_VMS:
				if (pFTPPath && bPathLeft)
				{
					xub_StrLen nSlash = aSlashFPath.Search('/');
					if (nSlash == STRING_NOTFOUND)
						nSlash = aSlashFPath.Len();
					*pFTPPath
						= INetURLObject::decode(
							  aSlashFPath.Copy(0,
											   nSlash >= 9 ? nSlash - 9 :
											                 nSlash),
							  '%', INetURLObject::DECODE_WITH_CHARSET);
					bool bFirstDir = true;
					while (nSlash < aSlashFPath.Len())
					{
						xub_StrLen nNextSlash
							= aSlashFPath.Search('/', nSlash + 1);
						if (nNextSlash == STRING_NOTFOUND)
							nNextSlash = aSlashFPath.Len();
						if (bFirstDir)
							bFirstDir = false;
						else
							*pFTPPath += '.';
						*pFTPPath
							+= INetURLObject::decode(
								   aSlashFPath.Copy(nSlash + 1,
													nNextSlash - nSlash - 1),
								   '%', INetURLObject::DECODE_WITH_CHARSET);
						nSlash = nNextSlash;
					}
					if (bFirstDir)
						pFTPPath->
							AppendAscii(RTL_CONSTASCII_STRINGPARAM("000000"));
					*pFTPPath += ']';
				}
				if (pFTPName)
					*pFTPName
						= INetURLObject::decode(
							  aName, '%', INetURLObject::DECODE_WITH_CHARSET);
				break;

			default:
				if (pFTPPath && bPathLeft)
					*pFTPPath = INetURLObject::decode(
						            aSlashFPath, '%',
									INetURLObject::DECODE_WITH_CHARSET);
				if (pFTPName)
					*pFTPName
						= INetURLObject::decode(
							  aName, '%', INetURLObject::DECODE_WITH_CHARSET);
				break;
		}
	}

	return true;
}

//============================================================================
String CntFTPImp::MapToExternalURL(String const & rNodeURL)
{
	String aURL(rNodeURL);
	String aSlashFPath;
	xub_StrLen nSlash;
	CntFTPURL::getSlashFPath(rNodeURL, aSlashFPath, nSlash);
	String aBase(GetServerBase());
	if (aBase.Len() > 0
		&& aSlashFPath.CompareTo(aBase, aBase.Len()) == COMPARE_EQUAL)
	{
		String aExternalURL(rNodeURL);
		aExternalURL.Erase(nSlash + 1, aBase.Len() - 1);
		return aExternalURL;
	}
	else
		return rNodeURL;
}

//============================================================================
// static
String CntFTPImp::GetName(CntNode const * pNode)
{
	String aName(OWN_URL(pNode));
	if (aName.GetChar(aName.Len() - 1) == '/')
		aName.Erase(aName.Len() - 1);
	xub_StrLen nSlash = aName.Len() - 1;
	while (aName.GetChar(nSlash) != '/')
		--nSlash;
	aName.Erase(0, nSlash + 1);
	return
		INetURLObject::decode(aName, '%', INetURLObject::DECODE_WITH_CHARSET);
}

//============================================================================
void CntFTPImp::forceDirectoryStorage() const
{
	String aURL(RTL_CONSTASCII_USTRINGPARAM(STG_PROTOCOL_CACHE));
	aURL += OWN_URL(&rFTPBoxNode);
	CntRootNodeMgr::Get()->Query(aURL);
}

//============================================================================
void CntFTPImp::forceUserDataStorage() const
{
	String aURL(RTL_CONSTASCII_USTRINGPARAM(STG_PROTOCOL_USER));
	aURL += OWN_URL(&rFTPBoxNode);
	CntRootNodeMgr::Get()->Query(aURL);
}

//============================================================================
// static
CntNode * CntFTPImp::GetDirectory(CntNode const * pNode)
{
	String aURL(RTL_CONSTASCII_USTRINGPARAM(STG_PROTOCOL_CACHE));
	aURL += OWN_URL(pNode);
	return CntStorageNode::StorageFileExists(aURL) ?
		       CntRootNodeMgr::Get()->Query(aURL) : 0;
}

//============================================================================
// static
CntNode * CntFTPImp::GetUserData(CntNode const * pNode)
{
	String aURL(RTL_CONSTASCII_USTRINGPARAM(STG_PROTOCOL_USER));
	aURL += OWN_URL(pNode);
	return CntStorageNode::StorageFileExists(aURL) ?
		       CntRootNodeMgr::Get()->Query(aURL) : 0;
}

//============================================================================
// static
bool CntFTPImp::ParseID(String const & rID, String & rName, bool & rDocument)
{
	if (rID.EqualsAscii(CNT_FTP_DOC_ENTRY_PREFIX, 0,
						RTL_CONSTASCII_LENGTH(CNT_FTP_DOC_ENTRY_PREFIX)))
	{
		rName = rID.Copy(RTL_CONSTASCII_LENGTH(CNT_FTP_DOC_ENTRY_PREFIX));
		rDocument = true;
		return true;
	}
	else if (rID.EqualsAscii(CNT_FTP_FOLDER_ENTRY_PREFIX, 0,
							 RTL_CONSTASCII_LENGTH(
								 CNT_FTP_FOLDER_ENTRY_PREFIX)))
	{
		rName = rID.Copy(RTL_CONSTASCII_LENGTH(CNT_FTP_FOLDER_ENTRY_PREFIX));
		rDocument = false;
		return true;
	}
	else
		return false;
}

//============================================================================
// static
USHORT const * CntFTPImp::GetFolderDirectoryEntryRanges()
{
	return aCntFTPFolderDirectoryEntryRanges;
}

//============================================================================
// static
USHORT const * CntFTPImp::GetFolderUserDataEntryRanges()
{
	return aCntFTPFolderUserDataEntryRanges;
}

//============================================================================
// static
USHORT const * CntFTPImp::GetDocDirectoryEntryRanges()
{
	return aCntFTPDocDirectoryEntryRanges;
}

//============================================================================
// static
USHORT const * CntFTPImp::GetDocRefcountCacheEntryRanges()
{
	return aCntFTPDocRefcountCacheEntryRanges;
}

//============================================================================
bool CntFTPImp::getUpdateOnOpenMode(CntNodeJob const & rJob) const
{
	if (CntAnchor const * pAnchor = PTR_CAST(CntAnchor, rJob.GetClient()))
	{
		CntAnchorRef
			xRootViewAnchor(new CntAnchor(0, pAnchor->GetRootViewURL()));
		return ITEMSET_VALUE(xRootViewAnchor, CntBoolItem,
							 WID_FLAG_UPDATE_ON_OPEN)
			       != false;
	}
	else
		return
			ITEMSET_VALUE(&rFTPBoxNode, CntBoolItem, WID_FLAG_UPDATE_ON_OPEN)
			    != false;
}

//============================================================================
//
//  CntFTPCleanCacheTask
//
//============================================================================

// virtual
CntFTPCleanCacheTask::~CntFTPCleanCacheTask()
{
	delete m_pIterator;
}

//============================================================================
// virtual
SfxPoolItem const * CntFTPCleanCacheTask::execute()
{
	if (!m_pCache)
	{
		m_pCache = getJob().GetCacheNode(false);
		if (!m_pCache)
		{
			cancel();
			return 0;
		}
		m_pIterator = new CntStorageIterator;
		String aStatusText(CntResId(RID_STATUS_FTP_CLEAN_CACHE));
		aStatusText.SearchAndReplaceAscii("%1",
										  m_rImp.GetServerNameAndPort());
		m_bStatus = true;
		getJob().Broadcast(CntStatusBarHint(aStatusText));
	}

	startTimeSlice();
	for (;;)
	{
		String aContentName(m_pCache->iter(*m_pIterator));
		if (aContentName.Len() == 0)
		{
			delete m_pIterator;
			m_pIterator = 0;
			break;
		}

		bool bRemove
			= aContentName.EqualsAscii(
				               CNT_FTP_DOC_CONTENTS_CACHE_ENTRY_PREFIX, 0,
							   RTL_CONSTASCII_LENGTH(
								   CNT_FTP_DOC_CONTENTS_CACHE_ENTRY_PREFIX))
			      != false;
		if (bRemove)
		{
			UINT32 nAttrib = 0;
			m_pCache->attrib(aContentName, 0, 0, nAttrib);
			bRemove = (nAttrib & CNTDIRENTRY_ATTRIB_FTP_PARTIAL) != 0;
		}
		if (bRemove)
		{
			String
				aRefcountName(RTL_CONSTASCII_USTRINGPARAM(
					              CNT_FTP_DOC_REFCOUNT_CACHE_ENTRY_PREFIX));
			aRefcountName
				+= aContentName.
				       Copy(RTL_CONSTASCII_LENGTH(
						        CNT_FTP_DOC_CONTENTS_CACHE_ENTRY_PREFIX));
			CntStoreItemSetRef
				xRefcountSet(
					m_pCache->openItemSet(
						          CntFTPImp::GetDocRefcountCacheEntryRanges(),
								  aRefcountName, STREAM_STD_READ));
			if (xRefcountSet.Is())
			{
				if (ITEMSET_VALUE(&xRefcountSet, CntUInt32Item,
								  WID_FTP_CACHEREFS)
					    != 0)
					bRemove = false;
				else
				{
					xRefcountSet = 0;
					m_pCache->remove(aRefcountName);
				}
			}
		}
		if (bRemove)
			m_pCache->remove(aContentName);

		if (checkTimeSliceExhausted())
		{
			reschedule();
			return 0;
		}
	}

	done();
	return 0;
}

//============================================================================
// virtual
void CntFTPCleanCacheTask::finished(bool)
{
	if (m_bStatus)
		getJob().Broadcast(CntStatusBarHint(String()));
}

