/*************************************************************************
 *
 *  $RCSfile: cnftptsk.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: sb $ $Date: 2001/07/26 12:47:14 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SVTOOLS_INETOPTIONS_HXX_
#include <svtools/inetoptions.hxx>
#endif
#ifndef _EINF_HXX
#include <tools/errinf.hxx>
#endif

#ifndef _CNTCMITM_HXX
#include <cntcmitm.hxx>
#endif
#ifndef _CNTINET_HXX
#include <cntinet.hxx>
#endif
#ifndef _CNTNFTP_HXX
#include <cntnftp.hxx>
#endif
#ifndef _CNTRESID_HXX
#include <cntresid.hxx>
#endif
#ifndef _CNTRNMGR_HXX
#include <cntrnmgr.hxx>
#endif
#ifndef _CSTRITEM_HXX
#include <cstritem.hxx>
#endif
#ifndef _PROCHAOS_HRC
#include <prochaos.hrc>
#endif

#ifndef CHAOS_CNFTPTSK_HXX
#include <cnftptsk.hxx>
#endif

using namespace chaos;

//============================================================================
//
//  CntFTPTask
//
//============================================================================

// virtual
SfxPoolItem const * CntFTPTask::execute()
{
	if (m_nState == STATE_INITIALIZE)
	{
		getImp().ChaseRedirection(getJob().GetSubject(),
								  getJob().GetSubject(), m_eLinkMode,
								  xTargetPointer, xTargetNode);
		if (!initialize())
			return 0;
		if (!bConnModeDetermined)
			eConnMode = getImp().GetConnMode();
		m_nState
			= eConnMode == CNT_CONN_MODE_ONLINE ? STATE_OPEN : EXTRA_STATES;
	}
	if (m_nState < EXTRA_STATES)
		executeCallback(0, 0);
	else
		handleReschedule();
	return 0;
}

//============================================================================
// virtual
void CntFTPTask::finished(bool bCanceled)
{
	if (m_bConnectionAcquired)
		getImp().clearTransferCallback();
	if (bCanceled)
	{
		if (m_bConnectionAcquired && m_eCallbackState != CALLBACK_IDLE)
			getImp().abortConnection(m_eCallbackState == CALLBACK_TRANSFER);
		handleCancel();
	}
	if (m_bConnectionAcquired)
		getImp().releaseConnection();
	clearStatusText();
}

//============================================================================
// static
sal_Bool CntFTPTask::callback(inet::INetFTPConnection * pConnection,
							  sal_Int32 nReplyCode,
							  sal_Char const * pReplyText, void * pData)
{
	vos::ORef< CntFTPTask > xTask(static_cast< CntFTPTask * >(pData));
	DBG_ASSERT(xTask.isValid(), "CntFTPTask::callback(): Bad data");
	DBG_ASSERT(pConnection == xTask->getImp().getConnection(),
			   "CntFTPTask::callback(): Bad connection");
	xTask->callbackOccured();
	if (xTask->wakeUp())
	{
		xTask->executeCallback(nReplyCode, pReplyText);
		xTask->sleep();
	}
	return true;
}

//============================================================================
// static
sal_Bool CntFTPTask::transferCallback(inet::INetFTPConnection * pConnection,
									  sal_Int32, sal_Char const *,
									  void * pData)
{
	vos::ORef< CntFTPTask > xTask(static_cast< CntFTPTask * >(pData));
	DBG_ASSERT(xTask.isValid(), "CntFTPTask::transferCallback(): Bad data");
	DBG_ASSERT(pConnection == xTask->getImp().getConnection(),
			   "CntFTPTask::transferCallback(): Bad connection");
	if (xTask->wakeUp())
	{
		xTask->handleTransferCallback();
		xTask->sleep();
	}
	return true;
}

//============================================================================
void CntFTPTask::executeCallback(sal_Int32 nReplyCode,
								 sal_Char const * pReplyText)
{
	if (m_eCallbackState != CALLBACK_IDLE
		&& nReplyCode != inet::INetFTPConnection::REPLY_RESOLVER_WAIT
		&& nReplyCode != inet::INetFTPConnection::REPLY_RESOLVER_DONE
		&& nReplyCode != inet::INetFTPConnection::REPLY_CONNECT_WAIT
		&& nReplyCode != inet::INetFTPConnection::REPLY_CONNECT_DONE
		&& nReplyCode != inet::INetFTPConnection::REPLY_REQUEST_WAIT
		&& nReplyCode != inet::INetFTPConnection::REPLY_REQUEST_DONE
		&& nReplyCode != inet::INetFTPConnection::REPLY_RESPONSE_WAIT
		&& nReplyCode != inet::INetFTPConnection::REPLY_RESPONSE_DONE
		&& nReplyCode != inet::INetFTPConnection::REPLY_TRANSFER_WAIT
		&& nReplyCode / 100 != 1)
		m_eCallbackState = CALLBACK_IDLE;

	if (nReplyCode == inet::INetFTPConnection::REPLY_NETWORK_ERROR
			 || nReplyCode == inet::INetFTPConnection::REPLY_RESOLVER_ERROR
			 || nReplyCode == inet::INetFTPConnection::REPLY_CONNECT_ERROR
			 || nReplyCode == inet::INetFTPConnection::REPLY_SERVICE_UNAVAIL)
	{
		getImp().abortConnection(false);
		if (nReplyCode == inet::INetFTPConnection::REPLY_NETWORK_ERROR
			&& (m_nState == STATE_USER_DONE || m_nState == STATE_PASS_DONE
				|| m_nState == STATE_ACCT_DONE))
			m_nState = STATE_OPEN;
		else if (!error(nReplyCode, pReplyText))
			return;
	}

	for (;;)
		switch (m_nState)
		{
			case STATE_OPEN:
				//@@@ Using busy waiting via reschedule instead of waiting on
				// a condition seems to avoid deadlocks; has to be
				// investigated carefully...
				if (!m_bConnectionAcquired)
				{
					if (!getImp().acquireConnection())
					{
						reschedule();
						return;
					}
					m_bConnectionAcquired = true;
				}

				if (!getImp().initializeConnection(m_bToClose))
					if (m_bToClose)
					{
						m_nState = EXTRA_STATES;
						break;
					}
					else if (handleError(ERRCODE_CHAOS_BAD_INET)
							     != RESPONSE_CANCELED)
					{
						cancel();
						return;
					}

				switch (getImp().getConnectionState())
				{
					case CntFTPImp::CONNECTION_DOWN:
						cancel();
						return;

					case CntFTPImp::CONNECTION_INITIALIZED:
						if (m_bToClose)
						{
							getImp().abortConnection(false);
							m_nState = EXTRA_STATES;
							break;
						}
						else
						{
							getImp().checkAnonymous();
							String aHost;
							USHORT nPort;
							getImp().GetServerNameAndPort(aHost, nPort);

							// Check proxy settings:
							String
								aURL(RTL_CONSTASCII_USTRINGPARAM("ftp://"));
							aURL += aHost;
							if (nPort > 0)
							{
								aURL += ':';
								aURL += String::CreateFromInt32(nPort);
							}
                            SvtInetOptions aOptions;
							if (aOptions.ShouldUseFtpProxy(aURL))
							{
                                rtl::OUString aProxyName
                                    = aOptions.GetProxyFtpName();
								if (aProxyName.getLength() > 0)
								{
									if (!error(
										     *new StringErrorInfo(
												      ERRCODE_CHAOS_FTP_PROXY,
													  getImp().
													 GetServerNameAndPort())))
										return;
									break;
								}
                                aProxyName = aOptions.GetProxySocksName();
								if (aProxyName.getLength() > 0)
									getImp().getConnection()->
										setSocksGateway(
											aProxyName,
                                            static_cast< sal_uInt16 >(
                                                aOptions.
                                                    GetProxySocksPort()));
							}

							String aText(CntResId(
								             RID_PROT_CONNECTING_TO_SERVER));
							aText.SearchAndReplaceAscii(
								      "$(ARG1)",
									  getImp().GetServerNameAndPort());
							setStatusText(aText);

							m_nState = STATE_OPEN_DONE;
							if (sleep())
							{
								sal_uInt32 nID = startCommand(false);
								bool bSuccess
									= getImp().getConnection()->open(aHost,
																	 nPort,
																	 callback,
																	 this)
									      != false;
								if (!wakeUp())
									getImp().abortConnection(false);
								else if (!bSuccess && !wasCalledBack(nID))
								{
									commandFailed();
									getImp().abortConnection(false);
									if (error(
										    *new TwoStringErrorInfo(
										 ERRCODE_CHAOS_SERVER_CONNECT_FAILURE,
										             String::CreateFromAscii(
												   RTL_CONSTASCII_STRINGPARAM(
															 "FTP")),
													 getImp().
													 GetServerNameAndPort())))
										break;
								}
							}
							return;
						}

					case CntFTPImp::CONNECTION_SEND_USER:
						if (m_bToClose)
							m_nState = STATE_CLOSE;
						else
						{
							setStatusText(
								CntResId(RID_PROT_SENDING_LOGIN_INFORMATION));
							m_nState = STATE_USER;
						}
						break;

					case CntFTPImp::CONNECTION_SEND_PASS:
						if (m_bToClose)
							m_nState = STATE_CLOSE;
						else
						{
							setStatusText(
								CntResId(RID_PROT_SENDING_LOGIN_INFORMATION));
							m_nState = STATE_PASS;
						}
						break;

					case CntFTPImp::CONNECTION_SEND_ACCT:
						if (m_bToClose)
							m_nState = STATE_CLOSE;
						else
						{
							setStatusText(
								CntResId(RID_PROT_SENDING_LOGIN_INFORMATION));
							m_nState = STATE_ACCT;
						}
						break;

					case CntFTPImp::CONNECTION_SEND_PWD:
						m_nState = m_bToClose ? STATE_CLOSE : STATE_INIT_PWD;
						break;

					case CntFTPImp::CONNECTION_AVAILABLE:
						m_nState = m_bToClose ? STATE_CLOSE : STATE_CWD;
						break;

					case CntFTPImp::CONNECTION_CLOSE:
						m_nState = STATE_CLOSE;
						break;
				}
				break;

			case STATE_OPEN_DONE:
				if (nReplyCode / 100 == 2)
				{
					getImp().
						setConnectionState(CntFTPImp::CONNECTION_SEND_USER);
					setStatusText(CntResId(
						              RID_PROT_SENDING_LOGIN_INFORMATION));
					m_nState = STATE_USER;
				}
				else if (nReplyCode
						     == inet::INetFTPConnection::REPLY_RESOLVER_WAIT
						 || nReplyCode
						       == inet::INetFTPConnection::REPLY_RESOLVER_DONE
						 || nReplyCode
						        == inet::INetFTPConnection::REPLY_CONNECT_WAIT
						 || nReplyCode
						        == inet::INetFTPConnection::REPLY_CONNECT_DONE
						 || !error(nReplyCode, pReplyText))
					return;
				break;

			case STATE_USER:
			{
				String aUser;
				bool bRestart = false;
				do
				{
					aUser = getImp().GetUserName();
					if (aUser.Len() > 0)
						break;
					switch (handleError(
						        getImp().getLoginAccount() ?
								    ERRCODE_CHAOS_LOGIN_FAILURE_ACCOUNT :
								    ERRCODE_CHAOS_LOGIN_FAILURE_RECEIVE,
								0, &getImp().GetFTPBoxNode()))
					{
						case RESPONSE_IGNORE:
						case RESPONSE_ABORT:
							cancel();
						case RESPONSE_CANCELED:
							return;

						default:
							if (getImp().connectionTerminated())
							{
								clearStatusText();
								m_nState = STATE_OPEN;
								bRestart = true;
							}
							break;
					}
				}
				while (!bRestart);
				if (bRestart)
					break;

				m_nState = STATE_USER_DONE;
				if (!connectionLoginUsername(aUser)
					&& error(ERRCODE_CHAOS_FTP_GENERAL_FAILURE))
					break;
				return;
			}

			case STATE_USER_DONE:
				if (nReplyCode / 100 == 2)
				{
					clearStatusText();
					getImp().
						setConnectionState(CntFTPImp::CONNECTION_SEND_PWD);
					m_nState = STATE_INIT_PWD;
				}
				else if (nReplyCode / 100 == 3)
				{
					getImp().
						setConnectionState(CntFTPImp::CONNECTION_SEND_PASS);
					m_nState = STATE_PASS;
				}
				else if (nReplyCode
						     == inet::INetFTPConnection::REPLY_NOT_LOGGED_IN)
				{
					String aTheReply(pReplyText, RTL_TEXTENCODING_ISO_8859_1);
					switch (handleError(
						        getImp().getLoginAccount() ?
								    ERRCODE_CHAOS_LOGIN_FAILURE_ACCOUNT :
								    ERRCODE_CHAOS_LOGIN_FAILURE_RECEIVE,
								&aTheReply,
								&getImp().GetFTPBoxNode()))
					{
						case RESPONSE_IGNORE:
						case RESPONSE_ABORT:
							cancel();
						case RESPONSE_CANCELED:
							return;

						default:
							if (getImp().connectionTerminated())
							{
								clearStatusText();
								m_nState = STATE_OPEN;
							}
							else
								m_nState = STATE_USER;
							break;
					}
				}
				else if (!error(nReplyCode, pReplyText))
					return;
				break;

			case STATE_PASS:
			{
				String aPassword;
				bool bRestart = false;
				do
				{
					aPassword = getImp().GetPassword();
					if (aPassword.Len() > 0)
						break;
					switch (handleError(
						        getImp().getLoginAccount() ?
								    ERRCODE_CHAOS_LOGIN_FAILURE_ACCOUNT :
								    ERRCODE_CHAOS_LOGIN_FAILURE_RECEIVE,
								0, &getImp().GetFTPBoxNode()))
					{
						case RESPONSE_IGNORE:
						case RESPONSE_ABORT:
							cancel();
						case RESPONSE_CANCELED:
							return;

						default:
							if (getImp().connectionTerminated())
							{
								clearStatusText();
								m_nState = STATE_OPEN;
								bRestart = true;
							}
							break;
					}
				}
				while (!bRestart);
				if (bRestart)
					break;

				m_nState = STATE_PASS_DONE;
				if (!connectionLoginPassword(aPassword)
					&& error(ERRCODE_CHAOS_FTP_GENERAL_FAILURE))
					break;
				return;
			}

			case STATE_PASS_DONE:
				if (nReplyCode / 100 == 2)
				{
					clearStatusText();
					getImp().
						setConnectionState(CntFTPImp::CONNECTION_SEND_PWD);
					getImp().setLoginAccount(false);
					m_nState = STATE_INIT_PWD;
				}
				else if (nReplyCode / 100 == 3)
				{
					getImp().
						setConnectionState(CntFTPImp::CONNECTION_SEND_ACCT);
					getImp().setLoginAccount(true);
					m_nState = STATE_ACCT;
				}
				else if (nReplyCode
						     == inet::INetFTPConnection::REPLY_NOT_LOGGED_IN)
				{
					String aTheReply(pReplyText, RTL_TEXTENCODING_ISO_8859_1);
					switch (handleError(
						        getImp().getLoginAccount() ?
								    ERRCODE_CHAOS_LOGIN_FAILURE_ACCOUNT :
								    ERRCODE_CHAOS_LOGIN_FAILURE_RECEIVE,
								&aTheReply,
								&getImp().GetFTPBoxNode()))
					{
						case RESPONSE_IGNORE:
						case RESPONSE_ABORT:
							cancel();
						case RESPONSE_CANCELED:
							return;

						default:
							if (getImp().connectionTerminated())
							{
								clearStatusText();
								m_nState = STATE_OPEN;
							}
							else
								m_nState = STATE_USER;
							break;
					}
				}
				else if (!error(nReplyCode, pReplyText))
					return;
				break;

			case STATE_ACCT:
			{
				String aAccount;
				bool bRestart = false;
				do
				{
					aAccount = getImp().GetAccount();
					if (aAccount.Len() > 0)
						break;
					String aOldPassword(getImp().GetPassword());
					switch (handleError(
						        getImp().getLoginAccount() ?
								    ERRCODE_CHAOS_LOGIN_FAILURE_ACCOUNT :
								    ERRCODE_CHAOS_LOGIN_FAILURE_RECEIVE,
								0, &getImp().GetFTPBoxNode()))
					{
						case RESPONSE_IGNORE:
						case RESPONSE_ABORT:
							cancel();
						case RESPONSE_CANCELED:
							return;

						default:
							if (getImp().connectionTerminated())
							{
								clearStatusText();
								m_nState = STATE_OPEN;
								bRestart = true;
							}
							else if (aOldPassword != getImp().GetPassword())
							{
								getImp().setConnectionState(
										     CntFTPImp::CONNECTION_SEND_USER);
								m_nState = STATE_USER;
								bRestart = true;
							}
							break;
					}
				}
				while (!bRestart);
				if (bRestart)
					break;

				m_nState = STATE_ACCT_DONE;
				if (!connectionLoginAccount(aAccount)
					&& error(ERRCODE_CHAOS_FTP_GENERAL_FAILURE))
					break;
				return;
			}

			case STATE_ACCT_DONE:
				if (nReplyCode / 100 == 2)
				{
					clearStatusText();
					getImp().
						setConnectionState(CntFTPImp::CONNECTION_SEND_PWD);
					m_nState = STATE_INIT_PWD;
				}
				else if (nReplyCode
						     == inet::INetFTPConnection::REPLY_NOT_LOGGED_IN)
				{
					String aTheReply(pReplyText, RTL_TEXTENCODING_ISO_8859_1);
					switch (handleError(
						        getImp().getLoginAccount() ?
								    ERRCODE_CHAOS_LOGIN_FAILURE_ACCOUNT :
								    ERRCODE_CHAOS_LOGIN_FAILURE_RECEIVE,
								&aTheReply,
								&getImp().GetFTPBoxNode()))
					{
						case RESPONSE_IGNORE:
						case RESPONSE_ABORT:
							cancel();
						case RESPONSE_CANCELED:
							return;

						default:
							if (getImp().connectionTerminated())
							{
								clearStatusText();
								m_nState = STATE_OPEN;
							}
							else
								m_nState = STATE_USER;
							break;
					}
				}
				else if (!error(nReplyCode, pReplyText))
					return;
				break;

			case STATE_INIT_PWD:
				m_nState = STATE_INIT_PWD_DONE;
				if (!connectionGetCurDir()
					&& error(ERRCODE_CHAOS_FTP_GENERAL_FAILURE))
					break;
				return;

			case STATE_INIT_PWD_DONE:
				if (nReplyCode / 100 == 2)
				{
					m_aPath = getImp().getConnection()->getCurDir();
					String
						aBase(getImp().MapToInternalPath(&getJob(), m_aPath));
					if (getImp().GetServerBase().Len() == 0)
						getImp().SetServerBase(getJob(), aBase);
					getImp().
						setConnectionState(CntFTPImp::CONNECTION_AVAILABLE);
					m_nState = STATE_CWD;
				}
				else if (!error(nReplyCode, pReplyText))
					return;
				break;

			case STATE_CWD:
			{
				getImp().ParseNodeURL(OWN_URL(xTargetNode.Is() ?
											      &xTargetNode :
											      &xTargetPointer),
									  aNodeURL, &m_aPath, &aName,
									  xTargetNode.Is() && !m_bCWDFullPath);
				String const & rNewPath
					= m_aPath.Len() == 0 ? aName : m_aPath;
				if (rNewPath == String(getImp().getConnection()->getCurDir()))
				{
					if (m_aPath.Len() == 0)
						m_aPath = rNewPath;
					m_nState = STATE_SPLIT_CWD;
					break;
				}

				m_nState = STATE_CWD_DONE;
				if (!connectionSetCurDir(rNewPath)
					&& error(ERRCODE_CHAOS_FTP_GENERAL_FAILURE))
					break;
				return;
			}

			case STATE_CWD_DONE:
				if (nReplyCode / 100 == 2)
				{
					m_nState = STATE_PWD_DONE;
					if (!connectionGetCurDir()
						&& error(ERRCODE_CHAOS_FTP_GENERAL_FAILURE))
						break;
				}
				else if (error(nReplyCode, pReplyText))
					break;
				return;

			case STATE_PWD_DONE:
				if (nReplyCode / 100 == 2)
				{
					m_aPath = getImp().getConnection()->getCurDir();
					m_nState = STATE_SPLIT_CWD;
				}
				else if (!error(nReplyCode, pReplyText))
					return;
				break;

			case STATE_SPLIT_CWD:
			{
				bool bSplitCWD = !xTargetNode.Is() && !m_bCWDFullPath;
				if (xTargetNode.Is())
					xTargetPointer = xTargetNode;
				String
					aRealPath(getImp().MapToInternalPath(&getJob(), m_aPath));

				CntNode & rBoxNode = getImp().GetFTPBoxNode();
				String aURL(OWN_URL(&rBoxNode));
				if (aURL.GetChar(aURL.Len() - 1) != '/')
					aURL += '/';
				aURL += aRealPath.Copy(1);
				if (!m_bCWDFullPath)
					aURL += CntFTPURL::encodeFSegment(aName);
				if (!xTargetPointer->ISA(CntFTPDocNode)
					&& aURL.GetChar(aURL.Len() - 1) != '/')
					aURL += '/';
				xTargetNode = rBoxNode.Query(aURL);
				if (!xTargetNode.Is())
				{
					if (error(ERRCODE_CHAOS_FTP_GENERAL_FAILURE))
						cancel();
					return;
				}

				if (xTargetNode != xTargetPointer
					&& xTargetPointer->ISA(CntFTPRedirectNode))
				{
					getImp().GetFolderNodeData(PTR_CAST(CntFTPFolderNode,
														&xTargetNode));
					static_cast< CntFTPRedirectNode * >(&xTargetPointer)->
						SetTarget(&xTargetNode);
				}

				// There are situations where a FTPD says dir "/a/b/c" is a
				// link, but a "CWD /a/b/c" followed by "PWD" will again
				// return "/a/b/c"---a situation that confuses
				// ChaseRedirection():
				if (getJob().GetSubject() != &xTargetNode)
					getImp().ChaseRedirection(getJob().GetSubject(),
											  &xTargetNode, m_eLinkMode,
											  xTargetPointer, xTargetNode);
				if (!xTargetNode.Is())
				{
					if (error(ERRCODE_CHAOS_FTP_GENERAL_FAILURE))
						cancel();
					return;
				}

				getImp().ParseNodeURL(OWN_URL(&xTargetNode), aNodeURL,
									  &m_aPath, &aName, !m_bCWDFullPath);

				if (!bSplitCWD)
				{
					m_nState = STATE_TYPE;
					break;
				}

				m_nState = STATE_SPLIT_CWD_DONE;
				if (!connectionSetCurDir(m_aPath.Len() == 0 ? aName : m_aPath)
					&& error(ERRCODE_CHAOS_FTP_GENERAL_FAILURE))
					break;
				return;
			}

			case STATE_SPLIT_CWD_DONE:
				if (nReplyCode / 100 == 2)
					m_nState = STATE_TYPE;
				else if (!error(nReplyCode, pReplyText))
					return;
				break;

			case STATE_TYPE:
				if (m_eDataType == inet::INetFTPConnection::DATA_TYPE_UNKNOWN
					|| m_eDataType == getImp().getConnection()->getDataType())
				{
					m_nState = EXTRA_STATES;
					break;
				}

				m_nState = STATE_TYPE_DONE;
				if (!(m_eDataType
					          == inet::INetFTPConnection::DATA_TYPE_ASCII ?
					      connectionSetTypeAscii() : connectionSetTypeImage())
					&& error(ERRCODE_CHAOS_FTP_GENERAL_FAILURE))
					break;
				return;

			case STATE_TYPE_DONE:
				if (nReplyCode / 100 == 2
					|| nReplyCode == 504
					   && m_eDataType
					          == inet::INetFTPConnection::DATA_TYPE_ASCII)
					m_nState = EXTRA_STATES;
				else if (!error(nReplyCode, pReplyText))
					return;
				break;

			case STATE_CLOSE:
				m_nState = STATE_CLOSE_DONE;
				if (!connectionClose())
					if (m_bToClose)
					{
						getImp().abortConnection(false);
						cancel();
					}
					else if (error(ERRCODE_CHAOS_FTP_GENERAL_FAILURE))
						break;
				return;

			case STATE_CLOSE_DONE:
				if (m_bToClose)
				{
					getImp().abortConnection(false);
					m_nState = EXTRA_STATES;
				}
				else if (nReplyCode / 100 == 2)
				{
					getImp().abortConnection(false);
					m_nState = STATE_OPEN;
				}
				else if (!error(nReplyCode, pReplyText))
					return;
				break;

			default: // EXTRA_STATES
				handleCallback(nReplyCode, pReplyText);
				return;
		}
}

//============================================================================
bool CntFTPTask::activateTransferCallback()
{
	return getImp().getConnection()->setTransferCallback(transferCallback,
														 this)
		       != false;
}

//============================================================================
CntFTPTask::CntFTPTask(CntNodeJob & rJob, CntFTPImp & rTheImp,
					   CntFTPImp::LinkMode eTheLinkMode, bool bTheCWDFullPath,
					   inet::INetFTPConnection::DataType eTheDataType,
					   bool bTheToClose):
	ThreadTask(rJob, rTheImp.GetFTPBoxNode()),
	m_rImp(rTheImp),
	m_eLinkMode(eTheLinkMode),
	m_bCWDFullPath(bTheCWDFullPath),
	m_eDataType(eTheDataType),
	m_bToClose(bTheToClose),
	m_nCommandID(0),
	m_eCallbackState(CALLBACK_IDLE),
	m_bStatusText(false),
	m_bConnectionAcquired(false),
	bConnModeDetermined(false),
	m_nState(STATE_INITIALIZE)
{}

//============================================================================
String CntFTPTask::getFullPath()
{
	String aFullPath(m_aPath);
	if (aName.Len() > 0)
	{
		if (aFullPath.Len() > 0)
			aFullPath += '/';
		aFullPath += aName;
	}
	return aFullPath;
}

//============================================================================
// virtual
bool CntFTPTask::initialize()
{
	return true;
}

//============================================================================
// virtual
void CntFTPTask::handleCallback(sal_Int32, sal_Char const *)
{}

//============================================================================
// virtual
void CntFTPTask::handleTransferCallback()
{}

//============================================================================
// virtual
void CntFTPTask::handleReschedule()
{}

//============================================================================
// virtual
void CntFTPTask::handleCancel()
{}

//============================================================================
bool CntFTPTask::error(ErrCode nError, String const * pText, void * pData)
{
	switch (handleError(nError, pText, pData))
	{
		case RESPONSE_ABORT:
			cancel();
		case RESPONSE_CANCELED:
			return false;
	}
	switch (ErrorInfo::GetErrorInfo(nError)->GetErrorCode())
	{
		case ERRCODE_CHAOS_FTP_GENERAL_FAILURE:
		case ERRCODE_CHAOS_FTP_NETWORKERROR:
		case ERRCODE_CHAOS_FTP_RESOLVERERROR:
		case ERRCODE_CHAOS_FTP_PROXY:
			cancel();
			return false;
	}
	clearStatusText();
	m_nState = STATE_OPEN;
	return true;
}

//============================================================================
bool CntFTPTask::error(sal_Int32 nReplyCode, sal_Char const * pReplyText)
{
	switch (nReplyCode)
	{
		case inet::INetFTPConnection::REPLY_NETWORK_ERROR:
			return error(ERRCODE_CHAOS_FTP_NETWORKERROR);

		case inet::INetFTPConnection::REPLY_RESOLVER_ERROR:
			return error(ERRCODE_CHAOS_FTP_RESOLVERERROR);

		case inet::INetFTPConnection::REPLY_CONNECT_ERROR:
			return error(*new TwoStringErrorInfo(
				                  ERRCODE_CHAOS_SERVER_CONNECT_FAILURE,
								  String::CreateFromAscii(
									  RTL_CONSTASCII_STRINGPARAM("FTP")),
								  getImp().GetServerNameAndPort()));

        // Requested action not taken. File unavailable (e.g., file not
        // found, no access).
        case 550:
            return error(ERRCODE_IO_NOTEXISTS);

		default:
		{
			String aErrorText;
			if (pReplyText)
			{
				aErrorText = String(pReplyText, RTL_TEXTENCODING_ISO_8859_1);
				xub_StrLen nLen = aErrorText.Len();
				while (nLen > 0
					   && (INetMIME::isControl(aErrorText.GetChar(nLen - 1))
						   || aErrorText.GetChar(nLen - 1) == ' '))
					--nLen;
				if (nLen > 0
					&& (aErrorText.GetChar(nLen - 1) == '.'
						|| aErrorText.GetChar(nLen - 1) == '?'
						|| aErrorText.GetChar(nLen - 1) == '!'))
					--nLen;
				aErrorText.Erase(nLen);
			}
			return error(*new StringErrorInfo(ERRCODE_CHAOS_SERVER_ERROR,
											  aErrorText.Len() == 0 ?
											      String::CreateFromInt32(
													  nReplyCode) :
											      aErrorText));
		}
	}
}

//============================================================================
// virtual
void CntFTPTask::done()
{
	if (m_bConnectionAcquired)
	{
		getImp().clearTransferCallback();
		getImp().releaseConnection();
		m_bConnectionAcquired = false;
	}
	ThreadTask::done();
}

//============================================================================
bool CntFTPTask::connectionLoginUsername(String const & rUsername)
{
	if (sleep())
	{
		sal_uInt32 nID = startCommand(false);
		bool bSuccess = getImp().getConnection()->loginUsername(rUsername,
																callback,
																this)
			                != false;
		if (!wakeUp())
			getImp().abortConnection(false);
		else if (!bSuccess && !wasCalledBack(nID))
		{
			commandFailed();
			return false;
		}
	}
	return true;
}

//============================================================================
bool CntFTPTask::connectionLoginPassword(String const & rPassword)
{
	if (sleep())
	{
		sal_uInt32 nID = startCommand(false);
		bool bSuccess = getImp().getConnection()->loginPassword(rPassword,
																callback,
																this)
			                != false;
		if (!wakeUp())
			getImp().abortConnection(false);
		else if (!bSuccess && !wasCalledBack(nID))
		{
			commandFailed();
			return false;
		}
	}
	return true;
}

//============================================================================
bool CntFTPTask::connectionLoginAccount(String const & rAccount)
{
	if (sleep())
	{
		sal_uInt32 nID = startCommand(false);
		bool bSuccess = getImp().getConnection()->loginAccount(rAccount,
															   callback, this)
			                != false;
		if (!wakeUp())
			getImp().abortConnection(false);
		else if (!bSuccess && !wasCalledBack(nID))
		{
			commandFailed();
			return false;
		}
	}
	return true;
}

//============================================================================
bool CntFTPTask::connectionClose()
{
	if (sleep())
	{
		sal_uInt32 nID = startCommand(false);
		bool bSuccess = getImp().getConnection()->close(callback, this)
			                != false;
		if (!wakeUp())
			getImp().abortConnection(false);
		else if (!bSuccess && !wasCalledBack(nID))
		{
			commandFailed();
			return false;
		}
	}
	return true;
}

//============================================================================
bool CntFTPTask::connectionNoop()
{
	if (sleep())
	{
		sal_uInt32 nID = startCommand(false);
		bool bSuccess = getImp().getConnection()->noop(callback, this)
			                != false;
		if (!wakeUp())
			getImp().abortConnection(false);
		else if (!bSuccess && !wasCalledBack(nID))
		{
			commandFailed();
			return false;
		}
	}
	return true;
}

//============================================================================
bool CntFTPTask::connectionSetCurDir(String const & rPathname)
{
	if (sleep())
	{
		sal_uInt32 nID = startCommand(false);
		bool bSuccess = getImp().getConnection()->setCurDir(rPathname,
															callback, this)
			                != false;
		if (!wakeUp())
			getImp().abortConnection(false);
		else if (!bSuccess && !wasCalledBack(nID))
		{
			commandFailed();
			return false;
		}
	}
	return true;
}

//============================================================================
bool CntFTPTask::connectionGetCurDir()
{
	if (sleep())
	{
		sal_uInt32 nID = startCommand(false);
		bool bSuccess = getImp().getConnection()->getCurDir(callback, this)
			                != false;
		if (!wakeUp())
			getImp().abortConnection(false);
		else if (!bSuccess && !wasCalledBack(nID))
		{
			commandFailed();
			return false;
		}
	}
	return true;
}

//============================================================================
bool CntFTPTask::connectionMakeDir(String const & rPathname)
{
	if (sleep())
	{
		sal_uInt32 nID = startCommand(false);
		bool bSuccess = getImp().getConnection()->makeDir(rPathname, callback,
														  this)
			                != false;
		if (!wakeUp())
			getImp().abortConnection(false);
		else if (!bSuccess && !wasCalledBack(nID))
		{
			commandFailed();
			return false;
		}
	}
	return true;
}

//============================================================================
bool CntFTPTask::connectionRemoveDir(String const & rPathname)
{
	if (sleep())
	{
		sal_uInt32 nID = startCommand(false);
		bool bSuccess = getImp().getConnection()->removeDir(rPathname,
															callback, this)
			                != false;
		if (!wakeUp())
			getImp().abortConnection(false);
		else if (!bSuccess && !wasCalledBack(nID))
		{
			commandFailed();
			return false;
		}
	}
	return true;
}

//============================================================================
bool CntFTPTask::connectionRemove(String const & rPathname)
{
	if (sleep())
	{
		sal_uInt32 nID = startCommand(false);
		bool bSuccess = getImp().getConnection()->remove(rPathname, callback,
														 this)
			                != false;
		if (!wakeUp())
			getImp().abortConnection(false);
		else if (!bSuccess && !wasCalledBack(nID))
		{
			commandFailed();
			return false;
		}
	}
	return true;
}

//============================================================================
bool CntFTPTask::connectionRenameFrom(String const & rFromPath)
{
	if (sleep())
	{
		sal_uInt32 nID = startCommand(false);
		bool bSuccess = getImp().getConnection()->renameFrom(rFromPath,
															 callback, this)
			                != false;
		if (!wakeUp())
			getImp().abortConnection(false);
		else if (!bSuccess && !wasCalledBack(nID))
		{
			commandFailed();
			return false;
		}
	}
	return true;
}

//============================================================================
bool CntFTPTask::connectionRenameTo(String const & rToPath)
{
	if (sleep())
	{
		sal_uInt32 nID = startCommand(false);
		bool bSuccess = getImp().getConnection()->renameTo(rToPath, callback,
														   this)
			                != false;
		if (!wakeUp())
			getImp().abortConnection(false);
		else if (!bSuccess && !wasCalledBack(nID))
		{
			commandFailed();
			return false;
		}
	}
	return true;
}

//============================================================================
bool CntFTPTask::connectionSetTypeAscii()
{
	if (sleep())
	{
		sal_uInt32 nID = startCommand(false);
		bool bSuccess = getImp().getConnection()->setTypeAscii(callback, this)
			                != false;
		if (!wakeUp())
			getImp().abortConnection(false);
		else if (!bSuccess && !wasCalledBack(nID))
		{
			commandFailed();
			return false;
		}
	}
	return true;
}

//============================================================================
bool CntFTPTask::connectionSetTypeImage()
{
	if (sleep())
	{
		sal_uInt32 nID = startCommand(false);
		bool bSuccess = getImp().getConnection()->setTypeImage(callback, this)
			                != false;
		if (!wakeUp())
			getImp().abortConnection(false);
		else if (!bSuccess && !wasCalledBack(nID))
		{
			commandFailed();
			return false;
		}
	}
	return true;
}

//============================================================================
bool CntFTPTask::connectionGetNameList(String const & rPathname,
									   List & rNameList)
{
	if (!activateTransferCallback())
		return false;
	if (sleep())
	{
		sal_uInt32 nID = startCommand(true);
		bool bSuccess = getImp().getConnection()->getNameList(rPathname,
															  rNameList,
															  callback, this)
			                != false;
		if (!wakeUp())
			getImp().abortConnection(true);
		else if (!bSuccess && !wasCalledBack(nID))
		{
			commandFailed();
			return false;
		}
	}
	return true;
}

//============================================================================
bool CntFTPTask::connectionRetrieve(String const & rFromPath,
									SvOpenLockBytes * pToPath,
									sal_uInt32 nRestartOffset)
{
	if (!activateTransferCallback())
		return false;
	if (sleep())
	{
		sal_uInt32 nID = startCommand(true);
		bool bSuccess = getImp().getConnection()->retrieve(rFromPath, pToPath,
														   nRestartOffset,
														   callback, this)
			                != false;
		if (!wakeUp())
			getImp().abortConnection(true);
		else if (!bSuccess && !wasCalledBack(nID))
		{
			commandFailed();
			return false;
		}
	}
	return true;
}

//============================================================================
bool CntFTPTask::connectionStore(SvLockBytes * pFromPath,
								 String const & rToPath,
								 sal_uInt32 nRestartOffset)
{
	if (!activateTransferCallback())
		return false;
	if (sleep())
	{
		sal_uInt32 nID = startCommand(true);
		bool bSuccess = getImp().getConnection()->store(pFromPath, rToPath,
														nRestartOffset,
														callback, this)
			                != false;
		if (!wakeUp())
			getImp().abortConnection(true);
		else if (!bSuccess && !wasCalledBack(nID))
		{
			commandFailed();
			return false;
		}
	}
	return true;
}

//============================================================================
//
//  CntFTPCloseConnectionTask
//
//============================================================================

// virtual
bool CntFTPCloseConnectionTask::initialize()
{
	if (ITEM_VALUE(CntConnModeItem, *getJob().GetRequest())
		    != CNT_CONN_MODE_OFFLINE)
		return false;
	bConnModeDetermined = true;
	eConnMode = CNT_CONN_MODE_ONLINE;
	return true;
}

//============================================================================
// virtual
void CntFTPCloseConnectionTask::handleCallback(sal_Int32, sal_Char const *)
{
	done();
}

