/*************************************************************************
 *
 *  $RCSfile: cntinet.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: mhu $ $Date: 2001/07/24 17:37:02 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define _CNTINET_CXX "$Revision: 1.3 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _TOOLS_INETDEF_HXX
#include <tools/inetdef.hxx>
#endif
#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif

#ifndef _INET_WRAPPER_HXX
#include <inet/wrapper.hxx>
#endif
#ifndef _INET_CONFIG_HXX
#include <inet/inetcfg.hxx>
#endif

#ifndef _CNTINET_HXX
#include <cntinet.hxx>
#endif
#ifndef _CNTRNMGR_HXX
#include <cntrnmgr.hxx>
#endif

#ifndef _CHAOS_INIMGR_HXX
#include <inimgr.hxx>
#endif

using namespace chaos;

#ifdef _USE_NAMESPACE
using namespace inet;
#endif

/*========================================================================
 *
 * CntINetConfig internals.
 *
 *======================================================================*/
inline UniString S2U (const sal_Char *pszAscii)
{
	return UniString::CreateFromAscii (pszAscii);
}

/*========================================================================
 *
 * CntINetConfig implementation.
 *
 *======================================================================*/
/*
 * load.
 */
void CntINetConfig::load (
	INetWrapper   *pWrapper,
	CntIniManager *pIniMgr)
{
	// Check context.
	if (pWrapper == NULL)
	{
		if (!CNT_RNM()->getINetWrapper (pWrapper))
		{
			DBG_ERRORFILE ("load: GetINetWrapper() failed");
			return;
		}
	}

	if (pIniMgr == NULL)
	{
		pIniMgr = CNT_RNM()->GetIniManager();
		DBG_ASSERT (pIniMgr, "load: GetIniManager() failed");
		if (pIniMgr == NULL)
			return;
	}

	// Obtain global INetConfig.
	NAMESPACE_VOS(ORef)<INetConfig> xConfig;
	if (!pWrapper->getINetConfig (xConfig))
	{
		DBG_ERRORFILE ("load: getINetConfig() failed");
		return;
	}

	// Setup ProxyConfig.
	INetProxyConfig aProxyCfg (xConfig->getProxyConfig());

	sal_Int32 bUseProxy =
		(pIniMgr->getEntry(CNT_KEY_INET_PROXYTYPE)).ToInt32();
	if (bUseProxy > 0)
		aProxyCfg.setNoProxyList (pIniMgr->getEntry(CNT_KEY_INET_NOPROXY));
	else
		aProxyCfg.setNoProxyList (S2U ("*:*"));

	aProxyCfg.setHttpProxy (
		pIniMgr->getEntry (CNT_KEY_INET_HTTPPROXYNAME),
		(pIniMgr->getEntry(CNT_KEY_INET_HTTPPROXYPORT)).ToInt32());

	aProxyCfg.setFtpProxy (
		pIniMgr->getEntry (CNT_KEY_INET_FTPPROXYNAME),
		(pIniMgr->getEntry(CNT_KEY_INET_FTPPROXYPORT)).ToInt32());

	aProxyCfg.setSecureSocketProxy (
		pIniMgr->getEntry (CNT_KEY_INET_SECURITYPROXYNAME),
		(pIniMgr->getEntry(CNT_KEY_INET_SECURITYPROXYPORT)).ToInt32());

	aProxyCfg.setSocksProxy (
		pIniMgr->getEntry (CNT_KEY_INET_SOCKSPROXYNAME),
		(pIniMgr->getEntry(CNT_KEY_INET_SOCKSPROXYPORT)).ToInt32());

	xConfig->setProxyConfig (aProxyCfg);

	// Setup additional configuration.
	xConfig->setDomainNameServer (pIniMgr->getEntry (CNT_KEY_INET_DNS));

	xConfig->setUserAgent (S2U (INET_DEF_CALLERNAME));

#ifdef SOLAR_SSL
	// Setup SSL configuration.
	xConfig->setSecureSocketCertificatePath (
		pIniMgr->getEntry (CNT_KEY_CONFIG_DIR));

	xConfig->setSecureSocketCipherLevel (
		(pIniMgr->getEntry(CNT_KEY_INET_SSL)).ToInt32());
#endif /* SOLAR_SSL */
}

/*
 * shouldUseProxy.
 */
sal_Bool CntINetConfig::shouldUseProxy (
	INetWrapper     *pWrapper,
	const String    &rUrl,
	INetProxyConfig &rProxyCfg)
{
	// Check context.
	if (pWrapper == NULL)
	{
		if (!CNT_RNM()->getINetWrapper (pWrapper))
		{
			DBG_ERRORFILE ("shouldUseProxy: GetINetWrapper() failed");
			return sal_False;
		}
	}

	// Obtain global INetConfig.
	NAMESPACE_VOS(ORef)<INetConfig> xConfig;
	if (!pWrapper->getINetConfig (xConfig))
	{
		DBG_ERRORFILE ("shouldUseProxy: getINetConfig() failed");
		return sal_False;
	}

	// Obtain ProxyPolicy.
	NAMESPACE_VOS(ORef)<INetProxyPolicy>
		xProxyPolicy (xConfig->getProxyPolicy());
	if (!xProxyPolicy.isValid())
		return sal_False;

	// Query ProxyPolicy for applicable ProxyConfig.
	return xProxyPolicy->shouldUseProxy (rUrl, rProxyCfg);
}

