/*************************************************************************
 *
 *  $RCSfile: cntout.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: mhu $ $Date: 2001/07/24 17:42:39 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define _CNTOUT_CXX "$Revision: 1.3 $"

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif
#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#ifndef _SVTOOLS_CTYPEITM_HXX
#include <svtools/ctypeitm.hxx>
#endif

#ifndef _CNTOUT_HXX
#include <cntout.hxx>
#endif
#ifndef _CNTOUTIMP_HXX
#include <coutimp.hxx>
#endif

#ifndef _CNTDEFS_HXX
#include <cntdefs.hxx>
#endif
#ifndef _CNTAPI_HXX
#include <cntapi.hxx>
#endif

#ifndef _CNTVWITM_HXX
#define ITEMID_CNT_VIEW_DESCRIPTION WID_VIEW_DESCRIPTION
#include <cntvwitm.hxx>
#endif

#ifndef _CNTRNMGR_HXX
#include <cntrnmgr.hxx>
#endif
#ifndef _CNTOUT_HXX
#include <cntstgnd.hxx>
#endif
#ifndef _CNTMSGND_HXX
#include <cntmsgnd.hxx>
#endif
#ifndef _CNTMBITM_HXX
#include <cntmbitm.hxx>
#endif

#ifndef _CNTCMITM_HXX
#include <cntcmitm.hxx>
#endif
#ifndef _CNTSDITM_HXX
#include <cntsditm.hxx>
#endif
#ifndef _ILSTITEM_HXX
#include <ilstitem.hxx>
#endif
#ifndef _LAYITEM_HXX
#include <layitem.hxx>
#endif
#ifndef _RCPNITEM_HXX
#include <rcpnitem.hxx>
#endif
#ifndef _SORTITEM_HXX
#include <sortitem.hxx>
#endif
#ifndef _THRDITEM_HXX
#include <thrditem.hxx>
#endif
#ifndef _ULSTITEM_HXX
#include <ulstitem.hxx>
#endif

#ifndef _CHAOS_INIMGR_HXX
#include <inimgr.hxx>
#endif
#ifndef _CHAOS_SILITEM_HXX
#include <silitem.hxx>
#endif
#ifndef _CHAOS_STORITEM_HXX
#include <storitem.hxx>
#endif

#ifndef _CNTIDS_HRC
#include <cntids.hrc>
#endif
#ifndef _PROCHAOS_HRC
#include <prochaos.hrc>
#endif

using namespace chaos;

#ifdef _CHAOS_STORITEM_REF
SV_IMPL_REF(CntStoreItemSet);
#endif

#ifndef WID_BOXALL_END2
#define WID_BOXALL_END2 WID_PROPERTYLIST
#endif

/*========================================================================
 *
 * CntOutMessageNode interface.
 *
 *======================================================================*/
class CntOutMessageNode : public CntMessageNode
{
	/** Implementation.
	*/
	void GetData_Impl (CntStorageNode *pCache);
	void SetState_Impl (BOOL bLocked);

	/** Not implemented.
	*/
	COPYCTOR_API (CntOutMessageNode);

public:
	TYPEINFO();
	CNT_NODE_SUBCLASS_DECL();

	CntOutMessageNode (const USHORT *pRanges = NULL);
	virtual ~CntOutMessageNode (void);

	virtual CntNode* Initialize (
		CntNode *pParent, const String &rNodeURL);

	virtual const SfxPoolItem* InsertJob (CntNodeJob *pJob);

	virtual const SfxPoolItem* Put (
		const SfxPoolItem &rProp, USHORT nWhich);

	virtual FASTBOOL IsItemFlag (
		USHORT nWhich, USHORT nFlag) const;
};

/*========================================================================
 *
 * CntOutTrayNode internals.
 *
 *======================================================================*/
/*
 * Ranges.
 */
static USHORT __READONLY_DATA aOutTrayRanges_Impl[] =
{
	WID_REPLY_TO,             WID_REPLY_TO,
	WID_FROM,                 WID_TITLE,
	WID_ALL_START,            WID_COPY,
	WID_RENAME,               WID_VIEW_DESCRIPTION,
	WID_CREATE_NEW,           WID_FLD_COLUMN_INFO,
	WID_SENTMESSAGEVIEW_MODE, WID_SUBSCRNEWSGROUPCOUNT,
	WID_FLAG_SUPPORTMODE,     WID_PREPARE_MOVE,
	WID_MAILSEND_USERNAME,    WID_NEWSSEND_SERVERNAME,
	WID_SMTP_GATEWAY,         WID_REPLY_TO_DEFAULT,
	WID_UPDATE_ENABLED,       WID_CONNECTION_MODE,
	WID_OUTMSGEXTERNALSTATE,  WID_BOXEXT_END,
	WID_MSG_COLUMN_WIDTHS,    WID_PURGE,
	WID_SEARCH,               WID_BOXALL_END2,
	WID_VIEWDATA,             WID_VIEWDATA,
	WID_EXPORT,               WID_EXPORT,
	WID_VIEW_START,           WID_VIEW_END,
	WID_VIEW2_START,          WID_VIEW2_END,
	WID_FOLDER_START2,        WID_FOLDER_END2,
	WID_VIEW3_START,          WID_VIEW3_END,
	WID_SEND_FORMATS,		  WID_SEND_COPY_TARGET,
	0
};

/*========================================================================
 *
 * CntOutTrayNode implementation.
 *
 *======================================================================*/
/*
 * CntOutTrayNode.
 */
TYPEINIT1_AUTOFACTORY (CntOutTrayNode, CntNode);

CntOutTrayNode::CntOutTrayNode (void)
	: CntNode (aOutTrayRanges_Impl),
	  m_pImpl (NULL)
{
	// class CntOutTrayNode defaults.
	CntDefaults *pClassDefs = GetDefaults();
	if (pClassDefs == NULL)
	{
		// Create new class defaults.
	 	pClassDefs = new CntDefaults (*this, aOutTrayRanges_Impl);

		// Set ContentType.
		pClassDefs->Put (CntContentTypeItem (
			WID_CONTENT_TYPE, CONTENT_TYPE_X_CNT_OUTBOX));

		// Set Explorer/Browser relevant items.
		pClassDefs->Put (CntBoolItem (WID_FLAG_IS_FOLDER, TRUE));
		pClassDefs->Put (CntBoolItem (WID_FLAG_HAS_MESSAGES, TRUE));

		pClassDefs->Put(CntUShortListItem (
			WID_RENAME, WID_TITLE, 0));

		CntViewColumnsListItem aColumnDefs (
			WID_VIEW_COLS_BEAMER,
			WID_RECIPIENTLIST, DEF_WIDTH_RECIPIENTLIST,
			WID_TITLE,         DEF_WIDTH_TITLE_MAIL,
			WID_DATE_CREATED,  DEF_WIDTH_DATE_CREATED,
			WID_IS_MARKED,     DEF_WIDTH_IS_MARKED,
			0);

		pClassDefs->Put (aColumnDefs );
		pClassDefs->Put (aColumnDefs, WID_VIEW_COLS_FILEDLG);
		pClassDefs->Put (aColumnDefs, WID_VIEW_COLS_FLDWIN);

		// Set property tab pages wanted.
		pClassDefs->Put (CntIdentifierListItem (
			WID_PROPERTYLIST,
			CNT_TABPAGE_GENERAL,
			CNT_TABPAGE_SEND_SMTP,
			CNT_TABPAGE_SEND_NNTP,
			CNT_TABPAGE_SEND_VIM,
			CNT_TABPAGE_RULES,
			CNT_TABPAGE_VIEW_PROPERTIES,
			CNT_TABPAGE_HEADER,
			CNT_TABPAGE_BACKGROUND,
			CNT_TABPAGE_FONT,
			0));

		// Set threading item.
		CntThreadingItem aThrItem (WID_THREADING);
		aThrItem.Append (CntThreadingInfo (
			CNT_THREADING_BY_PROPVALUE, WID_TITLE, WID_TITLE));
		pClassDefs->Put (aThrItem);

		// Set LayoutItem.
		CntLayoutItem aLayoutItem (
			WID_VIEW_LAYOUT_FLDWIN, LAYOUT_MAILNEWS);
		pClassDefs->Put (aLayoutItem);

		// Set sorting item.
		CntSortingItem aSortingDefs (WID_SORTING);
		aSortingDefs.Append (CntSortingInfo (WID_DATE_CREATED, FALSE));
		aSortingDefs.Append (CntSortingInfo (WID_TITLE, TRUE));

		pClassDefs->Put (aSortingDefs);
		pClassDefs->Put (aSortingDefs, WID_VIEW_SORT_BEAMER);
		pClassDefs->Put (aSortingDefs, WID_VIEW_SORT_FILEDLG);
		pClassDefs->Put (aSortingDefs, WID_VIEW_SORT_FLDWIN_DETAILS);
		pClassDefs->Put (aSortingDefs, WID_VIEW_SORT_FLDWIN_ICON);

		// Store class defaults.
		SetDefaults (pClassDefs);
	}
	CntInterface::SetParent (pClassDefs);

	// Set current default server into class defaults.
	CntIniManager *pIniMgr = CNT_RNM()->GetIniManager();
	if (pIniMgr)
	{
		CntSendInfoListItem aSendInfoList (WID_SEND_SERVERNAME);

		aSendInfoList[CNT_OUTMSG_PROTOCOL_SMTP]
		 = pIniMgr->getEntry (CNT_KEY_INET_SMTPSERVER);

		aSendInfoList[CNT_OUTMSG_PROTOCOL_NNTP]
		 = pIniMgr->getEntry (CNT_KEY_INET_NNTPSERVER);

		pClassDefs->Put (aSendInfoList);
	}

	// Create implementation instance.
	m_pImpl = new CntOutTrayNode_Impl (this);
}

/*
 * ~CntOutTrayNode.
 */
CntOutTrayNode::~CntOutTrayNode()
{
	delete m_pImpl;
}

/*
 * Register.
 */
CNT_NODE_SUBCLASS_IMPL (CntOutTrayNode)
{
	// Register ourself at root node manager.
	CntNodeFactory *pFac = new CntNodeFactory (
		S2U ("out:///~*"), UniString (sal_Unicode('/')),
		StaticType(), CONTENT_TYPE_X_CNT_OUTBOX,
		CNT_CREATION_FLAG_PROPERTIES | CNT_CREATION_FLAG_KIND_FOLDER,
		HID_CHAOS_NEW_OUT_BOX);
	CntRootNodeMgr::InsertFactory (pFac);

	// Register possible children.
	pFac = new CntNodeFactory (
		S2U ("/*"), UniString(),
		TYPE (CntOutMessageNode), CONTENT_TYPE_X_CNT_MESSAGE,
		CNT_CREATION_FLAG_MESSAGEDOC | CNT_CREATION_FLAG_KIND_DOCUMENT,
		HID_CHAOS_NEW_OUT_BOX);
	InsertFactory (pFac);
}

/*
 * InsertJob.
 */
const SfxPoolItem* CntOutTrayNode::InsertJob (CntNodeJob* pJob)
{
	// Check request.
	const SfxPoolItem *pReq = pJob->GetRequest();
	if (pReq->Which() == WID_OPEN)
	{
		// Check subject.
		CntNode *pSubject = pJob->GetSubject();
		if (pSubject->ISA(CntOutMessageNode))
		{
			if (m_pImpl->Initialize(pJob))
			{
				// Check message body.
				CntStorageNode *pCache = pJob->GetCacheNode();

				String aUrl (OWN_URL (pSubject));
				aUrl.AppendAscii (".body");

				UINT32 nAttrib = 0;
				pCache->attrib (aUrl, 0, 0, nAttrib);
				if (nAttrib & CNTDIRENTRY_ATTRIB_HIDDEN)
				{
					// Immediate execution.
					CntMessageBodyItem aItem (WID_MESSAGEBODY, aUrl);
					if (aItem.Get (pCache, m_pImpl->GetMailer()))
					{
						// Load message body.
						pSubject->Put (aItem);

						// Done.
						pJob->Done();
						return NULL;
					}
				}
			}

			// Not available.
			pJob->Cancel();
			return NULL;
		}
	}

	// Forward to base class.
	return CntNode::InsertJob (pJob);
}

/*
 * ExecuteJob.
 */
const SfxPoolItem* CntOutTrayNode::ExecuteJob (CntNodeJob* pJob)
{
	// Check RequestData.
	CntOutJob_Impl *pJobImpl = (CntOutJob_Impl *)(pJob->GetRequestData());
	if (pJobImpl)
	{
		// Execute rescheduled CntOutJob_Impl.
		return pJobImpl->Execute();
	}

	// Check Subject.
	CntNode *pSubject = pJob->GetSubject();
	if (pSubject == this)
	{
		// Job for ourselfs.
		const SfxPoolItem *pReq = pJob->GetRequest();
		switch (pReq->Which())
		{
			case WID_CREATE_NEW:
				if (pJob->GetClient())
				{
					// Create empty message node.
					CntNodeItem *pNodeItem =
						(CntNodeItem *)(CntNode::ExecuteJob (pJob));
					if (pNodeItem == NULL)
						return NULL;

					CntNode *pNode = pNodeItem->GetValue();
					if (pNode == NULL)
						return pNodeItem;

					// Obtain client.
					CntInterface *pClient = pJob->GetClient();
					if (pClient == NULL)
						return pNodeItem;

					// Feed node with client defaults.
					String aSender (CntOutMessage_Impl::querySendInfo (
						*pClient, WID_SEND_FROM_DEFAULT));
					if (aSender.Len())
						pNode->Put (CntNameItem (WID_FROM, aSender));

					String aReply (CntOutMessage_Impl::querySendInfo (
						*pClient, WID_SEND_REPLY_TO_DEFAULT));
					if (aReply.Len())
						pNode->Put (CntStringItem (WID_REPLY_TO, aReply));

					// Done.
					return pNodeItem;
				}
				break;

			case WID_GETDATA:
				if (!m_pImpl->IsInitialized())
				{
					// Restore box itemset.
					CntStoreItemSetRef xBoxSet (
						m_pImpl->GetBoxItemSet (pJob->GetCacheNode()));
					if (xBoxSet.Is())
						Put (*xBoxSet);
				}
				break;

			case WID_CONNECTION_MODE:
				if (m_pImpl->Initialize(pJob))
				{
					// Set connection mode.
					CntConnMode eConnMode =
						(CntConnMode)(ITEM_VALUE(CntConnModeItem, *pReq));
					m_pImpl->SetConnMode (eConnMode);

					// Done.
					pJob->Done();
					return NULL;
				}
				break;

			case WID_SEARCH:
				if (m_pImpl->Initialize(pJob))
				{
					const CntSearchData &rData =
						ITEM_VALUE (CntSearchDataItem, *pReq);
					if (rData.DoSearchFirstLevel())
					{
						// Setup.
						pJobImpl = new CntOutBoxOpenJob_Impl (pJob, m_pImpl);
						pJob->SetRequestData (pJobImpl);

						// Execute.
						return pJobImpl->Execute();
					}
					else
					{
						// Not supported.
						pJob->Cancel();
						return NULL;
					}
				}
				break;

			case WID_OPEN:
				if (m_pImpl->Initialize(pJob))
				{
					// Setup.
					pJobImpl = new CntOutBoxOpenJob_Impl (pJob, m_pImpl);
					pJob->SetRequestData (pJobImpl);

					// Execute.
					return pJobImpl->Execute();
				}
				break;

			case WID_UPDATE:
				if (m_pImpl->Initialize(pJob))
				{
					// Setup.
					pJobImpl = new CntOutBoxSendJob_Impl (pJob, m_pImpl);
					pJob->SetRequestData (pJobImpl);

					// Execute.
					return pJobImpl->Execute();
				}
				break;

			case WID_IMPORT:
				if (m_pImpl->Initialize(pJob))
				{
					// Setup.
					pJobImpl = new CntOutBoxImportJob_Impl (pJob, m_pImpl);
					pJob->SetRequestData (pJobImpl);

					// Execute.
					return pJobImpl->Execute();
				}
				break;

			case WID_EXPORT:
				if (m_pImpl->Initialize(pJob))
				{
					// Setup.
					pJobImpl = new CntOutBoxExportJob_Impl (pJob, m_pImpl);
					pJob->SetRequestData (pJobImpl);

					// Execute.
					return pJobImpl->Execute();
				}
				break;

			default:
				break;
		}
		return CntNode::ExecuteJob (pJob);
	}
	else if (pSubject->ISA(CntOutMessageNode))
	{
		// Execute job on behalf of a CntOutMessageNode.
		const SfxPoolItem *pReq = pJob->GetRequest();
		switch (pReq->Which())
		{
			case WID_INSERT:
				if (m_pImpl->Initialize(pJob))
				{
					// Setup.
					pJobImpl = new CntOutMsgSendJob_Impl (pJob, m_pImpl);
					pJob->SetRequestData (pJobImpl);

					// Execute.
					return pJobImpl->Execute();
				}
				break;

			case WID_RESEND_MSG:
				if (m_pImpl->Initialize(pJob))
				{
					// Setup.
					pJobImpl = new CntOutMsgResendJob_Impl (pJob, m_pImpl);
					pJob->SetRequestData (pJobImpl);

					// Execute.
					return pJobImpl->Execute();
				}
				break;

			case WID_IS_MARKED:
				if (m_pImpl->Initialize(pJob))
				{
					// Setup.
					pJobImpl = new CntOutMsgMarkJob_Impl (pJob, m_pImpl);
					pJob->SetRequestData (pJobImpl);

					// Execute.
					return pJobImpl->Execute();
				}
				break;

			case WID_DELETE:
				if (m_pImpl->Initialize(pJob))
				{
					// Setup.
					pJobImpl = new CntOutMsgDeleteJob_Impl (pJob, m_pImpl);
					pJob->SetRequestData (pJobImpl);

					// Execute.
					return pJobImpl->Execute();
				}
				break;

			case WID_UNDELETE:
				if (m_pImpl->Initialize(pJob))
				{
					// Setup.
					pJobImpl = new CntOutMsgRestoreJob_Impl (pJob, m_pImpl);
					pJob->SetRequestData (pJobImpl);

					// Execute.
					return pJobImpl->Execute();
				}
				break;

			case WID_EXPORT:
				if (m_pImpl->Initialize(pJob))
				{
					// Setup.
					pJobImpl = new CntOutMsgExportJob_Impl (pJob, m_pImpl);
					pJob->SetRequestData (pJobImpl);

					// Execute.
					return pJobImpl->Execute();
				}
				break;

			case WID_TRANSFER_RESULT:
				if (m_pImpl->Initialize(pJob))
				{
					m_pImpl->setMessageCopyResult(*pJob);
					pJob->Done();
					return 0;
				}
				break;

			default:
				break;
		}
		return CntNode::ExecuteJob (pJob);
	}
	else
	{
		// Forward to base class.
		return CntNode::ExecuteJob (pJob);
	}
}

/*
 * Notify
 */
void CntOutTrayNode::Notify (SfxBroadcaster& rBC, const SfxHint& rHint)
{
	CntNode::Notify (rBC, rHint);
}

/*
 * SetConnMode.
 * (Called by CntRootNodeMgr after global mode change).
 */
void CntOutTrayNode::SetConnMode (CntConnMode eConnMode)
{
	m_pImpl->SetConnMode (eConnMode);
}

/*========================================================================
 *
 * CntOutMessageNode implementation.
 *
 *======================================================================*/
/*
 * CntStoreItemSet ranges.
 */
COUTMSG_DIR_RANGES_IMPL (aMsgDirRanges_Impl);

/*
 * CntNode ranges.
 */
static USHORT __READONLY_DATA aOutMsgRanges_Impl[] =
{
	WID_NEWS_XREF,         WID_NEWS_XREF,
	WID_MSG_START,         WID_ALL_END,
	WID_INSERT,            WID_INSERT,
	WID_USERNAME,          WID_SERVERBASE,
	WID_UNDELETE,          WID_REOPEN,
	WID_PROPERTYLIST,      WID_SEND_VIM_POPATH,
	WID_DOCUMENT_HEADER,   WID_DOCUMENT_SIZE,
	WID_ACCOUNT,           WID_ACCOUNT,
	WID_EXPORT,            WID_EXPORT,
	WID_ACTION_LIST,       WID_ACTION_LIST,
	WID_SEND_FORMATS,	   WID_TRANSFER_RESULT,
	0
};

/*
 * CntOutMessageNode.
 */
TYPEINIT1_AUTOFACTORY (CntOutMessageNode, CntMessageNode);

CntOutMessageNode::CntOutMessageNode (const USHORT *pRanges)
	: CntMessageNode (pRanges ? pRanges : aOutMsgRanges_Impl)
{
	// Obtain class defaults.
	CntDefaults *pClassDefs = GetDefaults();
	if (pClassDefs == NULL)
	{
		// Create defaults.
		pClassDefs = new CntDefaults (
			*this, aOutMsgRanges_Impl, CntMessageNode::GetDefaults());

        // Set defaults for a message.
		pClassDefs->Put (CntContentTypeItem (
			WID_CONTENT_TYPE, CONTENT_TYPE_X_CNT_MESSAGE));
		pClassDefs->Put (CntBoolItem (WID_FLAG_IS_MESSAGE, TRUE));
		pClassDefs->Put (CntBoolItem (WID_FLAG_READONLY, FALSE));

		// Disable unwanted items in [WID_MSG_START, WID_MSG_END].
		pClassDefs->DisableItem (WID_MAIL_REPLY);
		pClassDefs->DisableItem (WID_POST_REPLY);
		pClassDefs->DisableItem (WID_HIDE_THREAD);
		pClassDefs->DisableItem (WID_MARK_THREAD_READ);
		pClassDefs->DisableItem (WID_MARK_THREAD_UNREAD);

		// Disable unwanted items in [WID_ALL_START, WID_ALL_END].
		pClassDefs->DisableItem (WID_DEFAULT);
		pClassDefs->DisableItem (WID_RENAME);
		pClassDefs->DisableItem (WID_IS_READ);

		// Set property tabdialog pages.
		pClassDefs->Put (CntIdentifierListItem (
			WID_PROPERTYLIST,
			CNT_TABPAGE_GENERAL,
			CNT_TABPAGE_RECIPIENT_STATE,
			0));
	}
	CntInterface::SetParent (pClassDefs);
}

/*
 * ~CntOutMessageNode.
 */
CntOutMessageNode::~CntOutMessageNode (void)
{
}

/*
 * Register.
 */
CNT_NODE_SUBCLASS_IMPL (CntOutMessageNode)
{
	// Nothing to do.
}

/*
 * Initialize.
 */
CntNode* CntOutMessageNode::Initialize (
	CntNode *pParent, const String &rNodeURL)
{
	CntNode *pNode = CntMessageNode::Initialize (pParent, rNodeURL);
	if (pNode)
	{
		// Clear special items.
		ClearItem (WID_INTERIM_URL);
		ClearItem (WID_USERNAME);
		ClearItem (WID_PASSWORD);

		// Disable Resend (enabled at runtime).
		DisableItem (WID_RESEND_MSG);
	}
	return pNode;
}

/*
 * GetData_Impl.
 */
void CntOutMessageNode::GetData_Impl (CntStorageNode *pCache)
{
	if (pCache)
	{
		// Obtain message itemset.
		String aNodeURL (OWN_URL (this));
		aNodeURL.AppendAscii (".node");

		CntStoreItemSetRef xDirSet (pCache->openItemSet (
			aMsgDirRanges_Impl, aNodeURL, STREAM_STD_READ));
		if (xDirSet.Is())
		{
			// Load message itemset.
			CntInterface::Put (*xDirSet);
			xDirSet.Clear();
		}

		// Set Marked property.
		UINT32 nAttrib = 0;
		pCache->attrib (aNodeURL, 0, 0, nAttrib);
		if (nAttrib & CNTDIRENTRY_ATTRIB_MARKED)
		{
			CntBoolItem aMarked (WID_IS_MARKED, TRUE);
			CntInterface::Put (aMarked, aMarked.Which());
		}

		// Backward compatibility.
		const SfxPoolItem *pItem = NULL;
		GetItemState (WID_SIZE, FALSE, &pItem);
		if (pItem == NULL)
		{
			// Open message body.
			String aBodyURL (OWN_URL (this));
			aBodyURL.AppendAscii (".body");

			SvStream *pStrm = pCache->openStream (aBodyURL, STREAM_STD_READ);
			if (pStrm)
			{
				// Determine message size.
				ULONG nSize = pStrm->Seek (STREAM_SEEK_TO_END);
				delete pStrm;

				// Store message size.
				CntUInt32Item aSize (WID_SIZE, nSize);
				CntInterface::Put (aSize, aSize.Which());

				xDirSet = pCache->openItemSet (
					aMsgDirRanges_Impl,
					aNodeURL, STREAM_READWRITE | STREAM_NOCREATE);
				if (xDirSet.Is())
					xDirSet->Put (aSize, aSize.Which());
			}
		}
	}
}

/*
 * SetState_Impl.
 */
void CntOutMessageNode::SetState_Impl (BOOL bLocked)
{
	// Set locked property.
	SetIsLocked (bLocked);

	// Check for RecipientList item.
	const SfxPoolItem *pItem = NULL;
	GetItemState (WID_RECIPIENTLIST, FALSE, &pItem);
	if (pItem)
	{
		// Obtain RecipientList item.
		const CntRecipientListItem *pRcptList =
			(const CntRecipientListItem *)pItem;

		// Set readonly property.
		CntBoolItem aReadOnly (
			WID_FLAG_READONLY,
			bLocked || pRcptList->IsPartiallySent());
		CntInterface::Put (aReadOnly, aReadOnly.Which());

		// Check for Resend.
		if (!bLocked && pRcptList->IsCompletelyProcessed())
			ClearItem (WID_RESEND_MSG);
	}
}

/*
 * InsertJob.
 */
const SfxPoolItem* CntOutMessageNode::InsertJob (CntNodeJob *pJob)
{
	// Check request.
	const SfxPoolItem *pReq = pJob->GetRequest();
	switch (pReq->Which())
	{
		case WID_OPEN: // Load Property Job.
			if (pJob->GetCacheNode())
			{
				// Obtain message itemset.
				GetData_Impl (pJob->GetCacheNode());

				// Set message state.
				SetState_Impl (GetIsLocked());

				// Check for immediate execution.
				const CntMessageBodyItem *pItem = NULL;
				GetItemState (
					WID_MESSAGEBODY, FALSE, (const SfxPoolItem**)&pItem);
				if (pItem && pItem->Get())
				{
					// Message body already loaded.
					pJob->Done();
					return NULL;
				}
			}
			break;

		case WID_GETDATA: // Load Property Job.
			if (pJob->GetCacheNode())
			{
				// Obtain message itemset.
				GetData_Impl (pJob->GetCacheNode());

				// Set message state.
				SetState_Impl (GetIsLocked());

				// Done.
				pJob->Done();
				return NULL;
			}
			break;

		case WID_PUTDATA: // Set Property Job.
			if (pJob->GetSubject())
			{
				// Set all properties.
				const CntItemListItem *pListItem =
					(const CntItemListItem *)pReq;
				USHORT i, n = pListItem->Count();
				for (i = 0; i < n; i++)
				{
					// Set current property.
					const SfxPoolItem &rProp = (*pListItem)[i];
					Put (rProp, rProp.Which());
				}

				// Done.
				pJob->Done();
				return NULL;
			}
			break;

		case WID_TITLE: // Set Property Job.
			if (pJob->GetSubject())
			{
				// Set Title (ViewProp) as Subject (OwnProp).
				Put (*pReq, pReq->Which());
				pJob->Done();
				return NULL;
			}
			break;

		case WID_MSG_LOCK: // Set Property Job.
			if (pJob->GetSubject())
			{
				// Set locked property.
				SetState_Impl (ITEM_VALUE (CntBoolItem, *pReq));

				// Done.
				pJob->Done();
				return NULL;
			}
			break;

		case WID_ACTION_LIST: // Store Property Job.
			if (pJob->GetCacheNode())
			{
				// Obtain message itemset.
				CntStorageNode *pCache = pJob->GetCacheNode();
				String aNodeURL (OWN_URL (this));
				aNodeURL.AppendAscii (".node");

				CntStoreItemSetRef xDirSet (pCache->openItemSet (
					aMsgDirRanges_Impl, aNodeURL,
					STREAM_READWRITE | STREAM_NOCREATE));
				if (xDirSet.Is())
				{
					// Update message itemset.
					xDirSet->Put (*pReq, pReq->Which());
					xDirSet.Clear();
				}

				// Done.
				CntInterface::Put (*pReq, pReq->Which());
				pJob->Done();
				return NULL;
			}
			break;

		default:
			break;
	}

	// Forward to base class.
	return CntMessageNode::InsertJob (pJob);
}

/*
 * Put.
 */
const SfxPoolItem* CntOutMessageNode::Put (
	const SfxPoolItem &rProp, USHORT nWhich)
{
	if (GetIsLocked())
	{
		// Message locked for editing.
		switch (nWhich)
		{
			case WID_TO:
			case WID_CC:
			case WID_BCC:
			case WID_NEWSGROUPS:
				// Clear previous RecipientList.
				ClearItem (WID_RECIPIENTLIST);
				break;

			case WID_RECIPIENTLIST:
				// Keep current item state.
				return NULL;

			default:
				break;
		}
	}
	return CntInterface::Put (rProp, nWhich);
}

/*
 * IsItemFlag.
 */
FASTBOOL CntOutMessageNode::IsItemFlag (USHORT nWhich, USHORT nFlag) const
{
	switch (nFlag)
	{
		case CNT_ITEM_AUTO_OWNPROP: // Never.
			return FALSE;
		default:
			break;
	}
	return CntMessageNode::IsItemFlag (nWhich, nFlag);
}

