/*************************************************************************
 *
 *  $RCSfile: coutimp.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: mhu $ $Date: 2001/07/24 17:59:46 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CNTOUTIMP_HXX
#define _CNTOUTIMP_HXX "$Revision: 1.3 $"

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif
#ifndef _REF_HXX
#include <tools/ref.hxx>
#endif
#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif

#ifndef _SFXLSTNER_HXX
#include <svtools/lstner.hxx>
#endif
#ifndef _SFXBRDCST_HXX
#include <svtools/brdcst.hxx>
#endif
#ifndef _SFXHINT_HXX
#include <svtools/hint.hxx>
#endif

#ifndef _INET_MACROS_HXX
#include <inet/macros.hxx>
#endif

#ifndef _CNTJOB_HXX
#include "cntjob.hxx"
#endif
#ifndef _CNTSTGND_HXX
#include "cntstgnd.hxx"
#endif
#ifndef _CSTRITEM_HXX
#include "cstritem.hxx"
#endif
#ifndef _OUTITEMS_HXX
#include "outitems.hxx"
#endif
#ifndef _RCPNITEM_HXX
#include "rcpnitem.hxx"
#endif
#ifndef _CHAOS_SILITEM_HXX
#include "silitem.hxx"
#endif

class CntOutMessageCachingPolicy;
class INetCoreNewsMessage;

#ifdef _USE_NAMESPACE
namespace inet {
#endif

class INetCoreMailer;

#ifdef _USE_NAMESPACE
}
#endif

namespace chaos
{

class CntExport;
class CntImport;

/*========================================================================
 *
 * CntOut... common internals.
 *
 *======================================================================*/
#ifndef COPYCTOR_API
#define COPYCTOR_API(C) C(const C&); C& operator=(const C&)
#endif

#ifndef CNTDIRENTRY_ATTRIB_UNSENT
#define CNTDIRENTRY_ATTRIB_UNSENT CNTDIRENTRY_ATTRIB_USER1
#endif

#ifndef ITEMSET_VALUE_STRING
#define ITEMSET_VALUE_STRING(a, b) ITEMSET_VALUE((a), CntStringItem, (b))
#endif

#ifndef ITEMSET_VALUE_UINT32
#define ITEMSET_VALUE_UINT32(a, b) ITEMSET_VALUE((a), CntUInt32Item, (b))
#endif

#define COUTIMP_ADDRESS_QUOTE "\"\"<>()"

#define COUTIMP_SENDTRIES_LIMIT 10

#define COUTJOB_RESCHEDULE_TIMELIMIT 200 /* [ms] */

inline UniString S2U (const sal_Char *pszAscii)
{
	return UniString::CreateFromAscii (pszAscii);
}

inline UniString COUTIMP_CUT_STRING (
	UniString& a, xub_StrLen i, xub_StrLen n)
{
	UniString b (a.Copy (i, n));
	a.Erase (i, n);
	return b;
}

/*
 * CntOutTrayNode: CntStoreItemSet Ranges.
 */
#define COUTBOX_DIR_RANGES_IMPL(a) \
static const USHORT a[] = \
{ \
	WID_TOTALCONTENTCOUNT, WID_TOTALCONTENTCOUNT, \
	WID_SENTCONTENTCOUNT,  WID_SENTCONTENTCOUNT, \
	0 \
};

/*
 * CntOutMessageNode: CntStoreItemSet Ranges.
 */
#define COUTMSG_DIR_RANGES_IMPL(a) \
static const USHORT a[] = \
{ \
	WID_PRIORITY,            WID_PRIORITY, \
	WID_REPLY_TO,            WID_TITLE, \
	WID_REFERENCES,          WID_NEWSGROUPS, \
	WID_OUTMSGINTERNALSTATE, WID_RECIPIENTLIST, \
	WID_DATE_CREATED,        WID_DATE_CREATED, \
	WID_SIZE,                WID_SIZE, \
	WID_ACTION_LIST,         WID_ACTION_LIST, \
	0 \
};

/*========================================================================
 *
 * CntOutTrayNode_Impl interface.
 *
 *======================================================================*/
class CntOutTrayNode_Impl
{
	/** Representation.
	*/
	CntNode                        *m_pParent;
	NAMESPACE_INET(INetCoreMailer) *m_pMailer;

	CntConnMode                     m_eConnMode;
	BOOL                            m_bInitialized;

	/** Not implemented.
	*/
	COPYCTOR_API (CntOutTrayNode_Impl);

public:
	CntOutTrayNode_Impl (
		CntNode *pParent,
		CntConnMode eConnMode = CNT_CONN_MODE_ONLINE);
	~CntOutTrayNode_Impl (void);

	BOOL IsInitialized (void) const { return m_bInitialized; }
	BOOL Initialize (CntNodeJob *pJob);

	CntNode*         GetParent (void) const { return m_pParent; }
	CntStoreItemSet* GetBoxItemSet (CntStorageNode *pCache);

	CntConnMode      GetConnMode (void) const { return m_eConnMode; }
	void             SetConnMode (CntConnMode eConnMode);

	NAMESPACE_INET(INetCoreMailer)* GetMailer (void);
	void PutMailer (NAMESPACE_INET(INetCoreMailer) *pMailer);
	BOOL HasMailer (void) const { return (!!m_pMailer); }

	void setMessageCopyResult(CntNodeJob & rJob);
	void updateMessageStatus(CntNodeJob & rJob);
};

/*========================================================================
 *
 * CntOutMessage_Impl interface.
 *
 *======================================================================*/
class CntOutMessage_Impl
{
public:
	/** setRecipientList.
	 */
	static void setRecipientList (
		CntInterface       &rMessage,
		const CntInterface &rPropSet);

	/** parseRecipient.
	 */
	static void parseRecipient (
		CntRecipientListItem &rRcptList,
		const CntStringItem  &rAddrList,
		const CntInterface   &rPropSet);

	/** querySendInfo.
	 */
	static String querySendInfo (
		const CntInterface    &rPropSet,
		USHORT                 nWhich,
		CntOutMsgProtocolType  eProto = CNT_OUTMSG_PROTOCOL_SMTP);
};

/*========================================================================
 *
 * CntOutJob_Impl interface.
 *
 *======================================================================*/
class CntOutJob_Impl : public SfxListener, public SvRefBase
{
	/** Representation.
	*/
	CntNodeJobRef        m_xJob;
	CntOutTrayNode_Impl *m_pParent;

	/** Not implemented.
	*/
	COPYCTOR_API (CntOutJob_Impl);

protected:
	/** Broadcast (notify master job client).
	*/
	void Broadcast (const SfxHint& rHint);

public:
	CntOutJob_Impl (
		CntNodeJob *pJob, CntOutTrayNode_Impl *pParent);
	virtual ~CntOutJob_Impl (void);

	CntNodeJob* GetJob (void) const { return m_xJob; }

	CntOutTrayNode_Impl* GetParent (void) const { return m_pParent; }

	CntNode* GetRootNode (void) const 
	{
		return m_pParent->GetParent();
	}

	virtual const SfxPoolItem* Execute (void) = 0;

	virtual void  Notify (SfxBroadcaster& rBC, const SfxHint& rHint);
};

SV_DECL_IMPL_REF (CntOutJob_Impl);

/*========================================================================
 *
 * CntOutBoxOpenJob_Impl interface.
 *
 *======================================================================*/
class CntOutBoxOpenJob_Impl : public CntOutJob_Impl
{
	/** State.
	*/
	enum State
	{
		STATE_NONE = 0,
		STATE_OPEN,
		STATE_DONE
	};

	/** Representation.
	*/
	CntStorageNode     *m_pCache;
	CntStorageIterator *m_pIter;
	ULONG               m_nIter;
	ULONG               m_nSent;
	USHORT              m_eViewMode;
	State               m_eState;

	/** queryResult.
	*/
	CntNode* queryResult (
		const String &rUrl, UINT32 nAttrib);

	/** querySent.
	*/
	BOOL querySent (
		CntNode *pNode, const String &rUrl, UINT32 nAttrib);

	/** Not implemented.
	*/
	COPYCTOR_API (CntOutBoxOpenJob_Impl);

public:
	CntOutBoxOpenJob_Impl (
		CntNodeJob *pJob, CntOutTrayNode_Impl *pParent);
	virtual ~CntOutBoxOpenJob_Impl (void);

	virtual const SfxPoolItem* Execute (void);

	virtual void  Notify (SfxBroadcaster& rBC, const SfxHint& rHint);
};

/*========================================================================
 *
 * CntOutBoxSendJob_Impl interface.
 *
 *======================================================================*/
class CntOutBoxSendJob_Impl : public CntOutJob_Impl
{
	/** State.
	*/
	enum State
	{
		STATE_NONE = 0,
		STATE_SEND,
		STATE_DONE
	};

	/** Representation.
	*/
	CntNodeJobRef       m_xSubJob;
	CntStorageNode     *m_pCache;
	CntStorageIterator *m_pIter;
	State               m_eState;

	/** Not implemented.
	*/
	COPYCTOR_API (CntOutBoxSendJob_Impl);

public:
	CntOutBoxSendJob_Impl (
		CntNodeJob *pJob, CntOutTrayNode_Impl *pParent);
	virtual ~CntOutBoxSendJob_Impl (void);

	virtual const SfxPoolItem* Execute (void);

	virtual void  Notify (SfxBroadcaster& rBC, const SfxHint& rHint);
};

/*========================================================================
 *
 * CntOutCloseJob_Impl interface.
 *
 *======================================================================*/
class CntOutCloseJob_Impl : public CntOutJob_Impl
{
	/** State.
	*/
	enum State
	{
		STATE_NONE = 0,
		STATE_NNTP,
		STATE_SMTP,
		STATE_CLOSE,
		STATE_DONE
	};

	/** Representation.
	*/
	NAMESPACE_INET(INetCoreMailer) *m_pMailer;
	State                           m_eState;

	/** Request callback.
	*/
	static sal_Bool ExecuteCallback (
		NAMESPACE_INET(INetCoreMailer) *pMailer,
		sal_Int32 nReplyCode, const sal_Char *pReplyText, void *pData);

	/** Request handler.
	*/
	void ExecuteHandler (
		NAMESPACE_INET(INetCoreMailer) *pMailer,
		sal_Int32 nReplyCode, const sal_Char *pReplyText);

	/** Not implemented.
	*/
	COPYCTOR_API (CntOutCloseJob_Impl);

public:
	CntOutCloseJob_Impl (
		CntNodeJob *pJob, CntOutTrayNode_Impl *pParent);
	virtual ~CntOutCloseJob_Impl (void);

	virtual const SfxPoolItem* Execute (void);

	virtual void  Notify (SfxBroadcaster& rBC, const SfxHint& rHint);
};

/*========================================================================
 *
 * CntOutMsgSendJob_Impl interface.
 *
 *======================================================================*/
class CntOutMsgSendJob_Impl : public CntOutJob_Impl
{
	/** Availability.
	 */
	enum Availability
	{
		AVAIL_UNKNOWN = 0,
		AVAIL_KNOWN,
		AVAIL_INSERTED
	};

	/** State.
	*/
	enum State
	{
		STATE_NONE = 0,
		STATE_INSERT,
		STATE_SEND,
		STATE_DONE
	};

	/** Representation.
	*/
	CntNodeJobRef         m_xSubJob;
	CntStorageNode       *m_pCache;

	CntRecipientListItem *m_pRcptList;
	USHORT                m_nIndex;
	State                 m_eState;

	/** queryAvailable.
	*/
	Availability queryAvailable (
		CntNode               *pSubject,
		CntRecipientListItem *&rpRcptList);

	/** queryInsert.
	*/
	BOOL queryInsert (
		CntNode *pSubject);

	/** querySend.
	*/
	CntNodeJob* querySend (
		const CntRecipientInfoItem &rRecipient);

	/** Not implemented.
	*/
	COPYCTOR_API (CntOutMsgSendJob_Impl);

public:
	CntOutMsgSendJob_Impl (
		CntNodeJob *pJob, CntOutTrayNode_Impl *pParent);
	virtual ~CntOutMsgSendJob_Impl (void);

	virtual const SfxPoolItem* Execute (void);

	virtual void  Notify (SfxBroadcaster& rBC, const SfxHint& rHint);
};

/*========================================================================
 *
 * CntOutMsgResendJob_Impl interface.
 *
 *======================================================================*/
class CntOutMsgResendJob_Impl : public CntOutJob_Impl
{
	/** State.
	*/
	enum State
	{
		STATE_NONE = 0,
		STATE_RESEND,
		STATE_DONE
	};

	/** Representation.
	*/
	CntNodeJobRef   m_xSubJob;
	CntStorageNode *m_pCache;
	State           m_eState;

	/** Not implemented.
	*/
	COPYCTOR_API (CntOutMsgResendJob_Impl);

public:
	CntOutMsgResendJob_Impl (
		CntNodeJob *pJob, CntOutTrayNode_Impl *pParent);
	virtual ~CntOutMsgResendJob_Impl (void);

	virtual const SfxPoolItem* Execute (void);

	virtual void  Notify (SfxBroadcaster& rBC, const SfxHint& rHint);
};

/*========================================================================
 *
 * CntOutMsgMarkJob_Impl interface.
 *
 *======================================================================*/
class CntOutMsgMarkJob_Impl : public CntOutJob_Impl
{
	/** State.
	*/
	enum State
	{
		STATE_NONE = 0,
		STATE_MARK,
		STATE_DONE
	};

	/** Representation.
	*/
	CntStorageNode *m_pCache;
	State           m_eState;

	/** Not implemented.
	*/
	COPYCTOR_API (CntOutMsgMarkJob_Impl);

public:
	CntOutMsgMarkJob_Impl (
		CntNodeJob *pJob, CntOutTrayNode_Impl *pParent);
	virtual ~CntOutMsgMarkJob_Impl (void);

	virtual const SfxPoolItem* Execute (void);

	virtual void  Notify (SfxBroadcaster& rBC, const SfxHint& rHint);
};

/*========================================================================
 *
 * CntOutMsgDeleteJob_Impl interface.
 *
 *======================================================================*/
class CntOutMsgDeleteJob_Impl : public CntOutJob_Impl
{
	/** State.
	*/
	enum State
	{
		STATE_NONE = 0,
		STATE_DELETE,
		STATE_DONE
	};

	/** Representation.
	*/
	CntStorageNode *m_pCache;
	State           m_eState;

	/** Not implemented.
	*/
	COPYCTOR_API (CntOutMsgDeleteJob_Impl);

public:
	CntOutMsgDeleteJob_Impl (
		CntNodeJob *pJob, CntOutTrayNode_Impl *pParent);
	virtual ~CntOutMsgDeleteJob_Impl (void);

	virtual const SfxPoolItem* Execute (void);

	virtual void  Notify (SfxBroadcaster& rBC, const SfxHint& rHint);
};

/*========================================================================
 *
 * CntOutMsgRestoreJob_Impl interface.
 *
 *======================================================================*/
class CntOutMsgRestoreJob_Impl : public CntOutJob_Impl
{
	/** State.
	*/
	enum State
	{
		STATE_NONE = 0,
		STATE_RESTORE,
		STATE_DONE
	};

	/** Representation.
	*/
	CntStorageNode *m_pCache;
	State           m_eState;

	/** Not implemented.
	*/
	COPYCTOR_API (CntOutMsgRestoreJob_Impl);

public:
	CntOutMsgRestoreJob_Impl (
		CntNodeJob *pJob, CntOutTrayNode_Impl *pParent);
	virtual ~CntOutMsgRestoreJob_Impl (void);

	virtual const SfxPoolItem* Execute (void);

	virtual void  Notify (SfxBroadcaster& rBC, const SfxHint& rHint);
};

/*========================================================================
 *
 * CntOutNNTPJob_Impl interface.
 *
 *======================================================================*/
class CntOutNNTPJob_Impl : public CntOutJob_Impl
{
	/** State.
	*/
	enum State
	{
		STATE_NONE = 0,
		STATE_CLOSED,
		STATE_OPEN,
		STATE_SEND,
		STATE_AUTH,
		STATE_USER,
		STATE_PASS,
		STATE_DONE
	};

	/** Representation.
	*/
	NAMESPACE_INET(INetCoreMailer) *m_pMailer;
	INetCoreNewsMessage            *m_pMessage;
	CntRecipientInfo               *m_pRcptInfo;
	USHORT                          m_nHintId;
	State                           m_eState;

	/** Request callback.
	*/
	static sal_Bool ExecuteCallback (
		NAMESPACE_INET(INetCoreMailer) *pMailer,
		sal_Int32 nReplyCode, const sal_Char *pReplyText, void *pData);

	/** Request handler.
	*/
	void ExecuteHandler (
		NAMESPACE_INET(INetCoreMailer) *pMailer,
		sal_Int32 nReplyCode, const sal_Char *pReplyText);

	/** SetProtocolError.
	*/
	void SetProtocolError (
		sal_Int32 nReplyCode, const sal_Char *pReplyText);

	/** Not implemented.
	*/
	COPYCTOR_API (CntOutNNTPJob_Impl);

public:
	CntOutNNTPJob_Impl (
		CntNodeJob *pJob, CntOutTrayNode_Impl *pParent);
	virtual ~CntOutNNTPJob_Impl (void);

	virtual const SfxPoolItem* Execute (void);

	virtual void  Notify (SfxBroadcaster& rBC, const SfxHint& rHint);
};

/*========================================================================
 *
 * CntOutSMTPJob_Impl interface.
 *
 *======================================================================*/
class CntOutSMTPJob_Impl : public CntOutJob_Impl
{
	/** State.
	*/
	enum State
	{
		STATE_NONE = 0,
		STATE_OPEN,
		STATE_SEND,
		STATE_CLOSE,
		STATE_DONE
	};

	/** Representation.
	*/
	NAMESPACE_INET(INetCoreMailer) *m_pMailer;
	INetCoreNewsMessage            *m_pMessage;
	CntRecipientInfo               *m_pRcptInfo;
	USHORT                          m_nHintId;
	State                           m_eState;

	/** Request callback.
	*/
	static sal_Bool ExecuteCallback (
		NAMESPACE_INET(INetCoreMailer) *pMailer,
		sal_Int32 nReplyCode, const sal_Char *pReplyText, void *pData);

	/** Request handler.
	*/
	void ExecuteHandler (
		NAMESPACE_INET(INetCoreMailer) *pMailer,
		sal_Int32 nReplyCode, const sal_Char *pReplyText);

	/** SetProtocolError.
	*/
	void SetProtocolError (
		sal_Int32 nReplyCode, const sal_Char *pReplyText);

	/** Not implemented.
	*/
	COPYCTOR_API (CntOutSMTPJob_Impl);

public:
	CntOutSMTPJob_Impl (
		CntNodeJob *pJob, CntOutTrayNode_Impl *pParent);
	virtual ~CntOutSMTPJob_Impl (void);

	virtual const SfxPoolItem* Execute (void);

	virtual void  Notify (SfxBroadcaster& rBC, const SfxHint& rHint);
};

/*========================================================================
 *
 * CntOutCopyJob_Impl interface.
 *
 *======================================================================*/
class CntOutCopyJob_Impl : public CntOutJob_Impl
{
	/** Not implemented.
	*/
	COPYCTOR_API (CntOutCopyJob_Impl);

public:
	CntOutCopyJob_Impl (
		CntNodeJob *pJob, CntOutTrayNode_Impl *pParent);
	virtual ~CntOutCopyJob_Impl (void);

	virtual const SfxPoolItem* Execute (void);

	virtual void  Notify (SfxBroadcaster& rBC, const SfxHint& rHint);
};

/*========================================================================
 *
 * CntOutBoxImportJob_Impl interface.
 *
 *======================================================================*/
class CntOutBoxImportJob_Impl : public CntOutJob_Impl
{
	/** Representation.
	*/
	SvStream                   *m_pStream;
	CntImport                  *m_pImport;
	CntOutMessageCachingPolicy *m_pPolicy;
	String                      m_sFileName;
	USHORT                      m_nHintID;
	bool                        m_bMessageFound;

	/** Not implemented.
	*/
	COPYCTOR_API (CntOutBoxImportJob_Impl);

public:
	CntOutBoxImportJob_Impl (
		CntNodeJob *pJob, CntOutTrayNode_Impl *pParent);
	virtual ~CntOutBoxImportJob_Impl (void);

	virtual const SfxPoolItem* Execute (void);

	virtual void  Notify (SfxBroadcaster& rBC, const SfxHint& rHint);
};

/*========================================================================
 *
 * CntOutBoxExportJob_Impl.
 *
 *======================================================================*/
class CntOutBoxExportJob_Impl : public CntOutJob_Impl
{
	/** Representation.
	*/
	CntNodeRef			m_xMessageNode;
	CntNodeJobRef		m_xOpenJob;
	SvStream           *m_pStream;
	CntExport          *m_pExport;
	CntStorageNode     *m_pCache;
	CntStorageIterator *m_pIter;
	UINT32              m_nIter;
	USHORT              m_nHintID;

	/** Not implemented.
	*/
	COPYCTOR_API (CntOutBoxExportJob_Impl);

public:
	CntOutBoxExportJob_Impl (
		CntNodeJob *pJob, CntOutTrayNode_Impl *pParent);

	virtual const SfxPoolItem* Execute (void);

	virtual void  Notify (SfxBroadcaster& rBC, const SfxHint& rHint);
};

/*========================================================================
 *
 * CntOutMsgExportJob_Impl.
 *
 *======================================================================*/
class CntOutMsgExportJob_Impl: public CntOutJob_Impl
{
	/** Representation.
	*/
	SvStream *m_pStream;
	USHORT    m_nHintID;

	/** Not implemented.
	*/
	COPYCTOR_API (CntOutMsgExportJob_Impl);

public:
	CntOutMsgExportJob_Impl (
		CntNodeJob *pJob, CntOutTrayNode_Impl *pParent);
	virtual ~CntOutMsgExportJob_Impl (void);

	virtual const SfxPoolItem* Execute (void);

	virtual void  Notify (SfxBroadcaster& rBC, const SfxHint& rHint);
};

} // namespace chaos

#endif /* !_CNTOUTIMP_HXX */

