/*************************************************************************
 *
 *  $RCSfile: adminimpl.hxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: dg $ $Date: 2001/10/11 14:19:49 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef CONFIGMGR_API_ADMINIMPL_HXX_
#define CONFIGMGR_API_ADMINIMPL_HXX_

#ifndef _CPPUHELPER_IMPLBASE2_HXX_
#include <cppuhelper/implbase2.hxx>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XNAMECONTAINER_HPP_
#include <com/sun/star/container/XNameContainer.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSINGLESERVICEFACTORY_HPP_
#include <com/sun/star/lang/XSingleServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif
#ifndef CONFIGMGR_API_SVCCOMPONENT_HXX_
#include "confsvccomponent.hxx"
#endif
#ifndef CONFIGMGR_TREEBUILDERCALLBACK_HXX
#include "treebuildercallback.hxx"
#endif


namespace configmgr
{
	namespace css  = ::com::sun::star;
	namespace uno  = css::uno;
	namespace container  = css::container;
	namespace lang = css::lang;			
	namespace beans = css::beans;		

	class OAdminProviderImpl;	
	class IDOMNodeDataProvider;
	
	namespace configuration 
	{
		class AbsolutePath;
		class Name;
	}
	
	//==========================================================================
	//= OAdminAccess	
	//==========================================================================
	typedef ::cppu::ImplHelper2	<	container::XNameContainer,
									lang::XSingleServiceFactory
								>	OAdminAccess_Base;	


	/** base class for administration transaction like adding and removing users
	*/
	class SAL_NO_VTABLE OAdminAccess : public ServiceComponentImpl,
									   public OAdminAccess_Base
	{			
	protected:
		OAdminProviderImpl*			m_pProviderImpl;	/// provider, who creates the object

	public:
		/** constructs the object.
			@param		_pProviderImpl		a pointer to the provider
			@param		_pInfo				a pointer to the service info
		*/
		OAdminAccess(OAdminProviderImpl* _pProviderImpl, 
					 ServiceInfo const* _pInfo);			

		// XInterface
		virtual uno::Any SAL_CALL queryInterface(uno::Type const& rType) throw (uno::RuntimeException);
		virtual void SAL_CALL acquire() throw();
		virtual void SAL_CALL release() throw();

		// XTypeProvider
		uno::Sequence< uno::Type > SAL_CALL getTypes() throw (uno::RuntimeException);		

		// XComponent
		virtual void SAL_CALL		disposing();	

		// XElementAccess		
		virtual uno::Type SAL_CALL	getElementType(  ) throw (uno::RuntimeException);
		virtual sal_Bool SAL_CALL	hasElements(  ) throw (uno::RuntimeException);					

		// XNameAccess				
		virtual sal_Bool SAL_CALL	hasByName( const ::rtl::OUString& aName ) throw (uno::RuntimeException);		

		// XNameReplace
		virtual void SAL_CALL		replaceByName( const ::rtl::OUString& _rName, const uno::Any& _rElement ) throw (lang::IllegalArgumentException, container::NoSuchElementException, lang::WrappedTargetException, uno::RuntimeException);

		// XNameContainer
		virtual void SAL_CALL		insertByName( const ::rtl::OUString& _rName, const uno::Any& _rElement ) throw (lang::IllegalArgumentException, container::ElementExistException, lang::WrappedTargetException, uno::RuntimeException);
		virtual void SAL_CALL		removeByName( const ::rtl::OUString& _rName ) throw (container::NoSuchElementException, lang::WrappedTargetException, uno::RuntimeException);

		// XSingleServiceFactory
		virtual uno::Reference< uno::XInterface > SAL_CALL createInstance(  ) throw (uno::Exception, uno::RuntimeException);		
		virtual uno::Reference< uno::XInterface > SAL_CALL createInstanceWithArguments( const uno::Sequence< uno::Any >& aArguments ) throw (uno::Exception, uno::RuntimeException);

	protected:
		/** hook for inserting an element
			@param			_rName 			the configuration name of the element.
			@param			_rParent		the configuration name of the parent, could be empty.			
			@param			_pNodeWriter	a pointer to the object writing the pure node data. Must not
											be NULL. The object pointed to does not need to support ref-counting,
											so the caller has to ensure that it lives until the updateNode
											returns (It does NOT need to live until the request is done).
			@param			_rHandler		callback for status notifications.
											May be NULL (if you're sure that the request will succeed and
											not interested in the results ...)												
			
		*/
		virtual void insertElement(const configuration::Name& _rName, 
							       const configuration::Name& _rParent, 
								   IDOMNodeDataProvider* _pNodeWriter, 
								   const ::vos::ORef< IRequestCallback >& _rHandler) = 0;	
	
		/** hook for deleting an element
			@param			_rName 			the configuration name of the element.
			@param			_rHandler		callback for status notifications.
											May be NULL (if you're sure that the request will succeed and
											not interested in the results ...)												
			
		*/
		virtual void deleteElement(const configuration::Name& _rName, 
							       const ::vos::ORef< IRequestCallback >& _rHandler) = 0;		
		
		/// implements a generic retrieval of a element
		uno::Any getElement( uno::Sequence< uno::Any > const& _rArgs ) throw(container::NoSuchElementException, lang::WrappedTargetException, uno::RuntimeException);	

		/// implements a generic retrieval for the element names
		uno::Sequence< ::rtl::OUString > getElementNames( const configuration::AbsolutePath& _rPath ) throw (uno::RuntimeException);

		/// extracts the node containing the parent information
		uno::Reference< beans::XPropertySet > extractDataNode( const uno::Any& _rElement )
				throw (lang::IllegalArgumentException, lang::WrappedTargetException, uno::RuntimeException);
	};


} // namespace configmgr

#endif // CONFIGMGR_API_ADMINIMPL_HXX_


