/*************************************************************************
 *
 *  $RCSfile: groupimpl.cxx,v $
 *
 *  $Revision: 1.33 $
 *
 *  last change: $Author: dg $ $Date: 2001/10/11 14:18:27 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include "groupimpl.hxx"

#ifndef CONFIGMGR_API_ADMINPROVIDERIMPL_HXX_
#include "adminproviderimpl.hxx"
#endif
#ifndef _CONFIGMGR_STRDECL_HXX_
#include "strdecl.hxx"
#endif
#ifndef CONFIGMGR_CREATEPROPERTYVALUE_HXX
#include "createpropertyvalue.hxx"
#endif
#ifndef _CONFIGMGR_TRACER_HXX_
#include "tracer.hxx"
#endif
#ifndef CONFIGMGR_CONFIGSET_HXX_
#include "configset.hxx"
#endif

namespace configmgr
{
	using ::rtl::OUString;
	using namespace configuration;

	const AsciiServiceName aGroupAccessServices[] = 
	{
		"com.sun.star.configuration.GroupAccess", 
		NULL
	};

	const ServiceInfo aGroupAccessSI =
	{ 
		"com.sun.star.comp.configuration.GroupAccess", 
		aGroupAccessServices
	};
	
	//-----------------------------------------------------------------------------
	//= OGroupAccess
	//=============================================================================	
	//-----------------------------------------------------------------------------
	OGroupAccess::OGroupAccess(OAdminProviderImpl* _pProviderImpl)
				 :OAdminAccess(_pProviderImpl, &aGroupAccessSI)	{}		

	//------------------------------------------------------------------------
	uno::Sequence< sal_Int8 > SAL_CALL OGroupAccess::getImplementationId() throw (uno::RuntimeException)
	{
		static ::cppu::OImplementationId * pId = 0;
		if (! pId)
		{
			::osl::MutexGuard aGuard( ::osl::Mutex::getGlobalMutex() );
			if (! pId)
			{
				static ::cppu::OImplementationId aId;
				pId = &aId;
			}
		}
		return pId->getImplementationId();		
	}	

	// XNameAccess		
	//-----------------------------------------------------------------------------
	uno::Any SAL_CALL OGroupAccess::getByName(const ::rtl::OUString& aName) throw (container::NoSuchElementException, lang::WrappedTargetException, uno::RuntimeException)
	{
		// now lookup the group in cache		
		uno::Sequence< uno::Any > aArgs(2);	// optional arg.
		aArgs[0] <<= configmgr::createPropertyValue(OProviderImpl::FactoryArguments::getNodePathArgumentName(), (::rtl::OUString const&)NODE_USERPROFILE);
		aArgs[1] <<= configmgr::createPropertyValue(OProviderImpl::FactoryArguments::getUserArgumentName(), aName);

		return getElement( aArgs );
	}

	//-----------------------------------------------------------------------------
	uno::Sequence< ::rtl::OUString > SAL_CALL OGroupAccess::getElementNames(  ) throw(uno::RuntimeException)
	{
		// requesting all group names
		return OAdminAccess::getElementNames(AbsolutePath::parse(NODE_USERPROFILE_GROUPLIST));		
	}		

	//-----------------------------------------------------------------------------
	void OGroupAccess::insertElement(const configuration::Name& _rName, 
							         const configuration::Name& _rParent, 
								     IDOMNodeDataProvider* _pNodeWriter, 
								     const ::vos::ORef< IRequestCallback >& _rHandler)
	{
		// now look what has changed in comparision to the default user
		IAdminProvider* pAdminProvider = m_pProviderImpl->getSession()->asIAdminProvider();
		OSL_ENSURE(pAdminProvider, "OGroupAccess::deleteElement: admin session not available in local session!");
		if (pAdminProvider)
			pAdminProvider->addGroup(_rName, _rParent, _pNodeWriter, _rHandler);
	}

	//-----------------------------------------------------------------------------
	void OGroupAccess::deleteElement(const configuration::Name& _rName, 
							       const ::vos::ORef< IRequestCallback >& _rHandler)
	{
		// now look what has changed in comparision to the default user
		IAdminProvider* pAdminProvider = m_pProviderImpl->getSession()->asIAdminProvider();
		OSL_ENSURE(pAdminProvider, "OGroupAccess::deleteElement: admin session not available in local session!");
		if (pAdminProvider)
			pAdminProvider->deleteGroup(_rName, _rHandler);
	}	
	
} // namespace configmgr


