/*************************************************************************
 *
 *  $RCSfile: configsession.hxx,v $
 *
 *  $Revision: 1.20 $
 *
 *  last change: $Author: jb $ $Date: 2001/11/14 17:02:00 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CONFIGMGR_SESSION_CONFIGSESSION_HXX_
#define _CONFIGMGR_SESSION_CONFIGSESSION_HXX_

#ifndef _CONFIGMGR_COMMONTYPES_HXX_
#include "commontypes.hxx"
#endif
#ifndef _CONFIGMGR_SERVER_VERSION_HXX_
#include "server_version.hxx"
#endif
#ifndef CONFIGMGR_MISC_OPTIONS_HXX_
#include <options.hxx>
#endif

#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif
#ifndef _COM_SUN_STAR_XML_SAX_XDOCUMENTHANDLER_HPP_
#include <com/sun/star/xml/sax/XDocumentHandler.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif
#ifndef _OSL_TIME_H_
#include <osl/time.h>
#endif
#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif


//..........................................................................
namespace configmgr
{
    class INotifyListener;
//..........................................................................
    namespace configuration { class Name; class AbsolutePath; }
    typedef ::rtl::OUString NodeID;

//==========================================================================
//= StatusInfo
//==========================================================================
/** encapsulates the result of a request to the registry server
	@deprecated
*/
struct StatusInfo
{
	sal_Int32			nCode;			/// the error code, at the moment 0 indicates success, != 0 indicates an error
	::rtl::OUString		sMessage;		/// the error message, semantic depends on the specific registry server you're using
};

//==========================================================================
//= IRequestCallback
//==========================================================================
/** interface for transfering the results of asynchronous operations on a config session.
	<BR>
	As most of the methods of <type>IConfigSession</type> are potentially one-way , result
	callbacks are an essential part of the request concept.
	<BR>
	Calling order : If the request could not be forwarded to the server usually fullfilling it,
	<method>failed</method> is called and the object is released afterwards.
	If the request could be forwarded and the server acknowledges the it's queueing, <method>acknowledged</method>
	is invoked. After (successfull or not) finishing the request (as indicated by the server) <method>done</method>
	is called.
	<BR>
	Derived classes may extend this calling order by inserting additonal notifications, but never change
	the relative order of this base class' method calls.
	<BR>
	Usually the caller of <type>IConfigSession</type> methods provides an <type>IRequestCallback</type>
	interface which can handle the results. If so, this object will be acquired immediately (of course)
	and released as soon as the result notification (no matter if it is "success" or "failed") was sent.
	<BR>
	@todo:
	TODO : the current spec says that in case of success, no status will be returned.
	So perhaps our callback interface needs to differ between "done successfully"
	and "done, but had an error"
	after using this interface for a while, I think that it is not very plausible at the moment ...
	"failed" indicates an error, "done" may indicate an error or an success ... that's somewhat unlucky ...
*/
class SAL_NO_VTABLE IRequestCallback : public IInterface
{
public:
	/** indicates that the request could not be queued. Depending on the object implementing an
		<type>IConfigSession</type> interface, the meaning of this method will be quite different.
		@param			_nErrorCode		the session type specific error code. It may evidence an error
										on the connection to the remote server or an error while working
										on a local configuration file.<BR>
										If this methods gets invoked, no further call to <method>done</method>
										will occur.
	*/
	virtual		void failed(sal_Int32 _nErrorCode) = 0;

	/** called when the request is done (no matter if successfull or not, this information is provided by
		the StatusInfo given).
		@param			_rStatus		status after the request
	*/
	virtual		void done(const StatusInfo& _rStatus) = 0;
};


//==========================================================================
//= IGenericCalback
//==========================================================================
/** a session callback for transactions which return a list of properties not beeing interpreted by the session.
	<BR>
	Simple types are string, integer etc. Especially node data can't be transported through this callback.
*/
class SAL_NO_VTABLE IPropertyRequestCallback : public IRequestCallback
{
public:
	/** forwards the parameters extracted from the response body.
	*/
	void gotParameters(const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& _rParams);
};

//==========================================================================
//= IDataRequestCallback
//==========================================================================
/** interface for transfering results of asynchronous operations supplying
	node-specific data. May be used for propagating data the user requested
	with an response (e.g. openNode, getNode) or in case of an error while
	executing a request working on node data (e.g. if an updateNode fails,
	a config server may return the current state of the node in request).
	<BR>
	Calling order : the <method>getDataReader</method> gets called between <method>acknowledged</method>
	and <method>done</method>, if ever (if the queueing of and request fails, as indicated by
	<method>failed</method>, the data reader is never needed and thus the method will never be called).
*/
class SAL_NO_VTABLE IDataRequestCallback : public IRequestCallback
{
public:
	/**	get the document handler which will receive the node specific data the
		request produced.
		<BR>
		If the returned interface is NULL, the results of the request will be quashed.
	*/
	virtual		::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XDocumentHandler >
					getDataReader() = 0;
};

//==========================================================================
//= IOpenObjectCallback
//==========================================================================
/** interface for callbacks for operations which open an object which get's a server-side id.
	<BR>
	Calling order : <method>getNodeId</method> gets called between <method>acknowledged</method>
	and <method>getDataReader</method>, if ever.
	
*/
class SAL_NO_VTABLE IOpenObjectCallback : public IDataRequestCallback
{
public:
	/** forwardes the id of the object just opened to the callback object. All later operations
		will probably need this id.
	*/
	virtual	void	gotObjectId(const NodeID& _rId) = 0;
};

//==========================================================================
//= INotifyCallback
//==========================================================================
/** interface for callbacks for notifications of a server.
	<BR>
	Gets called when a notifcation occurs.	
*/
class SAL_NO_VTABLE INotifyCallback : public IDataRequestCallback
{	
public:
    typedef configuration::AbsolutePath AbsolutePath; 
public:
	/** forwardes the id of the object just opened to the callback object. All later operations
		will probably need this id.
	*/
	virtual void notifyOccured(const AbsolutePath& _rPath) = 0;	
};

//==========================================================================
//= IDOMNodeDataProvider
//==========================================================================
/** interface for transfering node data from the configuration proxy to the registry
	client.
*/
class SAL_NO_VTABLE IDOMNodeDataProvider
{
public:
	/** write the data of a DOM node to a given document handler.
		@param		_rHandler		the document handler to write to.
	*/
	virtual void	writeNodeData(
		const ::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XDocumentHandler >& _rHandler) = 0;
};

class IAdminProvider;
class INotifyProvider;
class IUpdateProvider;
class ITreeProvider;
class ITemplateProvider;
class IDefaultProvider;

//==========================================================================
//= IConfigSession
//==========================================================================
/** abstract interface for configuration access. provides methods for working
	on nodes and listener administration
*/
class SAL_NO_VTABLE IConfigSession
{
public:
	/** possible error reaons
	*/
	enum TSessionError
	{
		E_None,					/// all okay ....
		E_Invalid,				/// the object is invalid in any way
		E_ConnectionError,		/// there was an error on the underlying connection
		E_TimedOut,				/// the underlying connection did not response in time to a vital request
		E_NotConnected,			/// there is no underlying connection
		E_NotOpen,				/// the session is not opened
		E_WrongFormat,			/// the (input or output) XML stream has a wrong format

		E_Unknown				/// an unspecified error occured
	};

	enum { COMPLETE_SUBTREE = 0  };

public:

	virtual ~IConfigSession() { }

// temp hack for disabling caching
	virtual sal_Bool        allowsCaching_Hack()     const  {return sal_True;}
// temp hack for disabling caching
	virtual sal_Bool        supportsFinalized_Hack() const  {return sal_True;}
// temp check for default capability
	virtual sal_Bool        isAutoLoadingDefaults() const  {return sal_False;}
	

// error handling
	/** return the last error occured
		@seealso	getConnectionError
	*/
	virtual TSessionError	getError() const = 0;

	/** return the last error on the underlying connection.
		@return		error code. The meaning of this code depends on the type of connection you're using
					(e.g. whether it is a remote server or a local file)
		@seealso	getError
	*/
	virtual sal_Int32		getConnectionError() const = 0;

// miscellaneous
	/** get the master timeout for the session. This is a session aspect usually collected while
		bootstrapping. All clients waiting for the (maybe asynchronous) callbacks the session does
		should use this timeout.
	*/
	virtual TimeValue*		getMasterTimeout() const { return NULL; }

	/** closing the session, Session IO shouldn't be possible afterwards		
	*/
	virtual void	close() {};	

	/** casts a configsession to a notify session if available. 
		By default a configsession isn't a notify session!
		@return		an notifysession or NULL
		@seealso	INotifyProvider
	*/
	virtual ITreeProvider* asITreeProvider();
	virtual ITreeProvider const* asITreeProvider() const;

	/** casts a configsession to a template provider if available. 
		By default a configsession isn't a template provider!
		@return		a template-provider interface or NULL
	*/
	virtual ITemplateProvider* asITemplateProvider();

	/** casts a configsession to a default provider if available. 
		By default a configsession isn't a template provider!
		@return		a default-provider interface or NULL
	*/
	virtual IDefaultProvider* asIDefaultProvider();

	/** casts a configsession to a notify session if available. 
		By default a configsession isn't a notify session!
		@return		an notifysession or NULL
		@seealso	INotifyProvider
	*/
	virtual IUpdateProvider* asIUpdateProvider();
	virtual IUpdateProvider const* asIUpdateProvider() const;
	
	/** casts a configsession to an admin session if available. 
		By default a configsession isn't a admin session!
		@return		an adminsession or NULL
		@seealso	IAdminProvider
	*/
	virtual IAdminProvider* asIAdminProvider();
	virtual IAdminProvider const* asIAdminProvider() const;
};

//==========================================================================
//= IUpdateProvider
//==========================================================================
/** abstract interface for configuration update access. 	
*/
class SAL_NO_VTABLE IUpdateProvider
{
public:
    typedef configuration::AbsolutePath AbsolutePath; 
public:
// node related methods
	/** open (on the server's side) a node given by it's path. Basicly, this means
		that the the server ensures that the node is loaded from the underlying storage
		system into it's cache.<BR>
		For a more detailed description of the execution of a openNode request, please see the
		appropriate registry service documentation.
		@param			_rNodeAccessor	the path to the node 
		@param			_rOptions		additional parameter for the call
		@param			_nLevel			indicates how many tree levels under the node determined by <arg>_rNodeAccessor</arg>
										should be loaded
		@param			_rHandler		callback for status notifications. May be NULL,
										though this is not recommended, as, without the id
										returned, you're not able to access the node afterwards.
	*/
	virtual void	openNode(const AbsolutePath& _rNodeAccessor, 
							 const vos::ORef < OOptions >& _rOptions,
							 sal_Int32 _nLevel, 
							 const ::vos::ORef< IOpenObjectCallback >& _rHandler,
							 INotifyListener* _pListener = NULL) = 0;

	/** open (on the server's side) a node given by it's path. The registry server tries
		to finish any pending transactions before the close request is fullfilled.<BR>
		For a more detailed description of the execution of a closeNode request, please see the
		appropriate registry service documentation.
		@param			_rNodeId		the id of the node (as supplied to the <type>IOpenObjectCallback</type>
										interface used for opening the node)
		@param			_rHandler		callback for status notifications. May be NULL.
	*/
	virtual void	closeNode(const NodeID& _rNodeId, 							  
							  const ::vos::ORef< IRequestCallback >& _rHandler) = 0;
	
	/** update a registry nodes content (maybe partial).
		@param			_rNodeId		the id of a node (as delivered to the <type>IOpenObjectCallback</type>
										interface used for opening the node) of which a small subtree is about
										to be modified. 
		@param			_rNodeAccessor	the subnode which is to be modified, must be a sub node
										of the one identified by _nNodeId.
		@param			_pNodeWriter	a pointer to the object writing the pure node data. Must not
										be NULL. The object pointed to does not need to support ref-counting,
										so the caller has to ensure that it lives until the updateNode
										returns (It does NOT need to live until the request is done).
		@param			_rHandler		callback for status notifications.
										May be NULL (if you're sure that the request will succeed and
										not interested in the results ...)<BR>
										This is an <type>IDataRequestCallback</type> instead of a simple
										<type>IRequestCallback</type>, as the current state of the node
										updated is transfered back to the caller (even if the update did not
										succeed this data will represent the current state without that update).
		@seealso		addNode
		@seealso		deleteNode
	*/
	virtual void	updateNode(const NodeID& _rNodeId, 
							   const AbsolutePath& _rNodeAccessor,
							   const vos::ORef < OOptions >& _rOptions,
							   IDOMNodeDataProvider* _pNodeWriter, const ::vos::ORef< IDataRequestCallback >& _rHandler) = 0;
};


//==========================================================================
//= IAdminProvider
//==========================================================================
/** abstract interface for configuration administration access. provides methods for working
	adding and removing groups and users.
*/
class SAL_NO_VTABLE IAdminProvider
{
public:
    typedef configuration::Name Name; 
public:
	/** adds a new user to the registry.
		@param			_rName 			the name of the new user.
		@param			_rGroup			the name of the user group the user belongs to.
		
		@param			_pNodeWriter	a pointer to the object writing the pure node data. Must not
										be NULL. The object pointed to does not need to support ref-counting,
										so the caller has to ensure that it lives until the updateNode
										returns (It does NOT need to live until the request is done).
										<BR>
										The top level element to write is the node name, not the parent node name !
										This means that there is some redundance, as the node name is supplied by
										the writer and by the parameter <arg>_rNewNodeName</arg>.
		@param			_rHandler		callback for status notifications.
										May be NULL (if you're sure that the request will succeed and
										not interested in the results ...)
		@seealso		addNode
	*/
	virtual void	addUser(const Name& _rUser, 
							const Name& _rGroup, 
							IDOMNodeDataProvider* _pNodeWriter, 
							const ::vos::ORef< IRequestCallback >& _rHandler) = 0;		

	/** removes a user from the registry
		@param			_rName 			the name of the new user.

		@param			_rHandler		callback for status notifications.
										May be NULL (if you're sure that the request will succeed and
										not interested in the results ...)												
		@seealso		addUser
	*/
	virtual void	deleteUser(const Name& _rUser, 							   
							   const ::vos::ORef< IRequestCallback >& _rHandler) = 0;

	
	/** adds a new usergroup to the registry.
		@param			_rName 			the name of the new group.

		@param			_pNodeWriter	a pointer to the object writing the pure node data. Must not
										be NULL. The object pointed to does not need to support ref-counting,
										so the caller has to ensure that it lives until the updateNode
										returns (It does NOT need to live until the request is done).
										<BR>
										The top level element to write is the node name, not the parent node name !
										This means that there is some redundance, as the node name is supplied by
										the writer and by the parameter <arg>_rNewNodeName</arg>.										

		@param			_rHandler		callback for status notifications.
										May be NULL (if you're sure that the request will succeed and
										not interested in the results ...)												
		@seealso		removeGroup
	*/
	virtual void	addGroup(const Name& _rGroup,
							 const Name& _rParent, 
							 IDOMNodeDataProvider* _pNodeWriter, 
							 const ::vos::ORef< IRequestCallback >& _rHandler) = 0;		

	/** removes a group from the registry. The group must be empty!
		@param			_rName 			the name of the user group.

		@param			_rHandler		callback for status notifications.
										May be NULL (if you're sure that the request will succeed and
										not interested in the results ...)												
		@seealso		addGroup
	*/
	virtual void	deleteGroup(const Name& _rGroup, 							   
							    const ::vos::ORef< IRequestCallback >& _rHandler) = 0;
};



//..........................................................................
}	// namespace configmgr
//..........................................................................

#endif // _CONFIGMGR_SESSION_CONFIGSESSION_HXX_


