/*************************************************************************
 *
 *  $RCSfile: remotesession.hxx,v $
 *
 *  $Revision: 1.20 $
 *
 *  last change: $Author: jb $ $Date: 2001/11/14 17:02:00 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CONFIGMGR_SESSION_REMOTESESSION_HXX_
#define _CONFIGMGR_SESSION_REMOTESESSION_HXX_

#ifndef _CONFIGMGR_SESSION_CONFIGSESSION_HXX_
#include "configsession.hxx"
#endif

#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif
#ifndef _VOS_SOCKET_HXX_
#include <vos/socket.hxx>
#endif

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_XML_SAX_XDOCUMENTHANDLER_HPP_
#include <com/sun/star/xml/sax/XDocumentHandler.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XACTIVEDATASOURCE_HPP_
#include <com/sun/star/io/XActiveDataSource.hpp>
#endif
#ifndef _COM_SUN_STAR_XML_SAX_XPARSER_HPP_
#include <com/sun/star/xml/sax/XParser.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XOUTPUTSTREAM_HPP_
#include <com/sun/star/io/XOutputStream.hpp>
#endif

#ifndef _CONFIGMGR_SERVER_VERSION_HXX_
#include "server_version.hxx"
#endif

#include "options.hxx"

//..........................................................................
namespace configmgr
{
//..........................................................................

class OReceiveThread;
class OSocketOutputStream;
class OResponseRedirector;
class OWaitForCloseSession;
class AttributeListImpl;

//==========================================================================
//= ORemoteSession
//==========================================================================
/** encapsulates low-level access to a registry server.
	<BR>
	As all communication with the registry server is XML-based, data not hidden by this class'
	implementation is transported using <type scope="com::sun::star::xml::sax">XDocumentHandler</type>
	interfaces.
*/
class ORemoteSession : public IConfigSession,
					   public IUpdateProvider,
					   public IAdminProvider

{
	friend class OWaitForCloseSession;
    typedef sal_Int32 SessionID;
    typedef sal_Int32 TransID;
protected:
	::osl::Mutex				m_aMutex;				/// multi-thread access safety
	SessionID					m_nSessionId;			/// server-side session id
	rtl_uString*				m_pLastUsedTransId;		/// last used client-side transaction id
														// (we use an rtl_uString structure for this for better
														// performance)
	OReceiveThread*				m_pReaderThread;		/// the object doing the reading and parsing
	OResponseRedirector*		m_pInterpreter;			/// the object doing the interpretation of the parsed xml stream
	
	sal_Int32					m_eConnectionError;		/// the last socket related error (if any)
	TSessionError				m_eSessionError;		/// our own last error
	::vos::OConnectorSocket*	m_pServerConnection;	/// the connection to the configuration server

 	::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XDocumentHandler >
								m_xWriter;				/// the service object for writing XML code
	::com::sun::star::uno::Reference< ::com::sun::star::io::XActiveDataSource >
								m_xWriterSource;
	::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XParser >
								m_xReader;				/// the service object for reading/parsing XML code
	::com::sun::star::uno::Reference< ::com::sun::star::io::XOutputStream >
								m_xOutputStream;

	TimeValue*					m_pTimeout;
	AttributeListImpl*			m_pAttributes;		   /// envelope attributes
	sal_Bool                    m_bCachingPossible;    /// just need for the cahcing hack see below and implementaion

public:
	/** constructs a session object. No connection is made at this moment, so
		you can't use the object 'til you called <method>open</method>.
		@param			_rxServiceProvider		a service factory used to create SAX-reader and -writer services
		@seealso	open
		@seealso	close
		@seealso	isOpen
	*/
				ORemoteSession(
					const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& _rxServiceProvider);

	/** destroys the session object. Currently, if the session is not closed at this
		moment, it will be killed.
		TODO : think about doing a "soft" close, perhaps with a helper object living
		longer than the session object and handling all outstanding notifications
		(if necessary).
	*/
				~ORemoteSession();

// implementation for cacheing info, this is a hack for user nobody to disable cacheing
// must be erased when non cachable proxy available
	virtual sal_Bool        allowsCaching_Hack() const { return m_bCachingPossible;	}
	
    // while the server does not support proper merging/handling of 'finalized'
	virtual sal_Bool        supportsFinalized_Hack() const { return sal_False;	}

// miscellaneous
		virtual TimeValue*		getMasterTimeout() const { return m_pTimeout; }

// connection related methods
	/** try to connect to the configuration server on the given address/port.
		@param			_rDottedAddress		the dotted address of the system where the registry server
											resides (something like "141.99.128.50")
		@param			_nPort				the port to connect
		@param			_pTimeout			timeout value for connecting. May be NULL, in this case no timeout
											is used.
		@return								sal_True if successfully connected, sal_False otherwise. In the latter
											case <method>getConnectionError</method> will return a more detailed
											error code.
		@seealso	isConnected
	*/
	sal_Bool	connect(const ::rtl::OUString& _rDottedAddress, sal_Int32 _nPort, const TimeValue* _pTimeout = NULL);

	/** connect to the configuration server of a portal environment and open the session (this is done implicitly
		by the portal environment for security reasons)
		@param	_rServiceMgr	service manager for establishing a connection
		@param	_rServer		name of the server the portal is running on. If empty, the process must be run on the
								same machine as the StarPortal. In this case, no authentication is needed, as
								all processes running on the same machine as the portal are considered to be
								trustworthy. Thus _rUser and _rPassword are ignored then.
		@param	_rService		service name for portal connection
		@param	_nPort			port the portal server is running on. Ignored if _rServer is empty.
		@param	_rUser			user name for authenticating against the portal. Ignored if _rServer is empty.
		@param	_rPassword		password for authenticating against the portal. Ignored if _rServer is empty.
	*/
	void		connectToPortal(::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory > const& _rServiceMgr,
								const ::rtl::OUString& _rService,
								const ::rtl::OUString& _rServer,								
								sal_Int32 _nPort,
								const ::rtl::OUString& _rUser,
								const ::rtl::OUString& _rPassword,
								const TimeValue* _pTimeout = NULL);

	/** checks whether or not the object is connected to the configuration server. No check is made if the connection
		is really alive, basically the return indicates only if a previous <method>connect</method> call
		was successfull.
		@seealso	connect
	*/
	sal_Bool		isConnected() { return m_xOutputStream.is(); }

// -----------------------
// session related methods
	/** opens (synchronously) a configuration session for the given user. You need to connect to the server before
		opening a session.
		<BR>
		A session has to be opened to use any of the node-related methods.
		@param		_rUser		the name of the user the connection should be established for
		@param		_rPwd		the users password
		@return					sal_True if the session could be successfully opened,
								sal_False otherwise
		@seealso	connect
		@seealso	close
		@seealso	isOpen
	*/
	sal_Bool		open(const ::rtl::OUString& _rUser, const ::rtl::OUString& _rPwd);

	/**	closes the current configuration session. No node-related methods can be
		done afterwards, until you re-open a session calling <code>open</code>.
		<BR>
		The registry server will try to finish any pending update-/add-/deleteNode
		operations, so be prepared that any callbacks which may exist for such
		transactions can be called before the connection is really closed (which
		is indicated by a call to the given <type>IRequestCallback</type>).
		<BR>
		On successfull server-side close, the session object will free all it's resources
		(including the notification listener and all callbacks for requests which maybe
		never were handled).
		<BR>
		For a more detailed description of the execution of a close request, please see the
		appropriate registry service documentation.
		@param		_rHandler		callback for status notifications. May be NULL,
									though this is not recommended.
		@seealso	open
		@seealso	isOpen
	*/
	void		close();

	/** hard version of <method>close</method>. Will release all callbacks, disconnect
		the listener, cancel all pending transactions (<method>cancelAllTrans</method>)
		and close the session.
		<BR>
		All (client side) resources are freed afterwards, even if the close operation was not
		successfull (though this may be rather impossible), so use this with intelligence !
	*/
	void		kill();

	/** check whether or not the session is open at the moment
		@seealso	open
		@seealso	close
	*/
	sal_Bool	isOpen() { ::osl::MutexGuard aG(m_aMutex); return m_nSessionId != -1; }

// ----------------------
// IConfigSession methods
// error handling
	/// return the last error occured
	virtual TSessionError	getError() const { return m_eSessionError; }

	/** return the last socket related error occured (if any)
		@seealso	getError
	*/
	virtual sal_Int32	getConnectionError() const { return sal_Int32(m_pServerConnection ? m_pServerConnection->getError() : m_eConnectionError); }

// node related methods
	/// open a specific node
	virtual void	openNode(const AbsolutePath& _rNodePath, 
							 const vos::ORef < OOptions >& _rOptions,
							 sal_Int32 _nLevel, 
							 const ::vos::ORef< IOpenObjectCallback >& _rHandler,
							 INotifyListener* _pListener);

	/// close a specific node
	virtual void	closeNode(const NodeID& _rNodeId, 
							  const ::vos::ORef< IRequestCallback >& _rHandler);	

// ---------------------------
// transaction related methods
	/** cancel a specific transaction.
		@param			_nTransId		The id of the transaction as got from <type>IRequestCallback</type>::acknowledged.
		@param			_rHandler		callback for status notifications. May be NULL.
	*/
	void		cancelTrans(TransID _nTransId, const ::vos::ORef< IRequestCallback >& _rHandler);

	/** cancel all transactions on a particular node
		@param			_rNodePath		a node path. All transaction on that node will be canceled.
	*/
	void		cancelNodeTrans(const AbsolutePath& _rNodePath, const ::vos::ORef< IRequestCallback >& _rHandler);

	/** cancel all transactions on the current session.
	*/
	void		cancelAllTrans();

#if KNOW_THE_RESPONSE_FORMAT
	// TODO
	// we don't know the servers response format for the following requests, probably the IRequestCallback
	// won't be sufficient to transfer the results. So these methods have to be used with reservation.

	/** get the status of a specific transaction
		@param			_nTransId		The id of the transaction as got from <type>IRequestCallback</type>::acknowledged.
		@param			_rHandler		callback for status notifications.
										May be NULL.
	*/
	void		getStatus(TransID _nTransId, const ::vos::ORef< IRequestCallback >& _rHandler);

	/** get the status of all currently pending transactions
		@param			_rHandler		callback for status notifications. May be NULL.
	*/
	void		getAllStatus(const ::vos::ORef< IRequestCallback >& _rHandler);
#endif

#ifdef _REMOTE_PATH_TRANSLATION_
protected:

	/** as long as the session needs to translate some node paths for the server : translate the given node path
		as got from client of the remote session, so that the server understands it.
		@param			_rPath			the path to translate
	*/
    ::rtl::OUString translateClientPath(AbsolutePath const& _rPath);
#endif

private:
	/** disconnect from the configuration server.
	*/
	void		implDisconnect();

	/** starts writing an request, packed into an envelope. m_xWriter is used for this, and after returning
		from the method the parameters or the request transported in the envelope may be written. Afterwards the
		envelope should be closed with <method>closeEnvelopedRequest</method> (These two methods always have to
		be called in pairs, with a maximum nesting level of 1).
		<BR>
		The method will write the envelope prefix, the header, the body prefix and the param prefix, so you
		can start writing the param values immediately afterwards.
		@param			_rRequestName		the name of the request. will be put into the header of the envelope
		@param			_nParamCount		the number of params you intend to write
		@return								an string describing the unique transaction id used.
		@seealso		closeEnvelopedRequest
	*/
	::rtl::OUString		openEnvelopedRequest(const ::rtl::OUString& _rRequestName, sal_Int32 _nParamCount);

	/** closes the currently open envelope. To be called only after an preceding <method>openEnvelopedRequest</method>.
		<BR>
		The methods writes the param, body and envelope footers.
		@param			_rHandler			callback for status notifications. If not NULL, it will recieve
											notifications
		@seealso		openEnvelopedRequest
	*/
	void				closeEnvelopedRequest();

	/** writes a request parameter represented as string
		<BR>
		Note that "representes as string" does not mean that the param is of type "string". Instead it may
		be an "integer" or "boolean", but within the XML stream it occurs as character string.
		@param			_rTypeDesc			the type description for the parameter, e.g. "integer" or "String"
		@param			_rParamName			the name of the parameter, e.g. "userName" or "nodePath", dependent of the type of the current operation
		@param			_rValue				the value of the parameter
		@seealso		writeNodeParameter
	*/
	void				writeStringParameter(const ::rtl::OUString& _rTypeDesc, const ::rtl::OUString& _rParamName, const ::rtl::OUString& _rValue);

	/** write a request parameter represented as node data
		@param			_pProvider			the provider of the data to be written
		@param			_rNameParamValue	the value for the "name" parameter. For an update node, this would be
											"changedNode"
	*/
	void				writeNodeParameter(IDOMNodeDataProvider* _pProvider, const ::rtl::OUString& _rNameParamValue);

	/** write just the name tag for a new aser or group which does not contain any settings
		@param			_rNameParamValue	the value for the "name" parameter. For an update node, this would be
											"changedNode"
		@param			_rProfileName		the name of the profile to be written		
	*/
	void				writeEmptyProfile(const ::rtl::OUString& _rNameParamValue, const ::rtl::OUString& _rProfileName);

	/** calculates the next free client side transaction id. This means that the _rId will be set to
		a new value. Whether you use this value or not, the next call of this method will increment
		the id again, so no later call ever will produce the same id as you got from this one.
	*/
	void				nextRequestTransId(::rtl::OUString& /* out */ _rId);

	/** <method>closeSession</method> is asynchronous, but we have to do some cleanup after the close is done,
		we need our own callback for the "closeSession successfully done" server response
	*/
	void				implCloseSuccessfull();	

protected:
	/// Provider Identifications
	virtual IAdminProvider* asIAdminProvider();
	virtual IAdminProvider const* asIAdminProvider() const;	
	virtual IUpdateProvider* asIUpdateProvider();
	virtual IUpdateProvider const* asIUpdateProvider() const;

	/// IAdminProvider
	virtual void		addUser(const Name& _rUser, 
								const Name& _rGroup, 
								IDOMNodeDataProvider* _pNodeWriter, 
								const ::vos::ORef< IRequestCallback >& _rHandler);			
	virtual void		deleteUser(const Name& _rUser, 							   
								   const ::vos::ORef< IRequestCallback >& _rHandler);
	virtual void		addGroup(const Name& _rGroup, 
								 const Name& _rParent,
								IDOMNodeDataProvider* _pNodeWriter, 
								const ::vos::ORef< IRequestCallback >& _rHandler);			
	virtual void		deleteGroup(const Name& _rGroup, 							   
							     const ::vos::ORef< IRequestCallback >& _rHandler);
	

	/// IUpdateProvider
	virtual void	updateNode(const NodeID& _rNodeId, 
							   const AbsolutePath& _rNodePath,
							   const vos::ORef < OOptions >& _rOptions,
							   IDOMNodeDataProvider* _pNodeWriter, 
							   const ::vos::ORef< IDataRequestCallback >& _rHandler);

	virtual void    openTemplate(const AbsolutePath& _rNodePath,
								 const vos::ORef < OOptions >& _rOptions,
								 sal_Int32 _nLevel,
								 const ::vos::ORef< IOpenObjectCallback >& _rHandler)
	{
		OSL_ENSURE(false, "RemoteSession openTemplate(): NOT READY YET.");
	}
	
};


//..........................................................................
}	// namespace configmgr
//..........................................................................

#endif // _CONFIGMGR_SESSION_REMOTESESSION_HXX_


