/*************************************************************************
 *
 *  $RCSfile: xmltreebuilder.hxx,v $
 *
 *  $Revision: 1.25 $
 *
 *  last change: $Author: jb $ $Date: 2001/09/28 12:44:15 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

/* PLEASE DON'T DELETE ANY COMMENT LINES, ALSO IT'S UNNECESSARY. */

#ifndef _CONFIGMGR_XMLTREEBUILDER_HXX
#define _CONFIGMGR_XMLTREEBUILDER_HXX

#ifndef _CONFIGMGR_TREE_VALUENODE_HXX
#include "valuenode.hxx"
#endif
#ifndef CONFIGMGR_CHANGE_HXX
#include "change.hxx"
#endif
#ifndef CONFIGMGR_TREECHANGELIST_HXX
#include "treechangelist.hxx"
#endif
#ifndef CONFIGMGR_MISC_OPTIONS_HXX_
#include "options.hxx"
#endif

#ifndef _COMPHELPER_UNO3_HXX_
#include <comphelper/uno3.hxx>
#endif
#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>
#endif

#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif
#ifndef _COM_SUN_STAR_SCRIPT_XTYPECONVERTER_HPP_
#include <com/sun/star/script/XTypeConverter.hpp>
#endif
#ifndef _COM_SUN_STAR_XML_SAX_XEXTENDEDDOCUMENTHANDLER_HPP_
#include <com/sun/star/xml/sax/XExtendedDocumentHandler.hpp>
#endif

#ifndef INCLUDED_VECTOR
#include <vector>
#define INCLUDED_VECTOR
#endif
#ifndef INCLUDED_STACK
#include <stack>
#define INCLUDED_STACK
#endif
#ifndef INCLUDED_MEMORY
#include <memory>
#define INCLUDED_MEMORY
#endif



#ifdef LLA_PRIVAT_DEBUG
#include "msc_msg.hxx"
#endif

namespace configmgr
{
// -----------------------------------------------------------------------------

	namespace uno		= ::com::sun::star::uno;
	namespace sax		= ::com::sun::star::xml::sax;
	namespace script	= ::com::sun::star::script;
	namespace lang		= ::com::sun::star::lang;

	using ::rtl::OUString;

// -----------------------------------------------------------------------------

	struct ParserContext;
	class OValueHandler;
	class OAttributeParser; 
	class OTreeNodeFactory; 
	class OTreeChangeFactory; 


// -----------------------------------------------------------------------------
/*
	TYPE            |  Node
	----------------|-----------------------
	group (default) |  Subtree[group]
	set             |  Subtree[set]

	boolean         |  value[bool]
	short           |  value[int16]
	int             |  value[int32]
	long            |  value[int64]
	double          |  value[double]
	string          |  value[OUString]
	binary          |  value[sequence<int8>]

	derived="list"    sequence<...>
*/
// -----------------------------------------------------------------------------

	// Stack to hold a pointer for the subtree
	struct XMLNode
	{
        enum Type { Unknown, Group, Set, Value };
        node::Attributes    attributes;
        Type                type;			

		XMLNode() 
        : attributes()
        , type(Unknown)
        {}

		explicit 
        XMLNode(node::Attributes const& _attributes) 
        : attributes(_attributes)
        , type(Unknown)
        {}
	};


// -----------------------------------------------------------------------------
// #pragma message(MSC_MSG("Warum bin ich von DataConverter abgeleitet?"))
	typedef ::cppu::WeakImplHelper1<sax::XDocumentHandler> TreeBuilder_Base;

	class XMLTreeBuilder
	:	public TreeBuilder_Base
	{
	private:
		// Member for XML tracking
		// enum {
		// 	GROUP, TYPE, SET
		// };


		enum State {
			ELEMENT_EXPECTED,
			VALUE_TYPE_STARTED,
			NAME_STARTED,

			FORWARDING_DATA,
			IGNORING_DATA
		};

		// transitions in startElement(Name, Attributes)            						  Attributes
		// 						  node  value data  data_item  nodefault  default       Name
        // 	(0) ELEMENT_EXPECTED   1      2|3  	-       -        -           -            3    data="..." goto 5; derive="..." goto 4
        // 	(1) NODE_TYPE_STARTED  -      12  	-       -        -           -            -
        // 	(2) VALUE_TYPE_STARTED -      -   	-       -        -           -            -    derive="list" goto 4; else goto 5
        // 	(3) NAME_STARTED       -      -   	-       -        -           -            -    class="group" goto 1; type="..." goto 2
        // 	(4) DATA_EXPECTED      -      -   	6       9        -           -            -
        // 	(5) VALUE_TYPE_DONE    -      -   	-       -        -           -            - END
        // 	(6) DATA               -      -   	-       -        10          -            -
        // 	(7) DATA_DONE          -      -   	-       -        5           8            -
        // 	(8) DATA_DEFAULT       -      -   	-       -        -           -            - END
        // 	(9) DATA_ITEM          -      -   	-       -        -           -            - END
		// (10) DATA_ITEM_DONE     -      -   	-       -        5           11           -
		// (11) DATA_ITEM_DEFAULT  -      -   	-       -        -           -            - END


		// transitions in endElement
		//                      DATA_DONE  DATA_DEFAULT DATA_ITEM_DONE DATA_ITEM_DEFAULT VALUE_DONE DATA DATA_ITEM
		// (0) epsilon              1          3             1               4               2        3     4
		// (1) VALUE_DONE
		// (2) VALUE_EXPECTED
		// (3) DATA_DONE
		// (4) DATA_ITEM_DONE

		State m_eState;
		struct XMLNodeSubtree : public XMLNode
		{
			ISubtree *pSubtree;

			XMLNodeSubtree() 
            : XMLNode()
            , pSubtree(NULL)
            {}

            explicit
			XMLNodeSubtree(node::Attributes const& _attributes) 
            : XMLNode(_attributes)
            , pSubtree(NULL)
            {}
		};

		sal_Int16 m_nElementDepth;

		std::stack< XMLNodeSubtree, std::vector<XMLNodeSubtree> > m_aXMLNodeStack;

	protected:
		XMLTreeBuilder(std::auto_ptr<ISubtree> pSubtree, OUString const& _sModuleName, const vos::ORef<OOptions> &_aOptions, node::Attributes const& _aStartAttributes);
		friend class XMLTreeChangeListBuilder;

	protected:
		osl::Mutex				m_aMutex;	 // necessary since our wait methods have a timeout		
		std::auto_ptr<INode>	m_pRoot;

		std::auto_ptr<ParserContext>	m_pContext;
		std::auto_ptr<OValueHandler>	m_pValueHandler;
		uno::Reference<sax::XLocator>	m_xLocator;
#ifdef DBG_UTIL
		sal_Int32                     m_nLine;
#endif
		rtl::OString LineWarning(const rtl::OString& aWarn); // add a Line:(xyz) the given String

		void rootSubtree(std::auto_ptr<ISubtree> aSubtree);

	public:
        XMLTreeBuilder(OUString const& _sModuleName, const vos::ORef<OOptions> &_aOptions, node::Attributes const& _aStartAttributes);
		virtual ~XMLTreeBuilder();

	// checking the result
		bool hasResult();
		std::auto_ptr<ISubtree>	getResultTree();
		std::auto_ptr<INode>	getResultNode();

	// helper
		/// get the attribute parser in use
		OAttributeParser& getAttributeHandler() const; 
		ParserContext&    getParserContext() const;
        node::Attributes    getCurrentAttributes() const;

		/// get the node factory in use
		OTreeNodeFactory& getNodeFactory() const; 

	// XInterface
		virtual ::com::sun::star::uno::Any SAL_CALL queryInterface( const ::com::sun::star::uno::Type& aType ) throw(::com::sun::star::uno::RuntimeException);
		virtual void SAL_CALL acquire(  ) throw();
		virtual void SAL_CALL release(  ) throw();

	// XDocumentHandler
		virtual void SAL_CALL startDocument(void)
			throw (sax::SAXException, uno::RuntimeException);

		virtual void SAL_CALL endDocument(void)
			throw(sax::SAXException, uno::RuntimeException);
		virtual void SAL_CALL startElement(const OUString& aName,
										   const uno::Reference< sax::XAttributeList > &xAttribs)
			throw(sax::SAXException, uno::RuntimeException);
		virtual void SAL_CALL endElement(const OUString& aName)
			throw(sax::SAXException, uno::RuntimeException);
		virtual void SAL_CALL characters(const OUString& aChars)
			throw(sax::SAXException, uno::RuntimeException);

		virtual void SAL_CALL ignorableWhitespace(const OUString& aWhitespaces)
			throw(sax::SAXException, uno::RuntimeException){}
		
		virtual void SAL_CALL setDocumentLocator(const uno::Reference< sax::XLocator > &xLocator)
			throw(sax::SAXException, uno::RuntimeException);
		virtual void SAL_CALL processingInstruction(const OUString& aTarget,
													const OUString& aData)
			throw(sax::SAXException, uno::RuntimeException){}		

	};

// ------------------------- XML TreeChangeList Builder -------------------------
	class XMLTreeChangeListBuilder 
	: public TreeBuilder_Base
	{
		enum State {
			NODE_IGNORED,			// used for removed elements in the tree						
			FORWARDING_DATA,		// forwarded handling for values -> VALUE_NODE_DONE			
			NODE_EXPECTED			// there should follow the next node
		};				
		
	private:
		::osl::Mutex					m_aMutex;				// needed as this object is used in different threads
		TreeChangeList*					m_pTreeChangeList;		// change list may be overwritten by derived classes																
																// they have the ownership of this list		
		std::auto_ptr<ParserContext>	m_pContext;
		std::auto_ptr<OValueHandler>	m_pValueHandler;		// Values are dispatched to this handler		
		sal_Int32						m_nElementDepth;				
		State							m_eState;
		State							m_ePushedState;					 // single stack for State

		struct XMLNodeChange : public XMLNode
		{
			Change *pChange;

			XMLNodeChange() 
            : XMLNode()
            , pChange(NULL)
            {}

            explicit
			XMLNodeChange(node::Attributes const& _attributes) 
            : XMLNode(_attributes)
            , pChange(NULL)
            {}
		};

		std::stack< XMLNodeChange, std::vector<XMLNodeChange> > m_aXMLNodeStack;

	protected:
		struct Uninitialized {};
		XMLTreeChangeListBuilder(Uninitialized);		
		void init(OUString const& sModule, const vos::ORef<OOptions> &_aOptions);

		void setChangeList(TreeChangeList& _rList);
		::osl::Mutex& getMutex() {return m_aMutex;}

	public:
		explicit XMLTreeChangeListBuilder(TreeChangeList& _rList);		
		virtual ~XMLTreeChangeListBuilder();		

	// helper
		/// get the attribute parser in use
		OAttributeParser& getAttributeHandler() const; 
		/// get the context data for this parse run
		ParserContext&    getParserContext() const;
		/// get the node factory in use
		OTreeChangeFactory& getNodeFactory() const; 

        node::Attributes    getCurrentAttributes() const;

	// XDocumentHandler
		virtual void SAL_CALL startDocument(void)
			throw (sax::SAXException, uno::RuntimeException);

		virtual void SAL_CALL endDocument(void)
			throw(sax::SAXException, uno::RuntimeException);
		virtual void SAL_CALL startElement(const OUString& aName,
										   const uno::Reference< sax::XAttributeList > &xAttribs)
			throw(sax::SAXException, uno::RuntimeException);
		virtual void SAL_CALL endElement(const OUString& aName)
			throw(sax::SAXException, uno::RuntimeException);
		virtual void SAL_CALL characters(const OUString& aChars)
			throw(sax::SAXException, uno::RuntimeException);

		virtual void SAL_CALL ignorableWhitespace(const OUString& aWhitespaces)
			throw(sax::SAXException, uno::RuntimeException);

		virtual void SAL_CALL processingInstruction(const OUString& aTarget,
													const OUString& aData)
			throw(sax::SAXException, uno::RuntimeException){}
		
		virtual void SAL_CALL setDocumentLocator(const uno::Reference< sax::XLocator > &xLocator)
			throw(sax::SAXException, uno::RuntimeException){}		
	};


} // namespace configmgr
#endif /* Header double load protection */
	
	
