/*************************************************************************
 *
 *  $RCSfile: portalstream.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: dg $ $Date: 2001/01/25 11:23:34 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CONFIGMGR_SESSION_PORTALSTREAM_HXX_
#define _CONFIGMGR_SESSION_PORTALSTREAM_HXX_

#ifndef _COM_SUN_STAR_CONNECTION_XCONNECTION2_HPP_
#include <com/sun/star/connection/XConnection2.hpp>
#endif

#ifndef _CONFIGMGR_SESSION_SESSIONSTREAM_HXX_
#include "sessionstream.hxx"
#endif

//..........................................................................
namespace configmgr
{
//..........................................................................

#define ICONNECTION()	static_cast< ::com::sun::star::connection::XConnection2*>(m_pReader)
#define OCONNECTION()	static_cast< ::com::sun::star::connection::XConnection2*>(m_pWriter)

//==========================================================================
//= OPortalInputStream
//==========================================================================
class OPortalInputStream : public OSessionInputStream
{
protected:
	::com::sun::star::uno::Reference < ::com::sun::star::connection::XConnection2 >	m_aEnsureLifetime;

public:
	OPortalInputStream(::com::sun::star::connection::XConnection2* _pReader);

protected:
	virtual sal_Bool	implRead(::com::sun::star::uno::Sequence< sal_Int8 >& _aData, sal_Int32& _nBytes, sal_Bool _bWantAll)
		throw (::com::sun::star::io::NotConnectedException, ::com::sun::star::io::IOException);

	virtual void		implClose();
};

//==========================================================================
//= OPortalOutputStream
//==========================================================================
class OPortalOutputStream : public OSessionOutputStream
{
protected:
	::com::sun::star::uno::Reference < ::com::sun::star::connection::XConnection2 >	m_aEnsureLifetime;

public:
	OPortalOutputStream(::com::sun::star::connection::XConnection2* _pWriter);

	virtual void SAL_CALL flush(  ) throw(::com::sun::star::io::NotConnectedException, ::com::sun::star::io::BufferSizeExceededException, ::com::sun::star::io::IOException, ::com::sun::star::uno::RuntimeException);

protected:
	virtual sal_Int32	implWrite(const ::com::sun::star::uno::Sequence< sal_Int8 >& _rData);
	virtual void		implClose();
};

//..........................................................................
}	// namespace configmgr
//..........................................................................

#endif // _CONFIGMGR_SESSION_PORTALSTREAM_HXX_

