/*************************************************************************
 *
 *  $RCSfile: socketstream.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: lla $ $Date: 2001/03/23 09:37:46 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CONFIGMGR_SESSION_SOCKETSTREAM_HXX_
#include "socketstream.hxx"
#endif
#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif
#ifndef _CONFIGMGR_SESSION_RS_TYPES_HXX_
#include "rs_types.hxx"
#endif
#include "tracer.hxx"

#include <string.h>

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::io;
using namespace ::vos;
using namespace ::std;

//..........................................................................
namespace configmgr
{
//..........................................................................

#define ENTER()		\
	::osl::MutexGuard aGuard(m_aMutex);	\
	checkConnected();

#define CHECK_SOCKET_ERROR(socket)	\
	if (ISocketTypes::E_None != socket->getError())	\
	{	\
		::rtl::OUString	sSocketMessage;	\
		socket->getError(sSocketMessage);	\
		throw IOException(sSocketMessage, *this);	\
	}

//==========================================================================
//= OSocketInputStream
//==========================================================================
//--------------------------------------------------------------------------
OSocketInputStream::OSocketInputStream(OConnectorSocket* _pReader)
	:OSessionInputStream(_pReader)
	,m_pSocket(_pReader)
{
	OSL_ENSURE(ISOCKET() != NULL, "OSocketInputStream::OSocketInputStream : invalid socket !");

#if DBG_UTIL
	const TimeValue* pReceiveTimeout = ISOCKET()->getRecvTimeout();
	OSL_ENSURE(!pReceiveTimeout, "OSocketInputStream::OSocketInputStream : the stream must not have an receive timeout !");
#endif
//	if (!pReceiveTimeout || ((0 == pReceiveTimeout->Seconds) && (0 == pReceiveTimeout->Nanosec)))
//	{	// no timeout set -> do it ourself
//		OSL_TRACE("OSocketInputStream::OSocketInputStream : have to set the receive timeout myself !");
//		TimeValue aNewTimeout;
//		aNewTimeout.Seconds = 5;
//		aNewTimeout.Nanosec = 0;
//		ISOCKET()->setRecvTimeout(&aNewTimeout);
//	}
}

//--------------------------------------------------------------------------
sal_Bool OSocketInputStream::implRead(::com::sun::star::uno::Sequence< sal_Int8 >& _rData, sal_Int32& _nBytes, sal_Bool _bWantAll)
	throw (NotConnectedException, IOException)
{
	OSL_ENSURE(ISOCKET() != NULL, "OSocketInputStream::implRead : something went heavily wrong ... have no reader !");

	sal_Int8* pBuffer = _rData.getArray();
	if (!_bWantAll)
	{
		// wait (without timeout, thus blocking) until we have some bytes
		// (the call will be canceled if the socket is closed in another thread)
		ISOCKET()->isRecvReady(NULL);
		
		sal_Int32 nAvailable;
		CFG_TRACE_INFO("socket input stream: peeking");
		// peek the socket until there is at least one byte
		do
		{
			nAvailable = ISOCKET()->recv(pBuffer, _nBytes, ISocketTypes::TMsg_Peek);
#ifdef LLA_PRIVAT_DEBUG
			if (m_bClosed)
				// somebody called closeInput while we were reading. Though closeInput blocks at the moment (provided
				// that this method was called with m_aMutex locked, which is a precondition), we have to tell our own
				// caller that we're closed now.
				throw NotConnectedException(::rtl::OUString(), *this);
#endif
			if (nAvailable <= 0)
			{
				CHECK_SOCKET_ERROR(ISOCKET());
			}
			if (m_bClosed)
				// somebody called closeInput while we were reading. Though closeInput blocks at the moment (provided
				// that this method was called with m_aMutex locked, which is a precondition), we have to tell our own
				// caller that we're closed now.
				throw NotConnectedException(::rtl::OUString(), *this);
		}
		while (0 == nAvailable);
		CFG_TRACE_INFO_NI("socket input stream: %i bytes available", nAvailable);
		
		// now maybe read less than required
		if (nAvailable < _nBytes)
			_nBytes = nAvailable;
	}
				
	sal_Int32 nReadFromSocket = 0;
	do
	{
		nReadFromSocket = ISOCKET()->read(pBuffer, _nBytes);
		CFG_TRACE_INFO("socket input stream: read %i bytes", nReadFromSocket);

		if (m_bClosed)
			// somebody called closeInput while we were reading. Though closeInput blocks at the moment (provided
			// that this method was called with m_aMutex locked, which is a precondition), we have to tell our own
			// caller that we're closed now.
			throw NotConnectedException(::rtl::OUString(), *this);
	}
	while	(	(nReadFromSocket <= 0)
			&&	(	(ISocketTypes::E_None == ISOCKET()->getError())
				||	(ISocketTypes::E_TimedOut == ISOCKET()->getError())
				)
			);

	// check the stream for errors
	CHECK_SOCKET_ERROR(ISOCKET());

	_nBytes = nReadFromSocket;

	return sal_True;
}

//--------------------------------------------------------------------------
sal_Bool OSocketInputStream::isConnected()
{
	return OSessionInputStream::isConnected() && ISOCKET() && ISOCKET()->isValid();
}

//--------------------------------------------------------------------------
void OSocketInputStream::implClose()
{
	ISOCKET()->shutdown(ISocketTypes::TDirection_Read);
}

//==========================================================================
//= OSocketOutputStream
//==========================================================================
//--------------------------------------------------------------------------
OSocketOutputStream::OSocketOutputStream(OConnectorSocket* _pWriter)
	:OSessionOutputStream(_pWriter)
	,m_pSocket(_pWriter)
{
	OSL_ENSURE(OSOCKET() != NULL, "OSocketOutputStream::OSocketOutputStream : invalid socket !");
}

//--------------------------------------------------------------------------
sal_Int32 OSocketOutputStream::implWrite(const ::com::sun::star::uno::Sequence< sal_Int8 >& _rData)
{
	if (!_rData.getLength())
	{
		CFG_TRACE_WARNING("socket output stream: somebody attempted to write 0 bytes");
		return 0;
	}
	sal_Int32 nWritten = OSOCKET()->write(_rData.getConstArray(), _rData.getLength());
	if (nWritten <= 0)
	{
		CHECK_SOCKET_ERROR(OSOCKET());
	}

	OSL_ENSURE(nWritten == _rData.getLength(), "OSocketOutputStream::writeBytes : written insufficient bytes, but no error !");
		// if write does not handle all bytes, there must have been an error, in which case CHECK_SOCKET_ERROR should have
		// thrown an exception
	return nWritten;
}

//--------------------------------------------------------------------------
void OSocketOutputStream::implClose()
{
	OSOCKET()->shutdown(ISocketTypes::TDirection_Write);
}

//--------------------------------------------------------------------------
sal_Bool OSocketOutputStream::isConnected()
{
	return OSessionOutputStream::isConnected() && OSOCKET() && OSOCKET()->isValid();
}

//..........................................................................
}	// namespace configmgr
//..........................................................................


