/*************************************************************************
 *
 *  $RCSfile: localizednodebuilder.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: hjs $ $Date: 2001/11/08 15:18:28 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

/* PLEASE DON'T DELETE ANY COMMENT LINES, ALSO IT'S UNNECESSARY. */

#ifndef CONFIGMGR_LOCALIZEDNODEBUILDER_HXX
#define CONFIGMGR_LOCALIZEDNODEBUILDER_HXX

#include "valuenodebuilder.hxx"

#include "matchlocale.hxx"
#include "valuenode.hxx"

#include <vos/ref.hxx>

namespace configmgr
{
	namespace uno		= ::com::sun::star::uno;
	namespace sax		= ::com::sun::star::xml::sax;
	namespace lang		= ::com::sun::star::lang;

// -----------------------------------------------------------------------------

	class AbstractLocalizedNodeBuilder : public AbstractValueNodeBuilder
	{
	public:
		AbstractLocalizedNodeBuilder(ParserContext& rContext);
		AbstractLocalizedNodeBuilder(vos::ORef< AbstractValueNodeBuilder > const& rValueBuilder);
		
		bool isInValue() const;

	protected:
		// XDocumentHandler implementations
		virtual void SAL_CALL startElement(const rtl::OUString& aName,
										   const uno::Reference< sax::XAttributeList > &xAttribs)
			throw(sax::SAXException, uno::RuntimeException);
		virtual void SAL_CALL endElement(const rtl::OUString& aName)
			throw(sax::SAXException, uno::RuntimeException);

		virtual void SAL_CALL characters(const rtl::OUString& aChars)
			throw(sax::SAXException, uno::RuntimeException);
		virtual void SAL_CALL ignorableWhitespace(const rtl::OUString& aWhitespaces)
			throw(sax::SAXException, uno::RuntimeException);

	private:
		virtual bool acceptLocale(OUString const& aLocale, OUString& sNodeName) = 0;
		virtual void valueAvailable(std::auto_ptr<INode> aValueNode) = 0;

	protected:
		// AbstractValueNodeBuilder implementations
		virtual void startedNode();
		virtual void finishNode();
		// ISaxNodeBuilder implementations
		virtual void doPrepare();

	private:
		vos::ORef< AbstractValueNodeBuilder >	m_xValueBuilder;
		uno::Reference< sax::XDocumentHandler >	m_xActiveHandler;
	};
	
// -----------------------------------------------------------------------------
/*	class LocalizedValueNodeBuilder : public AbstractLocalizedNodeBuilder
	{
	public:
		LocalizedValueNodeBuilder(ParserContext& rContext);
		LocalizedValueNodeBuilder(vos::ORef< AbstractValueNodeBuilder > const& rValueBuilder);
		
		void setAcceptedLocales(rtl::OUString const & _sLocale);
		void setAcceptedLocales(lang::Locale  const & _aLocale);
		void setAcceptedLocales(uno::Sequence< rtl::OUString > const & _sLocale);
		void setAcceptedLocales(uno::Sequence< lang::Locale  > const & _aLocale);

	private: // AbstractLocalizedNodeBuilder
		virtual bool acceptLocale(OUString const& aLocale, OUString& sNodeName);
		virtual void valueAvailable(std::auto_ptr<INode> aValueNode);

	protected:
		// AbstractValueNodeBuilder implementations
		virtual void startedNode();
		virtual void finishNode();

		// ISaxNodeBuilder
		virtual void doPrepare();
		virtual std::auto_ptr<INode> doGetNode();

	private:
		std::auto_ptr<INode> implMakeNullNode();

		localehelper::FindBestLocale m_aLocaleFinder;
		std::auto_ptr<INode> m_pCurrentValue;
	};
*/	
// -----------------------------------------------------------------------------
	class LocalizedValueSetBuilder : public AbstractLocalizedNodeBuilder
	{
	public:
		LocalizedValueSetBuilder(ParserContext& rContext);
		LocalizedValueSetBuilder(vos::ORef< AbstractValueNodeBuilder > const& rValueBuilder);
		
	private: // AbstractLocalizedNodeBuilder
		virtual bool acceptLocale(OUString const& aLocale, OUString& sNodeName);
		virtual void valueAvailable(std::auto_ptr<INode> aValueNode);

	protected:
		// AbstractValueNodeBuilder implementations
		virtual void startedNode();

		// ISaxNodeBuilder
		virtual void doPrepare();
		virtual std::auto_ptr<INode> doGetNode();

	private:
		std::auto_ptr<ISubtree> implMakeSetNode();

		std::auto_ptr<ISubtree> m_aValueSet;
	};
	
// -----------------------------------------------------------------------------
	template <class Context>
	vos::ORef<AbstractLocalizedNodeBuilder> createLocalizedNodeBuilder(Context& rContext)
	{
		using namespace localehelper;

		vos::ORef<LocalizedValueSetBuilder> aNewBuilder( new LocalizedValueSetBuilder( rContext ) );
		return aNewBuilder.getBodyPtr();
	}
// -----------------------------------------------------------------------------
} // namespace

#endif

