/*************************************************************************
 *
 *  $RCSfile: writesubtreeasbinaryhandler.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: jb $ $Date: 2001/11/09 12:18:46 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include "writesubtreeasbinaryhandler.hxx"

#ifndef _CONFIGMGR_TREE_VALUENODE_HXX
#include "valuenode.hxx"
#endif
#ifndef CONFIGMGR_BINARYWRITEHANDLER_HXX_
#include "binarywritehandler.hxx"
#endif
#ifndef CONFIGMGR_TREE_NODEFACTORY_HXX
#include "treenodefactory.hxx"
#endif
#ifndef CONFIGMGR_PARSERCONTEXT_HXX
#include "parsercontext.hxx"
#endif

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_XML_SAX_XEXTENDEDDOCUMENTHANDLER_HPP_
#include <com/sun/star/xml/sax/XExtendedDocumentHandler.hpp>
#endif
#ifndef _COM_SUN_STAR_XML_SAX_XATTRIBUTELIST_HPP_
#include <com/sun/star/xml/sax/XAttributeList.hpp>
#endif

#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>
#endif

#ifndef INCLUDED_VECTOR
#include <vector>
#define INCLUDED_VECTOR
#endif

// -----------------------------------------------------------------------------
#define ASCII(x) rtl::OUString::createFromAscii(x)
// -----------------------------------------------------------------------------

namespace configmgr
{
	using namespace rtl;
	using namespace std;
	using namespace com::sun::star::uno;
	// using namespace comphelper;

	namespace css = com::sun::star;
	namespace lang = css::lang;
//	namespace io = css::io;

// -----------------------------------------------------------------------------
// ------------ ANALYSE binary write and read of a complete Subtree ------------
// -----------------------------------------------------------------------------

	OWriteSubtreeAsBinaryHandler::OWriteSubtreeAsBinaryHandler( const uno::Reference< sax::XDocumentHandler > &_xWriter, rtl::OUString const& _sFileURL, 
									uno::Reference< lang::XMultiServiceFactory > const& _rxServiceProvider,
									ParserContext& _rContext) 
        CFG_UNO_THROW1 (io::IOException)
	:
	 m_xHandler(_xWriter),
	 m_sFileURL(_sFileURL),
	 m_xServiceProvider(_rxServiceProvider),
	 m_rContext(_rContext),
	 m_eState(IGNORING_DATA),
	 m_nElementDepth(0)
	{
		m_pValueHandler.reset(new OValueHandler(m_rContext));

		// We need early open() the file, because, if we can't write to file, open() will throw, and in the
		// localsession we don't connect the fallen OWriteSubtreeAsBinaryHandler to the XMLTreeBuilder and
		// don't create a binary file.
		m_aWriter.reset(new OBinaryBaseWriter(m_sFileURL, m_xServiceProvider));
		m_aWriter->open();
	}

// -----------------------------------------------------------------------------
	OWriteSubtreeAsBinaryHandler::~OWriteSubtreeAsBinaryHandler()
	{
		volatile int dummy = 0;
	}
	
// -----------------------------------------------------------------------------
	// XDocumentHandler
	void OWriteSubtreeAsBinaryHandler::startDocument(void)
		throw (sax::SAXException, uno::RuntimeException)
	{
		// create a new OBinaryBaseWriter

		writeFileHeader(*m_aWriter, CFG_BINARY_SUBTREE_MAGIC);
		m_eState = ELEMENT_EXPECTED;

		m_xHandler->startDocument();
	}
	
// -----------------------------------------------------------------------------
	void OWriteSubtreeAsBinaryHandler::endDocument(void)
		throw(sax::SAXException, uno::RuntimeException)
	{
		m_xHandler->endDocument();
		writeStop(*m_aWriter);

		// write the magic at last again, so we must only read the last value to check if file is complete read.
		sal_Int32 nMagic2 = CFG_BINARY_SUBTREE_MAGIC;
		m_aWriter->write(nMagic2);

		m_aWriter->close();
	}
	
// -----------------------------------------------------------------------------

    // local struct to hold node data
    struct OWriteSubtreeAsBinaryHandler::BinaryNode
    {
         enum Type { Unknown, Group, Set, Value };
        
         NodeData            data;
         Type                type; // State for SET Mode

         explicit
 	    BinaryNode(node::Attributes const& _attributes) 
        : type(Unknown), data(_attributes) 
        {}
  };

// -----------------------------------------------------------------------------
	void OWriteSubtreeAsBinaryHandler::startElement(const rtl::OUString& _aName,
									  const uno::Reference< sax::XAttributeList > &_xAttrList)
		throw(sax::SAXException, uno::RuntimeException)
	{
        BinaryNode aBinNode(this->getCurrentAttributes());

		if (FORWARDING_DATA == m_eState)
		{
			// Forwarding perhaps for valueHandler

			++m_nElementDepth;
			m_pValueHandler->handler()->startElement(_aName, _xAttrList);
			// TODO : think about handling the exceptions ....
		}
		else
		{
			m_eState = NAME_STARTED;

			OAttributeParser& aParser = this->getAttributeHandler();

			OUString aName = aParser.getNodeName(_aName,_xAttrList);

			// do we have a set
			OUString sInstanceName;		// could be empty		
			OUString sInstanceModule;	// could be empty	

			if (aParser.getSetElementType(_xAttrList,sInstanceName,sInstanceModule))
			{				
                aBinNode.type		= BinaryNode::Set;
			}
			else if (aParser.isValue(_xAttrList))
			{
				// if we are a type="..." create a new valuehandler and set all handling to this class
                aBinNode.type		= BinaryNode::Value;

                m_eState = VALUE_TYPE_STARTED;
			}
			else
			{
				// group node
                aBinNode.type		= BinaryNode::Group;
			}

			if (aParser.isDeleted(_xAttrList))
			{
				m_eState = IGNORING_DATA;
				m_nElementDepth = 1;
				OSL_ENSURE(false, "Isn't handled correct yet");
			}

			// default for name without any attributes
			if (m_eState == NAME_STARTED)
			{
                OSL_ASSERT(aBinNode.type == BinaryNode::Group || aBinNode.type == BinaryNode::Set);

				OTreeNodeFactory aFactory;

				// read the attributes
				aParser.getNodeAttributes(_xAttrList, aBinNode.data.attributes);

				// create a new Subtree
				std::auto_ptr<ISubtree> pNewNode;
                if (aBinNode.type == BinaryNode::Set)
				{
					OSL_ENSURE(sInstanceName.getLength() != 0, "XMLTreeBuilder::startElement : type=set, but no template instance name !");

					pNewNode = aFactory.createSetNode(aName,sInstanceName,sInstanceModule,aBinNode.data.attributes);
				}
				else
				{
					OSL_ENSURE(sInstanceName.getLength() == 0, "XMLTreeBuilder::startElement : type!=set, but has template instance name !");
					OSL_ENSURE(sInstanceModule.getLength() == 0, "XMLTreeBuilder::startElement : type!=set, but has template module name !");

					pNewNode = aFactory.createGroupNode(aName,aBinNode.data.attributes);
				}
				OBinaryWriteHandler aHandler(*m_aWriter, m_xServiceProvider, false);
				aHandler.applyToNode(*pNewNode);

				// create a mark
				aBinNode.data.mark.create(m_aWriter.get());
			}
			else if (m_eState == VALUE_TYPE_STARTED)
			{
                OSL_ASSERT(aBinNode.type == BinaryNode::Value);

				m_eState = FORWARDING_DATA;
				m_nElementDepth = 1;
				
				m_pValueHandler->prepare(_xAttrList, this->getCurrentAttributes());
				//	m_pValueHandler->handler().startDocument();
				m_pValueHandler->handler()->startElement(_aName, _xAttrList);
			}
			else
			{
				OSL_ENSURE(false, "NO Subtree(set) and no ValueNode, something goes wrong.");
			}
		}
		m_aNodeStack.push(aBinNode.data);

		// forward to the original
		m_xHandler->startElement(_aName, _xAttrList);
	}
	
// -----------------------------------------------------------------------------
	void OWriteSubtreeAsBinaryHandler::endElement(const rtl::OUString& _aName)
		throw(sax::SAXException, uno::RuntimeException)
	{
		if (FORWARDING_DATA == m_eState)
		{
			// Forwarding perhaps for valueHandler
			m_pValueHandler->handler()->endElement(_aName);
			
			if (0 == --m_nElementDepth)
			{
				// we left the node description
				
				std::auto_ptr<INode> pNode = m_pValueHandler->createNode();

				OBinaryWriteHandler aHandler(*m_aWriter, m_xServiceProvider, true);
				aHandler.applyToNode(*pNode);
				
				m_eState = ELEMENT_EXPECTED;
			}
		}

		m_xHandler->endElement(_aName);

		// delete a created Mark.
		OSL_ENSURE(!m_aNodeStack.empty(), "There is a problem with the Stack, it must not be empty");

		OMark & rMark = m_aNodeStack.top().mark;
		if (rMark.is())
		{
			writeStop(*m_aWriter);
			rMark.store(/*m_pWriter*/);
		}
		m_aNodeStack.pop();
	}
	
// -----------------------------------------------------------------------------
	void OWriteSubtreeAsBinaryHandler::characters(const rtl::OUString& _aChars)
		throw(sax::SAXException, uno::RuntimeException)
	{
		if (FORWARDING_DATA == m_eState)
		{
			// Forwarding perhaps for valueHandler
			m_pValueHandler->handler()->characters(_aChars);
			// TODO : think about handling the exceptions ....
		}
		m_xHandler->characters(_aChars);
	}
	
// -----------------------------------------------------------------------------
	void OWriteSubtreeAsBinaryHandler::ignorableWhitespace(const rtl::OUString& aWhitespaces)
		throw(sax::SAXException, uno::RuntimeException)
	{
		m_xHandler->ignorableWhitespace(aWhitespaces);
	}
	
// -----------------------------------------------------------------------------
	void OWriteSubtreeAsBinaryHandler::processingInstruction(const rtl::OUString& aTarget,
											   const rtl::OUString& aData)
		throw(sax::SAXException, uno::RuntimeException)
	{
		m_xHandler->processingInstruction(aTarget, aData);
	}
	
// -----------------------------------------------------------------------------
	void OWriteSubtreeAsBinaryHandler::setDocumentLocator(const uno::Reference< sax::XLocator > &xLocator)
		throw(sax::SAXException, uno::RuntimeException)
	{
		m_xHandler->setDocumentLocator(xLocator);
	}

// -----------------------------------------------------------------------------
	OAttributeParser& OWriteSubtreeAsBinaryHandler::getAttributeHandler() const
	{
		OSL_ASSERT(m_pValueHandler.get());
		return m_rContext.aAttributeParser;
	}

// -----------------------------------------------------------------------------
    node::Attributes OWriteSubtreeAsBinaryHandler::getCurrentAttributes() const
	{
        if (m_aNodeStack.empty())
            return m_rContext.aBaseAttributes;

        else
		    return m_aNodeStack.top().attributes;;
	}
	
// -----------------------------------------------------------------------------

} // namespace configmgr
