/*************************************************************************
 *
 *  $RCSfile: writesubtreeasbinaryhandler.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: jb $ $Date: 2001/11/09 12:18:46 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CONFIGMGR_BINARYHANDLER_HXX
#define CONFIGMGR_BINARYHANDLER_HXX


#ifndef _CONFIGMGR_TREE_VALUENODE_HXX
#include "valuenode.hxx"
#endif
#ifndef CONFIGMGR_UTILITY_HXX_
#include "utility.hxx"
#endif

#ifndef CONFIGMGR_BINARYWRITER_HXX
#include "binarywriter.hxx"
#endif
#ifndef CONFIGMGR_ATTRIBUTEPARSER_HXX
#include "attributeparser.hxx"
#endif
#ifndef CONFIGMGR_VALUEHANDLER_HXX
#include "valuehandler.hxx"
#endif

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif

#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>
#endif

#ifndef _COM_SUN_STAR_XML_SAX_XEXTENDEDDOCUMENTHANDLER_HPP_
#include <com/sun/star/xml/sax/XExtendedDocumentHandler.hpp>
#endif

#ifndef _COM_SUN_STAR_XML_SAX_XATTRIBUTELIST_HPP_
#include <com/sun/star/xml/sax/XAttributeList.hpp>
#endif

#ifndef INCLUDED_STACK
#include <stack>
#define INCLUDED_STACK
#endif

// -----------------------------------------------------------------------------
namespace configmgr
{
	namespace css =  com::sun::star;
	namespace sax =  css::xml::sax;
	namespace uno =  css::uno;
	namespace lang = css::lang;

// ------------ ANALYSE binary write and read of a complete Subtree ------------

//	bool write(ISubtree const* _pSubtree, rtl::OUString const& _aFilename, 
//			   uno::Reference< lang::XMultiServiceFactory > const& _xServiceProvider);
	
// -----------------------------------------------------------------------------
	typedef ::cppu::WeakImplHelper1<sax::XDocumentHandler> CmDocumentHandler_BASE;
	class OWriteSubtreeAsBinaryHandler : public CmDocumentHandler_BASE
	{
		enum State {
			VALUE_TYPE_STARTED,
			ELEMENT_EXPECTED,
			NAME_STARTED,
			
			FORWARDING_DATA,
			IGNORING_DATA
		};
	public:
		
		OWriteSubtreeAsBinaryHandler( const uno::Reference< sax::XDocumentHandler > &_xWriter, rtl::OUString const& _sFileURL, 
						const uno::Reference< lang::XMultiServiceFactory >& _rxServiceProvider,
						ParserContext& _rContext) 
            CFG_UNO_THROW1 (io::IOException);

		~OWriteSubtreeAsBinaryHandler();
		// XDocumentHandler
		virtual void SAL_CALL startDocument(void)
			throw (sax::SAXException, uno::RuntimeException);
		virtual void SAL_CALL endDocument(void)
			throw(sax::SAXException, uno::RuntimeException);
		virtual void SAL_CALL startElement(const rtl::OUString& aName,
										   const uno::Reference< sax::XAttributeList > &xAttribs)
			throw(sax::SAXException, uno::RuntimeException);
		virtual void SAL_CALL endElement(const rtl::OUString& aName)
			throw(sax::SAXException, uno::RuntimeException);
		virtual void SAL_CALL characters(const rtl::OUString& aChars)
			throw(sax::SAXException, uno::RuntimeException);

		virtual void SAL_CALL ignorableWhitespace(const rtl::OUString& aWhitespaces)
			throw(sax::SAXException, uno::RuntimeException);

		virtual void SAL_CALL processingInstruction(const rtl::OUString& aTarget,
													const rtl::OUString& aData)
			throw(sax::SAXException, uno::RuntimeException);
		virtual void SAL_CALL setDocumentLocator(const uno::Reference< sax::XLocator > &xLocator)
			throw(sax::SAXException, uno::RuntimeException);
		
		OAttributeParser& getAttributeHandler() const;

        node::Attributes getCurrentAttributes() const;
	private:
		/// get the attribute parser in use
		uno::Reference< sax::XDocumentHandler > const m_xHandler;  // the parser that handles the found substructure
		rtl::OUString m_sFileURL;
		std::auto_ptr<OBinaryBaseWriter> m_aWriter;

        // every startElement must know it's own Mark
        struct NodeData { 
            OMark mark; 
            node::Attributes attributes; 

            NodeData(node::Attributes const& _attributes)
            : mark(), attributes(_attributes)
            {}
        };
		std::stack<NodeData> m_aNodeStack; 
        struct BinaryNode;
		friend struct BinaryNode;
		std::auto_ptr<OValueHandler> m_pValueHandler;
		ParserContext&               m_rContext;
		State m_eState;

		sal_Int16 m_nElementDepth;
		uno::Reference< lang::XMultiServiceFactory > m_xServiceProvider;
	};

} // namespace configmgr

#endif
