/*************************************************************************
 *
 *  $RCSfile: xmltreebuilder.cxx,v $
 *
 *  $Revision: 1.31 $
 *
 *  last change: $Author: jb $ $Date: 2001/11/05 16:50:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdio.h>

#include "xmltreebuilder.hxx"

#ifndef CONFIGMGR_VALUEHANDLER_HXX
#include "valuehandler.hxx"
#endif
#ifndef CONFIGMGR_PARSERCONTEXT_HXX
#include "parsercontext.hxx"
#endif
#ifndef CONFIGMGR_ATTRIBUTEPARSER_HXX
#include "attributeparser.hxx"
#endif
#ifndef CONFIGMGR_TREE_NODEFACTORY_HXX
#include "treenodefactory.hxx"
#endif
#ifndef CONFIGMGR_TREE_CHANGEFACTORY_HXX
#include "treechangefactory.hxx"
#endif

#ifndef _CONFIGMGR_TRACER_HXX_
#include "tracer.hxx"
#endif

#ifndef _CPPUHELPER_TYPEPROVIDER_HXX_
#include <cppuhelper/typeprovider.hxx>
#endif

namespace configmgr
{
    using namespace com::sun::star::uno;
    using namespace com::sun::star::xml::sax;
    using namespace rtl;
    using namespace std;

    
// -----------------------------------------------------------------------------
#ifndef ASCII
	static inline OUString ASCII(const char* aStr)
	{
		return OUString::createFromAscii(aStr);
	}
#endif

// ---------------------------------- C/D Tors ----------------------------------
	XMLTreeBuilder::XMLTreeBuilder( OUString const& _sModule, 
                                    const vos::ORef<OOptions> &_aOptions, 
                                    node::Attributes const& _aStartAttributes) 
	: m_eState(IGNORING_DATA) // ?
	, m_nElementDepth(-1)
	, m_aXMLNodeStack()
	, m_aMutex()		
	, m_pRoot(NULL)
	, m_xLocator()
#if defined(DBG_UTIL)
	,m_nLine(0)
#endif
	{
		m_pContext.reset(new ParserContext(_sModule, _aStartAttributes, _aOptions->getTypeConverter()));
		m_pValueHandler.reset(new OValueHandler(*m_pContext));
	}

// -----------------------------------------------------------------------------
	XMLTreeBuilder::XMLTreeBuilder(std::auto_ptr<ISubtree> pSubtree_,								   
								   OUString const& _sModule, 
								   const vos::ORef<OOptions> &_aOptions,
                                   node::Attributes const& _aStartAttributes) 
	: m_eState(IGNORING_DATA) // ?
	, m_nElementDepth(-1)
	, m_aXMLNodeStack()
	, m_aMutex()		
	, m_pRoot(NULL)
	, m_xLocator()
#if defined(DBG_UTIL)
	,m_nLine(0)
#endif
	{
		m_pContext.reset(new ParserContext(_sModule, _aStartAttributes, _aOptions->getTypeConverter()));
		m_pValueHandler.reset(new OValueHandler(*m_pContext));

		rootSubtree(pSubtree_);
	}

// -----------------------------------------------------------------------------
	XMLTreeBuilder::~XMLTreeBuilder()
	{
	}
// -----------------------------------------------------------------------------
	OAttributeParser& XMLTreeBuilder::getAttributeHandler() const
	{
		return getParserContext().aAttributeParser;
	}
// -----------------------------------------------------------------------------
	ParserContext& XMLTreeBuilder::getParserContext() const
	{
		OSL_ASSERT(m_pContext.get());
		return *m_pContext;
	}
	
// -----------------------------------------------------------------------------
    node::Attributes XMLTreeBuilder::getCurrentAttributes() const
	{
        if (m_aXMLNodeStack.empty())
            return getParserContext().aBaseAttributes;

        else
		    return m_aXMLNodeStack.top().attributes;;
	}
	
// -----------------------------------------------------------------------------
	OTreeNodeFactory& XMLTreeBuilder::getNodeFactory() const
	{
		return getParserContext().aNodeFactory;
	}
// -----------------------------------------------------------------------------
	bool XMLTreeBuilder::hasResult()
	{
		osl::MutexGuard aGuard(m_aMutex);

		return m_pRoot.get() != NULL;
	}
// -----------------------------------------------------------------------------
	auto_ptr<ISubtree>	XMLTreeBuilder::getResultTree()
	{
		osl::MutexGuard aGuard(m_aMutex);
		
		auto_ptr<ISubtree> pResult;
		if (m_pRoot.get())
		{
			if (m_pRoot->ISA(ISubtree))
			{
				pResult.reset( m_pRoot.release()->asISubtree() );
			}
		}
		return pResult;
	}
// -----------------------------------------------------------------------------
	std::auto_ptr<INode> XMLTreeBuilder::getResultNode()
	{
		osl::MutexGuard aGuard(m_aMutex);
		
		return m_pRoot;
	}
// -----------------------------------------------------------------------------

	void XMLTreeBuilder::rootSubtree(std::auto_ptr<ISubtree> pSubtree_)
	{
		OSL_ENSURE(m_aXMLNodeStack.empty(), "Cannot reroot TreeBuilder unless stack is empty");

		ISubtree* pTree = pSubtree_.get();
		m_pRoot.reset( pSubtree_.release() );
		// we must set the subtree in the stack, because stack.top().pSubtree will be used to set a new value
		XMLNodeSubtree aXMLNode;
		aXMLNode.pSubtree = pTree;
		m_aXMLNodeStack.push(aXMLNode);

		m_eState = ELEMENT_EXPECTED;
	}

// ------------------------------ XInterface ------------------------------
	uno::Any SAL_CALL XMLTreeBuilder::queryInterface(uno::Type const& rType) throw (uno::RuntimeException)
	{
		uno::Any aRet = TreeBuilder_Base::queryInterface(rType);

		return aRet;
	}

// -----------------------------------------------------------------------------
	void SAL_CALL XMLTreeBuilder::acquire() throw ()
	{
		TreeBuilder_Base::acquire();
	}

// -----------------------------------------------------------------------------
	void SAL_CALL XMLTreeBuilder::release() throw ()
	{
		TreeBuilder_Base::release();
	}
// ------------------------------ XDocumentHandler ------------------------------
	void XMLTreeBuilder::startDocument( void )
		throw (SAXException, RuntimeException)
	{
		m_eState = ELEMENT_EXPECTED;
	}

// -----------------------------------------------------------------------------
	void XMLTreeBuilder::endDocument( void )
		throw (SAXException, RuntimeException)
	{
		// PRE: call after last element has read
		// m_aCondition.set();				 // will not block
	}

// -----------------------------------------------------------------------------
	void XMLTreeBuilder::startElement(const OUString& _aName,
									  const Reference< XAttributeList > &_xAttrList)
		throw(SAXException, RuntimeException)
	{
		// PRE: a new element was begin <aName>
		//      xAttrList contains every element after aName and '>'

		// Prepare attributes.

		::osl::MutexGuard aGuard(m_aMutex);

		if (IGNORING_DATA == m_eState)
		{
			// ignoring everything (e.g. for a deleted node)
			++m_nElementDepth;
		}
		else if (FORWARDING_DATA == m_eState)
		{
			// Forwarding perhaps for valueHandler

			++m_nElementDepth;
			m_pValueHandler->handler()->startElement(_aName, _xAttrList);
			// TODO : think about handling the exceptions ....
		}
		else
		{
#if defined(DBG_UTIL)
			// this is now always need for correct error messages
			if (m_xLocator.is())
			{
				m_nLine = m_xLocator->getLineNumber();
			}
#endif
			// default
			m_eState = NAME_STARTED;

			XMLNodeSubtree aXMLNode(this->getCurrentAttributes());

			OAttributeParser& aParser = this->getAttributeHandler();

			OUString aName = aParser.getNodeName(_aName,_xAttrList);

			// do we have a set
			OUString sInstanceName;		// could be empty		
			OUString sInstanceModule;	// could be empty	

			if (aParser.getSetElementType(_xAttrList,sInstanceName,sInstanceModule))
			{				
                aXMLNode.type = XMLNode::Set;
			}
			else if (aParser.isValue(_xAttrList))
			{
				// if we are a type="..." create a new valuehandler and set all handling to this class
                aXMLNode.type = XMLNode::Value;

                m_eState = VALUE_TYPE_STARTED;
			}
			else
			{
				// group node
                aXMLNode.type = XMLNode::Group;
			}

			if (aParser.isDeleted(_xAttrList))
			{
				m_eState = IGNORING_DATA;
				m_nElementDepth = 1;
			}

			// default for name without any attributes
			if (m_eState == NAME_STARTED)
			{
				OSL_ASSERT(aXMLNode.type != XMLNode::Unknown);
				OSL_ASSERT(aXMLNode.type != XMLNode::Value);

				OTreeNodeFactory& aFactory = this->getNodeFactory();

				// read the attributes
				aParser.getNodeAttributes(_xAttrList, aXMLNode.attributes);

				// create a new Subtree
				std::auto_ptr<ISubtree> pNewNode;
                if (aXMLNode.type == XMLNode::Set)
				{
					OSL_ENSURE(sInstanceName.getLength() != 0, LineWarning("XMLTreeBuilder::startElement : type=set, but no template instance name !"));
//					OSL_ENSURE(sInstanceModule.getLength() != 0, LineWarning("XMLTreeBuilder::startElement : type=set, but no template module name !"));

					pNewNode = aFactory.createSetNode(aName,sInstanceName,sInstanceModule,aXMLNode.attributes);
				}
				else
				{
				    OSL_ASSERT(aXMLNode.type == XMLNode::Group);
					OSL_ENSURE(sInstanceName.getLength() == 0, LineWarning("XMLTreeBuilder::startElement : type!=set, but has template instance name !"));
					OSL_ENSURE(sInstanceModule.getLength() == 0, LineWarning("XMLTreeBuilder::startElement : type!=set, but has template module name !"));

					pNewNode = aFactory.createGroupNode(aName,aXMLNode.attributes);
				}

				INode* pNew = NULL;

				if (m_pRoot.get() != NULL)
				{
					if (!m_aXMLNodeStack.empty())
					{
						ISubtree* pSubtree = m_aXMLNodeStack.top().pSubtree;

						pNew = pSubtree->addChild(auto_ptr<INode>(pNewNode.release()));
					}
					else
					{
						OString aStr = "xmltreebuilder: Stack is empty, read problem with: ";
						aStr += rtl::OUStringToOString(aName,RTL_TEXTENCODING_ASCII_US).getStr();
						OSL_ENSURE(false, LineWarning(aStr));
					}
				}
				else
				{
					m_pRoot.reset( pNewNode.release() );
					pNew = m_pRoot.get();
				}

				aXMLNode.pSubtree = static_cast<ISubtree*>(pNew);
				m_eState = ELEMENT_EXPECTED;

				m_aXMLNodeStack.push(aXMLNode);
			}
			else if (m_eState == VALUE_TYPE_STARTED)
			{
                OSL_ASSERT(aXMLNode.type == XMLNode::Value);

				aXMLNode.pSubtree = NULL;
				m_eState = FORWARDING_DATA;
				m_nElementDepth = 1;

				m_pValueHandler->prepare(_xAttrList, aXMLNode.attributes);
			//	m_pValueHandler->handler().startDocument();
				m_pValueHandler->handler()->startElement(_aName, _xAttrList);
			}
		}
	}

// -----------------------------------------------------------------------------
	void XMLTreeBuilder::endElement(const OUString& _aName)
		throw(SAXException, RuntimeException)
	{
		// PRE: </aName>

		if (IGNORING_DATA == m_eState)
		{
			if (0 == --m_nElementDepth)
			{
				m_eState = ELEMENT_EXPECTED;
			}
		}
		else if (FORWARDING_DATA == m_eState)
		{
			// Forwarding perhaps for valueHandler
			m_pValueHandler->handler()->endElement(_aName);

			if (0 == --m_nElementDepth)
			{
				// we left the node description

				//m_pValueHandler->handler()->endDocument();

				// create node by ValueHandler
				std::auto_ptr<INode> pNode = m_pValueHandler->createNode();
				if (m_pRoot.get() == NULL)
				{
					m_pRoot = pNode;
				}
				else
				{
					ISubtree* pSubtree = m_aXMLNodeStack.top().pSubtree;
					if (pSubtree)				 // Node could be NULL, if read problems with twice same named Elements
						pSubtree->addChild( pNode );
				}
				
				m_eState = ELEMENT_EXPECTED;
			}
			// TODO : think about handling the exceptions ....
		}
		else
		{
			::osl::MutexGuard aGuard(m_aMutex);

			if (m_eState == ELEMENT_EXPECTED)
			{
				// remove an element from the stack
				if (m_aXMLNodeStack.size() > 0)
					m_aXMLNodeStack.pop();
			}
		}
	}

// -----------------------------------------------------------------------------
	void XMLTreeBuilder::characters(const OUString& _aChars)
		throw(SAXException, RuntimeException)
	{
		// PRE: all between <T> and </T>, T can be a valid Value
		// _aValue = _aValue + String(aName);		 // append(!) value
		if (FORWARDING_DATA == m_eState)
		{
			// Forwarding perhaps for valueHandler
			m_pValueHandler->handler()->characters(_aChars);
			// TODO : think about handling the exceptions ....
		}
		else if (IGNORING_DATA != m_eState)
			OSL_ENSURE(_aChars.trim().getLength() == 0, "XMLTreeBuilder: Warning: Ignoring non-whitespace characters");
	}
// -----------------------------------------------------------------------------
	void XMLTreeBuilder::setDocumentLocator(const uno::Reference< sax::XLocator > &xLocator)
		throw(sax::SAXException, uno::RuntimeException)
	{
		m_xLocator = xLocator;
	}

// -----------------------------------------------------------------------------
	OString XMLTreeBuilder::LineWarning(const OString &aWarn)
	{
		if (m_xLocator.is())
		{
			sal_Int32 nLine = m_xLocator->getLineNumber();
			OString aLine= OString::valueOf(nLine);

			OString aStr = aWarn;
			aStr = aStr + " Line: (" + aLine + ")";

			return aStr;
		}
		return aWarn;
	}

// -----------------------------------------------------------------------------
// --------------------------- TreeChangeListBuilder ---------------------------
// -----------------------------------------------------------------------------
XMLTreeChangeListBuilder::XMLTreeChangeListBuilder(Uninitialized)
		:m_pTreeChangeList(NULL)
{
	// no init yet
}

// -----------------------------------------------------------------------------
XMLTreeChangeListBuilder::XMLTreeChangeListBuilder(TreeChangeList& _rList)
		:m_pTreeChangeList(&_rList)	
{
	this->init(_rList.getModuleName().toString(), _rList.getOptions());
}
// -----------------------------------------------------------------------------
void XMLTreeChangeListBuilder::init(OUString const& _sModule, const vos::ORef<OOptions> &_aOptions)
{		
    node::Attributes const aChangeTreeStartAttributes; // default-constructed

	m_pContext.reset(new ParserContext(_sModule, aChangeTreeStartAttributes, _aOptions->getTypeConverter()));
	m_pValueHandler.reset(new OValueHandler(*m_pContext));
}

// -----------------------------------------------------------------------------
XMLTreeChangeListBuilder::~XMLTreeChangeListBuilder()
{
}

// -----------------------------------------------------------------------------
ParserContext& XMLTreeChangeListBuilder::getParserContext() const
{
	OSL_ASSERT(m_pContext.get());
	return *m_pContext;
}

// -----------------------------------------------------------------------------
OAttributeParser& XMLTreeChangeListBuilder::getAttributeHandler() const
{
	return getParserContext().aAttributeParser;
}
	
// -----------------------------------------------------------------------------
node::Attributes XMLTreeChangeListBuilder::getCurrentAttributes() const
{
    if (m_aXMLNodeStack.empty())
        return getParserContext().aBaseAttributes;

    else
		return m_aXMLNodeStack.top().attributes;
}
	
// -----------------------------------------------------------------------------
OTreeChangeFactory& XMLTreeChangeListBuilder::getNodeFactory() const
{
    // so far change factories don't have any state
    static OTreeChangeFactory aSingleChangeFactory;
    return aSingleChangeFactory;
}

// ------------------------------ XDocumentHandler ------------------------------
void XMLTreeChangeListBuilder::startDocument( void )
	throw (SAXException, RuntimeException)
{
	::osl::MutexGuard aGuard(m_aMutex);

	OSL_ENSURE(m_pTreeChangeList, "XMLTreeChangeListBuilder::startDocument: no ChangeList given, possible error");

	// empty the node stack if necessary
	while (m_aXMLNodeStack.size())
		m_aXMLNodeStack.pop();

	// do nothing if there is no changelist
	if (!m_pTreeChangeList)
	{
		m_eState = NODE_IGNORED;
		m_ePushedState = NODE_EXPECTED;
	}
	else
		m_ePushedState = m_eState = NODE_EXPECTED;
}

// -----------------------------------------------------------------------------
void XMLTreeChangeListBuilder::endDocument( void )
	throw (SAXException, RuntimeException)
{
	::osl::MutexGuard aGuard(m_aMutex);

	OSL_ENSURE(!m_aXMLNodeStack.size(), "XMLTreeChangeListBuilder::endDocument: stack is not empty");
	// Treebuilder does not own the changes list so free the reference now
	m_pTreeChangeList = NULL;
}

// -----------------------------------------------------------------------------
void XMLTreeChangeListBuilder::startElement(const OUString& _aName,
											const Reference< XAttributeList > &_xAttrList)
	throw(SAXException, RuntimeException)
{
	::osl::MutexGuard aGuard(m_aMutex);
	// PRE: a new element was begin <aName>
	//      xAttrList contains every element after aName and '>'

	// special current states
	if (NODE_IGNORED == m_eState)
	{
		OSL_ENSURE(m_nElementDepth, "XMLTreeChangeListBuilder::startElement : m_eState & m_nElementDepth are inconsistent !");
		++m_nElementDepth;
	}
	else if (FORWARDING_DATA == m_eState)
	{
		++m_nElementDepth;
		if (m_pValueHandler.get() && m_pValueHandler->isActive())
			m_pValueHandler->handler()->startElement(_aName, _xAttrList);
		// TODO : think about handling the exceptions ....
	}
	else
	{
		XMLNodeChange aXMLNode(this->getCurrentAttributes());

		OAttributeParser& aParser = this->getAttributeHandler();

		OUString aName = aParser.getNodeName(_aName,_xAttrList);

		// do we have a set
		OUString sInstanceName;		// could be empty		
		OUString sInstanceModule;	// could be empty	

		if (aParser.getSetElementType(_xAttrList,sInstanceName,sInstanceModule))
		{				
            aXMLNode.type = XMLNode::Set;
		}
		else if (aParser.isValue(_xAttrList))
		{
            aXMLNode.type = XMLNode::Value;
		}
		else
		{
			// group node
            aXMLNode.type = XMLNode::Group;
		}

		if (aParser.isDeleted(_xAttrList))
		{
			OSL_ENSURE(!m_aXMLNodeStack.empty(), "XMLTreeChangeListBuilder::startElement : NodeStack is invalid !");
			if (!m_aXMLNodeStack.empty())
			{
  				OSL_ENSURE(m_aXMLNodeStack.top().pChange->ISA(SubtreeChange), "XMLTreeChangeListBuilder::startElement : Invalid Change Parent!");
				SubtreeChange* pParent = static_cast<SubtreeChange*>(m_aXMLNodeStack.top().pChange);
                pParent->addChange(base_ptr(getNodeFactory().createRemoveNodeChange( aName)));
			}

			// ignore further elements
			m_ePushedState = NODE_EXPECTED;
			m_eState = NODE_IGNORED;
			m_nElementDepth = 1;
		}
        else if ( aXMLNode.type != XMLNode::Value )
		{
			OSL_ASSERT(aXMLNode.type == XMLNode::Group || aXMLNode.type == XMLNode::Set);
			// independent of the state (replaced or modified) we build a subtree change
			// this change is only temporary. We have to adjust this changes with the
			// cache tree, to see if we have to replace a subtreechange with an addnode
			SubtreeChange* pNewChange = NULL;

			aParser.getNodeAttributes(_xAttrList,aXMLNode.attributes);
			
			if (m_aXMLNodeStack.empty())
			{
				m_pTreeChangeList->root.setNodeName(aName);
				aXMLNode.pChange = pNewChange = &(m_pTreeChangeList->root);
			}
			else 
			{
                // a new internal (tree) node
                std::auto_ptr<SubtreeChange> pNewTree;
				if (aXMLNode.type == XMLNode::Set)
				{								
					OSL_ENSURE(sInstanceName.getLength() != 0, "XMLTreeChangeListBuilder::startElement : type=set, but no template instance name !");
	//				OSL_ENSURE(sInstanceModule.getLength() != 0, "XMLTreeChangeListBuilder::startElement : type=set, but no template module name !");
		
					pNewTree =  getNodeFactory().createSetNodeChange(aName, sInstanceName, sInstanceModule, aXMLNode.attributes);
				}
				else
				{								
					OSL_ENSURE(sInstanceName.getLength() == 0, "XMLTreeChangeListBuilder::startElement : type!=set, but has template instance name !");
					OSL_ENSURE(sInstanceModule.getLength() == 0, "XMLTreeChangeListBuilder::startElement : type!=set, but has template module name !");

					pNewTree =  getNodeFactory().createGroupNodeChange(aName, aXMLNode.attributes);
				}

                aXMLNode.pChange = pNewChange = pNewTree.get();

				OSL_ENSURE(m_aXMLNodeStack.top().pChange->ISA(SubtreeChange), "XMLTreeChangeListBuilder::startElement : Invalid Change Parent!");
		
				SubtreeChange* pParent = static_cast<SubtreeChange*>(m_aXMLNodeStack.top().pChange);
				pParent->addChange(base_ptr(pNewTree));				
			}
			
			m_eState = NODE_EXPECTED;

			// put the node on the stack for following childs
			m_aXMLNodeStack.push(aXMLNode);
		}
		else // value node
		{
			// A Value is started, we get the value via the XMLTreeBuilder routines
			// to prevent much code doubling
			// todo this:
			// create an Subtree, call with actual object the xmltreebuilder
			// which will interpret the current value as ValueNode and get all other
			// information and put it as a ValueNode in the Subtree.
			// to get The ValueNode from this subtree take a look at
			// XMLTreeChangeListBuilder::endElement
			m_ePushedState = m_eState;
			m_eState = FORWARDING_DATA;
			m_nElementDepth = 1;			 // 1, not 0 !

			m_pValueHandler->prepare(_xAttrList, aXMLNode.attributes);
			//m_pValueHandler->startDocument();
			m_pValueHandler->handler()->startElement(_aName, _xAttrList);
		}
	}
}

// -----------------------------------------------------------------------------

namespace
{
    class ValueNodeToChange
    {
        OTreeChangeFactory&  m_rFactory;

        struct Handler : NodeModification
        {
            ValueNodeToChange&  m_rParent;
            ISubtree&           m_rSource;
            SubtreeChange&      m_rDest;

            Handler(ValueNodeToChange& _rParent, ISubtree& _rSource, SubtreeChange& _rDest)
            : m_rParent(_rParent)
            , m_rSource(_rSource)
            , m_rDest(_rDest)
            {}

            virtual void handle(ValueNode& _rValue);
            virtual void handle(ISubtree& _rTree);
        };

    public:
        ValueNodeToChange(OTreeChangeFactory& _rFactory)
        : m_rFactory(_rFactory)
        {}

    public:
        auto_ptr<ValueChange> convertSimpleValueChange(ValueNode const& _aValue)
        {
            return m_rFactory.createValueChange(
                                    _aValue.getName(),
                                    _aValue.getAttributes(),
                                    ValueChange::wasDefault,
                                    _aValue.getValue()
                                );
        }
        auto_ptr<SubtreeChange> convertLocalizedValueChange(ISubtree& _aSet)
        {
            auto_ptr<SubtreeChange> aResult = m_rFactory.createSetNodeChange(
                                                    _aSet.getName(),
                                                    _aSet.getElementTemplateName(),
                                                    _aSet.getElementTemplateModule(),
                                                    _aSet.getAttributes(),
                                                    false
                                                );

            Handler(*this,_aSet,*aResult).applyToChildren(_aSet);

            return aResult;
        }
        auto_ptr<AddNode> wrap(auto_ptr<INode> pNode) const
        { 
            OSL_ASSERT(pNode.get() && pNode->getAttributes().isReplacedForUser());

            OUString const aNodeName = pNode->getName();
            
            return m_rFactory.createAddNodeChange(pNode, aNodeName);
        }
    public:
        auto_ptr<Change> convertToChange(auto_ptr<INode> _pNode);
    };
// -----------------------------------------------------------------------------

    auto_ptr<Change> ValueNodeToChange::convertToChange(auto_ptr<INode> _pNode)
    {
        auto_ptr<Change> aResult;

        if (_pNode.get())
        {
            if ( _pNode->getAttributes().isReplacedForUser() )
            {
                // replaced values are added as AddNode
                aResult = base_ptr(wrap(_pNode));
            }
            else if (ValueNode* pValueNode = _pNode->asValueNode())
            {
                aResult = base_ptr(convertSimpleValueChange(*pValueNode));
            }
            else if (ISubtree* pSubtree = _pNode->asISubtree())
            {
                OSL_ENSURE(isLocalizedValueSet(*pSubtree), "Invalid node: Found (non-localized) Tree instead of value node");
                aResult = base_ptr(convertLocalizedValueChange(*pSubtree));
            }
            else
                OSL_ENSURE(false, "Invalid value node: Unknown node type");
        }

        return aResult;
    }
// -----------------------------------------------------------------------------

    void ValueNodeToChange::Handler::handle(ValueNode& _rValue)
    {
        auto_ptr<Change> pChange;
        if (_rValue.getAttributes().isReplacedForUser())
        {
            OUString const aNodeName = _rValue.getName();

            auto_ptr<INode> pValue = m_rSource.removeChild(aNodeName);

            OSL_ASSERT(&_rValue == pValue.get());

            pChange = base_ptr(m_rParent.wrap(pValue));
        }
        else
        {
            pChange = base_ptr(m_rParent.convertSimpleValueChange(_rValue));
        }

        m_rDest.addChange( pChange );
    }
    void ValueNodeToChange::Handler::handle(ISubtree& _rTree)
    {
        OSL_ENSURE(false, "Unexpected: Container node found inside a localized value");
    }
// -----------------------------------------------------------------------------
}
// -----------------------------------------------------------------------------

void XMLTreeChangeListBuilder::endElement(const OUString& aName)
	throw(SAXException, RuntimeException)
{
	// PRE: </aName>
	::osl::MutexGuard aGuard(m_aMutex);
	if (NODE_IGNORED == m_eState)
	{
		OSL_ENSURE(m_nElementDepth, "XMLTreeChangeListBuilder::endElement : m_eState & m_nElementDepth are inconsistent !");
		if (0 == --m_nElementDepth)
			// we left the unknown territory ....
			m_eState = m_ePushedState;
	}
	else if (FORWARDING_DATA == m_eState)
	{
		if (0 == --m_nElementDepth)
		{
			// We got a ValueNode from the xmltreebuilder
			// so we create a ValueGet Object and call the visitor pattern
			// to get the ValueNode which is collect in the Subtree we
			// created vor the xmltreebuilder.

			// we left the node description
			m_eState = m_ePushedState;
			// call this method again, this will bring us into the else-branch below
			OSL_ASSERT(m_eState == NODE_EXPECTED); // endElement(aName);

			m_pValueHandler->handler()->endElement(aName);
			//m_pValueHandler->handler()->endDocument();

			// create the value node and convert it to a change
            auto_ptr<Change> pValueChange = ValueNodeToChange(getNodeFactory()).convertToChange(m_pValueHandler->createNode());

			// get the name to use from the Node
			OSL_ENSURE( pValueChange.get(), "ERROR: No Value node could be created");

			OSL_ENSURE(!m_aXMLNodeStack.empty(), "XMLTreeChangeListBuilder::endElement : NodeStack is invalid !");
			if (!m_aXMLNodeStack.empty())
			{
				OSL_ENSURE(m_aXMLNodeStack.top().pChange->isA(SubtreeChange::getStaticType()), "XMLTreeChangeListBuilder::endElement : Invalid Change Parent!");
				SubtreeChange* pParent = static_cast<SubtreeChange*>(m_aXMLNodeStack.top().pChange);

				pParent->addChange(pValueChange);
			}
		}
		else
		{	// it's one of the elements of the node value description
			if (m_pValueHandler.get() && m_pValueHandler->isActive())
				m_pValueHandler->handler()->endElement(aName);
			// TODO : think about handling the exceptions ....
		}
	}
	// remove the element from the stack
	else if (m_aXMLNodeStack.size())
		m_aXMLNodeStack.pop();
}

// -----------------------------------------------------------------------------
void XMLTreeChangeListBuilder::characters(const OUString& aChars)
	throw(SAXException, RuntimeException)
{
	// PRE: all between <T> and </T>, T can be a valid Value
	// _aValue = _aValue + String(aName);		 // append(!) value
	::osl::MutexGuard aGuard(m_aMutex);
	if (FORWARDING_DATA == m_eState)
		m_pValueHandler->handler()->characters(aChars);
}

// -----------------------------------------------------------------------------
void XMLTreeChangeListBuilder::ignorableWhitespace(const OUString& aWhitespaces)
	throw(sax::SAXException, uno::RuntimeException)
{
	::osl::MutexGuard aGuard(m_aMutex);
	if (FORWARDING_DATA == m_eState)
		m_pValueHandler->handler()->ignorableWhitespace(aWhitespaces);
	// TODO : think about handling the exceptions ....
}

// -----------------------------------------------------------------------------
void XMLTreeChangeListBuilder::setChangeList(TreeChangeList& _rList)
{
	::osl::MutexGuard aGuard(m_aMutex);
	m_pTreeChangeList = &_rList;
}

// -------------------------------------------------------------------------

} // namespace configmgr

