/*************************************************************************
 *
 *  $RCSfile: AccessibleBase.cxx,v $
 *
 *  $Revision: 1.6.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/05/31 14:43:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the License); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an AS IS basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef DBACCESS_ACCESSIBLEBASE_HXX
#include "AccessibleBase.hxx"
#endif
#ifndef _SV_WINDOW_HXX
#include <vcl/window.hxx>
#endif
#ifndef _UTL_CONFIGMGR_HXX_ 
#include <unotools/configmgr.hxx>
#endif
#ifndef _TOOLS_DEBUG_HXX 
#include <tools/debug.hxx>
#endif
#ifndef _DRAFTS_COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLEROLE_HPP_
#include <drafts/com/sun/star/accessibility/AccessibleRole.hpp>
#endif
#ifndef _DRAFTS_COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLESTATETYPE_HPP_
#include <drafts/com/sun/star/accessibility/AccessibleStateType.hpp>
#endif
#ifndef _DRAFTS_COM_SUN_STAR_ACCESSIBILITY_XACCESSIBLEEVENTLISTENER_HPP_
#include <drafts/com/sun/star/accessibility/XAccessibleEventListener.hpp>
#endif
#ifndef _TOOLKIT_AWT_VCLXWINDOW_HXX_ 
#include <toolkit/awt/vclxwindow.hxx>
#endif


namespace dbaui
{
	using namespace ::drafts::com::sun::star::accessibility;
	using namespace ::com::sun::star::uno;
	using namespace ::com::sun::star::beans;
	using namespace ::com::sun::star::lang;
	using namespace ::com::sun::star;

	DBG_NAME(OAccessibleBase )
	OAccessibleBase::OAccessibleBase(Window* _pWindow,
									 const Reference< XAccessible >& _xParent)
		:OAccessibleBase_BASE(m_aMutex) 
		,m_pWindow(_pWindow)
		,m_aPropertyListener(m_aMutex)
		,m_xParent(_xParent)
	{
		DBG_CTOR(OAccessibleBase ,NULL);
		if( m_xParent.is() )
			m_xParentContext = m_xParent->getAccessibleContext();
	}
	// -----------------------------------------------------------------------------
	OAccessibleBase::~OAccessibleBase()
	{
		DBG_DTOR(OAccessibleBase ,NULL); 
	}
	// -----------------------------------------------------------------------------
	void SAL_CALL OAccessibleBase::disposing()
	{
		m_pWindow = NULL;
		EventObject aEvt(*this);
		m_aPropertyListener.disposeAndClear(aEvt);
	}
	// -----------------------------------------------------------------------------
	::rtl::OUString SAL_CALL OAccessibleBase::getImplementationName() throw(RuntimeException)
	{
		return getImplementationName_Static();
	}
	// -----------------------------------------------------------------------------
	Sequence< ::rtl::OUString > SAL_CALL OAccessibleBase::getSupportedServiceNames() throw(RuntimeException)
	{
		return getSupportedServiceNames_Static();
	}
	// -----------------------------------------------------------------------------
	sal_Bool SAL_CALL OAccessibleBase::supportsService( const ::rtl::OUString& _rServiceName ) throw (RuntimeException)
	{
		Sequence< ::rtl::OUString > aSupported(getSupportedServiceNames());
		const ::rtl::OUString* pSupported = aSupported.getConstArray();
		const ::rtl::OUString* pEnd = pSupported + aSupported.getLength();
		for (;pSupported != pEnd && !pSupported->equals(_rServiceName); ++pSupported)
			;

		return pSupported != pEnd;
	}
	// -----------------------------------------------------------------------------
	// XServiceInfo - static methods
	Sequence< ::rtl::OUString > OAccessibleBase::getSupportedServiceNames_Static(void) throw( RuntimeException )
	{
		Sequence< ::rtl::OUString > aSupported(2);
		aSupported[0] = ::rtl::OUString::createFromAscii("drafts.com.sun.star.accessbility.Accessible");
		aSupported[1] = ::rtl::OUString::createFromAscii("drafts.com.sun.star.accessbility.AccessibleContext");
		return aSupported;
	}
	// -----------------------------------------------------------------------------
	::rtl::OUString OAccessibleBase::getImplementationName_Static(void) throw( RuntimeException )
	{
		return ::rtl::OUString::createFromAscii("org.openoffice.comp.dbu.JoinViewAccessbility");
	}
	// -----------------------------------------------------------------------------
	Reference< XAccessibleContext > SAL_CALL OAccessibleBase::getAccessibleContext(  ) throw (RuntimeException)
	{
		::osl::MutexGuard aGuard( m_aMutex  );
		return this;
	}
	// -----------------------------------------------------------------------------
	// XAccessibleContext
	// -----------------------------------------------------------------------------
	Reference< XAccessible > SAL_CALL OAccessibleBase::getAccessibleParent(  ) throw (RuntimeException)
	{
		::osl::MutexGuard aGuard( m_aMutex  );
		return m_xParent;
	}
	// -----------------------------------------------------------------------------
	sal_Int32 SAL_CALL OAccessibleBase::getAccessibleIndexInParent(  ) throw (RuntimeException)
	{
		return 0;
	}
	// -----------------------------------------------------------------------------
	sal_Int16 SAL_CALL OAccessibleBase::getAccessibleRole(  ) throw (RuntimeException)
	{
		return AccessibleRole::FRAME; // ? or may be an AccessibleRole::WINDOW
	}
	// -----------------------------------------------------------------------------
	::rtl::OUString SAL_CALL OAccessibleBase::getAccessibleDescription(  ) throw (RuntimeException)
	{
		::osl::MutexGuard aGuard( m_aMutex  );
		//	static ::rtl::OUString sDescription(RTL_CONSTASCII_USTRINGPARAM(""));
		if ( m_pWindow )
			return m_pWindow->GetText();
		return ::rtl::OUString();
	}
	// -----------------------------------------------------------------------------
	::rtl::OUString SAL_CALL OAccessibleBase::getAccessibleName(  ) throw (RuntimeException)
	{
		return getAccessibleDescription(  );
	}
	// -----------------------------------------------------------------------------
	Reference< XAccessibleRelationSet > SAL_CALL OAccessibleBase::getAccessibleRelationSet(  ) throw (RuntimeException)
	{
		return Reference< XAccessibleRelationSet >();
	}
	// -----------------------------------------------------------------------------
	Reference< XAccessibleStateSet > SAL_CALL OAccessibleBase::getAccessibleStateSet(  ) throw (RuntimeException)
	{
		::osl::MutexGuard aGuard( m_aMutex  );
		::utl::AccessibleStateSetHelper* pHelper = new ::utl::AccessibleStateSetHelper();
		Reference< XAccessibleStateSet > xRet = pHelper;
		if( rBHelper.bDisposed )
			pHelper->AddState( AccessibleStateType::DEFUNC );
		else if ( m_pWindow )
		{
			pHelper->AddState( AccessibleStateType::FOCUSABLE );
			if ( m_pWindow->HasFocus() )
				pHelper->AddState( AccessibleStateType::FOCUSED );
			if ( m_pWindow->IsActive() )
				pHelper->AddState( AccessibleStateType::ACTIVE );
			if ( isEditable() )
				pHelper->AddState( AccessibleStateType::EDITABLE );
			if ( m_pWindow->IsEnabled() )
				pHelper->AddState( AccessibleStateType::ENABLED );
			if ( m_pWindow->IsReallyVisible() )
				pHelper->AddState( AccessibleStateType::VISIBLE );
		}

		return xRet;
	}
	// -----------------------------------------------------------------------------
	Locale SAL_CALL OAccessibleBase::getLocale(  ) throw (IllegalAccessibleComponentStateException, RuntimeException)
	{
		Locale aRet;
		::utl::ConfigManager::GetDirectConfigProperty(::utl::ConfigManager::LOCALE) >>= aRet;
		return aRet;
	}
	// -----------------------------------------------------------------------------
	// XAccessibleComponent
	sal_Bool SAL_CALL OAccessibleBase::contains( const awt::Point& _aPoint ) throw (RuntimeException)
	{
		::osl::MutexGuard aGuard( m_aMutex  );
		sal_Bool bInside = sal_False;
		if ( m_pWindow ) 
		{
			Rectangle aRect(m_pWindow->GetPosPixel(),m_pWindow->GetSizePixel());
			bInside = aRect.IsInside(Point(_aPoint.X,_aPoint.Y));
		}
		
		return bInside;
	}
	// -----------------------------------------------------------------------------
	Reference< XAccessible > SAL_CALL OAccessibleBase::getAccessibleAt( const awt::Point& _aPoint ) throw (RuntimeException)
	{
		return Reference< XAccessible >();
	}
	// -----------------------------------------------------------------------------
	awt::Rectangle SAL_CALL OAccessibleBase::getBounds(  ) throw (RuntimeException)
	{
		::osl::MutexGuard aGuard( m_aMutex  );
		awt::Rectangle aRect;
		if ( m_pWindow ) 
		{
			Point aPos = m_pWindow->GetPosPixel();
			aRect.X = aPos.X();
			aRect.Y = aPos.Y();
			Size aSize = m_pWindow->GetSizePixel();
			aRect.Width = aSize.Width();
			aRect.Height = aSize.Height();
		}
		
		return aRect;
	}
	// -----------------------------------------------------------------------------
	awt::Point SAL_CALL OAccessibleBase::getLocation(  ) throw (RuntimeException)
	{
		::osl::MutexGuard aGuard( m_aMutex  );
		Point aPoint(0,0);
		if ( m_pWindow ) 
			aPoint = m_pWindow->GetPosPixel();
		return awt::Point(aPoint.X(),aPoint.Y());
	}
	// -----------------------------------------------------------------------------
	awt::Point SAL_CALL OAccessibleBase::getLocationOnScreen(  ) throw (RuntimeException)
	{
		::osl::MutexGuard aGuard( m_aMutex  );
		Point aPoint(0,0);
		if ( m_pWindow ) 
			aPoint = m_pWindow->ScreenToOutputPixel(m_pWindow->GetPosPixel());
		return awt::Point(aPoint.X(),aPoint.Y());
	}
	// -----------------------------------------------------------------------------
	awt::Size SAL_CALL OAccessibleBase::getSize(  ) throw (RuntimeException)
	{
		::osl::MutexGuard aGuard( m_aMutex  );
		Size aSize;
		if ( m_pWindow ) 
			aSize = m_pWindow->GetSizePixel();
		return awt::Size(aSize.Width(),aSize.Height());
	}
	// -----------------------------------------------------------------------------
	sal_Bool SAL_CALL OAccessibleBase::isShowing(  ) throw (RuntimeException)
	{
		::osl::MutexGuard aGuard( m_aMutex  );
		return m_pWindow ? m_pWindow->IsActive() : sal_False;
	}
	// -----------------------------------------------------------------------------
	sal_Bool SAL_CALL OAccessibleBase::isVisible(  ) throw (RuntimeException)
	{
		::osl::MutexGuard aGuard( m_aMutex  );
		return m_pWindow ? m_pWindow->IsVisible() : sal_False;
	}
	// -----------------------------------------------------------------------------
	sal_Bool SAL_CALL OAccessibleBase::isFocusTraversable(  ) throw (RuntimeException)
	{
		::osl::MutexGuard aGuard( m_aMutex  );
		return m_pWindow ? (m_pWindow->GetGetFocusFlags() & GETFOCUS_AROUND) == GETFOCUS_AROUND : sal_False;
	}
	// -----------------------------------------------------------------------------
	void SAL_CALL OAccessibleBase::addFocusListener( const Reference< awt::XFocusListener >& xListener ) throw (RuntimeException)
	{
		::osl::MutexGuard aGuard( m_aMutex  );
		if( m_pWindow && xListener.is() )
			m_pWindow->GetWindowPeer()->GetFocusListeners().addInterface(xListener);
	}
	// -----------------------------------------------------------------------------
	void SAL_CALL OAccessibleBase::removeFocusListener( const Reference< awt::XFocusListener >& xListener ) throw (RuntimeException)
	{
		::osl::MutexGuard aGuard( m_aMutex  );
		if( m_pWindow && xListener.is() )
			m_pWindow->GetWindowPeer()->GetFocusListeners().removeInterface(xListener);
	}
	// -----------------------------------------------------------------------------
	void SAL_CALL OAccessibleBase::grabFocus(  ) throw (RuntimeException)
	{
		::osl::MutexGuard aGuard( m_aMutex  );
		if( m_pWindow )
			m_pWindow->GrabFocus();
	}
	// -----------------------------------------------------------------------------
	Any SAL_CALL OAccessibleBase::getAccessibleKeyBinding(  ) throw (RuntimeException)
	{
		return Any();
	}
	// -----------------------------------------------------------------------------
	// XAccessibleExtendedComponent
	sal_Int32 SAL_CALL OAccessibleBase::getForeground(  ) throw (RuntimeException)
	{
		::osl::MutexGuard aGuard( m_aMutex  );
		return m_pWindow ? m_pWindow->GetControlForeground().GetRGBColor() : sal_Int32(0);
	}
	// -----------------------------------------------------------------------------
	sal_Int32 SAL_CALL OAccessibleBase::getBackground(  ) throw (RuntimeException)
	{
		::osl::MutexGuard aGuard( m_aMutex  );
		return m_pWindow ? m_pWindow->GetControlBackground().GetRGBColor() : sal_Int32(0);
	}
	// -----------------------------------------------------------------------------
	Reference< awt::XFont > SAL_CALL OAccessibleBase::getFont(  ) throw (RuntimeException)
	{
		return Reference< awt::XFont >();
	}
	// -----------------------------------------------------------------------------
	awt::FontDescriptor SAL_CALL OAccessibleBase::getFontMetrics( const Reference< awt::XFont >& xFont ) throw (RuntimeException)
	{
		return awt::FontDescriptor();
	}
	// -----------------------------------------------------------------------------
	sal_Bool SAL_CALL OAccessibleBase::isEnabled(  ) throw (RuntimeException)
	{
		::osl::MutexGuard aGuard( m_aMutex  );
		return m_pWindow && m_pWindow->IsEnabled();
	}
	// -----------------------------------------------------------------------------
	::rtl::OUString SAL_CALL OAccessibleBase::getTitledBorderText(  ) throw (RuntimeException)
	{
		::osl::MutexGuard aGuard( m_aMutex  );
		return m_pWindow ? ::rtl::OUString(m_pWindow->GetText()) : ::rtl::OUString();
	}
	// -----------------------------------------------------------------------------
	::rtl::OUString SAL_CALL OAccessibleBase::getToolTipText(  ) throw (RuntimeException)
	{
		::osl::MutexGuard aGuard( m_aMutex  );
		return m_pWindow ? ::rtl::OUString(m_pWindow->GetQuickHelpText()) : ::rtl::OUString();
	}
	// -----------------------------------------------------------------------------
	void OAccessibleBase::notifyAccessibleEvent(	sal_Int16 _nEventId,
												const Any& _aOldValue,
												const Any& _aNewValue)
	{
		AccessibleEventObject aEvt;
		aEvt.Source = *this;
		aEvt.EventId = _nEventId;
		::cppu::OInterfaceIteratorHelper aIter(m_aPropertyListener);
		while (aIter.hasMoreElements())
			((XAccessibleEventListener*)aIter.next())->notifyEvent(aEvt);
	}
	// -----------------------------------------------------------------------------
	void SAL_CALL OAccessibleBase::addEventListener( const Reference< XAccessibleEventListener >& xListener ) throw (RuntimeException)
	{
		if ( xListener.is() )
			m_aPropertyListener.addInterface(xListener);
	}
	// -----------------------------------------------------------------------------
	void SAL_CALL OAccessibleBase::removeEventListener( const Reference< XAccessibleEventListener >& xListener ) throw (RuntimeException)
	{
		if ( xListener.is() )
			m_aPropertyListener.removeInterface(xListener);
	}
	// -----------------------------------------------------------------------------
	// -----------------------------------------------------------------------------
}

// -----------------------------------------------------------------------------

