/*************************************************************************
 *
 *  $RCSfile: dataobject.cxx,v $
 *
 *  $Revision: 1.1.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/11/01 10:16:14 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

//------------------------------------------------------------------------
// includes
//------------------------------------------------------------------------

#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif

#include "..\..\..\source\win32\dtobj\DTransHelper.hxx"

#ifndef _TWRAPPERDATAOBJECT_HXX_
#include "dataobject.hxx"
#endif

#include <windows.h>
#include <ole2.h>
#include <memory>
#include <tchar.h>
#include <rtl/ustring.hxx>
using namespace rtl;
//------------------------------------------------------------------------
// namespace directives
//------------------------------------------------------------------------

using namespace ::std;


DataObject::DataObject( ) :
	m_nRefCnt( 0 )
{		
	
}

DataObject::DataObject( const OUString& data): m_nRefCnt( 0), m_sData( data)
{
}
DataObject::DataObject( const char* data): m_nRefCnt( 0)
{
	OUString s(data, strlen( data), RTL_TEXTENCODING_ASCII_US);
	m_sData= s;
}
DataObject::DataObject( const wchar_t* data): m_nRefCnt( 0)
{
	m_sData= OUString( data);
}

//------------------------------------------------------------------------
// IUnknown->QueryInterface
//------------------------------------------------------------------------

STDMETHODIMP DataObject::QueryInterface( REFIID iid, LPVOID* ppvObject )
{	
	OSL_ASSERT( NULL != ppvObject );

	if ( NULL == ppvObject )
		return E_INVALIDARG;

	HRESULT hr = E_NOINTERFACE;

	*ppvObject = NULL;

	if ( ( __uuidof( IUnknown ) == iid ) || ( __uuidof( IDataObject ) == iid ) )
	{
		*ppvObject = static_cast< IUnknown* >( this );
		( (LPUNKNOWN)*ppvObject )->AddRef( );
		hr = S_OK;
	}

	return hr;
}

//------------------------------------------------------------------------
// IUnknown->AddRef
//------------------------------------------------------------------------
STDMETHODIMP_(ULONG) DataObject::AddRef( )
{
	return static_cast< ULONG >( InterlockedIncrement( &m_nRefCnt ) );
}

//------------------------------------------------------------------------
// IUnknown->Release
//------------------------------------------------------------------------
STDMETHODIMP_(ULONG) DataObject::Release( )
{
	ULONG nRefCnt = static_cast< ULONG >( InterlockedDecrement( &m_nRefCnt ) );

	if ( 0 == nRefCnt )
	{
		delete this;
	}

	return nRefCnt;
}

/*------------------------------------------------------------------------
IDataObject::GetData
------------------------------------------------------------------------*/

STDMETHODIMP DataObject::GetData( LPFORMATETC pFE, LPSTGMEDIUM pSTM )
{		
	HRESULT hr= S_OK;
	
	if ( ( NULL == pFE ) || ( NULL == pSTM ) )
		return E_INVALIDARG;
	if( pFE->cfFormat == CF_UNICODETEXT)
	{
		HGLOBAL hmem= GlobalAlloc( GHND, m_sData.getLength() * sizeof(sal_Unicode) + 2);
		LPVOID pVoid= GlobalLock( hmem);
		if( pVoid)
			memcpy( pVoid, m_sData.getStr(), m_sData.getLength() * sizeof(sal_Unicode));

		GlobalUnlock( hmem);
		pSTM->tymed= CF_UNICODETEXT;
		pSTM->hGlobal= hmem; 
		pSTM->pUnkForRelease= NULL;
	}
	else if( pFE->cfFormat == CF_TEXT)
	{
		OString s= OUStringToOString( m_sData, RTL_TEXTENCODING_ASCII_US);
		HGLOBAL hmem= GlobalAlloc( GHND, s.getLength()  + 1);
		LPVOID pVoid= GlobalLock( hmem);
		if( pVoid)
			memcpy( pVoid, s.getStr(), s.getLength());

		GlobalUnlock( hmem);
		pSTM->tymed= CF_TEXT;
		pSTM->hGlobal= hmem; 
		pSTM->pUnkForRelease= NULL;
	}
	else
		hr= DV_E_FORMATETC;
	return hr;
}

//------------------------------------------------------------------------
// IDataObject->EnumFormatEtc
// Only supports GetData
//------------------------------------------------------------------------

STDMETHODIMP DataObject::EnumFormatEtc( DWORD dwDirection, IEnumFORMATETC** ppenumFormatetc )
{
	if ( ( NULL == ppenumFormatetc ) || ( DATADIR_SET == dwDirection ) )
		return E_INVALIDARG;
	
	*ppenumFormatetc = NULL;

	HRESULT hr = E_FAIL;

	if ( DATADIR_GET == dwDirection )
	{
		*ppenumFormatetc = new CEnumFormatEtcData( this );
		static_cast< LPUNKNOWN >( *ppenumFormatetc )->AddRef( );
		hr = S_OK;
	}

	return hr;
}

//------------------------------------------------------------------------
// IDataObject->QueryGetData
//------------------------------------------------------------------------

STDMETHODIMP DataObject::QueryGetData( LPFORMATETC pFormatetc )
{
	return E_NOTIMPL;
}

//------------------------------------------------------------------------
// IDataObject->GetDataHere
//------------------------------------------------------------------------

STDMETHODIMP DataObject::GetDataHere( LPFORMATETC, LPSTGMEDIUM )
{
	return E_NOTIMPL;
}

//------------------------------------------------------------------------
// IDataObject->GetCanonicalFormatEtc
//------------------------------------------------------------------------

STDMETHODIMP DataObject::GetCanonicalFormatEtc( LPFORMATETC, LPFORMATETC )
{
	return E_NOTIMPL;
}

//------------------------------------------------------------------------
// IDataObject->SetData
//------------------------------------------------------------------------

STDMETHODIMP DataObject::SetData( LPFORMATETC, LPSTGMEDIUM, BOOL )
{
	return E_NOTIMPL;
}

//------------------------------------------------------------------------
// IDataObject->DAdvise
//------------------------------------------------------------------------

STDMETHODIMP DataObject::DAdvise( LPFORMATETC, DWORD, LPADVISESINK, DWORD * )
{
	return E_NOTIMPL;
}

//------------------------------------------------------------------------
// IDataObject->DUnadvise
//------------------------------------------------------------------------

STDMETHODIMP DataObject::DUnadvise( DWORD )
{
	return E_NOTIMPL;
}

//------------------------------------------------------------------------
// IDataObject->EnumDAdvise
//------------------------------------------------------------------------

STDMETHODIMP DataObject::EnumDAdvise( LPENUMSTATDATA * )
{
	return E_NOTIMPL;
}

//------------------------------------------------------------------------
// for our convenience
//------------------------------------------------------------------------

DataObject::operator IDataObject*( )
{
	return static_cast< IDataObject* >( this );
}


//============================================================================
// CEnumFormatEtc
//============================================================================

//----------------------------------------------------------------------------
// ctor
//----------------------------------------------------------------------------

CEnumFormatEtcData::CEnumFormatEtcData( LPUNKNOWN pUnkDataObj ) :
	m_nRefCnt( 0 ),
	m_pUnkDataObj( pUnkDataObj ),
	m_nCurrPos( 0 )
{
}

//----------------------------------------------------------------------------
// IUnknown->QueryInterface
//----------------------------------------------------------------------------

STDMETHODIMP CEnumFormatEtcData::QueryInterface( REFIID iid, LPVOID* ppvObject )
{
	if ( NULL == ppvObject )
		return E_INVALIDARG;

	HRESULT hr = E_NOINTERFACE;

	*ppvObject = NULL;

	if ( ( __uuidof( IUnknown ) == iid ) || ( __uuidof( IEnumFORMATETC ) == iid ) )
	{
		*ppvObject = static_cast< IUnknown* >( this );
		static_cast< LPUNKNOWN >( *ppvObject )->AddRef( );
		hr = S_OK;
	}

	return hr;
}

//----------------------------------------------------------------------------
// IUnknown->AddRef
//----------------------------------------------------------------------------

STDMETHODIMP_(ULONG) CEnumFormatEtcData::AddRef( )
{
	// keep the dataobject alive
	m_pUnkDataObj->AddRef( );		
	return InterlockedIncrement( &m_nRefCnt );
}

//----------------------------------------------------------------------------
// IUnknown->Release
//----------------------------------------------------------------------------

STDMETHODIMP_(ULONG) CEnumFormatEtcData::Release( )
{
	// release the outer dataobject		
	m_pUnkDataObj->Release( );

	// we need a helper variable because it's
	// not allowed to access a member variable
	// after an object is destroyed
	ULONG nRefCnt = InterlockedDecrement( &m_nRefCnt );
	if ( 0 == nRefCnt )
		delete this;

	return nRefCnt;
}

//----------------------------------------------------------------------------
// IEnumFORMATETC->Next
//----------------------------------------------------------------------------

STDMETHODIMP CEnumFormatEtcData::Next( ULONG celt, LPFORMATETC rgelt, ULONG* pceltFetched )
{
	if ( ( 0 != celt ) && ( NULL == rgelt ) )
		return E_INVALIDARG;

	ULONG   ulFetched = 0;
	ULONG   ulToFetch = celt;
	HRESULT hr        = S_FALSE;
	
//  	while( m_nCurrPos < 1 )
//  	{		
//  		rgelt->cfFormat = CF_UNICODETEXT;
//  		rgelt->ptd      = NULL;
//  		rgelt->dwAspect = DVASPECT_CONTENT;
//  		rgelt->lindex   = -1;
//  		rgelt->tymed    = TYMED_HGLOBAL;

//  		++m_nCurrPos;
//  		++rgelt;
//  		--ulToFetch;
//  		++ulFetched;
//  	}
	
	for( sal_Int32 i= 0; i < celt; i++)
	{
		if( m_nCurrPos < 2) // we support 2 formats
		{

			if( m_nCurrPos == 0)
				rgelt->cfFormat= CF_UNICODETEXT;
			else if( m_nCurrPos == 1)
				rgelt->cfFormat= CF_TEXT;
			
			rgelt->ptd      = NULL;
			rgelt->dwAspect = DVASPECT_CONTENT;
			rgelt->lindex   = -1;
			rgelt->tymed    = TYMED_HGLOBAL;
			
			++m_nCurrPos;
			++rgelt;
			--ulToFetch;
			++ulFetched;
		}
	}
	
	if ( ulFetched == celt )
		hr = S_OK;

	if ( NULL != pceltFetched )
	{		
		*pceltFetched = ulFetched;
	}
	
	return hr;
}

//----------------------------------------------------------------------------
// IEnumFORMATETC->Skip
//----------------------------------------------------------------------------

STDMETHODIMP CEnumFormatEtcData::Skip( ULONG celt )
{
	HRESULT hr = S_FALSE;
	
	/*
	if ( ( m_nCurrPos + celt ) < m_nClipFormats )
	{
		m_nCurrPos += celt;
		hr = S_OK;
	}
	*/

	return hr;
}

//----------------------------------------------------------------------------
// IEnumFORMATETC->Reset
//----------------------------------------------------------------------------

STDMETHODIMP CEnumFormatEtcData::Reset( )
{
	m_nCurrPos = 0;
	return S_OK;
}

//----------------------------------------------------------------------------
// IEnumFORMATETC->Clone
//----------------------------------------------------------------------------

STDMETHODIMP CEnumFormatEtcData::Clone( IEnumFORMATETC** ppenum )
{
	OSL_ASSERT( NULL != ppenum );

	if ( NULL == ppenum )
		return E_INVALIDARG;

	HRESULT hr = E_FAIL;
	
	*ppenum = NULL;
	
	CEnumFormatEtcData* pCEnumFEtc = new CEnumFormatEtcData( m_pUnkDataObj );
	if ( NULL != pCEnumFEtc )
	{
		pCEnumFEtc->m_nCurrPos = m_nCurrPos;
		*ppenum = static_cast< IEnumFORMATETC* >( pCEnumFEtc );
		static_cast< LPUNKNOWN >( *ppenum )->AddRef( );
		hr = NOERROR;
	}

	return hr;
}
