/*************************************************************************
 *
 *  $RCSfile: contenttask.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:45 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CONTENT_HXX_
#include "content.hxx"
#endif

//------------------------------------------------------------
//	Constructors & Destructors
//------------------------------------------------------------

OContentTask::OContentTask(  const Reference< XContentTaskEnvironment >& xEnv, OContent *pContent ) :
m_aThread( NULL ),
m_pContent( pContent ),
m_aContentGuard( *m_pContent )
{
	m_xEnvironment = xEnv;
	setStatus( ContentTaskStatus_CREATED );
}

//------------------------------------------------------------

OContentTask::~OContentTask()
{
}

//------------------------------------------------------------
// Static methods
//------------------------------------------------------------

void OContentTask::executeWorker( void *pv )
{
	OContentTask	*_this = (OContentTask *)pv;

	_this->execute();
	_this->m_aThread = NULL;
}

//------------------------------------------------------------
// Class methods
//------------------------------------------------------------

ContentTaskStatus OContentTask::setStatus( ContentTaskStatus eStatus )
{
	Guard< Mutex >	aGuard( m_aMutex );

	ContentTaskEvent	aEvent;
	aEvent.Source		= (XContentTask *)this;
	aEvent.OldStatus	= m_eStatus;
	aEvent.NewStatus	= m_eStatus = eStatus;

	if( m_xEnvironment.is() )
	{
		Reference< XContentTaskClient > xClient = m_xEnvironment->getClient();
		if( xClient.is() )
			xClient->contentTaskEvent( aEvent );
	}
	
	return aEvent.OldStatus;
}

//------------------------------------------------------------
//	XInterface
//------------------------------------------------------------

void OContentTask::acquire() throw( RuntimeException )
{
	OWeakObject::acquire();
}

//------------------------------------------------------------

void OContentTask::release() throw( RuntimeException )
{
	OWeakObject::release();
}

//------------------------------------------------------------

sal_Bool OContentTask::queryInterface( const Uik& type, Any& ifc ) throw( RuntimeException )
{
	return ::com::sun::star::uno::queryInterface(
		type, ifc,
		SAL_STATIC_CAST( XContentTask*, this )
		)
		|| OWeakObject::queryInterface( type, ifc );
}

//------------------------------------------------------------
//	XContentTask
//------------------------------------------------------------

void SAL_CALL OContentTask::start() throw()
{
	Guard< Mutex > aGuard( m_aMutex );

	if( m_eStatus == ContentTaskStatus_CREATED && !m_aThread )
		m_aThread = osl_createThread( executeWorker, this );
}

//------------------------------------------------------------

void SAL_CALL OContentTask::execute() throw( Exception )
{
	setStatus( ContentTaskStatus_RUNNING );
	doExecute();
	setStatus( ContentTaskStatus_DONE );
}

//------------------------------------------------------------

void SAL_CALL OContentTask::abort() throw()
{
	osl_destroyThread( m_aThread );
	setStatus( ContentTaskStatus_ABORTED );
}

//------------------------------------------------------------

ContentTaskStatus SAL_CALL OContentTask::getStatus() throw()
{
	return m_eStatus;
}

//------------------------------------------------------------

Reference< XContentTaskEnvironment > SAL_CALL OContentTask::getEnvironment() throw()
{
	return m_xEnvironment;
}

