/*************************************************************************
 *
 *  $RCSfile: propertytask.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:45 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CONTENT_HXX_
#include "content.hxx"
#endif

//------------------------------------------------------------
//	Constructors & Destructors
//------------------------------------------------------------

OPropertyTask::OPropertyTask( const Reference< XContentTaskEnvironment >& xEnv,  OContent *pContent, const Sequence< PropertyValueInfo >& crProperties, PropertyTaskType eType ) :
OContentTask( xEnv, pContent ),
m_eType( eType ),
m_aProperties( crProperties )
{
}

//------------------------------------------------------------

OPropertyTask::~OPropertyTask()
{
}


//------------------------------------------------------------
//	OContentTask
//------------------------------------------------------------

void OPropertyTask::doExecute()
{
	if ( getType() == PropertyTaskType_SET )
	{
		Sequence< PropertyChangeEvent >	aEvents;
		long							nEvents = 0;

		for ( int i = 0; i < m_aProperties.getLength(); i++ )
		{
			Any OldValue = setPropertyValue( m_aProperties[i] );

			if ( m_aProperties[i].ValueState == PropertyValueState_PROCESSED )
			{
				aEvents.realloc( nEvents + 1 );
				aEvents[nEvents].Source = (XPropertyTask *)this;
				aEvents[nEvents].PropertyName = m_aProperties[i].Name;
				aEvents[nEvents].PropertyHandle = m_aProperties[i].Handle;
				aEvents[nEvents].Further = sal_False;
				aEvents[nEvents].OldValue = OldValue;
				aEvents[nEvents].NewValue = m_aProperties[i].Value;
				nEvents++;
			}
		}

		if ( nEvents )
			m_pContent->broadcastPropertiesChangeEvents( aEvents );
	}
	else if ( getType() == PropertyTaskType_GET )
	{
		for ( int i = 0; i < m_aProperties.getLength(); i++ )
			getPropertyValue( m_aProperties[ i ] );
	}
}

//------------------------------------------------------------
//	XPropertyTask
//------------------------------------------------------------

PropertyTaskType SAL_CALL OPropertyTask::getType() throw()
{
	return m_eType;
}

//------------------------------------------------------------

Sequence< PropertyValueInfo > SAL_CALL OPropertyTask::getProperties() throw()
{
	return m_aProperties;
}
