/*************************************************************************
 *
 *  $RCSfile: contenttaskclient.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:46 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <contenttaskclient.hxx>

#include <osl/diagnose.h>

#define OSL_ASSERT( x )

using namespace osl;
using namespace std;

/**************************************************************************
 *
 * Constructor
 *
 **************************************************************************
 */

OClientContentTask::OClientContentTask( const Reference< XContentTaskClient > &xClient,
									    const Reference< XContentTaskEnvironment > &xEnvironment) :
    OContentTaskHelper(xEnvironment),
    m_xClient(xClient)
{
    m_bAborted = sal_False;
}

/**************************************************************************
 *
 * Destructor
 *
 **************************************************************************
 */

OClientContentTask::~OClientContentTask()
{
}

/**************************************************************************
 *
 * queryInterface
 *
 **************************************************************************
 */

#if defined(TF_TYPE) || (SUPD >= 564)
Any SAL_CALL OClientContentTask::queryInterface( const Type& type ) throw(RuntimeException)
{
	Any	aRet = ::cppu::queryInterface(type, static_cast < XContentTaskClient * > (this));

	return ( aRet.hasValue() ? aRet : OWeakObject::queryInterface( type ) );
}
#else
sal_Bool SAL_CALL OClientContentTask::queryInterface( const Uik& rUik, Any& aIfc ) throw(RuntimeException)
{
	if(com::sun::star::uno::queryInterface(rUik, aIfc, static_cast < XContentTaskClient * > (this)))
		return sal_True;

	return OWeakObject::queryInterface(rUik, aIfc);
}
#endif

/**************************************************************************
 *
 * setStatus
 *
 **************************************************************************
 */

ContentTaskStatus OClientContentTask::setStatus( const ContentTaskStatus& eStatus )
{
	// copy event received
	ContentTaskEvent aEvent;

	// set task wrapper as source
	aEvent.Source = static_cast < XContentTask * > (this);

    aEvent.OldStatus = m_eStatus;
    aEvent.NewStatus = eStatus;

	// client object must be set
	OSL_ASSERT(m_xClient.is());

	m_xClient->contentTaskEvent(aEvent);

    m_eStatus = eStatus;

    return aEvent.OldStatus;
}

/**************************************************************************
 *
 * setStatus
 *
 **************************************************************************
 */

void OClientContentTask::doExecute()
{
    safe_list< Reference< XInterface > >::iterator iter, imax;
	safe_list< Reference< XInterface > > copy_aTaskList;

	{
		Guard< MutexWrap > aGuard(m_aTaskList);
		copy_aTaskList = m_aTaskList;
	}

    // call execute on all tasks
    for(iter = copy_aTaskList.begin(), imax = copy_aTaskList.end(); iter != imax; iter++)
	{
		Reference< XContentTask > xTask = Reference< XContentTask >::query(*iter);

        // what is it ?
        OSL_ASSERT(xTask.is());

        xTask->execute();
	}
}

/**************************************************************************
 *
 * addContentTask
 *
 **************************************************************************
 */

void OClientContentTask::addContentTask(const Reference< XContentTask > &xTask)
{
	Guard< MutexWrap > aGuard(m_aTaskList);

    m_aTaskList.push_back(xTask);
}

/**************************************************************************
 *
 * disposing
 *
 **************************************************************************
 */

void SAL_CALL OClientContentTask::disposing( const EventObject& rEvent ) throw(RuntimeException)
{
    Guard< MutexWrap > aGuard(m_aTaskList);

    // source object must be set
    OSL_ASSERT(rEvent.Source.is());

    safe_list< Reference< XInterface > >::iterator iter, imax;

    // find the source of this event in task list
    for(iter = m_aTaskList.begin(), imax = m_aTaskList.end(); iter != imax; iter++)
	{
        if(*iter == rEvent.Source)
            break;
	}

    // if not in list, why receiving events from this object ?
    OSL_ASSERT(iter != imax);

    if(iter != imax)
	{
        // remove element from list
        m_aTaskList.erase(iter);

		if(!m_bAborted)
			m_bAborted = sal_True;
	}
}

/**************************************************************************
 *
 * contentTaskEvent
 *
 **************************************************************************
 */

void SAL_CALL OClientContentTask::contentTaskEvent( const ContentTaskEvent& rEvent ) throw(RuntimeException)
{
	Guard< MutexWrap > aGuard(m_aTaskList);

    // source object must be set
    OSL_ASSERT(rEvent.Source.is());

    // action depends on new status
    switch(rEvent.NewStatus)
	{
	case ContentTaskStatus_RUNNING:

        // if this is the first task, notify original client
        if(m_eStatus == ContentTaskStatus_CREATED)
		{
            // set new status and notify client
			setStatus(ContentTaskStatus_RUNNING);
		}

        break;

	case ContentTaskStatus_ABORTED:

        // set aborted flag and behave as if received a done
		if(!m_bAborted)
			m_bAborted = sal_True;

	case ContentTaskStatus_DONE:

		{
            safe_list< Reference < XInterface > >::iterator iter, imax;

            // check if source object is in list
			for( iter = m_aTaskList.begin(), imax = m_aTaskList.end(); iter != imax; iter++)
			{
				if(*iter == rEvent.Source)
					break;
			}

			// if not in list, why receiving events from this object ?
			OSL_ASSERT(iter != imax);

			if(iter != imax)
			{
				// remove element from list
				m_aTaskList.erase(iter);
			}
		}

        if(m_aTaskList.size() == 0)
		{
            // no task aborted
			if(m_bAborted)
				setStatus(ContentTaskStatus_ABORTED);
            else
				setStatus(ContentTaskStatus_DONE);
		}

        break;

	default:
        break;
	}
}

