/*************************************************************************
 *
 *  $RCSfile: desktopregistry.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:46 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef  _RTL_WSTRING_
#include <rtl/wstring>
#endif

#include <osl/diagnose.h>

#ifndef _CPPU_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif

#ifndef _UNO_MAPPING_HXX_
#include <uno/mapping.hxx>
#endif

#ifndef _CPPUHELPER_FACTORY_HXX_
#include <cppuhelper/factory.hxx>
#endif

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_SERVICENOTREGISTEREDEXCEPTION_HPP_
#include <com/sun/star/lang/ServiceNotRegisteredException.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif

#ifndef _COM_SUN_STAR_REGISTRY_XSIMPLEREGISTRY_HPP_
#include <com/sun/star/registry/XSimpleRegistry.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_XCONFIGMANAGER_HPP_
#include <com/sun/star/frame/XConfigManager.hpp>
#endif

#ifndef _COM_SUN_STAR_HIERARCHY_XHIERARCHYREGISTRY_HPP_
#include <com/sun/star/hierarchy/XHierarchyRegistry.hpp>
#endif

#if defined(TF_TYPE) || (SUPD >= 564)
using namespace cppu;
#endif

#define OSL_ASSERT( x )

using namespace com::sun::star::uno;

class DesktopRegistry: public ::com::sun::star::hierarchy::XHierarchyRegistry,
                       public ::com::sun::star::lang::XServiceInfo,
	                   public OWeakObject
{
	// constructor
	DesktopRegistry(const Reference< ::com::sun::star::lang::XMultiServiceFactory >& xServiceMgr);

    // destructor
	virtual ~DesktopRegistry();

public:

	// static create Instance
	static Reference< XInterface > createInstance(const Reference< ::com::sun::star::lang::XMultiServiceFactory >& xSMgr)
		throw(Exception);

    /*
     * XInterface
     */

    // query a specific interface
#if defined(TF_TYPE) || (SUPD >= 564)
    virtual Any SAL_CALL queryInterface( const Type& aUik )	throw(RuntimeException);
#else
    virtual sal_Bool SAL_CALL queryInterface( const Uik& aUik, Any& ifc )	throw(RuntimeException);
#endif

    // increase reference count
	virtual void SAL_CALL acquire() throw(RuntimeException)
	{
		OWeakObject::acquire();
	};

    // decrease reference count
    virtual void SAL_CALL release() throw(RuntimeException)
	{
		OWeakObject::release();
	};

    /*
     * XHierarchyRegistry
     */

    // register a new child for the given provider.
    virtual void SAL_CALL registerChild( const Reference< ::com::sun::star::hierarchy::XContentHierarchy >& xHierarchy, const ::rtl::OWString& aKey, const Any& aChildId ) throw(::com::sun::star::registry::InvalidRegistryException, ::com::sun::star::lang::IllegalArgumentException, RuntimeException);

    // deregister a child for the given provider.
    virtual void SAL_CALL deregisterChild( const Reference< ::com::sun::star::hierarchy::XContentHierarchy >& xHierarchy, const ::rtl::OWString& aKey, const Any& aChildId ) throw(::com::sun::star::registry::InvalidRegistryException, ::com::sun::star::lang::IllegalArgumentException, RuntimeException);

    // returns a list of all child registered to a provider.
    virtual Sequence< Any > SAL_CALL listRegisteredChilds( const ::rtl::OWString& aProviderKey ) throw(::com::sun::star::registry::InvalidRegistryException, RuntimeException);

    // register a new content to be merged with the given provider
    virtual void SAL_CALL registerContent( const Reference< ::com::sun::star::hierarchy::XContentHierarchy >& xHierarchy, const ::rtl::OWString& aKey, const Any& aContentId ) throw(::com::sun::star::registry::InvalidRegistryException, ::com::sun::star::lang::IllegalArgumentException, RuntimeException);

    // remove content from the provider's list
    virtual void SAL_CALL deregisterContent( const Reference< ::com::sun::star::hierarchy::XContentHierarchy >& xHierarchy, const ::rtl::OWString& aKey, const Any& aContentId ) throw(::com::sun::star::registry::InvalidRegistryException, ::com::sun::star::lang::IllegalArgumentException, RuntimeException);

    // list all contents merged into the given provider
    virtual Sequence< Any > SAL_CALL listRegisteredContents( const ::rtl::OWString& aProviderKey ) throw(::com::sun::star::registry::InvalidRegistryException, RuntimeException);

	/*
	 * XServiceInfo
	 */

	// returns the name of the current implementation
	virtual ::rtl::OWString SAL_CALL getImplementationName() throw(RuntimeException);

	// indicates if the specified service is supported or not
	virtual sal_Bool SAL_CALL supportsService(const ::rtl::OWString& aServiceName) throw(RuntimeException);

	// returns the names of all supported services
	virtual Sequence< ::rtl::OWString > SAL_CALL getSupportedServiceNames() throw(RuntimeException);

	// returns the static name of the current implementation
	static ::rtl::OWString SAL_CALL getImplementationName_Static();

	// returns the names of all services supported from startup
	static Sequence< ::rtl::OWString > SAL_CALL getSupportedServiceNames_Static();

private:

    // the registry used store the data
	Reference< ::com::sun::star::registry::XSimpleRegistry > m_xRegistry;

	// reference to the config manager
	Reference< ::com::sun::star::frame::XConfigManager > m_xConfigMgr;

	// reference to the service factory
	Reference< ::com::sun::star::lang::XMultiServiceFactory > m_xServiceMgr;
};

//------------------------------------------------------------------------

using namespace rtl;
using namespace cppu;

using namespace com::sun::star::uno;
using namespace com::sun::star::lang;
using namespace com::sun::star::frame;
using namespace com::sun::star::registry;
using namespace com::sun::star::hierarchy;

#if (SUPD < 565)
const char SpecialConfigManager[] = "stardiv.UnoControls.SpecialConfigManager";
#else
const char SpecialConfigManager[] = "com.sun.star.config.SpecialConfigManager";
#endif
const char SimpleRegistry[]       = "com.sun.star.registry.SimpleRegistry";
const char UserConfigKey[]        = "Directories/UserConfig-Path";
const char DesktopRdb[]           = "/desktop.rdb";
const char ChildPrefix[]          = "Child/";
const char ContentPrefix[]        = "Content/";
const char LastKeyNo[]            = "No";

/**************************************************************************
 *
 * helper functions
 *
 **************************************************************************
 */

inline Reference< XConfigManager > getSpecialConfigManager(const Reference< XMultiServiceFactory >& xServiceMgr)
	throw(RuntimeException, ServiceNotRegisteredException)
{
    try
	{
		Reference< XInterface > xIfc = xServiceMgr->
			createInstance(OWString::createFromAscii(SpecialConfigManager));

		if(xIfc.is())
		{
			return Reference< XConfigManager >::query(xIfc);
		}

		return Reference< XConfigManager >();
	}

    catch(RuntimeException)
	{
        throw;
	}

    catch(Exception)
	{
		ServiceNotRegisteredException xcept;

		xcept.Message = OWString::createFromAscii(SpecialConfigManager);

        throw xcept;
	}
}

//------------------------------------------------------------------------

inline OWString getUserConfigURL(const Reference< XConfigManager >& xSpecialConfigMgr)
{
	Reference< XSimpleRegistry > xSimReg=
		Reference< XSimpleRegistry >::query(xSpecialConfigMgr);

    if(xSimReg.is())
	{
		Reference< XRegistryKey > xRootKey = xSimReg->getRootKey();

		if(xRootKey.is())
		{
			OWString aURL;

            Reference< XRegistryKey > xRegKey = xRootKey->
				openKey(OWString::createFromAscii(UserConfigKey));

            if(xRegKey.is())
			{
				if(xRegKey->getValueType() == RegistryValueType_STRING)
				{
					aURL = xRegKey->getStringValue();
				}

                xRegKey->closeKey();
			}

            return xSpecialConfigMgr->substituteVariables(aURL);
		}
	}

    return OWString();
}

//------------------------------------------------------------------------

inline Reference< XSimpleRegistry > getSimpleRegistry(const Reference< XMultiServiceFactory >& xServiceMgr)
    throw(RuntimeException, ServiceNotRegisteredException)
{
    try
	{
		Reference< XInterface > xIfc = xServiceMgr->
			createInstance(OWString::createFromAscii(SimpleRegistry));

		if(xIfc.is())
		{
			return Reference< XSimpleRegistry >::query(xIfc);
		}

		return Reference< XSimpleRegistry >();
	}

    catch(RuntimeException)
	{
        throw;
	}

    catch(Exception)
	{
		ServiceNotRegisteredException xcept;

		xcept.Message = OWString::createFromAscii(SimpleRegistry);

        throw xcept;
	}
}

//------------------------------------------------------------------------

inline void openRegistry(const Reference< XSimpleRegistry >& xRegistry,
						 const Reference< XConfigManager >& xSpecialConfigMgr)

    throw(InvalidRegistryException)
{
    OSL_ASSERT(xRegistry.is());
    OSL_ASSERT(xSpecialConfigMgr.is());

	// retrieve file location of user config dir
	OWString aURL = getUserConfigURL(xSpecialConfigMgr);

	if(aURL.getLength())
	{
		// expand the url with "/desktop.rdb"
		aURL += OWString::createFromAscii(DesktopRdb);

		// open the registry database
		xRegistry->open(aURL, sal_False, sal_True);
	}
}

//------------------------------------------------------------------------

inline Reference< XRegistryKey > findKeyFromValue(const Reference< XContentHierarchy >& xHierarchy,
												  const Reference< XRegistryKey >& xProviderKey,
												  const Any& aValueToFind)
    throw(InvalidRegistryException)
{
	Sequence< OWString > aKeyList = xProviderKey->getKeyNames();
    Sequence< Any > aHierarchyIdentifier(&aValueToFind, 1);

    // search in all subkeys
	for(sal_Int32 i=0, imax=aKeyList.getLength(); i < imax; i++)
	{
		// open subkey if exists
		Reference< XRegistryKey > xSubKey = xProviderKey->openKey(aKeyList[i]);

		OSL_ASSERT(xSubKey.is());

		if(xSubKey.is())
		{
            RegistryValueType eValueType = xSubKey->getValueType();

            Any aValue;

            // wrap value in any
            if(eValueType == RegistryValueType_STRING)
			{
                aValue <<= xSubKey->getStringValue();
			}
            else if(eValueType == RegistryValueType_BINARY)
			{
                aValue <<= xSubKey->getBinaryValue();
			}

            // compare values and return the first key that matches
            if(xHierarchy->compareHierarchyIdentifiers(aHierarchyIdentifier, Sequence< Any >(&aValue, 1)))
			{
                return xSubKey;
			}

			xSubKey->closeKey();
		}
	}

    return Reference< XRegistryKey >();
}

//------------------------------------------------------------------------

inline Reference< XRegistryKey > createKeyWithValue(const Reference< XRegistryKey > xProviderKey, const Any& aValue)
{
    OWString  aKeyName = OWString::createFromAscii(LastKeyNo);
    sal_Int64 nLastKey;

    // try to open the key that remembers the last key no used.
	Reference< XRegistryKey > xLastKeyName = xProviderKey->openKey(aKeyName);

    if(xLastKeyName.is())
	{
        Sequence< sal_Int32 > aLongList = xLastKeyName->getLongListValue();

        // convert sequence to int64
        if(aLongList.getLength() != 2)
            throw InvalidRegistryException();

        ((sal_Int32 *) &nLastKey)[0] = aLongList[0];
        ((sal_Int32 *) &nLastKey)[1] = aLongList[1];
	}
    else
	{
        // create the key and set nLastKey to initial state
        xLastKeyName = xProviderKey->createKey(aKeyName);
        nLastKey = 0;
	}

    if(xLastKeyName.is())
	{
        // reuse aKeyName
		aKeyName = OWString::valueOf(++nLastKey);

        // create the key and initialize it with given value
        Reference< XRegistryKey > xSubKey = xProviderKey->createKey(aKeyName);

		if(xSubKey.is())
		{
            Type aValueType = aValue.getValueType();

            // value wrapped in any
			if (aValueType == getCppuType(reinterpret_cast < OWString * > (0)))
			{
                OWString aString;
#ifdef DEBUG
                sal_Bool bRet = aValue >>= aString;
                OSL_ASSERT(bRet);
#else
                aValue >>= aString;
#endif
				xSubKey->setStringValue(aString);
			}
            else if(aValueType == getCppuType(reinterpret_cast < Sequence< sal_Int8 > * > (0)))
			{
                Sequence< sal_Int8 > aBinary;

#ifdef DEBUG
                sal_Bool bRet = aValue >>= aBinary;
                OSL_ASSERT(bRet);
#else
                aValue >>= aBinary;
#endif
				xSubKey->setBinaryValue(aBinary);
			}

            xSubKey->closeKey();
		}

        // store the key no to registry
        Sequence < sal_Int32 > aLongList(2);

        aLongList[0] = ((sal_Int32 *) &nLastKey)[0];
        aLongList[1] = ((sal_Int32 *) &nLastKey)[1];

        xLastKeyName->setLongListValue(aLongList);
        xLastKeyName->closeKey();
	}

    return Reference< XRegistryKey >();
}


/**************************************************************************
 *
 * Constructor
 *
 **************************************************************************
 */

DesktopRegistry::DesktopRegistry(const Reference< XMultiServiceFactory >& xServiceMgr)
	: m_xServiceMgr(xServiceMgr)
{
    // create the services needed
	m_xRegistry  = getSimpleRegistry(xServiceMgr);
    m_xConfigMgr = getSpecialConfigManager(xServiceMgr);
}

/**************************************************************************
 *
 * Destructor
 *
 **************************************************************************
 */

DesktopRegistry::~DesktopRegistry()
{
    OSL_ASSERT(m_xRegistry.is());

    // close desktop.rdb
    if(m_xRegistry->isValid())
        m_xRegistry->close();
}

/**************************************************************************
 *
 * createInstance
 *
 **************************************************************************
 */

Reference< XInterface > DesktopRegistry::createInstance(const Reference< XMultiServiceFactory >& xSMgr) throw(Exception)
{
    try
	{
		return static_cast <XHierarchyRegistry *> (new DesktopRegistry(xSMgr));
	}

    catch(Exception)
	{
        throw;
	}

    catch( ... )
	{
        throw RuntimeException();
	}
}

/**************************************************************************
 *
 * queryInterface
 *
 **************************************************************************
 */

#if defined(TF_TYPE) || (SUPD >= 564)
Any SAL_CALL DesktopRegistry::queryInterface(const Type& type) throw(RuntimeException)
{
	Any	aRet = ::cppu::queryInterface( type,
                                           static_cast <XServiceInfo *> (this),
										   static_cast <XHierarchyRegistry *> (this));

	return ( aRet.hasValue() ? aRet : OWeakObject::queryInterface(type) );
}
#else
sal_Bool SAL_CALL DesktopRegistry::queryInterface(const Uik& rUik, Any& aIfc) throw(RuntimeException)
{
	if(com::sun::star::uno::queryInterface(rUik, aIfc,
                                           static_cast <XServiceInfo *> (this),
										   static_cast <XHierarchyRegistry *> (this)))
		return sal_True;

	return OWeakObject::queryInterface(rUik, aIfc);
}
#endif

/**************************************************************************
 *
 * getImplementationName
 *
 **************************************************************************
 */

OWString SAL_CALL DesktopRegistry::getImplementationName() throw(RuntimeException)
{
	return getImplementationName_Static();
}

/**************************************************************************
 *
 * getImplementationName_Static
 *
 **************************************************************************
 */

OWString SAL_CALL DesktopRegistry::getImplementationName_Static()
{
	 return L"com.sun.star.extensions.DesktopRegistry";
}

/**************************************************************************
 *
 * supportsService
 *
 **************************************************************************
 */

sal_Bool SAL_CALL DesktopRegistry::supportsService(const OWString& aServiceName) throw(RuntimeException)
{
	Sequence<OWString> aServiceNameList = getSupportedServiceNames();
	const OWString    *pNameArray       = aServiceNameList.getArray();

	for( sal_Int32 i = 0; i < aServiceNameList.getLength(); i++ )
		if( pNameArray[i] == aServiceName)
			return sal_True;

	return sal_False;
}

/**************************************************************************
 *
 * getSupportedServiceNames
 *
 **************************************************************************
 */

Sequence<OWString> SAL_CALL DesktopRegistry::getSupportedServiceNames() throw(RuntimeException)
{
	 return getSupportedServiceNames_Static();
}

/**************************************************************************
 *
 * getSupportedServiceNames_Static
 *
 **************************************************************************
 */

Sequence<OWString> SAL_CALL DesktopRegistry::getSupportedServiceNames_Static()
{
	Sequence<OWString> aServiceNameList( 1 );

	aServiceNameList.getArray()[0] = L"com.sun.star.hierarchy.DesktopRegistry";

	return aServiceNameList;
}

/**************************************************************************
 *
 * registerChild
 *
 **************************************************************************
 */

void SAL_CALL DesktopRegistry::registerChild( const Reference< XContentHierarchy >& xHierarchy,
                                              const OWString& aKey, const Any& aChildId )
    throw(InvalidRegistryException, IllegalArgumentException, RuntimeException)
{
    OSL_ASSERT(m_xRegistry.is());

    if(!m_xRegistry->isValid())
	{
        // throws InvalidRegistryException if it fails
        openRegistry(m_xRegistry, m_xConfigMgr);
	}

    // query the registry's root key
	Reference< XRegistryKey > xRootKey = m_xRegistry->getRootKey();

	if(xRootKey.is())
	{
		OWString aProviderKey = OWString::createFromAscii(ChildPrefix);

		// append provider ID to prefix: "Child/0A1113242341111"
		aProviderKey += aKey;

        // open the provider key if exists
        Reference< XRegistryKey > xProviderKey = xRootKey->openKey(aProviderKey);

		if(!xProviderKey.is())
		{
            // create new provider key
			xProviderKey = xRootKey->createKey(aProviderKey);
		}

		if(xProviderKey.is())
		{
            // search child in registry
            Reference< XRegistryKey > xSubKey = findKeyFromValue(xHierarchy, xProviderKey, aChildId);

            if(!xSubKey.is())
			{
                // create subkey if new
                xSubKey = createKeyWithValue(xProviderKey, aChildId);
			}

			if(xSubKey.is())
				xSubKey->closeKey();

			// close provider key
			xProviderKey->closeKey();
		}
	}
}

/**************************************************************************
 *
 * deregisterChild
 *
 **************************************************************************
 */

void SAL_CALL DesktopRegistry::deregisterChild( const Reference< XContentHierarchy >& xHierarchy,
												const OWString& aKey, const Any& aChildId )
    throw(InvalidRegistryException, IllegalArgumentException, RuntimeException)
{
    OSL_ASSERT(m_xRegistry.is());

    // query the registry's root key
	Reference< XRegistryKey > xRootKey = m_xRegistry->getRootKey();

    if(!m_xRegistry->isValid())
	{
        // throws InvalidRegistryException if it fails
        openRegistry(m_xRegistry, m_xConfigMgr);
	}

	if(xRootKey.is())
	{
		OWString aProviderKey = OWString::createFromAscii(ChildPrefix);

		// append provider ID to prefix: "Child/0A1113242341111"
		aProviderKey += aKey;

        // open the provider key if exists
        Reference< XRegistryKey > xProviderKey = xRootKey->openKey(aProviderKey);

		if(xProviderKey.is())
		{
            // search child in registry
            Reference< XRegistryKey > xSubKey = findKeyFromValue(xHierarchy, xProviderKey, aChildId);

            if(xSubKey.is())
			{
                OWString aKeyName = xSubKey->getKeyName();

                xSubKey->closeKey();
                xProviderKey->deleteKey(aKeyName);
			}

			// close provider key
			xProviderKey->closeKey();
		}
	}
}

/**************************************************************************
 *
 * listRegisteredChilds
 *
 **************************************************************************
 */

Sequence< Any > SAL_CALL DesktopRegistry::listRegisteredChilds( const OWString& aProviderKey )
    throw(InvalidRegistryException, RuntimeException)
{
    Sequence< Any > aReturnList;

    OSL_ASSERT(m_xRegistry.is());

    if(!m_xRegistry->isValid())
	{
        // throws InvalidRegistryException if it fails
        openRegistry(m_xRegistry, m_xConfigMgr);
	}

    // query the registry's root key
	Reference< XRegistryKey > xRootKey = m_xRegistry->getRootKey();

	if(xRootKey.is())
	{
        // open the provider key if exists
        Reference< XRegistryKey > xProviderKey = xRootKey->openKey(OWString::createFromAscii(ChildPrefix) + aProviderKey);

		if(xProviderKey.is())
		{
            Sequence< Reference < XRegistryKey > > aKeyList = xProviderKey->openKeys();

            // query number of keys to return
            sal_Int32 imax = aKeyList.getLength();

            // allocate memory in return list
            aReturnList.realloc(imax);

            for(sal_Int32 i = 0; i < imax; i++)
			{
                if(aKeyList[i].is())
				{
					RegistryValueType eValueType = aKeyList[i]->getValueType();
					Any aValue;

					// wrap value in any
					if(eValueType == RegistryValueType_STRING)
					{
						aValue <<= aKeyList[i]->getStringValue();
					}
					else if(eValueType == RegistryValueType_BINARY)
					{
						aValue <<= aKeyList[i]->getBinaryValue();
					}

					aKeyList[i]->closeKey();

					// store any in list
					aReturnList[i] = aValue;
				}
			}

			// close provider key
			xProviderKey->closeKey();
		}
	}

    return aReturnList;
}


/**************************************************************************
 *
 * registerContent
 *
 **************************************************************************
 */

void SAL_CALL DesktopRegistry::registerContent( const Reference< XContentHierarchy >& xHierarchy,
												const OWString& aKey, const Any& aContentId )
    throw(InvalidRegistryException, IllegalArgumentException, RuntimeException)
{
    OSL_ASSERT(m_xRegistry.is());

    if(!m_xRegistry->isValid())
	{
        // throws InvalidRegistryException if it fails
        openRegistry(m_xRegistry, m_xConfigMgr);
	}

    // query the registry's root key
	Reference< XRegistryKey > xRootKey = m_xRegistry->getRootKey();

	if(xRootKey.is())
	{
		OWString aProviderKey = OWString::createFromAscii(ContentPrefix);

		// append provider ID to prefix: "Child/0A1113242341111"
		aProviderKey += aKey;

        // open the provider key if exists
        Reference< XRegistryKey > xProviderKey = xRootKey->openKey(aProviderKey);

		if(!xProviderKey.is())
		{
            // create new provider key
			xProviderKey = xRootKey->createKey(aProviderKey);
		}

		if(xProviderKey.is())
		{
            // search child in registry
            Reference< XRegistryKey > xSubKey = findKeyFromValue(xHierarchy, xProviderKey, aContentId);

            if(!xSubKey.is())
			{
                // create subkey if new
                xSubKey = createKeyWithValue(xProviderKey, aContentId);
			}

			if(xSubKey.is())
				xSubKey->closeKey();

			// close provider key
			xProviderKey->closeKey();
		}
	}
}

/**************************************************************************
 *
 * deregisterContent
 *
 **************************************************************************
 */

void SAL_CALL DesktopRegistry::deregisterContent( const Reference< XContentHierarchy >& xHierarchy,
												  const OWString& aKey, const Any& aContentId )
    throw(InvalidRegistryException, IllegalArgumentException, RuntimeException)
{
    OSL_ASSERT(m_xRegistry.is());

    // query the registry's root key
	Reference< XRegistryKey > xRootKey = m_xRegistry->getRootKey();

    if(!m_xRegistry->isValid())
	{
        // throws InvalidRegistryException if it fails
        openRegistry(m_xRegistry, m_xConfigMgr);
	}

	if(xRootKey.is())
	{
		OWString aProviderKey = OWString::createFromAscii(ContentPrefix);

		// append provider ID to prefix: "Child/0A1113242341111"
		aProviderKey += aKey;

        // open the provider key if exists
        Reference< XRegistryKey > xProviderKey = xRootKey->openKey(aProviderKey);

		if(xProviderKey.is())
		{
            // search child in registry
            Reference< XRegistryKey > xSubKey = findKeyFromValue(xHierarchy, xProviderKey, aContentId);

			if(xSubKey.is())
			{
                OWString aKeyName = xSubKey->getKeyName();

                xSubKey->closeKey();
                xProviderKey->deleteKey(aKeyName);
			}

			// close provider key
			xProviderKey->closeKey();
		}
	}
}

/**************************************************************************
 *
 * listRegisteredContents
 *
 **************************************************************************
 */

Sequence< Any > SAL_CALL DesktopRegistry::listRegisteredContents( const OWString& aProviderKey )
    throw(InvalidRegistryException, RuntimeException)
{
    Sequence< Any > aReturnList;

    OSL_ASSERT(m_xRegistry.is());

    if(!m_xRegistry->isValid())
	{
        // throws InvalidRegistryException if it fails
        openRegistry(m_xRegistry, m_xConfigMgr);
	}

    // query the registry's root key
	Reference< XRegistryKey > xRootKey = m_xRegistry->getRootKey();

	if(xRootKey.is())
	{
        // open the provider key if exists
        Reference< XRegistryKey > xProviderKey = xRootKey->openKey(OWString::createFromAscii(ContentPrefix) + aProviderKey);

		if(xProviderKey.is())
		{
            Sequence< OWString > aKeyList = xProviderKey->getKeyNames();

            // query number of keys to return
            sal_Int32 imax = aKeyList.getLength();

            // allocate memory in return list
            aReturnList.realloc(imax);

            for( sal_Int32 i=0; i < imax; i++)
			{
				// open subkey if exists
				Reference< XRegistryKey > xSubKey = xProviderKey->openKey(aKeyList[i]);

                OSL_ASSERT(xSubKey.is());

				if(xSubKey.is())
				{
					RegistryValueType eValueType = xSubKey->getValueType();
					Any aValue;

					// wrap value in any
					if(eValueType == RegistryValueType_STRING)
					{
						aValue <<= xSubKey->getStringValue();
					}
					else if(eValueType == RegistryValueType_BINARY)
					{
						aValue <<= xSubKey->getBinaryValue();
					}

					xSubKey->closeKey();

					// store any in list
                    aReturnList[i] = aValue;
				}
			}

			// close provider key
			xProviderKey->closeKey();
		}
	}

    return aReturnList;
}

/*****************************************************************************
 *
 * writeComponentInfo
 *
 *****************************************************************************
 */

extern "C" sal_Bool SAL_CALL writeComponentInfo(uno_Interface* pUnoKey)
{
	sal_Bool ret = sal_False;

	if (pUnoKey)
	{
		Mapping aUno2Current(UNO_LB_UNO, CPPU_CURRENT_LANGUAGE_BINDING_NAME);
		if(aUno2Current.is())
		{
			XRegistryKey* pKey = (XRegistryKey *)aUno2Current.mapInterface(pUnoKey,
				::getCppuType((const Reference<XRegistryKey> *) 0));

			if(pKey)
			{
				Reference<XRegistryKey> xKey(pKey);
				pKey->release();

				try
				{
					Reference<XRegistryKey> xNewKey;
					Sequence<OWString>      aSNL;
					const OWString         *pArray;
					sal_Int32               i, imax;

					xNewKey = xKey->createKey(L"/"
					   + DesktopRegistry::getImplementationName_Static()
					   + L"/UNO/SERVICES");

					aSNL   = DesktopRegistry::getSupportedServiceNames_Static();
					pArray = aSNL.getArray();
					imax   = aSNL.getLength();

					for(i = 0; i < imax ; i++)
					{
						xNewKey->createKey(pArray[i]);
					}

					ret = sal_True;
				}
				catch( InvalidRegistryException& )
				{
				}
			}
		}
	}
	return ret;
}

/*****************************************************************************
 *
 * createComponent
 *
 *****************************************************************************
 */

extern "C" uno_Interface* SAL_CALL createComponentFactory(const sal_wChar* pImplementationName,
														  uno_Interface* pUnoSMgr,
														  uno_Interface* pUnoKey)
{
	uno_Interface *pRet = 0;

	Mapping aUno2Current(UNO_LB_UNO, CPPU_CURRENT_LANGUAGE_BINDING_NAME);
	Mapping aCurrent2Uno(CPPU_CURRENT_LANGUAGE_BINDING_NAME, UNO_LB_UNO);

	if(aUno2Current.is() && aCurrent2Uno.is())
	{
		Reference<XMultiServiceFactory> xSMgr;
		if(pUnoSMgr)
		{
			XMultiServiceFactory *pMSF = static_cast <XMultiServiceFactory *> (
			    aUno2Current.mapInterface(
				    pUnoSMgr,
					::getCppuType((const Reference <XMultiServiceFactory> *) 0)));

			if(pMSF)
			{
				xSMgr = pMSF;
				pMSF->release();
			}
		}

		Reference<XSingleServiceFactory> xFactory;

		if(DesktopRegistry::getImplementationName_Static().equals(pImplementationName))
		{
			xFactory = createSingleFactory(
				xSMgr, pImplementationName, 
				DesktopRegistry::createInstance,
				DesktopRegistry::getSupportedServiceNames_Static());
		}

		if(xFactory.is())
		{
			pRet = static_cast <uno_Interface *> (aCurrent2Uno.mapInterface(xFactory.get(),
			    ::getCppuType( (const Reference<XSingleServiceFactory> *) 0)));
		}
	}

	return pRet;
}


