/*************************************************************************
 *
 *  $RCSfile: hierarchy_helper.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:47 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _HIERARCHY_HELPER_HXX_
#include "hierarchy_helper.hxx"
#endif

/////////////////////////////////////////////////////////////////////////////
//
//	OContentHelper
//
/////////////////////////////////////////////////////////////////////////////

void OContentHelper::broadcastContentEvent( const ContentEvent & aEvent )
{
	Guard< MutexWrap >	aGuard( m_aContentEventListeners );

	for ( list< Reference< XContentEventListener > >::iterator it = m_aContentEventListeners.begin(); it != m_aContentEventListeners.end(); it++ )
	{
		Reference< XContentEventListener > xListener = (*it);

		if ( xListener.is() )
			xListener->contentEvent( aEvent );
	}
}

//-----------------------------------------------------------------------------
//	XInterface implementation
//-----------------------------------------------------------------------------

#if defined(TF_TYPE) || (SUPD >= 564)
Any SAL_CALL OContentHelper::queryInterface( const Type& type ) throw( RuntimeException )
{
	Any	aRet = ::cppu::queryInterface(
		type,
		SAL_STATIC_CAST( XContent*, this )
		);

	return aRet.hasValue() ? aRet : OWeakObject::queryInterface( type );
}
#else
sal_Bool SAL_CALL OContentHelper::queryInterface( const Uik& type, Any& ifc ) throw( RuntimeException )
{
	return ::com::sun::star::uno::queryInterface(
		type, ifc,
		SAL_STATIC_CAST( XContent*, this )
		)
		|| OWeakObject::queryInterface( type, ifc );
}
#endif


//-----------------------------------------------------------------------------
//	XContent implementation
//-----------------------------------------------------------------------------

void SAL_CALL OContentHelper::addContentEventListener( const Reference< XContentEventListener >& Listener ) throw(RuntimeException)
{
	m_aContentEventListeners.push_back( Listener );
}

//-----------------------------------------------------------------------------

void SAL_CALL OContentHelper::removeContentEventListener( const Reference< XContentEventListener >& Listener ) throw(RuntimeException)
{
	m_aContentEventListeners.remove( Listener );
}

///////////////////////////////////////////////////////////////////////////////
//
//	OPropertyHelper
//
///////////////////////////////////////////////////////////////////////////////

Sequence< PropertyChangeEvent > OPropertyHelper::matchEvents( const Sequence< PropertyChangeEvent >& Events, const Sequence< OWString > & PropertyNames ) throw(RuntimeException)
{
	Sequence< PropertyChangeEvent >	aResult( PropertyNames.getLength() );
	list< PropertyChangeEvent >	tempList;

	int	nEvents;

	for ( nEvents = 0; nEvents < Events.getLength(); nEvents++ )
		tempList.push_back( Events[nEvents] );

	nEvents = 0;

	for ( int i = 0; i < PropertyNames.getLength(); i++ )
	{
		for ( list< PropertyChangeEvent >::iterator it = tempList.begin(); it != tempList.end(); i++ )
		{
			if ( it->PropertyName == PropertyNames[i] )
			{
				aResult[nEvents++] = *it;
				tempList.erase( it );
				break;
			}
		}
	}

	aResult.realloc( nEvents );
	return aResult;
}

//-----------------------------------------------------------------------------

void OPropertyHelper::broadcastPropertiesChangeEvent( const Sequence< PropertyChangeEvent >& Events ) throw(RuntimeException)
{
	safe_list< PropertyListenerEntry >::iterator	it;

	for ( it = m_aPropertyChangeListeners.begin(); it != m_aPropertyChangeListeners.end(); it++ )
	{
		if ( it->Listener.is() )
		{
			if ( it->PropertyNames.getLength() )
			{
				Sequence< PropertyChangeEvent >	aSubEvents = matchEvents( Events, it->PropertyNames );

				if ( aSubEvents.getLength() )
					it->Listener->propertiesChange( aSubEvents );
			}
			else // interested in any event ?
				it->Listener->propertiesChange( Events );
		}
	}
}

//-----------------------------------------------------------------------------
//	XPropertyTaskProcessor implementation
//-----------------------------------------------------------------------------

void SAL_CALL OPropertyHelper::addPropertiesChangeListener( const Sequence< OWString >& PropertyNames, const Reference< XPropertiesChangeListener >& Listener ) throw(RuntimeException)
{
	PropertyListenerEntry	aEntry( PropertyNames, Listener );

	m_aPropertyChangeListeners.push_back( aEntry );
}

//-----------------------------------------------------------------------------

void SAL_CALL OPropertyHelper::removePropertiesChangeListener( const Sequence< OWString >& PropertyNames, const Reference< XPropertiesChangeListener >& Listener ) throw(RuntimeException)
{
	PropertyListenerEntry	aEntry( PropertyNames, Listener );

	m_aPropertyChangeListeners.remove( aEntry );
}

///////////////////////////////////////////////////////////////////////////////
//
//	OContentTaskHelper
//
///////////////////////////////////////////////////////////////////////////////

OContentTaskHelper::OContentTaskHelper(  const Reference< XContentTaskEnvironment >& xEnv ) :
m_aThread( NULL ),
m_xEnvironment( xEnv ),
m_eStatus( ContentTaskStatus_CREATED )
{
}

//------------------------------------------------------------

OContentTaskHelper::~OContentTaskHelper()
{
}

//------------------------------------------------------------
// Static methods
//------------------------------------------------------------

void OContentTaskHelper::executeWorker( void *pv )
{
	OContentTaskHelper	*_this = (OContentTaskHelper *)pv;

	try 
	{
		_this->execute();
	} 
	catch (...)
	{
		_this->setStatus( ContentTaskStatus_ABORTED );
	}

	_this->m_aThread = NULL;
}

//------------------------------------------------------------
// Class methods
//------------------------------------------------------------

ContentTaskStatus OContentTaskHelper::setStatus( const ContentTaskStatus &eStatus )
{
	ContentTaskEvent	aEvent;
	aEvent.Source		= (XContentTask *)this;
	aEvent.OldStatus	= m_eStatus;
	aEvent.NewStatus	= m_eStatus = eStatus;

	if( m_xEnvironment.is() )
	{
		Reference< XContentTaskClient > xClient = m_xEnvironment->getClient();
		if( xClient.is() )
			xClient->contentTaskEvent( aEvent );
	}
	
	return aEvent.OldStatus;
}

//------------------------------------------------------------
//	XInterface implementation
//------------------------------------------------------------

void OContentTaskHelper::acquire() throw( RuntimeException )
{
	OWeakObject::acquire();
}

//------------------------------------------------------------

void OContentTaskHelper::release() throw( RuntimeException )
{
	OWeakObject::release();
}

//------------------------------------------------------------

#if defined( TF_TYPE ) || ( SUPD >= 564 )
Any SAL_CALL OContentTaskHelper::queryInterface( const Type& type ) throw( RuntimeException )
{
	Any	aRet = ::cppu::queryInterface(
		type,
		SAL_STATIC_CAST( XContentTask*, this )
		);

	return aRet.hasValue() ? aRet : OWeakObject::queryInterface( type );
}
#else
sal_Bool OContentTaskHelper::queryInterface( const Uik& type, Any& ifc ) throw( RuntimeException )
{
	return ::com::sun::star::uno::queryInterface(
		type, ifc,
		SAL_STATIC_CAST( XContentTask*, this )
		)
		|| OWeakObject::queryInterface( type, ifc );
}
#endif

//------------------------------------------------------------
//	XContentTask implementation
//------------------------------------------------------------

void SAL_CALL OContentTaskHelper::start() throw()
{
	if( m_eStatus == ContentTaskStatus_CREATED && !m_aThread )
		m_aThread = osl_createThread( executeWorker, this );
}

//------------------------------------------------------------

void SAL_CALL OContentTaskHelper::execute() throw( Exception )
{
	setStatus( ContentTaskStatus_RUNNING );
	doExecute();
	setStatus( ContentTaskStatus_DONE );
}

//------------------------------------------------------------

void SAL_CALL OContentTaskHelper::abort() throw()
{
	osl_destroyThread( m_aThread );
	setStatus( ContentTaskStatus_ABORTED );
}

//------------------------------------------------------------

ContentTaskStatus SAL_CALL OContentTaskHelper::getStatus() throw()
{
	return m_eStatus;
}

//------------------------------------------------------------

Reference< XContentTaskEnvironment > SAL_CALL OContentTaskHelper::getEnvironment() throw()
{
	return m_xEnvironment;
}

///////////////////////////////////////////////////////////////////////////////
//
//	OPropertyTaskHelper
//
///////////////////////////////////////////////////////////////////////////////

//------------------------------------------------------------
//	XInterface implementation
//------------------------------------------------------------

#if defined( TF_TYPE ) || ( SUPD >= 564 )
Any SAL_CALL OPropertyTaskHelper::queryInterface( const Type& type ) throw( RuntimeException )
{
	Any	aRet = ::cppu::queryInterface(
		type,
		SAL_STATIC_CAST( XPropertyTask*, this )
		);

	return aRet.hasValue() ? aRet : OContentTaskHelper::queryInterface( type );
}
#else
sal_Bool SAL_CALL OPropertyTaskHelper::queryInterface( const Uik& type, Any& ifc ) throw( RuntimeException )
{
	return ::com::sun::star::uno::queryInterface(
		type, ifc,
		SAL_STATIC_CAST( XPropertyTask*, this )
		)
		|| OContentTaskHelper::queryInterface( type, ifc );
}
#endif

///////////////////////////////////////////////////////////////////////////////
//
//	OPropertySetInfoHelper
//
///////////////////////////////////////////////////////////////////////////////

//------------------------------------------------------------
//	XInterface implementation
//------------------------------------------------------------

#if defined( TF_TYPE ) || ( SUPD >= 564 )
Any SAL_CALL OPropertySetInfoHelper::queryInterface( const Type& type ) throw( RuntimeException )
{
	Any	aRet = ::cppu::queryInterface(
		type,
		SAL_STATIC_CAST( XPropertySetInfo*, this )
		);

	return aRet.hasValue() ? aRet : OWeakObject::queryInterface( type );
}
#else
sal_Bool SAL_CALL OPropertySetInfoHelper::queryInterface( const Uik& type, Any& ifc ) throw( RuntimeException )
{
	return ::com::sun::star::uno::queryInterface(
		type, ifc,
		SAL_STATIC_CAST( XPropertySetInfo*, this )
		)
		|| OWeakObject::queryInterface( type, ifc );
}
#endif

//------------------------------------------------------------
//	XPropertySetInfo implementation
//------------------------------------------------------------

Property SAL_CALL OPropertySetInfoHelper::getPropertyByName( const OWString& Name ) throw(UnknownPropertyException, RuntimeException)
{
	int	nProperties = m_aProperties.getLength();

	for ( int i = 0; i < nProperties; i++ )
	{
		if (m_aProperties[i].Name == Name)
			return m_aProperties[i];
	}

	throw UnknownPropertyException();

	return Property();
}

//-----------------------------------------------------------------------------

sal_Bool SAL_CALL OPropertySetInfoHelper::hasPropertyByName( const OWString& Name ) throw(RuntimeException)
{
	try
	{
		getPropertyByName( Name );
	}
	catch ( UnknownPropertyException )
	{
		return sal_False;
	}

	return sal_True;
}



///////////////////////////////////////////////////////////////////////////////
//
//	OCommandTaskHelper
//
///////////////////////////////////////////////////////////////////////////////

//------------------------------------------------------------
//	XInterface implementation
//------------------------------------------------------------

#if defined( TF_TYPE ) || ( SUPD >= 564 )
Any SAL_CALL OCommandTaskHelper::queryInterface( const Type& type ) throw( RuntimeException )
{
	Any	aRet = ::cppu::queryInterface(
		type,
		SAL_STATIC_CAST( XCommandTask*, this )
		);

	return aRet.hasValue() ? aRet : OContentTaskHelper::queryInterface( type );
}
#else
sal_Bool SAL_CALL OCommandTaskHelper::queryInterface( const Uik& type, Any& ifc ) throw( RuntimeException )
{
	return ::com::sun::star::uno::queryInterface(
		type, ifc,
		SAL_STATIC_CAST( XCommandTask*, this )
		)
		|| OContentTaskHelper::queryInterface( type, ifc );
}
#endif


///////////////////////////////////////////////////////////////////////////////
//
// OCommandInfoHelper
//
///////////////////////////////////////////////////////////////////////////////

CommandInfo SAL_CALL OCommandInfoHelper::getCommandInfoByName( const OWString& Name ) throw(UnsupportedCommandException, RuntimeException)
{
	Sequence< CommandInfo >	aInfo = getCommands();

	for ( int i = 0; i < aInfo.getLength(); i++ )
	{
		if ( aInfo[i].Name == Name )
			return aInfo[i];
	}

	throw UnsupportedCommandException();
}

//-----------------------------------------------------------------------------

CommandInfo SAL_CALL OCommandInfoHelper::getCommandInfoByHandle( sal_Int32 Handle ) throw(UnsupportedCommandException, RuntimeException)
{
	Sequence< CommandInfo >	aInfo = getCommands();

	for ( int i = 0; i < aInfo.getLength(); i++ )
	{
		if ( aInfo[i].Handle == Handle )
			return aInfo[i];
	}

	throw UnsupportedCommandException();
}

//-----------------------------------------------------------------------------

sal_Bool SAL_CALL OCommandInfoHelper::hasCommandByName( const OWString& Name ) throw(RuntimeException)
{
	try
	{
		getCommandInfoByName( Name );
	}
	catch ( UnsupportedCommandException )
	{
		return sal_False;
	}

	return sal_True;
}

//-----------------------------------------------------------------------------

sal_Bool SAL_CALL OCommandInfoHelper::hasCommandByHandle( sal_Int32 Handle ) throw(RuntimeException)
{
	try
	{
		getCommandInfoByHandle( Handle );
	}
	catch ( UnsupportedCommandException )
	{
		return sal_False;
	}

	return sal_True;
}

