/*************************************************************************
 *
 *  $RCSfile: taskwrapper.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:47 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _HIERARCHY_TASKWRAPPER_HXX_
#define _HIERARCHY_TASKWRAPPER_HXX_

#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif

#ifndef _COM_SUN_STAR_UCB_XCOMMANDTASK_HPP_
#include <com/sun/star/ucb/XCommandTask.hpp>
#endif

#ifndef _COM_SUN_STAR_UCB_XPROPERTYTASK_HPP_
#include <com/sun/star/ucb/XPropertyTask.hpp>
#endif

#ifndef _COM_SUN_STAR_UCB_XCONTENTTASKENVIRONMENT_HPP_
#include <com/sun/star/ucb/XContentTaskEnvironment.hpp>
#endif

#ifndef _COM_SUN_STAR_UCB_PROPERTYVALUEINFO_HPP_
#include <com/sun/star/ucb/PropertyValueInfo.hpp>
#endif

#ifndef _HIERARCHY_TEMPLATES_HXX_
#include "templates.hxx"
#endif

#include <osl/mutex.hxx>
#include <osl/conditn.hxx>
#include <cppuhelper/weak.hxx>

#if defined(TF_TYPE) || (SUPD >= 564)
using namespace cppu;
#endif

using namespace com::sun::star::lang;
using namespace com::sun::star::beans;
using namespace com::sun::star::uno;
using namespace com::sun::star::ucb;
using namespace com::sun::star::task;
using namespace osl;



///////////////////////////////////////////////////////////////////////////////
//
//	OContentTaskWrapper
//
///////////////////////////////////////////////////////////////////////////////

class OContentTaskWrapper :
public XContentTask,
public XContentTaskEnvironment,
public XContentTaskClient,
public OWeakObject
{
protected:
	safe_list< Reference< XContentTask > >	m_aTaskList;
	Reference< XContentTaskEnvironment >	m_xEnvironment;
	Condition								m_aFinishedCondition;
	ContentTaskStatus						m_eStatus;
	sal_Bool								m_bAborted;

	virtual int appendTask( Reference< XContentTask > & xTask );
	virtual int removeTask( Reference< XContentTask > & xTask );

	virtual void setStatus( const ContentTaskStatus & eStatus );
public:
	OContentTaskWrapper( const Reference< XContentTaskEnvironment > & xEnv );
	virtual ~OContentTaskWrapper() 
	{
		if ( m_aTaskList.size() != 0 )
			m_eStatus = ContentTaskStatus_ABORTED;
	};

    //	XInterface
#if defined(TF_TYPE) || (SUPD >= 564)
	virtual Any SAL_CALL queryInterface( const Type& type ) throw( RuntimeException );
#else
	virtual sal_Bool SAL_CALL queryInterface( const Uik& aUik, Any& ifc ) throw(RuntimeException);
#endif
	virtual void SAL_CALL acquire() throw(RuntimeException) { OWeakObject::acquire(); };
    virtual void SAL_CALL release() throw(RuntimeException) { OWeakObject::release(); };

	//	XContentTaskEnvironment
	virtual Reference< XContentTaskClient > SAL_CALL getClient() throw(RuntimeException) { return SAL_STATIC_CAST( XContentTaskClient*, this ); };
    virtual Reference< XInteractionHandler > SAL_CALL getInteractionHandler() throw(RuntimeException) { return m_xEnvironment->getInteractionHandler(); };
    virtual Reference< XProgressHandler > SAL_CALL getProgressHandler() throw(RuntimeException) { return m_xEnvironment->getProgressHandler(); };

	//	XContentTaskClient

    virtual void SAL_CALL contentTaskEvent( const ContentTaskEvent& rEvent ) throw(RuntimeException);

    //	XEventListener

    virtual void SAL_CALL disposing( const EventObject& rEvent ) throw(RuntimeException);

	// XContentTask
	virtual void SAL_CALL start() throw();
	virtual void SAL_CALL execute() throw( Exception );
	virtual void SAL_CALL abort() throw();
	virtual ContentTaskStatus SAL_CALL getStatus() throw()	{ return m_eStatus; };
	virtual Reference< XContentTaskEnvironment > SAL_CALL getEnvironment() throw() { return SAL_STATIC_CAST( XContentTaskEnvironment*, this ); }
};


///////////////////////////////////////////////////////////////////////////////
//
//	OCommandTaskWrapper
//
///////////////////////////////////////////////////////////////////////////////

class OCommandTaskWrapper : 
public XCommandTask,
public OContentTaskWrapper
{
protected:
	Command	m_aCommand;
	Any		m_aResult;
public:
	OCommandTaskWrapper( Command TheCommand, const Reference< XContentTaskEnvironment > & xEnv ) :
	  OContentTaskWrapper( xEnv ), m_aCommand( TheCommand ) {};

    //	XInterface
#if defined(TF_TYPE) || (SUPD >= 564)
	virtual Any SAL_CALL queryInterface( const Type& type ) throw( RuntimeException );
#else
	virtual sal_Bool SAL_CALL queryInterface( const Uik& aUik, Any& ifc ) throw(RuntimeException);
#endif
	virtual void SAL_CALL acquire() throw(RuntimeException) { OContentTaskWrapper::acquire(); };
    virtual void SAL_CALL release() throw(RuntimeException) { OContentTaskWrapper::release(); };

	// XCommandTask
	virtual Command SAL_CALL getCommand() throw() { return m_aCommand; };
	virtual Any SAL_CALL getResult() throw() { return m_aResult; };

	// XContentTask
	virtual void SAL_CALL start() throw() { OContentTaskWrapper::start(); };
	virtual void SAL_CALL execute() throw( Exception ) { OContentTaskWrapper::execute(); };
	virtual void SAL_CALL abort() throw() { OContentTaskWrapper::abort(); };
	virtual ContentTaskStatus SAL_CALL getStatus() throw() { return OContentTaskWrapper::getStatus(); };
	virtual Reference< XContentTaskEnvironment > SAL_CALL getEnvironment() throw() { return OContentTaskWrapper::getEnvironment(); };
};


///////////////////////////////////////////////////////////////////////////////
//
//	OPropertyTaskWrapper
//
///////////////////////////////////////////////////////////////////////////////

class OPropertyTaskWrapper : 
public XPropertyTask,
public OContentTaskWrapper
{
protected:
	PropertyTaskType				m_aType;
	Sequence< PropertyValueInfo >	m_aProperties;

	// OContentTaskWrapper

	virtual int removeTask( Reference< XContentTask > & xTask );
public:
	OPropertyTaskWrapper( PropertyTaskType Type, const Reference< XContentTaskEnvironment > & xEnv ) :
	  OContentTaskWrapper( xEnv ),  m_aType( Type ) {};

    //	XInterface
#if defined(TF_TYPE) || (SUPD >= 564)
	virtual Any SAL_CALL queryInterface( const Type& type ) throw( RuntimeException );
#else
	virtual sal_Bool SAL_CALL queryInterface( const Uik& aUik, Any& ifc ) throw(RuntimeException);
#endif
	virtual void SAL_CALL acquire() throw(RuntimeException) { OContentTaskWrapper::acquire(); };
    virtual void SAL_CALL release() throw(RuntimeException) { OContentTaskWrapper::release(); };

	// XPropertyTask

    virtual PropertyTaskType SAL_CALL getType() throw(RuntimeException) { return m_aType; };
    virtual Sequence< PropertyValueInfo > SAL_CALL getProperties() throw(RuntimeException) { return m_aProperties; };

	// XContentTask
	virtual void SAL_CALL start() throw() { OContentTaskWrapper::start(); };
	virtual void SAL_CALL execute() throw( Exception ) { OContentTaskWrapper::execute(); };
	virtual void SAL_CALL abort() throw() { OContentTaskWrapper::abort(); };
	virtual ContentTaskStatus SAL_CALL getStatus() throw() { return OContentTaskWrapper::getStatus(); };
	virtual Reference< XContentTaskEnvironment > SAL_CALL getEnvironment() throw() { return OContentTaskWrapper::getEnvironment(); };
};


#endif /* _HIERARCHY_TASKWRAPPER_HXX_ */

