/*************************************************************************
 *
 *  $RCSfile: inimanager.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: hr $ $Date: 2001/11/02 11:08:07 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

//_______________________________________________________________________________________________________________________
//	my own include
//_______________________________________________________________________________________________________________________

#ifndef _EXTENSIONS_INIMANAGER_HXX_
#include "inimanager.hxx"
#endif

//_______________________________________________________________________________________________________________________
//	includes of other projects
//_______________________________________________________________________________________________________________________

#ifndef _CPPUHELPER_TYPEPROVIDER_HXX_
#include <cppuhelper/typeprovider.hxx>
#endif

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif

#ifndef _RTL_USTRING_
#include <rtl/ustring>
#endif

//_______________________________________________________________________________________________________________________
//	includes of my own project
//_______________________________________________________________________________________________________________________

//_______________________________________________________________________________________________________________________
//	defines
//_______________________________________________________________________________________________________________________

#define	DEFAULT_SURL						OUString()
#define	DEFAULT_BISREADONLY					sal_True
#define	DEFAULT_BISOPEN						sal_False

#define	SERVICENAME		 					"com.sun.star.config.INIManager"
#define	IMPLEMENTATIONNAME					"com.sun.star.comp.extensions.INIManager"

//_______________________________________________________________________________________________________________________
//	macros
//_______________________________________________________________________________________________________________________

//_______________________________________________________________________________________________________________________
//	namespaces
//_______________________________________________________________________________________________________________________

using namespace ::rtl						;
using namespace ::osl						;
using namespace ::cppu						;
using namespace	::com::sun::star::uno		;
using namespace	::com::sun::star::lang		;
using namespace	::com::sun::star::registry	;
using namespace	::com::sun::star::beans		;
using namespace	::com::sun::star::util		;

namespace com{
	namespace sun{
		namespace star{
			namespace comp{
				namespace extensions{
					namespace inimanager{

//_______________________________________________________________________________________________________________________
//	constructor
//_______________________________________________________________________________________________________________________

INIManager::INIManager( const Reference< XMultiServiceFactory >& xFactory )
	: IMPL_MutexContainer	(						)	// Must be the first one - Is neccessary for follow initializations!
	, m_xFactory			( xFactory				)
	, m_aINIFile			( xFactory, m_aMutex 	)
	, m_sURL				( DEFAULT_SURL			)
	, m_bIsReadOnly			( DEFAULT_BISREADONLY	)
	, m_bIsOpen				( DEFAULT_BISOPEN		)
{
}

//_______________________________________________________________________________________________________________________
//	destructor
//_______________________________________________________________________________________________________________________

INIManager::~INIManager()
{
	close();
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

void SAL_CALL INIManager::open(	const	OUString&	sURL		,
										sal_Bool	bReadOnly	,
										sal_Bool	bCreate		) throw(	InvalidRegistryException	,
																			RuntimeException			)
{
    // Ready for multithreading
    MutexGuard aGuard( m_aMutex );

	// Safe impossible cases, for which method is not defined!
	DBG_ASSERT( impl_checkParameter_open( sURL, bReadOnly, bCreate ), "INIManager::open()\nInvalid parameter detected!\n" );

	// If file is already open, this function will close the currently open INI-file!
	// This method close old file AND reset some state variables!
	close();

	// Convert URL to UNC
	OUString sUNCFileName ;

	if ( FileBase::getSystemPathFromFileURL( sURL, sUNCFileName ) != FileBase::E_None )
	{
		// This is not a valid URL!
		throw InvalidRegistryException();
	}
	else // OSL file API now uses URLs !
		sUNCFileName = sURL;

	// Look, if file exist.
	DirectoryItem	aItem	;
	sal_Bool		bExist	;

	if ( DirectoryItem::get( sUNCFileName, aItem ) == FileBase::E_None )
	{
		bExist = sal_True  ;
	}
	else
	{
		bExist = sal_False ;
	}

	// If file not exist and user will not create it ...
	if (
		( bCreate	==	sal_False	) &&
		( bExist	==	sal_False	)
	   )
	{
		// ... we break this operation ... and throw an exception.
		throw InvalidRegistryException();
	}

	// Else we open the file.
	// If file not exist, the method "m_aINIFile->open()" create it automaticly.

	sal_Bool bState ;
	if ( bReadOnly == sal_True )
	{
		// Open file readonly without writelock!
		bState = m_aINIFile.open( sUNCFileName, OPENFLAG_READONLY );
	}
	else
	{
		// Open file not readonly with a flush-write-flag for caching!!!
		bState = m_aINIFile.open( sUNCFileName, OPENFLAG_WRITEABLE );
	}

	if ( bState == sal_False )
	{
		// At this point, the INI-file not exist AND can't be created!
		throw InvalidRegistryException();
	}

	// At this point, the INI-File is open OR new created!
	// Save state for following operations.
	m_sURL			=	sURL		;
	m_bIsReadOnly	=	bReadOnly	;
	m_bIsOpen		=	sal_True	;
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

void SAL_CALL INIManager::close() throw(	InvalidRegistryException	,
											RuntimeException			)
{
	// Ready for multithreading
    MutexGuard aGuard( m_aMutex );

	// Work only, if something to do :-)
	if ( m_bIsOpen == sal_True )
	{
		// Close file physichal.
		m_aINIFile.close();
	}
	// Clean this object ...
	impl_resetObject();
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

void SAL_CALL INIManager::destroy() throw(	InvalidRegistryException	,
											RuntimeException			)
{
	// Warn programmers ... This method is not implemented.
	DBG_ASSERT( sal_False, "INIManager::destroy()\nThis method is no implemented yet!\n" );
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

void SAL_CALL INIManager::mergeKey(	const	OUString&	sKeyName	,
									const	OUString&	sURL		) throw(	InvalidRegistryException	,
																				MergeConflictException		,
																				RuntimeException			)
{
	// Warn programmers ... This method is not implemented.
	DBG_ASSERT( sal_False, "INIManager::mergeKey()\nThis method is no implemented yet!\n" );
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

OUString SAL_CALL INIManager::getURL() throw( RuntimeException )
{
	// Ready for multithreading
    MutexGuard aGuard( Mutex::getGlobalMutex() );

	return m_sURL ;
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

Reference< XRegistryKey > SAL_CALL INIManager::getRootKey() throw(	InvalidRegistryException	,
																	RuntimeException			)
{
	// If instance not valid, we can't work!
	if ( isValid() == sal_False )
	{
		throw InvalidRegistryException();
	}

	// Ready for multithreading
    MutexGuard aGuard( m_aMutex );

	// Init default return value with NULL reference!
	Reference< XRegistryKey > xRootKey = Reference< XRegistryKey >();

	// Build RootKey at every call.
	// RootKey is "" !!!
	// The methods "openKey / createKey / ..." from Reference< XRegistryKey > works on subkeys!
	// If we set a valid section of current INI-file as rootkey ... we becomes problems!
	// Create dynamical RootKey
	RootKey* pNewKey = new RootKey( m_aMutex );

	// Save impossible cases
	// Never been reached, but its better to control!
	DBG_ASSERT( !(pNewKey == NULL), "INIManager::getRootKey()\nIts not possible to create a new key! Memorymanager works not fine.\n" );

	if ( pNewKey != NULL )
	{
		// Make a new RootKey. (Don't forget to initialize the new key!)
		Reference< XSimpleRegistry > xINIManager = SAL_STATIC_CAST( XSimpleRegistry*, this );

		// Safe impossible cases
		// I'm not a XSimpleRegistry ?
		DBG_ASSERT( !( xINIManager.is() == sal_False ), "INIManager::getRootKey()\nINIManager has no valid XSimpleRegistry interface?\n" );

		if ( xINIManager.is() )
		{
			// Give key a reference at this inimanager!
			// If this object deleted, ALL keys notified it.
			pNewKey->impl_initializeKey( xINIManager, &m_aINIFile );
			xRootKey = SAL_STATIC_CAST( XRegistryKey*, pNewKey );
		}
	}

	return xRootKey ;
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

sal_Bool SAL_CALL INIManager::isValid() throw( RuntimeException )
{
	// Ready for multithreading
    MutexGuard aGuard( m_aMutex );

	// Instance is valid, if file is open!
	return m_bIsOpen ;
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

sal_Bool SAL_CALL INIManager::isReadOnly() throw(	InvalidRegistryException	,
													RuntimeException			)
{
	// Ready for multithreading
    MutexGuard aGuard( m_aMutex );

	// If instance not valid, we can't work!
	if ( isValid() == sal_False )
	{
		throw InvalidRegistryException();
	}

	// Return state.
	return m_bIsReadOnly ;
}

//________________________________________________________________________________________________________
//	XInterface
//________________________________________________________________________________________________________

Any SAL_CALL INIManager::queryInterface( const Type& aType ) throw( RUNTIMEEXCEPTION )
{
	// Attention:
	//	Don't use mutex or guard in this method!!! Is a method of XInterface.

	// Ask for my own supported interfaces ...
	Any aReturn	( ::cppu::queryInterface	(  aType									  ,
									   			static_cast< XServiceInfo*		> ( this ),
									   			static_cast< XTypeProvider*		> ( this ),
									   			static_cast< XSimpleRegistry*	> ( this )
											)
				);

	// If searched interface not supported by this class ...
	if ( aReturn.hasValue() == sal_False )
	{
		// ... ask baseclass for interfaces!
		return OWeakObject::queryInterface( aType );
	}

	return aReturn ;
}

//________________________________________________________________________________________________________
//	XInterface
//________________________________________________________________________________________________________

void SAL_CALL INIManager::acquire() throw()
{
	// Attention:
	//	Don't use mutex or guard in this method!!! Is a method of XInterface.

	// Forward to baseclass
	OWeakObject::acquire();
}

//________________________________________________________________________________________________________
//	XInterface
//________________________________________________________________________________________________________

void SAL_CALL INIManager::release() throw()
{
	// Attention:
	//	Don't use mutex or guard in this method!!! Is a method of XInterface.

	// Forward to baseclass
	OWeakObject::release();
}

//________________________________________________________________________________________________________
//	XTypeProvider
//________________________________________________________________________________________________________

Sequence< Type > SAL_CALL INIManager::getTypes() throw( RuntimeException )
{
	// Optimize this method !
	// We initialize a static variable only one time. And we don't must use a mutex at every call!
	// For the first call; pTypeCollection is NULL - for the second call pTypeCollection is different from NULL!
	static OTypeCollection* pTypeCollection = NULL ;

	if ( pTypeCollection == NULL )
	{
		// Ready for multithreading; get global mutex for first call of this method only! see before
		MutexGuard aGuard( Mutex::getGlobalMutex() );

		// Control these pointer again ... it can be, that another instance will be faster then these!
		if ( pTypeCollection == NULL )
		{
			// Create a static typecollection ...
			static OTypeCollection aTypeCollection(	::getCppuType(( const Reference< XServiceInfo	>*)NULL ) ,
												  	::getCppuType(( const Reference< XTypeProvider	>*)NULL ) ,
												  	::getCppuType(( const Reference< XSimpleRegistry>*)NULL ) ) ;

			// ... and set his address to static pointer!
			pTypeCollection = &aTypeCollection ;
		}
	}

	return pTypeCollection->getTypes();
}

//________________________________________________________________________________________________________
//	XTypeProvider
//________________________________________________________________________________________________________

Sequence< sal_Int8 > SAL_CALL INIManager::getImplementationId() throw( RuntimeException )
{
	// Create one Id for all instances of this class.
	// Use ethernet address to do this! (sal_True)

	// Optimize this method
	// We initialize a static variable only one time. And we don't must use a mutex at every call!
	// For the first call; pID is NULL - for the second call pID is different from NULL!
	static OImplementationId* pID = NULL ;

	if ( pID == NULL )
	{
		// Ready for multithreading; get global mutex for first call of this method only! see before
		MutexGuard aGuard( Mutex::getGlobalMutex() );

		// Control these pointer again ... it can be, that another instance will be faster then these!
		if ( pID == NULL )
		{
			// Create a new static ID ...
			static OImplementationId aID( sal_False );
			// ... and set his address to static pointer!
			pID = &aID ;
		}
	}

	return pID->getImplementationId();
}

//________________________________________________________________________________________________________
//	XServiceInfo
//________________________________________________________________________________________________________

OUString SAL_CALL INIManager::getImplementationName() throw( RuntimeException )
{
	return INIManager::impl_getStaticImplementationName();
}

//________________________________________________________________________________________________________
//	XServiceInfo
//________________________________________________________________________________________________________

sal_Bool SAL_CALL INIManager::supportsService( const OUString& sServiceName ) throw( RuntimeException )
{
	// Ready for multithreading
	MutexGuard aGuard( m_aMutex );

    Sequence< OUString >	seqServiceNames	=	getSupportedServiceNames();
    const OUString*			pArray			=	seqServiceNames.getConstArray();

    for ( sal_Int32 nCounter = 0; nCounter < seqServiceNames.getLength(); nCounter++ )
	{
        if ( pArray[nCounter] == sServiceName )
		{
            return sal_True ;
		}
	}

    return sal_False ;
}

//________________________________________________________________________________________________________
//	XServiceInfo
//________________________________________________________________________________________________________

Sequence< OUString > SAL_CALL INIManager::getSupportedServiceNames() throw( RuntimeException )
{
	return impl_getStaticSupportedServiceNames();
}

//________________________________________________________________________________________________________
//	public impl. and static method to register service
//________________________________________________________________________________________________________

Sequence< OUString > INIManager::impl_getStaticSupportedServiceNames()
{
	// Normaly, i don't use mutex in "impl"-methods.
	// But this one is called from register functions to!
	// And there is no chance to do this ...

	// Ready for multithreading
	MutexGuard aGuard( Mutex::getGlobalMutex() );

    Sequence< OUString > seqServiceNames( 1 );
    seqServiceNames.getArray() [0] = OUString::createFromAscii( SERVICENAME );

    return seqServiceNames ;
}

//________________________________________________________________________________________________________
//	public impl. and static method to register service
//________________________________________________________________________________________________________

OUString INIManager::impl_getStaticImplementationName()
{
	// Normaly, i don't use mutex in "impl"-methods.
	// But this one is called from register functions to!
	// And there is no chance to do this ...

	// Ready for multithreading
	MutexGuard aGuard( Mutex::getGlobalMutex() );

	return OUString::createFromAscii( IMPLEMENTATIONNAME );
}

//________________________________________________________________________________________________________
//	protected method
//________________________________________________________________________________________________________

void INIManager::impl_addPropertyChangeListener(	const	OUString&								sKeyName	,
													const	Reference< XPropertyChangeListener >&	xListener	) throw( RuntimeException )
{
	//Is used from "ConfigManager" and forwarded to "ProfileCache".
	m_aINIFile.impl_addPropertyChangeListener( sKeyName, xListener );
}

//________________________________________________________________________________________________________
//	protected method
//________________________________________________________________________________________________________

void INIManager::impl_removePropertyChangeListener(	const	OUString&								sKeyName	,
													const	Reference< XPropertyChangeListener >&	xListener	) throw( RuntimeException )
{
	//Is used from "ConfigManager" and forwarded tp "ProfileCache".
	m_aINIFile.impl_removePropertyChangeListener( sKeyName, xListener );
}

//________________________________________________________________________________________________________
//	protected method
//________________________________________________________________________________________________________

void INIManager::impl_addModifyListener( const Reference< XModifyListener >& xListener ) throw( RuntimeException )
{
	//Is used from "ConfigManager" and forwarded tp "ProfileCache".
	m_aINIFile.impl_addModifyListener( xListener );
}

//________________________________________________________________________________________________________
//	protected method
//________________________________________________________________________________________________________

void INIManager::impl_removeModifyListener( const Reference< XModifyListener >& xListener ) throw( RuntimeException )
{
	//Is used from "ConfigManager" and forwarded tp "ProfileCache".
	m_aINIFile.impl_removeModifyListener( xListener );
}

//________________________________________________________________________________________________________
//	protected method
//________________________________________________________________________________________________________

void INIManager::impl_setConfigManagerReference( XInterface* pConfigManager )
{
	//Is used from "ConfigManager" and forwarded tp "ProfileCache".
	m_aINIFile.impl_setConfigManagerReference( pConfigManager );
}

//________________________________________________________________________________________________________
//	protected method
//________________________________________________________________________________________________________

void INIManager::impl_disposing( const EventObject& aEvent ) throw( RuntimeException )
{
	// Forward to ProfileCache
	m_aINIFile.impl_disposing( aEvent );
}

//________________________________________________________________________________________________________
//	protected method
//________________________________________________________________________________________________________

Reference< XMultiServiceFactory >& INIManager::impl_getFactoryReference()
{
	return m_xFactory ;
}

//________________________________________________________________________________________________________
//	protected method
//________________________________________________________________________________________________________

void INIManager::impl_flush()
{
	m_aINIFile.flush();
}

//________________________________________________________________________________________________________
//	private method
//________________________________________________________________________________________________________

void INIManager::impl_resetObject()
{
	m_sURL			=	DEFAULT_SURL		;
	m_bIsReadOnly	=	DEFAULT_BISREADONLY	;
	m_bIsOpen		=	DEFAULT_BISOPEN		;
}

//________________________________________________________________________________________________________
//	debug and check methods
//________________________________________________________________________________________________________

#ifdef _DEBUG

//********************************************************************************************************
sal_Bool INIManager::impl_checkParameter_open(	const	OUSTRING&	sURL		,
														sal_Bool	bReadOnly	,
														sal_Bool	bCreate		)
{
	// Set default return value.
	sal_Bool bReturn = sal_True ;

	// Check parameter. If an invalid value is detected ...
	if	(
			( &sURL				==	NULL							)	||
			( sURL.getLength()	<	1								)	||
			( ( bReadOnly != sal_True && bReadOnly != sal_False )	)	||
			( ( bCreate   != sal_True && bCreate   != sal_False )	)
		)
	{
		// ... set return value to WRONG. This is the value to activate DBG_ASSERT in parent method!
		bReturn = sal_False ;
	}

	// Variables OK
	return sal_True ;
}

#endif // #ifdef _DEBUG

     } // namespace inimanager
    } // namespace extensions
   } // namespace comp
  } // namespace star
 } // namespace sun
} // namespace com
