/*************************************************************************
 *
 *  $RCSfile: pgpfactory.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _COM_SUN_STAR_UNO_ANY_H_
#include <com/sun/star/uno/Any.h>
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSINGLESERVICEFACTORY_HPP_
#include <com/sun/star/lang/XSingleServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif

#ifndef _COM_SUN_STAR_LOADER_XIMPLEMENTATIONLOADER_HPP_
#include <com/sun/star/loader/XImplementationLoader.hpp>
#endif

#ifndef _COM_SUN_STAR_REGISTRY_XREGISTRYKEY_HPP_
#include <com/sun/star/registry/XRegistryKey.hpp>
#endif

#ifndef _CPPUHELPER_FACTORY_HXX_
#include <cppuhelper/factory.hxx>
#endif
#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif

#ifdef SAL_UNX
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#endif /* SAL_UNX */

using namespace com::sun::star::lang;
using namespace com::sun::star::loader;
using namespace com::sun::star::registry;
using namespace com::sun::star::uno;
using namespace cppu;
using namespace rtl;

/*========================================================================
 *
 * PGPFactory_Impl interface.
 *
 *======================================================================*/
class PGPFactory_Impl :
	public OWeakObject,
	public XServiceInfo,
	public XMultiServiceFactory
{
public:
	PGPFactory_Impl (const Reference<XMultiServiceFactory> &rxMgr);

	/** XInterface.
	 */
	virtual Any SAL_CALL queryInterface (const Type &rType)
		throw (RuntimeException);

	virtual void SAL_CALL acquire (void)
		throw (RuntimeException);

	virtual void SAL_CALL release (void)
		throw (RuntimeException);

	/** XServiceInfo.
	 */
	virtual OUString SAL_CALL getImplementationName (void)
		throw (RuntimeException);

	virtual sal_Bool SAL_CALL supportsService (const OUString &rServiceName)
		throw (RuntimeException);

	virtual Sequence<OUString> SAL_CALL getSupportedServiceNames (void)
		throw (RuntimeException);

	/** XMultiServiceFactory.
	 */
	virtual Reference<XInterface> SAL_CALL createInstance (
		const OUString &rServiceSpecifier)
		throw (Exception, RuntimeException);

	virtual Reference<XInterface> SAL_CALL createInstanceWithArguments (
		const OUString      &rServiceSpecifier,
		const Sequence<Any> &rArguments)
		throw (Exception, RuntimeException);

	virtual Sequence<OUString> SAL_CALL getAvailableServiceNames (void)
		throw (RuntimeException);

protected:
	/** Destruction.
	 */
	virtual ~PGPFactory_Impl (void);

private:
	/** Representation.
	 */
	Reference<XMultiServiceFactory>  m_xManager;
	Reference<XSingleServiceFactory> m_xFactory;
	sal_Bool                         m_tryDirect;

	/** Implementation.
	 */
	Reference<XSingleServiceFactory> tryDirect (
		const OUString &rServiceSpecifier) throw (Exception);

	Reference<XSingleServiceFactory> tryDirect (
		const Reference<XImplementationLoader> &rxLoader,
		const OUString                         &rLocation) throw (Exception);

	OString getPGPVersion();

	/** Not implemented.
	 */
	PGPFactory_Impl (const PGPFactory_Impl&);
	PGPFactory_Impl& operator= (const PGPFactory_Impl&);
};

/*========================================================================
 *
 * PGPFactory_Impl internals.
 *
 *======================================================================*/
#define PGPFACTORY_IMPLEMENTATION_NAME "com.sun.star.pgp.PGPFactory"
#define PGPFACTORY_SERVICE_NAME        "com.sun.star.pgp.PGPFactory"

#define PGPMAILER_IMPLEMENTATION_NAME  "com.sun.star.pgp.SimplePGPMailer.V10"
#define PGPMAILER_SERVICE_NAME         "com.sun.star.pgp.SimplePGPMailer"

#define S2U(p) rtl::OUString::createFromAscii((p))

/*
 * PGPFactory_getImplementationName.
 */
static OUString SAL_CALL PGPFactory_getImplementationName (void)
{
	return S2U (PGPFACTORY_IMPLEMENTATION_NAME);
}

/*
 * PGPFactory_getSupportedServiceNames.
 */
static Sequence<OUString>
SAL_CALL PGPFactory_getSupportedServiceNames (void)
{
	OUString aName (S2U (PGPFACTORY_SERVICE_NAME));
	Sequence<OUString> aSeq (&aName, 1);
	return aSeq;
}

/*
 * PGPFactory_createInstance.
 */
static Reference<XInterface>
SAL_CALL PGPFactory_createInstance (
	const Reference<XMultiServiceFactory> &rxManager)
{
	Reference<XInterface> xService (
		SAL_STATIC_CAST (OWeakObject*, new PGPFactory_Impl (rxManager)));
	return xService;
}

/*
 * PGPFactory_createServiceFactory.
 */
static Reference<XSingleServiceFactory>
SAL_CALL PGPFactory_createServiceFactory (
	const Reference<XMultiServiceFactory> &rxManager)
{
	Reference<XSingleServiceFactory> xFactory (
		cppu::createSingleFactory (
			rxManager,
			PGPFactory_getImplementationName(),
			PGPFactory_createInstance,
			PGPFactory_getSupportedServiceNames()));
	return xFactory;
}

/*========================================================================
 *
 * PGPFactory_Impl implementation.
 *
 *======================================================================*/
/*
 * PGPFactory_Impl.
 */
PGPFactory_Impl::PGPFactory_Impl (
	const Reference<XMultiServiceFactory> &rxManager)
	: m_xManager  (rxManager),
	  m_xFactory  (NULL)
{
#ifdef SAL_W32
	m_tryDirect = sal_True;
#else
	m_tryDirect = sal_False;
#endif /* SAL_W32 */
}

/*
 * ~PGPFactory_Impl.
 */
PGPFactory_Impl::~PGPFactory_Impl()
{
}

/*
 * XInterface: queryInterface.
 */
Any SAL_CALL PGPFactory_Impl::queryInterface (const Type &rType)
	throw (RuntimeException)
{
	Any result (cppu::queryInterface (
		rType,
		SAL_STATIC_CAST (XServiceInfo*, this),
		SAL_STATIC_CAST (XMultiServiceFactory*, this)));
	if (!result.hasValue())
		result = OWeakObject::queryInterface (rType);
	return (result);
}

/*
 * XInterface: acquire.
 */
void SAL_CALL PGPFactory_Impl::acquire (void) throw (RuntimeException)
{
	OWeakObject::acquire();
}

/*
 * XInterface: release.
 */
void SAL_CALL PGPFactory_Impl::release (void) throw (RuntimeException)
{
	OWeakObject::release();
}

/*
 * XServiceInfo: getImplementationName.
 */
OUString SAL_CALL PGPFactory_Impl::getImplementationName (void)
	throw (RuntimeException)
{
	return PGPFactory_getImplementationName();
}

/*
 * XServiceInfo: supportsService.
 */
sal_Bool SAL_CALL PGPFactory_Impl::supportsService (
	const OUString &rServiceName) throw (RuntimeException)
{
	return (rServiceName.compareToAscii (PGPFACTORY_SERVICE_NAME) == 0);
}

/*
 * XServiceInfo: getSupportedServiceNames.
 */
Sequence<OUString>
SAL_CALL PGPFactory_Impl::getSupportedServiceNames (void)
	throw (RuntimeException)
{
	return PGPFactory_getSupportedServiceNames();
}

/*
 * XMultiServiceFactory: createInstance.
 */
Reference<XInterface>
SAL_CALL PGPFactory_Impl::createInstance (
	const OUString &rServiceSpecifier)
	throw (Exception, RuntimeException)
{
	Reference<XInterface> xRet;
	if (rServiceSpecifier.compareToAscii (PGPMAILER_SERVICE_NAME) == 0)
	{
		if (m_tryDirect)
		{
			if (!m_xFactory.is())
				m_xFactory = tryDirect (rServiceSpecifier);
			if (m_xFactory.is())
				xRet = m_xFactory->createInstance();
		}
		if (!xRet.is())
		{
			xRet = m_xManager->createInstance (rServiceSpecifier);
		}
	}
	return xRet;
}

/*
 * XMultiServiceFactory: createInstanceWithArguments.
 */
Reference<XInterface>
SAL_CALL PGPFactory_Impl::createInstanceWithArguments (
	const OUString &rServiceSpecifier, const Sequence<Any> &rArguments)
	throw (Exception, RuntimeException)
{
	Reference<XInterface> xRet;
	if (rServiceSpecifier.compareToAscii (PGPMAILER_SERVICE_NAME) == 0)
	{
		if (m_tryDirect)
		{
			if (!m_xFactory.is())
				m_xFactory = tryDirect (rServiceSpecifier);
			if (m_xFactory.is())
				xRet = m_xFactory->createInstanceWithArguments (rArguments);
		}
		if (!xRet.is())
		{
			xRet = m_xManager->createInstanceWithArguments (
				rServiceSpecifier, rArguments);
		}
	}
	return xRet;
}

/*
 * XMultiServiceFactory: getAvailableServiceNames.
 */
Sequence<OUString> SAL_CALL PGPFactory_Impl::getAvailableServiceNames (void)
	throw (RuntimeException)
{
	OUString aName (S2U (PGPMAILER_SERVICE_NAME));
	if (m_xManager.is())
	{
#ifndef SAL_W32

		// Using a Java SimplePGPMailer. Avoid loading JavaVM, now.
		// Use ServiceManager lookup, instead.

		Sequence<OUString> aNames (m_xManager->getAvailableServiceNames());
		OUString const    *pNames = aNames.getConstArray();

		for (sal_Int32 i = 0; i < aNames.getLength(); i++)
		{
			if (pNames[i].equals (aName))
			{
				// Java SimplePGPMailer service is available.
				// Now check for an executable PGP version.

				OString pgpVersion (getPGPVersion());
				if (!pgpVersion.equals (""))
					return Sequence<OUString>(&aName, 1);

				// No executable PGP available.
				break;
			}
		}

#else  /* SAL_W32 */

		// Using a native SimplePGPMailer. Create instance.
		Reference<XInterface> xIfc (createInstance (aName));
		if (xIfc.is())
		{
			// Obtain service info.
			Reference<XServiceInfo> xInfo (xIfc, UNO_QUERY);
			if (xInfo.is())
			{
				// Report available service names.
				return xInfo->getSupportedServiceNames();
			}
		}

#endif /* SAL_W32 */
	}
	return Sequence<OUString>();
}

/*
 * tryDirect.
 */
Reference<XSingleServiceFactory>
PGPFactory_Impl::tryDirect (
	const OUString &rServiceSpecifier) throw (Exception)
{
	Reference<XSingleServiceFactory> xFactory;
	if (rServiceSpecifier.compareToAscii (PGPMAILER_SERVICE_NAME) == 0)
	{
		Reference<XImplementationLoader> xLoader (
			m_xManager->createInstance (
				S2U ("com.sun.star.loader.SharedLibrary")),
			UNO_QUERY);
		if (xLoader.is())
		{
			xFactory = tryDirect (xLoader, S2U ("pgp65mi.dll"));
			if (!xFactory.is())
				xFactory = tryDirect (xLoader, S2U ("pgp60mi.dll"));
			if (!xFactory.is())
				xFactory = tryDirect (xLoader, S2U ("pgp55mi.dll"));
			if (!xFactory.is())
				m_tryDirect = sal_False;
		}
	}
	return xFactory;
}

/*
 * tryDirect.
 */
Reference<XSingleServiceFactory>
PGPFactory_Impl::tryDirect (
	const Reference<XImplementationLoader> &rxLoader,
	const OUString                         &rLocation) throw (Exception)
{
	if (rxLoader.is())
	{
		try
		{
			Reference<XSingleServiceFactory> xFactory (
				rxLoader->activate (
					S2U (PGPMAILER_IMPLEMENTATION_NAME),
					S2U (""),
					rLocation,
					Reference<XRegistryKey>()),
				UNO_QUERY);
			return xFactory;
		}
		catch (CannotActivateFactoryException)
		{
		}
	}
	return Reference<XSingleServiceFactory>();
}

/*
 * getPGPVersion ("2.6.3", "5.0" or "").
 */
OString PGPFactory_Impl::getPGPVersion (void)
{
	OString sRet;

#ifdef SAL_UNX

	int p[2];
 	if (pipe (p) == -1)
		return sRet;

	if (!fork())
	{
		close (p[0]);   // only use one end
  		dup2 (p[1], 2); // stderror

		int nil= open("/dev/null", O_RDONLY);
		if (nil)
			dup2 (nil, 1); // stdout -> nil

		char *argv[] = {"pgp", "+batchmode", NULL};
		if (-1 == execvp ("pgp", argv))
			exit (-1);
	}
	else
	{
		close (p[1]);

		char buff[255];
		size_t nRead= 0;
		int off=0;

		// Read a chunk of data. The first usually contains the version.
		do
		{
			nRead = read (p[0], buff + off, sizeof(buff) - off);
			off += nRead;
		} while ((nRead > 0) && (sizeof(buff) > off));

		buff[off] = 0;
		if (strstr (buff, "2.6.3"))
			sRet= "2.6.3";
		else if (strstr (buff, "5.0"))
			sRet= "5.0";
	}
	wait (NULL);

#endif /* SAL_UNX */

	return sRet;
}

/*========================================================================
 *
 * Component Loader.
 *
 *======================================================================*/

static sal_Bool writeInfo( void * pRegistryKey,
						   const OUString & rImplementationName,
   						   Sequence< OUString > const & rServiceNames )
{
	OUString aKeyName( OUString::createFromAscii( "/" ) );
	aKeyName += rImplementationName;
	aKeyName += OUString::createFromAscii( "/UNO/SERVICES" );

	Reference< XRegistryKey > xKey;
	try
	{
		xKey = static_cast< XRegistryKey * >(
									pRegistryKey )->createKey( aKeyName );
	}
	catch ( InvalidRegistryException const & )
	{
	}

	if ( !xKey.is() )
		return sal_False;

	sal_Bool bSuccess = sal_True;

	for ( sal_Int32 n = 0; n < rServiceNames.getLength(); ++n )
	{
		try
		{
			xKey->createKey( rServiceNames[ n ] );
		}
		catch ( InvalidRegistryException const & )
		{
			bSuccess = sal_False;
			break;
		}
	}
	return bSuccess;
}

//=========================================================================
extern "C" void SAL_CALL component_getImplementationEnvironment(
	const sal_Char ** ppEnvTypeName, uno_Environment ** ppEnv )
{
	*ppEnvTypeName = CPPU_CURRENT_LANGUAGE_BINDING_NAME;
}

//=========================================================================
extern "C" sal_Bool SAL_CALL component_writeInfo(
	void * pServiceManager, void * pRegistryKey )
{
	return pRegistryKey &&
		   writeInfo( pRegistryKey,
			   		  PGPFactory_getImplementationName(),
			   		  PGPFactory_getSupportedServiceNames() );
}

//=========================================================================
extern "C" void * SAL_CALL component_getFactory(
	const sal_Char * pImplName, void * pServiceManager, void * pRegistryKey )
{
	void * pRet = 0;

	Reference< XMultiServiceFactory > xSMgr(
			reinterpret_cast< XMultiServiceFactory * >( pServiceManager ) );
	Reference< XSingleServiceFactory > xFactory;

	if ( PGPFactory_getImplementationName().compareToAscii( pImplName ) == 0 )
		xFactory = PGPFactory_createServiceFactory( xSMgr );

	if ( xFactory.is() )
	{
		xFactory->acquire();
		pRet = xFactory.get();
	}

	return pRet;
}

