/*************************************************************************
 *
 *  $RCSfile: vfsregistration.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include <cppuhelper/factory.hxx>
#include <cppuhelper/servicefactory.hxx>
#include <com/sun/star/uno/XInterface.hpp>

#include <uno/dispatcher.h>
#include <uno/mapping.hxx>
#include <com/sun/star/lang/XMultiServiceFactory.hpp>

#include <vfscontentprovider.hxx>

using namespace com::sun::star::registry;
using namespace com::sun::star::lang;
using namespace com::sun::star::uno;

extern "C" sal_Bool SAL_CALL writeComponentInfo( uno_Interface* pXUnoKey )
{
	if( pXUnoKey )
	{
		Mapping aUno2Current( UNO_LB_UNO, CPPU_CURRENT_LANGUAGE_BINDING_NAME );
		if( aUno2Current.is() )
		{
			XRegistryKey* pKey = (XRegistryKey*)aUno2Current.mapInterface(
				pXUnoKey,  ::getCppuType((const Reference< XRegistryKey >*)0)
				);
			if( pKey )
			{
				Reference< XRegistryKey > xKey( pKey );
				pKey->release();
				Reference< XRegistryKey > xNewKey = xKey->createKey(
					L"/com.sun.star.hierarchy.VirtualFileSystem/UNO/SERVICES/com.sun.star.hierarchy.VirtualFileSystem" );
				return sal_True;
			}
		}
	}
	return sal_False;
}

//--------------------------------------

static Reference< XInterface > createVFSRoot( const Reference< XMultiServiceFactory >& xMgr	)
{
	static Reference< XInterface > xRoot;
	if ( !xRoot.is() )
		xRoot = (OWeakObject*) new VFSContentProvider;
	return xRoot;
}

//--------------------------------------

extern "C" uno_Interface* SAL_CALL createComponentFactory( const sal_Unicode* pImplementationName, uno_Interface* pXUnoSMgr, uno_Interface* pXUnoKey )
{
	uno_Interface* pRet = 0;

	Mapping aUno2Current( UNO_LB_UNO, CPPU_CURRENT_LANGUAGE_BINDING_NAME );
	Mapping aCurrent2Uno( CPPU_CURRENT_LANGUAGE_BINDING_NAME, UNO_LB_UNO );

	if( aCurrent2Uno.is() && aUno2Current.is() )
	{
		Reference< XMultiServiceFactory > xMgr;
		if( pXUnoSMgr )
		{
			XMultiServiceFactory* pSF = (XMultiServiceFactory*)
				aUno2Current.mapInterface(
					pXUnoSMgr,
					::getCppuType( (const Reference< XMultiServiceFactory >*)0 )
					);
			if( pSF )
			{
				xMgr = pSF;
				pSF->release();
			}
		}
		if( ! rtl_ustr_ascii_compare(  pImplementationName, "com.sun.star.hierarchy.VirtualFileSystem" ) )
		{
			rtl::OUString aServiceName( L"com.sun.star.hierarchy.VirtualFileSystem" );
			Reference< XSingleServiceFactory > xFactory(
				cppu::createSingleFactory(
					xMgr, pImplementationName, createVFSRoot,
					Sequence< rtl::OUString >( &aServiceName, 1 )
					)
				);
			if( xFactory.is() )
			{
				pRet = (uno_Interface*)aCurrent2Uno.mapInterface(
					xFactory.get(),
					::getCppuType( (const Reference< XSingleServiceFactory >*) 0 )
					);
			}
		}
	}
	return pRet;
}


