/*************************************************************************
 *
 *  $RCSfile: vfsrootcontent.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _EXTENSIONS_VFSROOTCONTENT_HXX
#define _EXTENSIONS_VFSROOTCONTENT_HXX

#include <vfsfoldercontent.hxx>

#include <tools/list.hxx>	// Nur solange noch TOOLS-Liste

// =======================================================================
// VFSRootContent
// =======================================================================

class VFSRootContent :	public VFSFolderContent
{
private:
	OStoreFile			maStorage;

//	OUString			maIdentifierBase;
	List				maOpenContents;

public:
						VFSRootContent( const OUString& rIdentifier );
						~VFSRootContent();

	VFSContent* 		FindContent( const OUString& rIdentifier );
	void				FindContents( const OUString& rIdentifierStart, list<VFSContent*>& rFound );
	void				RemoveContent( VFSContent* pContent );

	sal_Bool			Exists( const String& Path, const String& Name );
	sal_Bool			Rename( const String& Path, const String& OldName, const String& NewName );
	sal_Bool			DeleteFile( const String& rFullName, sal_Bool bMarkOnly );
	sal_Bool			DeleteFolder( const String& rFullName, sal_Bool bMarkOnly );
	sal_Bool			RenameChilds( const String& rPath, const String& rFolderName, sal_uInt16 nOldStart, sal_uInt16 nOldLen, const String& rNewFolderName );

	OStoreFile&			GetStorage() { return maStorage; }

    sal_Bool			QueryContent( const OUString& Identifier, Reference<XContent>& NewContent ) throw(RuntimeException);
    sal_Bool			InsertNewContent( VFSContent* pVFSContent ) throw(RuntimeException);
};

#endif // _EXTENSIONS_VFSROOTCONTENT_HXX

