/*************************************************************************
 *
 *  $RCSfile: testjavavm.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <string.h>

#include <uno/api.h>

#include <usr/uno.hxx>
#include <usr/weak.hxx>
#include <usr/refl.hxx>
#include <usr/sequ.hxx>
#include <usr/reflserv.hxx>
#include <usr/factoryhlp.hxx>
#include <usr/services.hxx>
#include <usr/smart2uno.hxx>

#include <vos/mutex.hxx>
#include <vos/dynload.hxx>

#include <stardiv/uno/repos/serinfo.hxx>
#include <stardiv/uno/repos/implementationregistration.hxx>
#include <stardiv/uno/repos/simplreg.hxx>
#include <stardiv/uno/lang/factory.hxx>
#include <stardiv/uno/lang/serviceinfo.hxx>
#include <stardiv/java/javavm.hxx>

#include "extensionstest.hxx"

#if defined ( UNX ) || defined ( MAC )
#include <limits.h>
#define _MAX_PATH PATH_MAX
#endif

#ifdef _USE_NAMESPACE
using namespace vos;
using namespace usr;
#endif


void test_JavaVM()
{
	UString aJavaVMDllName;
	UString aAppSettingsDllName;
	XMultiServiceFactoryRef xMgr(getProcessServiceManager(), USR_QUERY);
	TEST_ENSHURE( xMgr.is(), "getProccessServcieManager failed !!" );
	
	XServiceRegistryRef xRegMgr(xMgr, USR_QUERY);
	TEST_ENSHURE( xRegMgr.is(), "query XRegistryServiceManager failed !!" );
	
	XImplementationRegistrationRef xInst( xMgr->createInstance(L"stardiv.uno.repos.ImplementationRegistration"), USR_QUERY );
	TEST_ENSHURE( xInst.is(), "no ImplementationRegistration" );
	TRY
	{
		char szDllName[_MAX_PATH]="";

		ORealDynamicLoader::computeModuleName("je", szDllName, _MAX_PATH);
		aJavaVMDllName = StringToOUString(szDllName, CHARSET_SYSTEM);
		xInst->registerImplementation(L"stardiv.loader.SharedLibrary", aJavaVMDllName, XSimpleRegistryRef() );

		ORealDynamicLoader::computeModuleName("aps", szDllName, _MAX_PATH);
		aAppSettingsDllName = StringToOUString(szDllName, CHARSET_SYSTEM);
		xInst->registerImplementation(L"stardiv.loader.SharedLibrary", aAppSettingsDllName, XSimpleRegistryRef() );
	}
	CATCH( CannotRegisterImplementationException, e )
	{
		TEST_ENSHURE( FALSE, "register implementation failed" );
	}
	END_CATCH;

	Sequence<UString> seqImpl = xInst->getImplementations(L"stardiv.loader.SharedLibrary", aJavaVMDllName );
	TEST_ENSHURE( seqImpl.getLen() == 1, "count of implementantions is false" );
	TEST_ENSHURE( seqImpl.getConstArray()[0] == L"stardiv.extensions.JavaVirtualMachine", "implementation name is not equal" );

	seqImpl = xInst->getImplementations(L"stardiv.loader.SharedLibrary", aAppSettingsDllName );
	TEST_ENSHURE( seqImpl.getLen() == 1, "count of implementantions is false" );
	TEST_ENSHURE( seqImpl.getConstArray()[0] == L"stardiv.extensions.AppSettings", "implementation name is not equal" );

	XJavaVMRef xVM(xMgr->createInstance(L"com.sun.star.java.JavaVirtualMachine"), USR_QUERY);
	
	TEST_ENSHURE( xVM.is(), "loadable found but not installed !!" );
	
	BOOL isRunning = xVM->isVMStarted();

	Uik		aMachineId;
	uno2smart( aMachineId, UNO_getMachineIdentifier() );
	UsrAny aVM = xVM->getJavaVM( aMachineId, UNO_getProcessIdentifier() );
	TEST_ENSHURE( aVM.getReflection()->getTypeClass() == TypeClass_LONG, "not the right type" );
	UINT32 pJVM = aVM.getINT32();
	
	isRunning = xVM->isVMStarted();


//	TEST_ENSHURE( xInst->revokeImplementation(aJavaVMDllName), "revoke implementation failed" );
//	TEST_ENSHURE( xInst->revokeImplementation(aAppSettingsDllName), "revoke implementation failed" );
}
