/*************************************************************************
 *
 *  $RCSfile: localedata_nf.cxx,v $
 *
 *  $Revision: 1.12 $
 *
 *  last change: $Author: er $ $Date: 2001/02/02 17:09:57 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define I18N_CHARACTERCLASSIFICATION_USES_CLASS_INTERNATIONAL

#include "localedata_nf.hxx"

#ifndef _SV_SYSTEM_HXX
#include <vcl/system.hxx>
#endif
#ifndef _TOOLS_INTN_HXX
#include <tools/intn.hxx>
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

#ifndef _COM_SUN_STAR_I18N_KNUMBERFORMATUSAGE_HPP_
#include <com/sun/star/i18n/KNumberFormatUsage.hpp>
#endif

#pragma hdrstop

// Are these formats to be generated here (value 0)? Or are they generated by
// the NumberFormatter (value >0)? The count value is used for error checking.
#define NOGEN_NF_FRACTION	2
#define NOGEN_NF_BOOLEAN	1
#define NOGEN_NF_TEXT		1
#define NOT_GENERATED		(NOGEN_NF_FRACTION + NOGEN_NF_BOOLEAN + NOGEN_NF_TEXT)

using namespace ::com::sun::star::i18n;


LocaleDataFormats::LocaleDataFormats( International* pIntlP )
		:
		pIntl( pIntlP ),
		bChangeIntl( TRUE )
{
}


void LocaleDataFormats::getFormats(
			::com::sun::star::uno::Sequence< ::com::sun::star::i18n::FormatElement > & rSeq
			)
{
	if ( bChangeIntl )
	{
		setupKeywords();
		bChangeIntl = FALSE;
	}
	ImpGenerateFormats( rSeq );
}


void LocaleDataFormats::setupKeywords()
{
	sKeyword[NF_KEY_E].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 	"E" ) );		// exponent
	sKeyword[NF_KEY_AMPM].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 	"AM/PM" ) );	// AM/PM long
	sKeyword[NF_KEY_AP].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 	"A/P" ) );		// AM/PM short
	sKeyword[NF_KEY_MI].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 	"M" ) );		// minute  2
	sKeyword[NF_KEY_MMI].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 	"MM" ) );		// minute 02
	sKeyword[NF_KEY_S].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 	"S" ) );		// second  2
	sKeyword[NF_KEY_SS].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 	"SS" ) );		// second 02
	sKeyword[NF_KEY_Q].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 	"Q" ) );		// quarter short
	sKeyword[NF_KEY_QQ].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 	"QQ" ) );		// quarter long
	sKeyword[NF_KEY_NN].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 	"NN" ) );		// day of week short
	sKeyword[NF_KEY_NNN].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 	"NNN" ) );		// day of week long
	sKeyword[NF_KEY_NNNN].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 	"NNNN" ) );		// day of week long with separator
	sKeyword[NF_KEY_WW].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 	"WW" ) );		// week of year
	sKeyword[NF_KEY_CCC].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 	"CCC" ) );		// currency bank
	SetDependentKeywords();
}


void LocaleDataFormats::SetDependentKeywords()
{
	LanguageType eLnge = pIntl->GetLanguage();
	if ( eLnge == LANGUAGE_SYSTEM )
		eLnge = System::GetLanguage();

	// preset new calendar keywords
	sKeyword[NF_KEY_AAA].AssignAscii( RTL_CONSTASCII_STRINGPARAM(	"AAA" ) );
	sKeyword[NF_KEY_AAAA].AssignAscii( RTL_CONSTASCII_STRINGPARAM(	"AAAA" ) );
	sKeyword[NF_KEY_EC].AssignAscii( RTL_CONSTASCII_STRINGPARAM(	"E" ) );
	sKeyword[NF_KEY_EEC].AssignAscii( RTL_CONSTASCII_STRINGPARAM(	"EE" ) );
	sKeyword[NF_KEY_G].AssignAscii( RTL_CONSTASCII_STRINGPARAM(		"G" ) );
	sKeyword[NF_KEY_GG].AssignAscii( RTL_CONSTASCII_STRINGPARAM(	"GG" ) );
	sKeyword[NF_KEY_GGG].AssignAscii( RTL_CONSTASCII_STRINGPARAM(	"GGG" ) );
	sKeyword[NF_KEY_R].AssignAscii( RTL_CONSTASCII_STRINGPARAM(		"R" ) );
	sKeyword[NF_KEY_RR].AssignAscii( RTL_CONSTASCII_STRINGPARAM(	"RR" ) );

	switch ( eLnge )
	{
		case LANGUAGE_GERMAN:
		case LANGUAGE_GERMAN_SWISS:
		case LANGUAGE_GERMAN_AUSTRIAN:
		case LANGUAGE_GERMAN_LUXEMBOURG:
		case LANGUAGE_GERMAN_LIECHTENSTEIN:
		{
			sNameGeneral.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "Standard" ) );	//!! only 'a'-'Z' allowed !!

			//! only capital letters
			sKeyword[NF_KEY_GENERAL].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 	"STANDARD" ) );	// =sNameGeneral
			sKeyword[NF_KEY_M].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 		"M" ) );    // month 2
			sKeyword[NF_KEY_MM].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 		"MM" ) );   // month 02
			sKeyword[NF_KEY_MMM].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 		"MMM" ) );  // month Jan
			sKeyword[NF_KEY_MMMM].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 		"MMMM" ) ); // month Januar
			sKeyword[NF_KEY_MMMMM].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 	"MMMMM" ) );// month J
			sKeyword[NF_KEY_H].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 		"H" ) ); 			// hour 2
			sKeyword[NF_KEY_HH].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 		"HH" ) );			// hour 02
			sKeyword[NF_KEY_D].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 		"T" ) );
			sKeyword[NF_KEY_DD].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 		"TT" ) );
			sKeyword[NF_KEY_DDD].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 		"TTT" ) );
			sKeyword[NF_KEY_DDDD].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 		"TTTT" ) );
			sKeyword[NF_KEY_YY].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 		"JJ" ) );
			sKeyword[NF_KEY_YYYY].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 		"JJJJ" ) );
			sKeyword[NF_KEY_QUARTER] = GetQuarterWord( eLnge );
			sKeyword[NF_KEY_TRUE].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 		"WAHR" ) );
			sKeyword[NF_KEY_FALSE].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 	"FALSCH" ) );
			sKeyword[NF_KEY_BOOLEAN].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 	"LOGISCH" ) );
			sKeyword[NF_KEY_COLOR].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 	"FARBE" ) );
			sKeyword[NF_KEY_BLACK].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 	"SCHWARZ" ) );
			sKeyword[NF_KEY_BLUE].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 		"BLAU" ) );
			sKeyword[NF_KEY_GREEN] = UniString( "GR" "\xDC" "N", RTL_TEXTENCODING_ISO_8859_1 );
			sKeyword[NF_KEY_CYAN].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 		"CYAN" ) );
			sKeyword[NF_KEY_RED].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 		"ROT" ) );
			sKeyword[NF_KEY_MAGENTA].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 	"MAGENTA" ) );
			sKeyword[NF_KEY_BROWN].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 	"BRAUN" ) );
			sKeyword[NF_KEY_GREY].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 		"GRAU" ) );
			sKeyword[NF_KEY_YELLOW].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 	"GELB" ) );
			sKeyword[NF_KEY_WHITE].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 	"WEISS" ) );
		}
		break;
		default:
		{
			// General
			switch ( eLnge )
			{
				case LANGUAGE_ENGLISH           :
				case LANGUAGE_ENGLISH_US        :
				case LANGUAGE_ENGLISH_UK        :
				case LANGUAGE_ENGLISH_AUS       :
				case LANGUAGE_ENGLISH_CAN       :
				case LANGUAGE_ENGLISH_NZ        :
				case LANGUAGE_ENGLISH_EIRE      :
				case LANGUAGE_ENGLISH_SAFRICA   :
				case LANGUAGE_ENGLISH_JAMAICA   :
				case LANGUAGE_ENGLISH_CARRIBEAN :
				case LANGUAGE_ENGLISH_BELIZE	:
				case LANGUAGE_ENGLISH_TRINIDAD	:
				case LANGUAGE_ENGLISH_ZIMBABWE	:
				case LANGUAGE_ENGLISH_PHILIPPINES:
					sNameGeneral.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "General" ) );
					sKeyword[NF_KEY_GENERAL].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "GENERAL" ) );
				break;
				case LANGUAGE_PORTUGUESE           :
				case LANGUAGE_SPANISH             :
				case LANGUAGE_SPANISH_MEXICAN     :
				case LANGUAGE_SPANISH_MODERN      :
				case LANGUAGE_SPANISH_GUATEMALA   :
				case LANGUAGE_SPANISH_COSTARICA   :
				case LANGUAGE_SPANISH_PANAMA      :
				case LANGUAGE_SPANISH_DOMINICAN_REPUBLIC :
				case LANGUAGE_SPANISH_VENEZUELA   :
				case LANGUAGE_SPANISH_COLOMBIA    :
				case LANGUAGE_SPANISH_PERU        :
				case LANGUAGE_SPANISH_ARGENTINA   :
				case LANGUAGE_SPANISH_ECUADOR     :
				case LANGUAGE_SPANISH_CHILE       :
				case LANGUAGE_SPANISH_URUGUAY     :
				case LANGUAGE_SPANISH_PARAGUAY    :
				case LANGUAGE_SPANISH_BOLIVIA     :
				case LANGUAGE_SPANISH_EL_SALVADOR :
				case LANGUAGE_SPANISH_HONDURAS    :
				case LANGUAGE_SPANISH_NICARAGUA   :
				case LANGUAGE_SPANISH_PUERTO_RICO :
					sNameGeneral.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "Estandar" ) );
					sKeyword[NF_KEY_GENERAL].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "ESTANDAR" ) );
				break;
				case LANGUAGE_PORTUGUESE_BRAZILIAN :
					sNameGeneral.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "Geral" ) );
					sKeyword[NF_KEY_GENERAL].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "GERAL" ) );
				break;
				case LANGUAGE_FINNISH :
					sNameGeneral.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "Yleinen" ) );
					sKeyword[NF_KEY_GENERAL].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "YLEINEN" ) );
				break;
				case LANGUAGE_DUTCH         :
				case LANGUAGE_DUTCH_BELGIAN :
					sNameGeneral.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "Standaard" ) );
					sKeyword[NF_KEY_GENERAL].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "STANDAARD" ) );
				break;
				default:
					sNameGeneral.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "Standard" ) );
					sKeyword[NF_KEY_GENERAL].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "STANDARD" ) );
			}
			// day
			switch ( eLnge )
			{
				case LANGUAGE_ITALIAN       :
				case LANGUAGE_ITALIAN_SWISS :
					sKeyword[NF_KEY_D].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "G" ) );
					sKeyword[NF_KEY_DD].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "GG" ) );
					sKeyword[NF_KEY_DDD].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "GGG" ) );
					sKeyword[NF_KEY_DDDD].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "GGGG" ) );
					// must exchange the era code, same as Xcl
					sKeyword[NF_KEY_G].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "X" ) );
					sKeyword[NF_KEY_GG].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "XX" ) );
					sKeyword[NF_KEY_GGG].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "XXX" ) );
				break;
				case LANGUAGE_FRENCH            :
				case LANGUAGE_FRENCH_BELGIAN    :
				case LANGUAGE_FRENCH_CANADIAN   :
				case LANGUAGE_FRENCH_SWISS      :
				case LANGUAGE_FRENCH_LUXEMBOURG :
				case LANGUAGE_FRENCH_MONACO		:
					sKeyword[NF_KEY_D].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "J" ) );
					sKeyword[NF_KEY_DD].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "JJ" ) );
					sKeyword[NF_KEY_DDD].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "JJJ" ) );
					sKeyword[NF_KEY_DDDD].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "JJJJ" ) );
				break;
				case LANGUAGE_FINNISH :
					sKeyword[NF_KEY_D].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "P" ) );
					sKeyword[NF_KEY_DD].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "PP" ) );
					sKeyword[NF_KEY_DDD].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "PPP" ) );
					sKeyword[NF_KEY_DDDD].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "PPPP" ) );
				break;
				default:
					sKeyword[NF_KEY_D].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "D" ) );
					sKeyword[NF_KEY_DD].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "DD" ) );
					sKeyword[NF_KEY_DDD].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "DDD" ) );
					sKeyword[NF_KEY_DDDD].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "DDDD" ) );
			}
			// month
			switch ( eLnge )
			{
				case LANGUAGE_FINNISH :
					sKeyword[NF_KEY_M].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "K" ) );
					sKeyword[NF_KEY_MM].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "KK" ) );
					sKeyword[NF_KEY_MMM].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "KKK" ) );
					sKeyword[NF_KEY_MMMM].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "KKKK" ) );
					sKeyword[NF_KEY_MMMMM].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "KKKKK" ) );
				break;
				default:
					sKeyword[NF_KEY_M].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "M" ) );
					sKeyword[NF_KEY_MM].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "MM" ) );
					sKeyword[NF_KEY_MMM].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "MMM" ) );
					sKeyword[NF_KEY_MMMM].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "MMMM" ) );
					sKeyword[NF_KEY_MMMMM].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "MMMMM" ) );
			}
			// year
			switch ( eLnge )
			{
				case LANGUAGE_ITALIAN       :
				case LANGUAGE_ITALIAN_SWISS :
				case LANGUAGE_FRENCH            :
				case LANGUAGE_FRENCH_BELGIAN    :
				case LANGUAGE_FRENCH_CANADIAN   :
				case LANGUAGE_FRENCH_SWISS      :
				case LANGUAGE_FRENCH_LUXEMBOURG :
				case LANGUAGE_FRENCH_MONACO		:
				case LANGUAGE_PORTUGUESE           :
				case LANGUAGE_PORTUGUESE_BRAZILIAN :
				case LANGUAGE_SPANISH             :
				case LANGUAGE_SPANISH_MEXICAN     :
				case LANGUAGE_SPANISH_MODERN      :
				case LANGUAGE_SPANISH_GUATEMALA   :
				case LANGUAGE_SPANISH_COSTARICA   :
				case LANGUAGE_SPANISH_PANAMA      :
				case LANGUAGE_SPANISH_DOMINICAN_REPUBLIC :
				case LANGUAGE_SPANISH_VENEZUELA   :
				case LANGUAGE_SPANISH_COLOMBIA    :
				case LANGUAGE_SPANISH_PERU        :
				case LANGUAGE_SPANISH_ARGENTINA   :
				case LANGUAGE_SPANISH_ECUADOR     :
				case LANGUAGE_SPANISH_CHILE       :
				case LANGUAGE_SPANISH_URUGUAY     :
				case LANGUAGE_SPANISH_PARAGUAY    :
				case LANGUAGE_SPANISH_BOLIVIA     :
				case LANGUAGE_SPANISH_EL_SALVADOR :
				case LANGUAGE_SPANISH_HONDURAS    :
				case LANGUAGE_SPANISH_NICARAGUA   :
				case LANGUAGE_SPANISH_PUERTO_RICO :
					sKeyword[NF_KEY_YY].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "AA" ) );
					sKeyword[NF_KEY_YYYY].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "AAAA" ) );
					// must exchange the day of week name code, same as Xcl
					sKeyword[NF_KEY_AAA].AssignAscii( RTL_CONSTASCII_STRINGPARAM(	"OOO" ) );
					sKeyword[NF_KEY_AAAA].AssignAscii( RTL_CONSTASCII_STRINGPARAM(	"OOOO" ) );
				break;
				case LANGUAGE_DUTCH         :
				case LANGUAGE_DUTCH_BELGIAN :
					sKeyword[NF_KEY_YY].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "JJ" ) );
					sKeyword[NF_KEY_YYYY].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "JJJJ" ) );
				break;
				case LANGUAGE_FINNISH :
					sKeyword[NF_KEY_YY].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "VV" ) );
					sKeyword[NF_KEY_YYYY].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "VVVV" ) );
				break;
				default:
					sKeyword[NF_KEY_YY].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "YY" ) );
					sKeyword[NF_KEY_YYYY].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "YYYY" ) );
			}
			// hour
			switch ( eLnge )
			{
				case LANGUAGE_DUTCH         :
				case LANGUAGE_DUTCH_BELGIAN :
					sKeyword[NF_KEY_H].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "U" ) );
					sKeyword[NF_KEY_HH].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "UU" ) );
				break;
				case LANGUAGE_FINNISH :
				case LANGUAGE_SWEDISH         :
				case LANGUAGE_SWEDISH_FINLAND :
				case LANGUAGE_DANISH :
				case LANGUAGE_NORWEGIAN         :
				case LANGUAGE_NORWEGIAN_BOKMAL  :
				case LANGUAGE_NORWEGIAN_NYNORSK :
					sKeyword[NF_KEY_H].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "T" ) );
					sKeyword[NF_KEY_HH].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "TT" ) );
				break;
				default:
					sKeyword[NF_KEY_H].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "H" ) );
					sKeyword[NF_KEY_HH].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "HH" ) );
			}
			// quarter
			sKeyword[NF_KEY_QUARTER] = GetQuarterWord( eLnge );
			// logical boolean
			const xub_Unicode *pTrue, *pFalse;
			GetLogicalKeywords( eLnge, pTrue, pFalse );
			sKeyword[NF_KEY_TRUE] = pTrue;
			sKeyword[NF_KEY_FALSE] = pFalse;
			sKeyword[NF_KEY_BOOLEAN].AssignAscii( RTL_CONSTASCII_STRINGPARAM( "BOOLEAN" ) );
			// colour
			sKeyword[NF_KEY_COLOR].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 	"COLOR" ) );
			sKeyword[NF_KEY_BLACK].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 	"BLACK" ) );
			sKeyword[NF_KEY_BLUE].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 		"BLUE" ) );
			sKeyword[NF_KEY_GREEN].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 	"GREEN" ) );
			sKeyword[NF_KEY_CYAN].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 		"CYAN" ) );
			sKeyword[NF_KEY_RED].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 		"RED" ) );
			sKeyword[NF_KEY_MAGENTA].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 	"MAGENTA" ) );
			sKeyword[NF_KEY_BROWN].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 	"BROWN" ) );
			sKeyword[NF_KEY_GREY].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 		"GREY" ) );
			sKeyword[NF_KEY_YELLOW].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 	"YELLOW" ) );
			sKeyword[NF_KEY_WHITE].AssignAscii( RTL_CONSTASCII_STRINGPARAM( 	"WHITE" ) );
		}
		break;
	}
}


// static
void LocaleDataFormats::GetLogicalKeywords( LanguageType eLnge,
		const sal_Unicode*& pTrue, const sal_Unicode*& pFalse )
{
	static const sal_Unicode pDanishTrue[]		= { 'S', 'A', 'N', 'D', 0 };
	static const sal_Unicode pDanishFalse[]		= { 'F', 'A', 'L', 'S', 'K', 0 };
	static const sal_Unicode pDutchTrue[]		= { 'W', 'A', 'A', 'R', 0 };
	static const sal_Unicode pDutchFalse[]		= { 'O', 'N', 'W', 'A', 'A', 'R', 0 };
	static const sal_Unicode pFrenchTrue[]		= { 'V', 'R', 'A', 'I', 0 };
	static const sal_Unicode pFrenchFalse[]		= { 'F', 'A', 'U', 'X', 0 };
	static const sal_Unicode pGermanTrue[]		= { 'W', 'A', 'H', 'R', 0 };
	static const sal_Unicode pGermanFalse[]		= { 'F', 'A', 'L', 'S', 'C', 'H', 0 };
	static const sal_Unicode pItalianTrue[]		= { 'V', 'E', 'R', 'O', 0 };
	static const sal_Unicode pItalianFalse[]	= { 'F', 'A', 'L', 'S', 'O', 0 };
	static const sal_Unicode pNorwegianTrue[]  	= { 'R', 'I', 'K', 'T', 'I', 'G', 0 };
	static const sal_Unicode pNorwegianFalse[] 	= { 'G', 'A', 'L', 'T', 0 };
	static const sal_Unicode pPortugueseTrue[]	= { 'V', 'E', 'R', 'D', 'A', 'D', 'E', 'I', 'R', 'O', 0 };
	static const sal_Unicode pPortugueseFalse[]	= { 'F', 'A', 'L', 'S', 'O', 0 };
	static const sal_Unicode pSpanishTrue[]		= { 'V', 'E', 'R', 'D', 'A', 'D', 'E', 'R', 'O', 0 };
	static const sal_Unicode pSpanishFalse[]	= { 'F', 'A', 'L', 'S', 'O', 0 };
	static const sal_Unicode pSwedishTrue[]		= { 'S', 'A', 'N', 'T', 0 };
	static const sal_Unicode pSwedishFalse[] 	= { 'F', 'A', 'L', 'S', 'K', 'T', 0 };
	static const sal_Unicode pEnglishTrue[]		= { 'T', 'R', 'U', 'E', 0 };
	static const sal_Unicode pEnglishFalse[]   	= { 'F', 'A', 'L', 'S', 'E', 0 };

	if ( eLnge == LANGUAGE_SYSTEM )
		eLnge = System::GetLanguage();
	switch ( eLnge )
	{
		case LANGUAGE_DANISH:
			pTrue = pDanishTrue;
			pFalse = pDanishFalse;
			break;

		case LANGUAGE_DUTCH         :
		case LANGUAGE_DUTCH_BELGIAN :
			pTrue = pDutchTrue;
			pFalse = pDutchFalse;
			break;

		case LANGUAGE_FRENCH:
		case LANGUAGE_FRENCH_BELGIAN:
		case LANGUAGE_FRENCH_CANADIAN:
		case LANGUAGE_FRENCH_SWISS:
		case LANGUAGE_FRENCH_LUXEMBOURG:
		case LANGUAGE_FRENCH_MONACO:
			pTrue  = pFrenchTrue;
			pFalse = pFrenchFalse;
			break;

		case LANGUAGE_GERMAN:
		case LANGUAGE_GERMAN_SWISS:
		case LANGUAGE_GERMAN_AUSTRIAN:
		case LANGUAGE_GERMAN_LUXEMBOURG:
		case LANGUAGE_GERMAN_LIECHTENSTEIN:
			pTrue  = pGermanTrue;
			pFalse = pGermanFalse;
			break;

		case LANGUAGE_ITALIAN:
		case LANGUAGE_ITALIAN_SWISS:
			pTrue  = pItalianTrue;
			pFalse = pItalianFalse;
			break;

		case LANGUAGE_NORWEGIAN:
		case LANGUAGE_NORWEGIAN_BOKMAL:
		case LANGUAGE_NORWEGIAN_NYNORSK:
			pTrue  = pNorwegianTrue;
			pFalse = pNorwegianFalse;
			break;

		case LANGUAGE_PORTUGUESE:
		case LANGUAGE_PORTUGUESE_BRAZILIAN:
			pTrue  = pPortugueseTrue;
			pFalse = pPortugueseFalse;
			break;

		case LANGUAGE_SPANISH             :
		case LANGUAGE_SPANISH_MEXICAN     :
		case LANGUAGE_SPANISH_MODERN      :
		case LANGUAGE_SPANISH_GUATEMALA   :
		case LANGUAGE_SPANISH_COSTARICA   :
		case LANGUAGE_SPANISH_PANAMA      :
		case LANGUAGE_SPANISH_DOMINICAN_REPUBLIC :
		case LANGUAGE_SPANISH_VENEZUELA   :
		case LANGUAGE_SPANISH_COLOMBIA    :
		case LANGUAGE_SPANISH_PERU        :
		case LANGUAGE_SPANISH_ARGENTINA   :
		case LANGUAGE_SPANISH_ECUADOR     :
		case LANGUAGE_SPANISH_CHILE       :
		case LANGUAGE_SPANISH_URUGUAY     :
		case LANGUAGE_SPANISH_PARAGUAY    :
		case LANGUAGE_SPANISH_BOLIVIA     :
		case LANGUAGE_SPANISH_EL_SALVADOR :
		case LANGUAGE_SPANISH_HONDURAS    :
		case LANGUAGE_SPANISH_NICARAGUA   :
		case LANGUAGE_SPANISH_PUERTO_RICO :
			pTrue  = pSpanishTrue;
			pFalse = pSpanishFalse;
			break;

		case LANGUAGE_SWEDISH:
			pTrue  = pSwedishTrue;
			pFalse = pSwedishFalse;
			break;

		default:
			pTrue  = pEnglishTrue;
			pFalse = pEnglishFalse;
			break;
	}	// switch
}


// static
String LocaleDataFormats::GetQuarterWord( LanguageType eLang )
{
	String aStr;
	if ( eLang == LANGUAGE_SYSTEM )
		eLang = System::GetLanguage();
	switch ( eLang )
	{
		case LANGUAGE_GERMAN:
		case LANGUAGE_GERMAN_SWISS:
		case LANGUAGE_GERMAN_AUSTRIAN:
		case LANGUAGE_GERMAN_LUXEMBOURG:
		case LANGUAGE_GERMAN_LIECHTENSTEIN:
			aStr.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "Quartal" ) );
		break;
		default:
			aStr.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "quarter" ) );
	}
	return aStr;
}


String LocaleDataFormats::mapElementUsageShortToString( sal_Int16 nFormatUsage )
{
	String aStr;
	switch ( nFormatUsage )
	{
		case KNumberFormatUsage::DATE :
			aStr.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "DATE" ) );
		break;
		case KNumberFormatUsage::TIME :
			aStr.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "TIME" ) );
		break;
		case KNumberFormatUsage::DATE_TIME :
			aStr.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "DATE_TIME" ) );
		break;
		case KNumberFormatUsage::FIXED_NUMBER :
			aStr.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "FIXED_NUMBER" ) );
		break;
		case KNumberFormatUsage::FRACTION_NUMBER :
			aStr.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "FRACTION_NUMBER" ) );
		break;
		case KNumberFormatUsage::PERCENT_NUMBER :
			aStr.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "PERCENT_NUMBER" ) );
		break;
		case KNumberFormatUsage::CURRENCY :
			aStr.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "CURRENCY" ) );
		break;
		case KNumberFormatUsage::SCIENTIFIC_NUMBER :
			aStr.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "SCIENTIFIC_NUMBER" ) );
		break;
		default:
			aStr.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "UNKNOWN" ) );
	}
	return aStr;
}


String LocaleDataFormats::mapElementKeyShortToString( sal_Int16 nFormatUsage )
{
	String aStr;
	switch ( nFormatUsage )
	{
		case KNumberFormatUsage::DATE :
			aStr.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "Date" ) );
		break;
		case KNumberFormatUsage::TIME :
			aStr.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "Time" ) );
		break;
		case KNumberFormatUsage::DATE_TIME :
			aStr.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "DateTime" ) );
		break;
		case KNumberFormatUsage::FIXED_NUMBER :
			aStr.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "Fixed" ) );
		break;
		case KNumberFormatUsage::FRACTION_NUMBER :
			aStr.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "Fraction" ) );
		break;
		case KNumberFormatUsage::PERCENT_NUMBER :
			aStr.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "Percent" ) );
		break;
		case KNumberFormatUsage::CURRENCY :
			aStr.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "Currency" ) );
		break;
		case KNumberFormatUsage::SCIENTIFIC_NUMBER :
			aStr.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "Scientific" ) );
		break;
		default:
			aStr.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "Unknown" ) );
	}
	aStr.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "Formatskey" ) );
	return aStr;
}


void LocaleDataFormats::ImpGenerateFormats(
			::com::sun::star::uno::Sequence< ::com::sun::star::i18n::FormatElement > & rSeq
			)
{
	String aSystem( RTL_CONSTASCII_USTRINGPARAM( "System" ) );
	String aDefSystem( RTL_CONSTASCII_USTRINGPARAM( "def/System" ) );
	String aEmptyString;
	String aTypeShort(	RTL_CONSTASCII_USTRINGPARAM( "short" ) );
	String aTypeMedium(	RTL_CONSTASCII_USTRINGPARAM( "medium" ) );
	String aTypeLong(	RTL_CONSTASCII_USTRINGPARAM( "long" ) );

	xub_Unicode cDecSep = pIntl->GetNumDecimalSep();
	xub_Unicode cThousandSep = pIntl->GetNumThousandSep();

	sal_Int32 nFormatElement = 0;		// element in sequence
	sal_Int32 nElementKey;				// key number in formats entity

	// string: code, name, key, type, usage; int16: index; bool: default
	String aKeyString, aUsageString, aTmpStr;

	// Number
	nElementKey = 1;
	aKeyString = mapElementKeyShortToString( KNumberFormatUsage::FIXED_NUMBER );
	aUsageString = mapElementUsageShortToString( KNumberFormatUsage::FIXED_NUMBER );

	// Number General
	rSeq[nFormatElement++] = FormatElement(
		sNameGeneral,
		aEmptyString,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeMedium,
		aUsageString,
		NF_NUMBER_STANDARD,
		sal_True
		);

	// Number 0
	rSeq[nFormatElement++] = FormatElement(
		String( '0' ),
		aEmptyString,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeShort,
		aUsageString,
		NF_NUMBER_INT,
		sal_False
		);

	// Number 0.00
	aTmpStr.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "000" ) );
	aTmpStr.Insert(cDecSep,1);
	rSeq[nFormatElement++] = FormatElement(
		aTmpStr,
		aEmptyString,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeMedium,
		aUsageString,
		NF_NUMBER_DEC2,
		sal_False
		);

	// Number #,##0
	aTmpStr.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "###0" ) );
	aTmpStr.Insert(cThousandSep,1);
	rSeq[nFormatElement++] = FormatElement(
		aTmpStr,
		aEmptyString,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeShort,
		aUsageString,
		NF_NUMBER_1000INT,
		sal_False
		);

	// Number #,##0.00
	aTmpStr.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "###000" ) );
	aTmpStr.Insert(cThousandSep,1);
	aTmpStr.Insert(cDecSep,5);
	rSeq[nFormatElement++] = FormatElement(
		aTmpStr,
		aEmptyString,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeMedium,
		aUsageString,
		NF_NUMBER_1000DEC2,
		sal_False
		);

	// Number #,##0.00 System
	String sNumSystem;
	if ( pIntl->IsNumLeadingZero() )
		sNumSystem = '0';
	if ( pIntl->IsNumThousandSep() )
	{
		if ( pIntl->IsNumLeadingZero() )
			sNumSystem.Insert( String::CreateFromAscii(
				RTL_CONSTASCII_STRINGPARAM( "###" ) ), 0 );
		else
			sNumSystem.Insert( String::CreateFromAscii(
				RTL_CONSTASCII_STRINGPARAM( "####" ) ), 0 );
		sNumSystem.Insert( cThousandSep, 1 );
	}
	USHORT nNumDigits = pIntl->GetNumDigits();
	if ( nNumDigits )
	{
		sNumSystem += cDecSep;
		for ( USHORT j=0; j<nNumDigits; j++ )
		{
			sNumSystem += '0';
		}
	}
	rSeq[nFormatElement++] = FormatElement(
		sNumSystem,
		aSystem,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeMedium,
		aUsageString,
		NF_NUMBER_SYSTEM,
		sal_False
		);



	// Percent
	nElementKey = 1;
	aKeyString = mapElementKeyShortToString( KNumberFormatUsage::PERCENT_NUMBER );
	aUsageString = mapElementUsageShortToString( KNumberFormatUsage::PERCENT_NUMBER );

	// Percent 0%
	aTmpStr.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "0%" ) );
	rSeq[nFormatElement++] = FormatElement(
		aTmpStr,
		aEmptyString,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeShort,
		aUsageString,
		NF_PERCENT_INT,
		sal_False
		);

	// Percent 0.00%
	aTmpStr.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "000%" ) );
	aTmpStr.Insert(cDecSep,1);
	rSeq[nFormatElement++] = FormatElement(
		aTmpStr,
		aEmptyString,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeLong,
		aUsageString,
		NF_PERCENT_DEC2,
		sal_True
		);



	// Currency
	nElementKey = 1;
	aKeyString = mapElementKeyShortToString( KNumberFormatUsage::CURRENCY );
	aUsageString = mapElementUsageShortToString( KNumberFormatUsage::CURRENCY );

	String aRed( '[' );
	aRed += sKeyword[NF_KEY_RED];
	aRed += ']';

	// Currency #,##0 DM
	String sCurrFlat1( RTL_CONSTASCII_USTRINGPARAM( "###0" ) );
	sCurrFlat1.Insert(cThousandSep,1);
	String sCurrFlat2( sCurrFlat1 );					// #,##0.00 DM
	String sCurrFlat3( sCurrFlat1 );					// #,##0.-- DM
	// Count of decimal digits in currency
	USHORT nCurrDigits = pIntl->GetCurrDigits();
	if ( nCurrDigits )
	{
		sCurrFlat2 += cDecSep;
		sCurrFlat3 += cDecSep;
		sCurrFlat2.Expand( sCurrFlat2.Len() + nCurrDigits, '0' );
		sCurrFlat3.Expand( sCurrFlat3.Len() + nCurrDigits, '-' );
	}

	String s6 = sCurrFlat1;								// #,##0 DM
	ImpGetPosCurrFormat(s6);
	String s7 = sCurrFlat2;								// #,##0.00 DM
	ImpGetPosCurrFormat(s7);
	String sDash = sCurrFlat3;							// #,##0.-- DM
	ImpGetPosCurrFormat(sDash);
	String sNegStr1 = sCurrFlat1;						// -#,##0 DM
	ImpGetNegCurrFormat(sNegStr1);
	String sNegStr2 = sCurrFlat2;						// -#,##0.00 DM
	ImpGetNegCurrFormat(sNegStr2);
	String sNegStr3 = sCurrFlat3;						// -#,##0.-- DM
	ImpGetNegCurrFormat(sNegStr3);
	s6 += ';';
	String s8 = s6;
	s6 += sNegStr1;
	s8 += aRed;
	s8 += sNegStr1;
	s7 += ';';
	String s9 = s7;
	s7 += sNegStr2;
	s9 += aRed;
	s9 += sNegStr2;
	sDash += ';';
	String sDashed = sDash;
	sDash += sNegStr3;
	sDashed += aRed;
	sDashed += sNegStr3;

	// Currency #,##0 DM;-#,##0 DM
	rSeq[nFormatElement++] = FormatElement(
		s6,
		aEmptyString,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeShort,
		aUsageString,
		NF_CURRENCY_1000INT,
		sal_False
		);
	// Currency #,##0.00 DM;-#,##0.00 DM
	rSeq[nFormatElement++] = FormatElement(
		s7,
		aEmptyString,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeMedium,
		aUsageString,
		NF_CURRENCY_1000DEC2,
		sal_False
		);
	// Currency #,##0 DM;[RED]-#,##0 DM
	rSeq[nFormatElement++] = FormatElement(
		s8,
		aEmptyString,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeMedium,
		aUsageString,
		NF_CURRENCY_1000INT_RED,
		sal_False
		);
	// Currency #,##0.00 DM;[RED]-#,##0.00 DM
	rSeq[nFormatElement++] = FormatElement(
		s9,
		aEmptyString,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeMedium,
		aUsageString,
		NF_CURRENCY_1000DEC2_RED,
		sal_True
		);

	// Currency #,##0.00 DEM
	aTmpStr = sCurrFlat2;
	aTmpStr.AppendAscii( RTL_CONSTASCII_STRINGPARAM( " CCC" ) );
	rSeq[nFormatElement++] = FormatElement(
		aTmpStr,
		aEmptyString,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeMedium,
		aUsageString,
		NF_CURRENCY_1000DEC2_CCC,
		sal_False
		);

	// Currency #,##0.-- DM
	rSeq[nFormatElement++] = FormatElement(
		sDashed,
		aEmptyString,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeMedium,
		aUsageString,
		NF_CURRENCY_1000DEC2_DASHED,
		sal_False
		);



	// Date
	nElementKey = 1;
	aKeyString = mapElementKeyShortToString( KNumberFormatUsage::DATE );
	aUsageString = mapElementUsageShortToString( KNumberFormatUsage::DATE );

	xub_Unicode cDateSep = pIntl->GetDateSep();
	xub_Unicode cTimeSep = pIntl->GetTimeSep();

	// Date DD.MM.YY short system
	aTmpStr.Erase();
	ImpGetDateFormat(aTmpStr);
	rSeq[nFormatElement++] = FormatElement(
		aTmpStr,
		aSystem,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeShort,
		aUsageString,
		NF_DATE_SYSTEM_SHORT,
		sal_True
		);

	// Date NN DD.MMM YY
	aTmpStr = sKeyword[NF_KEY_NN];
	aTmpStr += ' ';
	aTmpStr += sKeyword[NF_KEY_DD];
	aTmpStr += cDateSep;
	aTmpStr += sKeyword[NF_KEY_MMM];
	aTmpStr += ' ';
	aTmpStr += sKeyword[NF_KEY_YY];
	rSeq[nFormatElement++] = FormatElement(
		aTmpStr,
		aEmptyString,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeMedium,
		aUsageString,
		NF_DATE_DEF_NNDDMMMYY,
		sal_False
		);

	String s12;                           // MM.YY
	String s13;                           // DD.MMM
	String sFullDate;						// DD.MM.YYYY
	String sDDMMYY;                       // DD.MM.YY
	switch(pIntl->GetDateFormat())
	{
		case DMY:
		{
			s12 = sKeyword[NF_KEY_MM];	   		// MM.YY
			s12 += cDateSep;
			s12 += sKeyword[NF_KEY_YY];
			s13 = sKeyword[NF_KEY_DD];	   		// DD.MMM
			s13 += cDateSep;
			s13 += sKeyword[NF_KEY_MMM];
			sFullDate = sKeyword[NF_KEY_DD]; 	// DD
			sFullDate += cDateSep;
			sFullDate += sKeyword[NF_KEY_MM];	// MM
			sFullDate += cDateSep;
			sDDMMYY = sFullDate;
			sFullDate += sKeyword[NF_KEY_YYYY];	// YYYY
			sDDMMYY += sKeyword[NF_KEY_YY];		// YY
		}
		break;
		case YMD:
		{
			s12 = sKeyword[NF_KEY_YY];			// YY.MM
			s12 += cDateSep;
			s12 += sKeyword[NF_KEY_MM];
			s13 = sKeyword[NF_KEY_MMM];			// MMM DD
			s13 += ' ';
			s13 += sKeyword[NF_KEY_DD];
			sFullDate = sKeyword[NF_KEY_YYYY];	// YYYY
			sDDMMYY = sKeyword[NF_KEY_YY];		// YY
			String aTmp( cDateSep );
			aTmp += sKeyword[NF_KEY_MM];		// MM
			aTmp += cDateSep;
			aTmp += sKeyword[NF_KEY_DD]; 		// DD
			sFullDate += aTmp;
			sDDMMYY += aTmp;

		}
		break;
		case MDY:
		default:
		{
			s12 = sKeyword[NF_KEY_MM];			// MM.YY
			s12 += cDateSep;
			s12 += sKeyword[NF_KEY_YY];
			s13 = sKeyword[NF_KEY_MMM];			// MMM DD
			s13 += ' ';
			s13 += sKeyword[NF_KEY_DD];
			sFullDate = sKeyword[NF_KEY_MM]; 	// MM
			sFullDate += cDateSep;
			sFullDate += sKeyword[NF_KEY_DD];	// DD
			sFullDate += cDateSep;
			sDDMMYY = sFullDate;
			sFullDate += sKeyword[NF_KEY_YYYY];	// YYYY
			sDDMMYY += sKeyword[NF_KEY_YY];		// YY
		}
		break;
	}
	rSeq[nFormatElement++] = FormatElement(
		s12,
		aDefSystem,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeMedium,
		aUsageString,
		NF_DATE_SYS_MMYY,
		sal_False
		);
	rSeq[nFormatElement++] = FormatElement(
		s13,
		aEmptyString,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeMedium,
		aUsageString,
		NF_DATE_SYS_DDMMM,
		sal_False
		);

	aTmpStr = sKeyword[NF_KEY_MMMM];		// MMMM
	rSeq[nFormatElement++] = FormatElement(
		aTmpStr,
		aEmptyString,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeMedium,
		aUsageString,
		NF_DATE_MMMM,
		sal_False
		);

	aTmpStr = sKeyword[NF_KEY_QQ];			// QQ YY
	aTmpStr += ' ';
	aTmpStr += sKeyword[NF_KEY_YY];
	rSeq[nFormatElement++] = FormatElement(
		aTmpStr,
		aEmptyString,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeMedium,
		aUsageString,
		NF_DATE_QQJJ,
		sal_False
		);

	// Date DD.MM.YYYY
	rSeq[nFormatElement++] = FormatElement(
		sFullDate,
		aDefSystem,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeMedium,
		aUsageString,
		NF_DATE_SYS_DDMMYYYY,
		sal_False
		);

	// Date DD.MM.YYYY
	rSeq[nFormatElement++] = FormatElement(
		sDDMMYY,
		aDefSystem,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeMedium,
		aUsageString,
		NF_DATE_SYS_DDMMYY,
		sal_False
		);

	// Date with long day of week
	// Uses "NNNN" instead of "NNN, " because of compatibility
	// Long date of system settings
	String sLongDate;
	ImpGetLongDateFormat( sLongDate );				// NNN, D. MMMM YYYY   System
	rSeq[nFormatElement++] = FormatElement(
		sLongDate,
		aSystem,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeLong,
		aUsageString,
		NF_DATE_SYSTEM_LONG,
		sal_False
		);


	// Hard coded but system dependent delimiters date formats

	sLongDate.Erase();
	ImpGetLongDateFormat( sLongDate, -1, 1, 1, 1 );	// D. MMM YY   def/System
	rSeq[nFormatElement++] = FormatElement(
		sLongDate,
		aDefSystem,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeLong,
		aUsageString,
		NF_DATE_SYS_DMMMYY,
		sal_False
		);

	sLongDate.Erase();
	ImpGetLongDateFormat( sLongDate, -1, 1, 1, 2 );	// D. MMM YYYY   def/System
	rSeq[nFormatElement++] = FormatElement(
		sLongDate,
		aDefSystem,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeLong,
		aUsageString,
		NF_DATE_SYS_DMMMYYYY,
		sal_False
		);

	sLongDate.Erase();
	ImpGetLongDateFormat( sLongDate, -1, 1, 2, 2 );	// D. MMMM YYYY   def/System
	rSeq[nFormatElement++] = FormatElement(
		sLongDate,
		aDefSystem,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeLong,
		aUsageString,
		NF_DATE_SYS_DMMMMYYYY,
		sal_False
		);

	sLongDate.Erase();
	ImpGetLongDateFormat( sLongDate, 1, 1, 1, 1 );	// NN, D. MMM YY   def/System
	rSeq[nFormatElement++] = FormatElement(
		sLongDate,
		aDefSystem,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeLong,
		aUsageString,
		NF_DATE_SYS_NNDMMMYY,
		sal_False
		);

	sLongDate.Erase();
	ImpGetLongDateFormat( sLongDate, 1, 1, 2, 2 );	// NN, D. MMMM YYYY   def/System
	rSeq[nFormatElement++] = FormatElement(
		sLongDate,
		aDefSystem,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeLong,
		aUsageString,
		NF_DATE_SYS_NNDMMMMYYYY,
		sal_False
		);

	sLongDate.Erase();
	ImpGetLongDateFormat( sLongDate, 2, 1, 2, 2 );	// NNN, D. MMMM YYYY   def/System
	rSeq[nFormatElement++] = FormatElement(
		sLongDate,
		aDefSystem,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeLong,
		aUsageString,
		NF_DATE_SYS_NNNNDMMMMYYYY,
		sal_False
		);


	// DIN (Deutsche Industrie Norm) and EN (European Norm) dates

	String aDIN( RTL_CONSTASCII_USTRINGPARAM( "DIN 5008 (EN 28601)" ) );
	String sDinTMMMJJJJ;						// DIN: D. MMM. YYYY
	sDinTMMMJJJJ += sKeyword[NF_KEY_D];
	sDinTMMMJJJJ += '.';
	sDinTMMMJJJJ += ' ';
	sDinTMMMJJJJ += sKeyword[NF_KEY_MMM];
	sDinTMMMJJJJ += '.';
	sDinTMMMJJJJ += ' ';
	sDinTMMMJJJJ += sKeyword[NF_KEY_YYYY];
	rSeq[nFormatElement++] = FormatElement(
		sDinTMMMJJJJ,
		aDIN,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeLong,
		aUsageString,
		NF_DATE_DIN_DMMMYYYY,
		sal_False
		);

	String sDinTMMMMJJJJ;						// DIN: D. MMMM YYYY
	sDinTMMMMJJJJ += sKeyword[NF_KEY_D];
	sDinTMMMMJJJJ += '.';
	sDinTMMMMJJJJ += ' ';
	sDinTMMMMJJJJ += sKeyword[NF_KEY_MMMM];
	sDinTMMMMJJJJ += ' ';
	sDinTMMMMJJJJ += sKeyword[NF_KEY_YYYY];
	rSeq[nFormatElement++] = FormatElement(
		sDinTMMMMJJJJ,
		aDIN,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeLong,
		aUsageString,
		NF_DATE_DIN_DMMMMYYYY,
		sal_False
		);

	String sDinMMTT;							// DIN: MM-DD
	sDinMMTT += sKeyword[NF_KEY_MM];
	sDinMMTT += '-';
	sDinMMTT += sKeyword[NF_KEY_DD];
	rSeq[nFormatElement++] = FormatElement(
		sDinMMTT,
		aDIN,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeShort,
		aUsageString,
		NF_DATE_DIN_MMDD,
		sal_False
		);

	String sDinJJMMTT = sDinMMTT;	 	   		// DIN: YY-MM-DD
	sDinJJMMTT.Insert( '-', 0 );
	sDinJJMMTT.Insert( sKeyword[NF_KEY_YY], 0 );
	rSeq[nFormatElement++] = FormatElement(
		sDinJJMMTT,
		aDIN,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeMedium,
		aUsageString,
		NF_DATE_DIN_YYMMDD,
		sal_False
		);

	String sDinJJJJMMTT = sDinMMTT;			// DIN: YYYY-MM-DD
	sDinJJJJMMTT.Insert( '-', 0 );
	sDinJJJJMMTT.Insert( sKeyword[NF_KEY_YYYY], 0 );
	rSeq[nFormatElement++] = FormatElement(
		sDinJJJJMMTT,
		aDIN,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeMedium,
		aUsageString,
		NF_DATE_DIN_YYYYMMDD,
		sal_False
		);

	// Date WeekOfYear
	rSeq[nFormatElement++] = FormatElement(
		sKeyword[NF_KEY_WW],
		aEmptyString,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeMedium,
		aUsageString,
		NF_DATE_WW,
		sal_False
		);



	// Time
	nElementKey = 1;
	aKeyString = mapElementKeyShortToString( KNumberFormatUsage::TIME );
	aUsageString = mapElementUsageShortToString( KNumberFormatUsage::TIME );

	String sHHMM = sKeyword[NF_KEY_HH];		// HH:MM
	sHHMM += cTimeSep;
	sHHMM += sKeyword[NF_KEY_MMI];
	rSeq[nFormatElement++] = FormatElement(
		sHHMM,
		aEmptyString,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeShort,
		aUsageString,
		NF_TIME_HHMM,
		sal_False
		);

	String sHHMMSS = sHHMM;				// HH:MM:SS
	sHHMMSS += cTimeSep;
	sHHMMSS += sKeyword[NF_KEY_SS];
	rSeq[nFormatElement++] = FormatElement(
		sHHMMSS,
		aEmptyString,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeMedium,
		aUsageString,
		NF_TIME_HHMMSS,
		sal_True
		);

	aTmpStr = sHHMM;						// HH:MM AM/PM
	aTmpStr += ' ';
	aTmpStr += sKeyword[NF_KEY_AMPM];
	rSeq[nFormatElement++] = FormatElement(
		aTmpStr,
		aEmptyString,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeShort,
		aUsageString,
		NF_TIME_HHMMAMPM,
		sal_False
		);

	aTmpStr = sHHMMSS;				// HH:MM:SS AM/PM
	aTmpStr += ' ';
	aTmpStr += sKeyword[NF_KEY_AMPM];
	rSeq[nFormatElement++] = FormatElement(
		aTmpStr,
		aEmptyString,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeMedium,
		aUsageString,
		NF_TIME_HHMMSSAMPM,
		sal_False
		);

	String sBigTime = sHHMMSS;				// [HH]:MM:SS
	sBigTime.Insert('[',0);
	sBigTime.Insert(']',3);
	rSeq[nFormatElement++] = FormatElement(
		sBigTime,
		aEmptyString,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeMedium,
		aUsageString,
		NF_TIME_HH_MMSS,
		sal_False
		);

	aTmpStr = sKeyword[NF_KEY_MMI];	// MM:SS,00
	aTmpStr += cTimeSep;
	aTmpStr += sKeyword[NF_KEY_SS];
	aTmpStr += cDecSep;
	aTmpStr += '0';
	aTmpStr += '0';
	rSeq[nFormatElement++] = FormatElement(
		aTmpStr,
		aEmptyString,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeShort,
		aUsageString,
		NF_TIME_MMSS00,
		sal_False
		);

	aTmpStr = sBigTime;						// [HH]:MM:SS,00
	aTmpStr += cDecSep;
	aTmpStr += '0';
	aTmpStr += '0';
	rSeq[nFormatElement++] = FormatElement(
		aTmpStr,
		aEmptyString,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeMedium,
		aUsageString,
		NF_TIME_HH_MMSS00,
		sal_False
		);



	// DateTime
	nElementKey = 1;
	aKeyString = mapElementKeyShortToString( KNumberFormatUsage::DATE_TIME );
	aUsageString = mapElementUsageShortToString( KNumberFormatUsage::DATE_TIME );

	aTmpStr = sDDMMYY; 					// DD.MM.YY HH:MM
	aTmpStr += ' ';
	aTmpStr += sHHMM;
	rSeq[nFormatElement++] = FormatElement(
		aTmpStr,
		aEmptyString,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeMedium,
		aUsageString,
		NF_DATETIME_SYSTEM_SHORT_HHMM,
		sal_True
		);

	String sFullDateTime = sFullDate;		// DD.MM.YYYY HH:MM:SS
	sFullDateTime += ' ';
	sFullDateTime += sHHMMSS;
	rSeq[nFormatElement++] = FormatElement(
		sFullDateTime,
		aEmptyString,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeMedium,
		aUsageString,
		NF_DATETIME_SYS_DDMMYYYY_HHMMSS,
		sal_False
		);



	// Scientific Number
	nElementKey = 1;
	aKeyString = mapElementKeyShortToString( KNumberFormatUsage::SCIENTIFIC_NUMBER );
	aUsageString = mapElementUsageShortToString( KNumberFormatUsage::SCIENTIFIC_NUMBER );

	// Scientific 0.00E+000
	aTmpStr.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "000E+000" ) );
	aTmpStr.Insert(cDecSep,1);
	rSeq[nFormatElement++] = FormatElement(
		aTmpStr,
		aEmptyString,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeMedium,
		aUsageString,
		NF_SCIENTIFIC_000E000,
		sal_True
		);

	// Scientific 0.00E+00
	aTmpStr.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "000E+00" ) );
	aTmpStr.Insert(cDecSep,1);
	rSeq[nFormatElement++] = FormatElement(
		aTmpStr,
		aEmptyString,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeMedium,
		aUsageString,
		NF_SCIENTIFIC_000E00,
		sal_False
		);



#if !NOGEN_NF_BOOLEAN
	// Boolean
	nElementKey = 1;
	aKeyString = mapElementKeyShortToString( KNumberFormatUsage::BOOLEAN );
	aUsageString = mapElementUsageShortToString( KNumberFormatUsage::BOOLEAN );

	rSeq[nFormatElement++] = FormatElement(
		sKeyword[NF_KEY_BOOLEAN],
		aEmptyString,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeMedium,
		aUsageString,
		NF_BOOLEAN,
		sal_True
		);
#endif



#if !NOGEN_NF_TEXT
	// Text
	nElementKey = 1;
	aKeyString = mapElementKeyShortToString( KNumberFormatUsage::TEXT );
	aUsageString = mapElementUsageShortToString( KNumberFormatUsage::TEXT );

	rSeq[nFormatElement++] = FormatElement(
		String( '0' ),
		aEmptyString,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeLong,
		aUsageString,
		NF_TEXT,
		sal_True
		);
#endif



#if !NOGEN_NF_FRACTION
	// Fraction Number  (! no default entry !)
	nElementKey = 1;
	aKeyString = mapElementKeyShortToString( KNumberFormatUsage::FRACTION_NUMBER );
	aUsageString = mapElementUsageShortToString( KNumberFormatUsage::FRACTION_NUMBER );

	// Fraction # ?/?
	rSeq[nFormatElement++] = FormatElement(
		String( RTL_CONSTASCII_USTRINGPARAM( "# ?/?" ) ),
		aEmptyString,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeShort,
		aUsageString,
		NF_FRACTION_1,
		sal_False
		);

	// Fraction # ??/??
	// "??/" would be interpreted by some compilers as a Trigraph for '\' !
	rSeq[nFormatElement++] = FormatElement(
		String( RTL_CONSTASCII_USTRINGPARAM( "# ?\?/?\?" ) ),
		aEmptyString,
		String( aKeyString ).Append( String::CreateFromInt32( nElementKey++ ) ),
		aTypeMedium,
		aUsageString,
		NF_FRACTION_2,
		sal_False
		);
#endif


#ifndef PRODUCT
	const sal_Int32 nNotGen = NOT_GENERATED;
	const sal_Int32 nNeeded = NF_INDEX_TABLE_ENTRIES;
	const sal_Int32 nTotal = nFormatElement + nNotGen;
	DBG_ASSERT( nTotal == nNeeded, "how many standard formats?" );
#endif
}


void LocaleDataFormats::ImpGetDateFormat(String& sDateStr)
{
	xub_Unicode cDateSep = pIntl->GetDateSep();
	switch (pIntl->GetDateFormat())
	{
		case MDY:
		{
			if (pIntl->IsDateMonthLeadingZero())
				sDateStr += sKeyword[NF_KEY_MM];
			else
				sDateStr += sKeyword[NF_KEY_M];
			sDateStr += cDateSep;
			if (pIntl->IsDateDayLeadingZero())
				sDateStr += sKeyword[NF_KEY_DD];
			else
				sDateStr += sKeyword[NF_KEY_D];
			sDateStr += cDateSep;
			if (pIntl->IsDateCentury())
				sDateStr += sKeyword[NF_KEY_YYYY];
			else
				sDateStr += sKeyword[NF_KEY_YY];
		}
		break;
		case DMY:
		{
			if (pIntl->IsDateDayLeadingZero())
				sDateStr += sKeyword[NF_KEY_DD];
			else
				sDateStr += sKeyword[NF_KEY_D];
			sDateStr += cDateSep;
			if (pIntl->IsDateMonthLeadingZero())
				sDateStr += sKeyword[NF_KEY_MM];
			else
				sDateStr += sKeyword[NF_KEY_M];
			sDateStr += cDateSep;
			if (pIntl->IsDateCentury())
				sDateStr += sKeyword[NF_KEY_YYYY];
			else
				sDateStr += sKeyword[NF_KEY_YY];
		}
		break;
		case YMD:
		{
			if (pIntl->IsDateCentury())
				sDateStr += sKeyword[NF_KEY_YYYY];
			else
				sDateStr += sKeyword[NF_KEY_YY];
			sDateStr += cDateSep;
			if (pIntl->IsDateMonthLeadingZero())
				sDateStr += sKeyword[NF_KEY_MM];
			else
				sDateStr += sKeyword[NF_KEY_M];
			sDateStr += cDateSep;
			if (pIntl->IsDateDayLeadingZero())
				sDateStr += sKeyword[NF_KEY_DD];
			else
				sDateStr += sKeyword[NF_KEY_D];
		}
		break;
		default:
		break;
	}
}


void lcl_ImplAddStringMaybeQuoted( String& rDes, const String& rSrc,
			International* pIntl )
{
	BOOL bQuoted = FALSE;
	const xub_StrLen nLen = rSrc.Len();
	xub_StrLen nPos = 0;
	while ( nPos < nLen )
	{
		sal_Unicode ch = rSrc.GetChar( nPos );
		if ( !bQuoted && pIntl->IsAlpha( ch ) )
		{
			rDes += '"';
			bQuoted = TRUE;
		}
		else if ( bQuoted && !pIntl->IsAlpha( ch ) )
		{
			rDes += '"';
			bQuoted = FALSE;
		}
		rDes += ch;
		nPos++;
	}
	if ( bQuoted )
		rDes += '"';
}


void LocaleDataFormats::ImpGetLongDateFormat( String& sDateStr,
								short nShortLongDayOfWeek,
								short nShortLongDay,
								short nShortLongMonth,
								short nShortLongYear )
{
	switch ( nShortLongDayOfWeek )
	{
		case -1 :
		break;
		case 0 :
			switch ( pIntl->GetLongDateDayOfWeekFormat() )
			{
				case DAYOFWEEK_NONE :
				break;
				case DAYOFWEEK_SHORT :
					sDateStr += sKeyword[NF_KEY_NN];
					lcl_ImplAddStringMaybeQuoted( sDateStr,
						pIntl->GetLongDateDayOfWeekSep(), pIntl );
				break;
				case DAYOFWEEK_LONG :
					sDateStr += sKeyword[NF_KEY_NNNN];
					// NNNN ist leider bereits mit Separator, so wird es in
					// aelteren Versionen, die noch kein NNN kennen, korrekt
					// dargestellt, nur der Formatstring sieht krank aus..
				break;
				default:
					DBG_ERRORFILE( "unknown LongDateDayOfWeekFormat" );
			}
		break;
		case 1 :
			sDateStr += sKeyword[NF_KEY_NN];
			lcl_ImplAddStringMaybeQuoted( sDateStr,
				pIntl->GetLongDateDayOfWeekSep(), pIntl );
		break;
		case 2 :
			sDateStr += sKeyword[NF_KEY_NNNN];
		break;
		default:
			DBG_ERRORFILE( "unknown nShortLongDayOfWeek" );
	}
	switch (pIntl->GetLongDateFormat())
	{
		case MDY:
		{
			switch ( nShortLongMonth )
			{
				case -1 :
				break;
				case 0 :
					switch ( pIntl->GetLongDateMonthFormat() )
					{
						case MONTH_NORMAL :
							sDateStr += sKeyword[NF_KEY_M];
						break;
						case MONTH_ZERO :
							sDateStr += sKeyword[NF_KEY_MM];
						break;
						case MONTH_SHORT :
							sDateStr += sKeyword[NF_KEY_MMM];
						break;
						case MONTH_LONG :
							sDateStr += sKeyword[NF_KEY_MMMM];
						break;
						default:
							DBG_ERRORFILE( "unknown LongDateMonthFormat" );
					}
				break;
				case 1 :
					sDateStr += sKeyword[NF_KEY_MMM];
				break;
				case 2 :
					sDateStr += sKeyword[NF_KEY_MMMM];
				break;
				default:
					DBG_ERRORFILE( "unknown nShortLongMonth" );
			}
			if ( nShortLongMonth != -1 )
				lcl_ImplAddStringMaybeQuoted( sDateStr,
					pIntl->GetLongDateMonthSep(), pIntl );

			switch ( nShortLongDay )
			{
				case -1 :
				break;
				case 0 :
					if ( pIntl->IsLongDateDayLeadingZero() )
						sDateStr += sKeyword[NF_KEY_DD];
					else
						sDateStr += sKeyword[NF_KEY_D];
				break;
				case 1 :
					sDateStr += sKeyword[NF_KEY_D];
				break;
				case 2 :
					sDateStr += sKeyword[NF_KEY_DD];
				break;
				default:
					DBG_ERRORFILE( "unknown nShortLongDay" );
			}
			if ( nShortLongDay != -1 )
				lcl_ImplAddStringMaybeQuoted( sDateStr,
					pIntl->GetLongDateDaySep(), pIntl );

			switch ( nShortLongYear )
			{
				case -1 :
				break;
				case 0 :
					if ( pIntl->IsLongDateCentury() )
						sDateStr += sKeyword[NF_KEY_YYYY];
					else
						sDateStr += sKeyword[NF_KEY_YY];
				break;
				case 1 :
					sDateStr += sKeyword[NF_KEY_YY];
				break;
				case 2 :
					sDateStr += sKeyword[NF_KEY_YYYY];
				break;
				default:
					DBG_ERRORFILE( "unknown nShortLongYear" );
			}
			//if ( nShortLongYear != -1 )
			//	lcl_ImplAddStringMaybeQuoted( sDateStr,
			//		pIntl->GetLongDateYearSep(), pIntl );

		}
		break;
		case DMY:
		{
			switch ( nShortLongDay )
			{
				case -1 :
				break;
				case 0 :
					if ( pIntl->IsLongDateDayLeadingZero() )
						sDateStr += sKeyword[NF_KEY_DD];
					else
						sDateStr += sKeyword[NF_KEY_D];
				break;
				case 1 :
					sDateStr += sKeyword[NF_KEY_D];
				break;
				case 2 :
					sDateStr += sKeyword[NF_KEY_DD];
				break;
				default:
					DBG_ERRORFILE( "unknown nShortLongDay" );
			}
			if ( nShortLongDay != -1 )
				lcl_ImplAddStringMaybeQuoted( sDateStr,
					pIntl->GetLongDateDaySep(), pIntl );

			switch ( nShortLongMonth )
			{
				case -1 :
				break;
				case 0 :
					switch ( pIntl->GetLongDateMonthFormat() )
					{
						case MONTH_NORMAL :
							sDateStr += sKeyword[NF_KEY_M];
						break;
						case MONTH_ZERO :
							sDateStr += sKeyword[NF_KEY_MM];
						break;
						case MONTH_SHORT :
							sDateStr += sKeyword[NF_KEY_MMM];
						break;
						case MONTH_LONG :
							sDateStr += sKeyword[NF_KEY_MMMM];
						break;
						default:
							DBG_ERRORFILE( "unknown LongDateMonthFormat" );
					}
				break;
				case 1 :
					sDateStr += sKeyword[NF_KEY_MMM];
				break;
				case 2 :
					sDateStr += sKeyword[NF_KEY_MMMM];
				break;
				default:
					DBG_ERRORFILE( "unknown nShortLongMonth" );
			}
			if ( nShortLongMonth != -1 )
				lcl_ImplAddStringMaybeQuoted( sDateStr,
					pIntl->GetLongDateMonthSep(), pIntl );

			switch ( nShortLongYear )
			{
				case -1 :
				break;
				case 0 :
					if ( pIntl->IsLongDateCentury() )
						sDateStr += sKeyword[NF_KEY_YYYY];
					else
						sDateStr += sKeyword[NF_KEY_YY];
				break;
				case 1 :
					sDateStr += sKeyword[NF_KEY_YY];
				break;
				case 2 :
					sDateStr += sKeyword[NF_KEY_YYYY];
				break;
				default:
					DBG_ERRORFILE( "unknown nShortLongYear" );
			}
			//if ( nShortLongYear != -1 )
			//	lcl_ImplAddStringMaybeQuoted( sDateStr,
			//		pIntl->GetLongDateYearSep(), pIntl );

		}
		break;
		case YMD:
		{
			switch ( nShortLongYear )
			{
				case -1 :
				break;
				case 0 :
					if ( pIntl->IsLongDateCentury() )
						sDateStr += sKeyword[NF_KEY_YYYY];
					else
						sDateStr += sKeyword[NF_KEY_YY];
				break;
				case 1 :
					sDateStr += sKeyword[NF_KEY_YY];
				break;
				case 2 :
					sDateStr += sKeyword[NF_KEY_YYYY];
				break;
				default:
					DBG_ERRORFILE( "unknown nShortLongYear" );
			}
			if ( nShortLongYear != -1 )
				lcl_ImplAddStringMaybeQuoted( sDateStr,
					pIntl->GetLongDateYearSep(), pIntl );

			switch ( nShortLongMonth )
			{
				case -1 :
				break;
				case 0 :
					switch ( pIntl->GetLongDateMonthFormat() )
					{
						case MONTH_NORMAL :
							sDateStr += sKeyword[NF_KEY_M];
						break;
						case MONTH_ZERO :
							sDateStr += sKeyword[NF_KEY_MM];
						break;
						case MONTH_SHORT :
							sDateStr += sKeyword[NF_KEY_MMM];
						break;
						case MONTH_LONG :
							sDateStr += sKeyword[NF_KEY_MMMM];
						break;
						default:
							DBG_ERRORFILE( "unknown LongDateMonthFormat" );
					}
				break;
				case 1 :
					sDateStr += sKeyword[NF_KEY_MMM];
				break;
				case 2 :
					sDateStr += sKeyword[NF_KEY_MMMM];
				break;
				default:
					DBG_ERRORFILE( "unknown nShortLongMonth" );
			}
			if ( nShortLongMonth != -1 )
				lcl_ImplAddStringMaybeQuoted( sDateStr,
					pIntl->GetLongDateMonthSep(), pIntl );

			switch ( nShortLongDay )
			{
				case -1 :
				break;
				case 0 :
					if ( pIntl->IsLongDateDayLeadingZero() )
						sDateStr += sKeyword[NF_KEY_DD];
					else
						sDateStr += sKeyword[NF_KEY_D];
				break;
				case 1 :
					sDateStr += sKeyword[NF_KEY_D];
				break;
				case 2 :
					sDateStr += sKeyword[NF_KEY_DD];
				break;
				default:
					DBG_ERRORFILE( "unknown nShortLongDay" );
			}
			//if ( nShortLongDay != -1 )
			//	lcl_ImplAddStringMaybeQuoted( sDateStr,
			//		pIntl->GetLongDateDaySep(), pIntl );

		}
		break;
		default:
			DBG_ERRORFILE( "unknown LongDateFormat" );
	}
}


void LocaleDataFormats::ImpGetPosCurrFormat( String& sPosStr )
{
	String aSymStr;
	LocaleDataCurrencyEntry::BuildSymbolString( aSymStr, pIntl, FALSE, FALSE );
	LocaleDataCurrencyEntry::CompletePositiveFormatString( sPosStr, aSymStr,
		pIntl->GetCurrPositiveFormat() );
}


void LocaleDataFormats::ImpGetNegCurrFormat( String& sNegStr )
{
	String aSymStr;
	LocaleDataCurrencyEntry::BuildSymbolString( aSymStr, pIntl, FALSE, FALSE );
	LocaleDataCurrencyEntry::CompleteNegativeFormatString( sNegStr, aSymStr,
		pIntl->GetCurrNegativeFormat() );
}


// static
void LocaleDataCurrencyEntry::BuildSymbolString( String& rStr,
			const International* pIntl, BOOL bBank, BOOL bWithoutExtension )
{
	rStr  = '[';
	rStr += '$';
	if ( bBank )
		rStr += pIntl->GetCurrBankSymbol();
	else
	{
		const String& rSymbol = pIntl->GetCurrSymbol();
		if ( rSymbol.Search( '-' ) != STRING_NOTFOUND || rSymbol.Search( ']' ) != STRING_NOTFOUND )
		{
			rStr += '"';
			rStr += rSymbol;
			rStr += '"';
		}
		else
			rStr += rSymbol;
		LanguageType eLang = pIntl->GetLanguage();
		if ( !bWithoutExtension && eLang != LANGUAGE_DONTKNOW && eLang != LANGUAGE_SYSTEM )
		{
			rStr += '-';
			rStr += String::CreateFromInt32( sal_Int32( eLang ), 16 ).ToUpperAscii();
		}
	}
	rStr += ']';
}


// static
void LocaleDataCurrencyEntry::CompletePositiveFormatString( String& rStr,
		const String& rSymStr, USHORT nPositiveFormat )
{
	switch( nPositiveFormat )
	{
		case 0:                                        	// $1
			rStr.Insert( rSymStr , 0 );
		break;
		case 1:											// 1$
			rStr += rSymStr;
		break;
		case 2:											// $ 1
		{
			rStr.Insert( ' ', 0 );
			rStr.Insert( rSymStr, 0 );
		}
		break;
		case 3:                                         // 1 $
		{
			rStr += ' ';
			rStr += rSymStr;
		}
		break;
		default:
			DBG_ERROR("LocaleDataCurrencyEntry::CompletePositiveFormatString: unknown option");
		break;
	}
}


// static
void LocaleDataCurrencyEntry::CompleteNegativeFormatString( String& rStr,
		const String& rSymStr, USHORT nNegativeFormat )
{
	switch( nNegativeFormat )
	{
		case 0:                                        	// ($1)
		{
			rStr.Insert( rSymStr, 0);
			rStr.Insert('(',0);
			rStr += ')';
		}
		break;
		case 1:                                        	// -$1
		{
			rStr.Insert( rSymStr, 0);
			rStr.Insert('-',0);
		}
		break;
		case 2:                                        	// $-1
		{
			rStr.Insert('-',0);
			rStr.Insert( rSymStr, 0);
		}
		break;
		case 3:                                        	// $1-
		{
			rStr.Insert( rSymStr, 0);
			rStr += '-';
		}
		break;
		case 4:                                        	// (1$)
		{
			rStr.Insert('(',0);
			rStr += rSymStr;
			rStr += ')';
		}
		break;
		case 5:                                        	// -1$
		{
			rStr += rSymStr;
			rStr.Insert('-',0);
		}
		break;
		case 6:                                        	// 1-$
		{
			rStr += '-';
			rStr += rSymStr;
		}
		break;
		case 7:                                        	// 1$-
		{
			rStr += rSymStr;
			rStr += '-';
		}
		break;
		case 8:                                        	// -1 $
		{
			rStr += ' ';
			rStr += rSymStr;
			rStr.Insert('-',0);
		}
		break;
		case 9:                                        	// -$ 1
		{
			rStr.Insert(' ',0);
			rStr.Insert( rSymStr, 0);
			rStr.Insert('-',0);
		}
		break;
		case 10:                                        // 1 $-
		{
			rStr += ' ';
			rStr += rSymStr;
			rStr += '-';
		}
		break;
		case 11:                                        // $ -1
		{
			String aTmp( rSymStr );
			aTmp += ' ';
			aTmp += '-';
			rStr.Insert( aTmp, 0 );
		}
		break;
		case 12 : 										// $ 1-
		{
			rStr.Insert(' ', 0);
			rStr.Insert( rSymStr, 0);
			rStr += '-';
		}
		break;
		case 13 : 										// 1- $
		{
			rStr += '-';
			rStr += ' ';
			rStr += rSymStr;
		}
		break;
		case 14 : 										// ($ 1)
		{
			rStr.Insert(' ',0);
			rStr.Insert( rSymStr, 0);
			rStr.Insert('(',0);
			rStr += ')';
		}
		break;
		case 15 :										// (1 $)
		{
			rStr.Insert('(',0);
			rStr += ' ';
			rStr += rSymStr;
			rStr += ')';
		}
		break;
		default:
			DBG_ERROR("LocaleDataCurrencyEntry::CompleteNegativeFormatString: unknown option");
		break;
	}
}


