/*************************************************************************
 *
 *  $RCSfile: collator_CJK.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: bustamam $ $Date: 2001/12/15 13:39:15 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <collator_CJK.hxx>
#include <com/sun/star/i18n/CollatorOptions.hpp>

sal_Int32 SAL_CALL
Collator_CJK::compare (
    	const ::rtl::OUString& str1, sal_Int32 off1, sal_Int32 len1, 
    	const ::rtl::OUString& str2, sal_Int32 off2, sal_Int32 len2,
	const sal_uInt16 index[],
	const sal_uInt16 weight[] )
	throw (::com::sun::star::uno::RuntimeException)
{
	const sal_Unicode *uStr1 = str1.getStr() + off1;
	const sal_Unicode *uStr2 = str2.getStr() + off2;

	for (int i = 0; i < len1 && i < len2; i++) {
	    sal_uInt16 wgt1, wgt2, idx1, idx2;

	    idx1 = index[uStr1[i] >> 8];
	    idx2 = index[uStr2[i] >> 8];

	    wgt1 = idx1 == 0xFFFE ? 0x0000 : (idx1 == 0xFFFF ? 0xFFFF : weight[idx1 + (uStr1[i] & 0xFF)]);
	    wgt2 = idx2 == 0xFFFE ? 0x0000 : (idx2 == 0xFFFF ? 0xFFFF : weight[idx2 + (uStr2[i] & 0xFF)]);

	    if (wgt1 != wgt2)
		return wgt1 < wgt2 ? -1 : 1;
	    else if ((wgt1 == 0x0000 || wgt1 == 0xFFFF) && uStr1[i] != uStr2[i]) 
		return uStr1[i] < uStr2[i] ? -1 : 1;
	}
	return len1 == len2 ? 0 : len1 < len2 ? -1 : 1;
}
