/*************************************************************************
 *
 *  $RCSfile: defaultnumberingprovider.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: jp $ $Date: 2001/07/20 19:39:36 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _I18N_DEFAULT_NUMBERING_PROVIDER_HXX_
#include <defaultnumberingprovider.hxx>
#endif
#ifndef _COM_SUN_STAR_STYLE_NUMBERINGTYPE_HPP_
#include <com/sun/star/style/NumberingType.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif
#ifndef _COM_SUN_STAR_TEXT_HORIORIENTATION_HPP_
#include <com/sun/star/text/HoriOrientation.hpp>
#endif
#ifndef I18N_OUTLINENUMBERING_HXX
#include <outlinenumbering.hxx>
#endif

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::container;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::style;
using namespace ::com::sun::star::text;
using namespace ::rtl;

#define C2U(cChar) OUString::createFromAscii(cChar);

#define OUTLINE_MAX 10
const sal_Char cNumberingType[] = "NumberingType";
const sal_Char cPrefix[] = "Prefix";
const sal_Char cSuffix[] = "Suffix";
const sal_Char cAdjust[] = "Adjust";
const sal_Char cValue [] = "Value";

//-----------------------------------------------------------------------------
//settings of continuous numbering levels
struct NumberingLevel_Impl
{
	sal_Unicode cPrefix;
	sal_Int16 	nNumType; //com::sun::star::style::NumberingType
	sal_Unicode cSuffix;
};
//-----------------------------------------------------------------------------
const NumberingLevel_Impl* lcl_GetContinousDefaults(Locale rLocale)
{
	static const NumberingLevel_Impl aContinuousDefaults[] =
	{
		{' ',NumberingType::ARABIC            ,')'},
		{' ',NumberingType::ARABIC            ,'.'},
		{'(',NumberingType::ARABIC            ,')'},
		{' ',NumberingType::ROMAN_UPPER       ,'.'},
		{' ',NumberingType::CHARS_UPPER_LETTER,')'},
		{' ',NumberingType::CHARS_LOWER_LETTER,')'},
		{'(',NumberingType::CHARS_LOWER_LETTER,')'},
		{' ',NumberingType::ROMAN_LOWER       ,'.'},
		{0, 0, 0},
	};
	return aContinuousDefaults;
}
//-----------------------------------------------------------------------------
const OutlineNumberingLevel_Impl* lcl_getOutlineLevel(sal_Int32 nIndex, const Locale& rLocale)
{
	const OutlineNumberingLevel_Impl* pRet = 0;
	switch(nIndex)
	{
		case 0:
		{
			static const OutlineNumberingLevel_Impl aOutline0[] =
			{
				{' ',NumberingType::ARABIC            ,' ',0x0020,"", 		  0,   0, 50, 0},
				{' ',NumberingType::ARABIC            ,' ',0x0020,"", 		  1,  50, 50, 0},
				{' ',NumberingType::CHARS_LOWER_LETTER,')',0x0020,"", 		  0, 100, 50, 0},
				{' ',NumberingType::CHAR_SPECIAL      ,' ',0x2022,"StarSymbol", 0, 150, 50, 0},
				{' ',NumberingType::CHAR_SPECIAL      ,' ',0x2022,"StarSymbol", 0, 200, 50, 0},
				{0, 0, 0, 0, 0, 0, 0, 0, 0}
			};
			pRet = aOutline0;
		}
		break;
		case 1:
		{
			static const OutlineNumberingLevel_Impl aOutline1[] =
			{
				{' ',NumberingType::ARABIC  		  	,'.',0x0020,""			, 0,   0, 50, 0},
				{' ',NumberingType::CHARS_LOWER_LETTER	,')',0x0020,""			, 0,  50, 50, 0},
				{' ',NumberingType::CHAR_SPECIAL		,' ',0x2022,"StarSymbol"	, 0, 100, 50, 0},
				{' ',NumberingType::CHAR_SPECIAL		,' ',0x2022,"StarSymbol"	, 0, 150, 50, 0},
				{' ',NumberingType::CHAR_SPECIAL		,' ',0x2022,"StarSymbol"	, 0, 200, 50, 0},
				{0, 0, 0, 0, 0, 0, 0, 0, 0}
			};
			pRet = aOutline1;
		}
		break;
		case 2:
		{
			static const OutlineNumberingLevel_Impl aOutline2[] =
			{
				{' ',NumberingType::ARABIC				,'.',0x0020,"" 		   , 0,   0, 50, 0},
				{'(',NumberingType::CHARS_LOWER_LETTER	,')',0x0020,""		   , 0,  50, 50, 0},
				{' ',NumberingType::ROMAN_LOWER			,'.',0x0020,"" 		   , 0, 100, 50, 0},
				{' ',NumberingType::CHARS_UPPER_LETTER	,'.',0x0020,"" 		   , 0, 150, 50, 0},
				{' ',NumberingType::CHAR_SPECIAL		,'.',0x2022,"StarSymbol" , 0, 200, 50, 0},
				{0, 0, 0, 0, 0, 0, 0, 0, 0}
			};
			pRet = aOutline2;
		}
		break;
		case 3:
		{
			static const OutlineNumberingLevel_Impl aOutline3[] =
			{
				{' ',NumberingType::ARABIC		,'.',0x0020,"", 0,   0, 50, 0},
				{' ',NumberingType::ARABIC		,'.',0x0020,"", 0,  50, 50, 0},
				{' ',NumberingType::ARABIC		,'.',0x0020,"", 0, 100, 50, 0},
				{' ',NumberingType::ARABIC		,'.',0x0020,"", 0, 150, 50, 0},
				{' ',NumberingType::ARABIC		,'.',0x0020,"", 0, 200, 50, 0},
				{0, 0, 0, 0, 0, 0, 0, 0, 0}
			};
			pRet = aOutline3;
		}
		break;
		case 4:
		{
			static const OutlineNumberingLevel_Impl aOutline4[] =
			{
				{' ',NumberingType::ROMAN_UPPER			,'.',0x0020,""			, 0,   0, 50, 0},
				{' ',NumberingType::CHARS_UPPER_LETTER  ,'.',0x0020,""			, 0,  50, 50, 0},
				{' ',NumberingType::ROMAN_LOWER			,'.',0x0020,""			, 0, 100, 50, 0},
				{' ',NumberingType::CHARS_LOWER_LETTER	,')',0x0020,""			, 0, 150, 50, 0},
				{' ',NumberingType::CHAR_SPECIAL		,' ',0x2022,"StarSymbol"	, 0, 200, 50, 0},
				{0, 0, 0, 0, 0, 0, 0, 0, 0}
			};
			pRet = aOutline4;
		}
		break;
		case 5:
		{
			static const OutlineNumberingLevel_Impl aOutline5[] =
			{
				{' ',NumberingType::CHARS_UPPER_LETTER	,'.',0x0020,""			, 0,   0, 50, 0},
				{' ',NumberingType::ROMAN_UPPER			,'.',0x0020,""			, 0,  50, 50, 0},
				{' ',NumberingType::CHARS_LOWER_LETTER	,'.',0x0020,""			, 0, 100, 50, 0},
				{' ',NumberingType::ROMAN_LOWER			,'.',0x0020,""			, 0, 150, 50, 0},
				{' ',NumberingType::CHAR_SPECIAL		,' ',0x2022,"StarSymbol"	, 0, 200, 50, 0},
				{0, 0, 0, 0, 0, 0, 0, 0, 0}
			};
			pRet = aOutline5;
		}
		break;
		case 6:
		{
			static const OutlineNumberingLevel_Impl aOutline6[] =
			{
				{' ',NumberingType::ARABIC	,' ',0x0020,"", 0,   0, 50, 0},
				{' ',NumberingType::ARABIC	,' ',0x0020,"", 1,  50, 50, 0},
				{' ',NumberingType::ARABIC	,' ',0x0020,"", 2, 100, 50, 0},
				{' ',NumberingType::ARABIC	,' ',0x0020,"", 3, 150, 50, 0},
				{' ',NumberingType::ARABIC	,' ',0x0020,"", 4, 200, 50, 0},
				{0, 0, 0, 0, 0, 0, 0, 0, 0}
			};
			pRet = aOutline6;
		}
		break;
		case 7:
		{
			static const OutlineNumberingLevel_Impl aOutline7[] =
			{
				{' ',NumberingType::CHAR_SPECIAL	,' ',0x27A2,"StarSymbol", 0,   0, 50, 0},
				{' ',NumberingType::CHAR_SPECIAL	,' ',0xE006,"StarSymbol", 0,  50, 50, 0},
				{' ',NumberingType::CHAR_SPECIAL	,' ',0xE004,"StarSymbol", 0, 100, 50, 0},
				{' ',NumberingType::CHAR_SPECIAL	,' ',0x2022,"StarSymbol", 0, 150, 50, 0},
				{' ',NumberingType::CHAR_SPECIAL	,' ',0x2022,"StarSymbol", 0, 200, 50, 0},
				{0, 0, 0, 0, 0, 0, 0, 0, 0}
			};
			pRet = aOutline7;
		}
		break;
	}
	return pRet;
}

/*-- 08.11.00 15:02:37---------------------------------------------------

  -----------------------------------------------------------------------*/
DefaultNumberingProvider::DefaultNumberingProvider()
{
}
/*-- 08.11.00 15:02:37---------------------------------------------------

  -----------------------------------------------------------------------*/
DefaultNumberingProvider::~DefaultNumberingProvider()
{
}
/*-- 08.11.00 15:02:37---------------------------------------------------

  -----------------------------------------------------------------------*/
Sequence< Reference< XIndexAccess > > DefaultNumberingProvider::getDefaultOutlineNumberings(
	const Locale& rLocale )
		throw(RuntimeException)
{
	Sequence< Reference< XIndexAccess > > aRet(OUTLINE_MAX);
	Reference< XIndexAccess >* pIndexAccess = aRet.getArray();
	sal_Int16 nCount = 0;
	const OutlineNumberingLevel_Impl* pOutlineNum = lcl_getOutlineLevel(nCount++, rLocale);
	while(pOutlineNum && nCount < OUTLINE_MAX)
	{
		pIndexAccess[nCount - 1] = new OutlineNumbering(pOutlineNum);
		pOutlineNum = lcl_getOutlineLevel(nCount++, rLocale);
	}
	aRet.realloc(nCount - 1);
	return aRet;
}
/*-- 08.11.00 15:02:37---------------------------------------------------

  -----------------------------------------------------------------------*/
Sequence< Sequence<	PropertyValue > > DefaultNumberingProvider::getDefaultContinuousNumberingLevels(
	const Locale& rLocale )
		throw(RuntimeException)
{
	const NumberingLevel_Impl* pLevelImpl = lcl_GetContinousDefaults(rLocale);
	if(!pLevelImpl)
		return Sequence< Sequence<	PropertyValue > >();
	sal_Int32 nCount = 0;
	const NumberingLevel_Impl* pTemp = pLevelImpl;
	while((pTemp++)->cPrefix)
	{
		nCount++;
	}
	Sequence< Sequence<	PropertyValue > > aRet(nCount);
	Sequence<	PropertyValue > * pRet = aRet.getArray();
	pTemp = pLevelImpl;
	for(sal_Int32 n = 0; n < nCount; n++, pTemp++)
	{
		pRet[n].realloc(4);
		PropertyValue* pValues = pRet[n].getArray();
		pValues[0].Name = C2U(cPrefix);
		pValues[0].Value <<= OUString(&pTemp->cPrefix, 1);
		pValues[1].Name = C2U(cNumberingType);
		pValues[1].Value <<= pTemp->nNumType;
		pValues[2].Name = C2U(cSuffix);
		pValues[2].Value <<= OUString(&pTemp->cSuffix, 1);
		pValues[3].Name = C2U(cAdjust);
		pValues[3].Value <<= (sal_Int16)HoriOrientation::LEFT;
	}
	return aRet;
}
/* -----------------------------16.11.00 15:48--------------------------------

 ---------------------------------------------------------------------------*/
OUString DefaultNumberingProvider::makeNumberingString(
		const Sequence< PropertyValue >& rProperties,
		const Locale& rLocale )
				throw(IllegalArgumentException,
				RuntimeException)
{
	OUString sRet;
	OUString sPrefix, sSuffix;
	sal_Int16 nNumberingType = -1;
	sal_Int32 nValue = -1;
	const PropertyValue* pValues = rProperties.getConstArray();
	for(sal_Int32 nProp = 0; nProp < rProperties.getLength(); nProp++)
	{
		if(pValues[nProp].Name.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(cNumberingType)))
			pValues[nProp].Value >>= nNumberingType;
		else if(pValues[nProp].Name.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(cPrefix)))
			pValues[nProp].Value >>= sPrefix;
		else if(pValues[nProp].Name.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(cSuffix)))
			pValues[nProp].Value >>= sSuffix;
		else if(pValues[nProp].Name.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(cValue)))
			pValues[nProp].Value >>= nValue;
	}
	if(nValue >= 0 && nNumberingType >= 0)
	{
		sal_Bool bAddPreSuffix = sal_True;
		switch(nNumberingType)
		{
			case NumberingType::CHARS_UPPER_LETTER  :
			case NumberingType::CHARS_LOWER_LETTER  :
				GetCharStr( nValue, nNumberingType, sRet );
			break;
			case NumberingType::ROMAN_UPPER         :
			case NumberingType::ROMAN_LOWER         :
				GetRomanString(	nValue, nNumberingType, sRet );
			break;
			case NumberingType::ARABIC              :
				sRet = OUString::valueOf(nValue);
			break;
			case NumberingType::CHARS_UPPER_LETTER_N:
			case NumberingType::CHARS_LOWER_LETTER_N:
				GetCharStrN( nValue, nNumberingType, sRet );
			break;
			case NumberingType::PAGE_DESCRIPTOR     :
			break;
			case NumberingType::CHAR_SPECIAL        :
			case NumberingType::NUMBER_NONE         :
			case NumberingType::BITMAP              :
				bAddPreSuffix = sal_False;
			break;
#ifdef DEBUG
        	case 20:
			{
				if(nValue >= 0 && nValue <= 5)
				{
						static const sal_Char* aTestNumbers[] =
						{
							"None","First","Second","Third","Fourth","Fifth"
						};
						sRet = OUString::createFromAscii(aTestNumbers[nValue]);
				}
				else
					sRet = OUString::createFromAscii("too big!");
			}
			break;

#endif
		}
		if(bAddPreSuffix)
		{
			sPrefix += sRet;
			sRet = sPrefix;
			sRet += sSuffix;
		}
	}
	return sRet;
}
/* -----------------------------16.11.00 16:36--------------------------------

 ---------------------------------------------------------------------------*/
void DefaultNumberingProvider::GetRomanString(
	sal_Int32 nValue, sal_Int16 nType, OUString& rStr ) const
{
	nValue %= 4000;			// highest supported number
//		i, ii, iii, iv, v, vi, vii, vii, viii, ix
//							(Dummy),1000,500,100,50,10,5,1
	const sal_Char *cRomanArr = NumberingType::ROMAN_UPPER == nType
						? "MDCLXVI--"	// +2 Dummy-Eintraege !!
						: "mdclxvi--";	// +2 Dummy-Eintraege !!

	sal_uInt16 nMask = 1000;
	while( nMask )
	{
		sal_uInt8 nZahl = sal_uInt8(nValue / nMask);
		sal_uInt8 nDiff = 1;
		nValue %= nMask;

		if( 5 < nZahl )
		{
			if( nZahl < 9 )
				rStr += C2U(cRomanArr-1);
			++nDiff;
			nZahl -= 5;
		}
		sal_Unicode cChar = *cRomanArr;
		switch( nZahl )
		{
		case 3:	{rStr += OUString(&cChar, 1);}
		case 2:	{rStr += OUString(&cChar, 1);}
		case 1:	{rStr += OUString(&cChar, 1);}
		break;

		case 4:		{
						rStr += OUString(&cChar, 1);
						cChar = *(cRomanArr-nDiff);
						rStr += OUString(&cChar, 1);
					}
					break;
		case 5:		{
						cChar = *(cRomanArr-nDiff);
						rStr += OUString(&cChar, 1);
					}
					break;
		}

		nMask /= 10;			// zur naechsten Dekade
		cRomanArr += 2;
	}
}
/* -----------------------------16.11.00 16:32--------------------------------

 ---------------------------------------------------------------------------*/
void DefaultNumberingProvider::GetCharStr(
	sal_Int32 nValue, sal_Int16 nType, OUString& rStr ) const
{
	if(!nValue)
		return;

	const sal_uInt32 coDiff = 'Z' - 'A' +1;
	char cAdd = (NumberingType::CHARS_UPPER_LETTER == nType ? 'A' : 'a') - 1;
	sal_uInt32 nCalc;

	do {
		nCalc = nValue % coDiff;
		if( !nCalc )
			nCalc = coDiff;
		sal_Unicode nTmp = cAdd + nCalc;
		OUString sTmp(&nTmp, 1);
		rStr = sTmp += rStr;
		nValue -= nCalc;
		if( nValue )
			nValue /= coDiff;
	} while( nValue );
}
/* -----------------------------16.11.00 16:36--------------------------------

 ---------------------------------------------------------------------------*/
void DefaultNumberingProvider::GetCharStrN(
	sal_Int32 nValue, sal_Int16 nType, OUString& rStr ) const
{
	if(nValue < 1)
		return;
	const sal_uInt32 coDiff = 'Z' - 'A' +1;
	sal_Unicode cChar = --nValue % coDiff;
	if( NumberingType::CHARS_UPPER_LETTER_N == nType )
		cChar += 'A';
	else
		cChar += 'a';

	OUString sTmp(&cChar, 1);
	for(sal_Int32 nFill = 0; nFill < (nValue / coDiff) + 1; nFill++)
		rStr += sTmp;
}
/*-- 09.11.00 10:52:03---------------------------------------------------

  -----------------------------------------------------------------------*/
OutlineNumbering::OutlineNumbering(const OutlineNumberingLevel_Impl* pOutlnLevels) :
	m_pOutlineLevels(pOutlnLevels),
	m_nCount(0)
{
	const OutlineNumberingLevel_Impl* pTemp = m_pOutlineLevels;
	while((pTemp++)->cPrefix)
		m_nCount++;
}
/*-- 09.11.00 10:52:03---------------------------------------------------

  -----------------------------------------------------------------------*/
OutlineNumbering::~OutlineNumbering()
{
}
/*-- 09.11.00 10:52:03---------------------------------------------------

  -----------------------------------------------------------------------*/
sal_Int32 OutlineNumbering::getCount(  ) throw(RuntimeException)
{
	return m_nCount;
}
/*-- 09.11.00 10:52:03---------------------------------------------------

  -----------------------------------------------------------------------*/
Any OutlineNumbering::getByIndex( sal_Int32 nIndex )
	throw(IndexOutOfBoundsException, WrappedTargetException, RuntimeException)
{
	if(nIndex < 0 || nIndex >= m_nCount)
		throw IndexOutOfBoundsException();
	const OutlineNumberingLevel_Impl* pTemp = m_pOutlineLevels;
	pTemp += nIndex;
	Any aRet;

	Sequence<PropertyValue> aOutlineNumbering(10);
	PropertyValue* pValues = aOutlineNumbering.getArray();
	pValues[0].Name = C2U(cPrefix);
	pValues[0].Value <<= OUString(&pTemp->cPrefix, 1);
	pValues[1].Name = C2U(cNumberingType);
	pValues[1].Value <<= pTemp->nNumType;
	pValues[2].Name = C2U(cSuffix);
	pValues[2].Value <<= OUString(&pTemp->cSuffix, 1);
	pValues[3].Name = C2U("BulletChar");
	pValues[3].Value <<= OUString(&pTemp->cBulletChar, 1);
	pValues[4].Name = C2U("BulletFontName");
	pValues[4].Value <<= C2U(pTemp->sBulletFontName);
	pValues[5].Name = C2U("ParentNumbering");
	pValues[5].Value <<= pTemp->nParentNumbering;
	pValues[6].Name = C2U("LeftMargin");
	pValues[6].Value <<= pTemp->nLeftMargin;
	pValues[7].Name = C2U("SymbolTextDistance");
	pValues[7].Value <<= pTemp->nSymbolTextDistance;
	pValues[8].Name = C2U("FirstLineOffset");
	pValues[8].Value <<= pTemp->nFirstLineOffset;
	pValues[9].Name = C2U(cAdjust);
	pValues[9].Value <<= (sal_Int16)HoriOrientation::LEFT;
	aRet <<= aOutlineNumbering;
	return aRet;
}
/*-- 09.11.00 10:52:04---------------------------------------------------

  -----------------------------------------------------------------------*/
Type OutlineNumbering::getElementType(  ) throw(RuntimeException)
{
	return ::getCppuType((Sequence<PropertyValue>*)0);
}
/*-- 09.11.00 10:52:04---------------------------------------------------

  -----------------------------------------------------------------------*/
sal_Bool OutlineNumbering::hasElements(  ) throw(RuntimeException)
{
	return m_nCount > 0;
}
/* -----------------------------21.02.01 15:57--------------------------------

 ---------------------------------------------------------------------------*/
struct Supported_NumberingType
{
	sal_Int16 		nType;
	const sal_Char*	cSymbol;
};
static const Supported_NumberingType aSupportedTypes[] =
{
	{NumberingType::CHARS_UPPER_LETTER, 	"A"},
	{NumberingType::CHARS_LOWER_LETTER, 	"a"},
	{NumberingType::ROMAN_UPPER, 			"I"},
	{NumberingType::ROMAN_LOWER, 			"i"},
	{NumberingType::ARABIC, 				"1"},
	{NumberingType::NUMBER_NONE, 			"''"},
	{NumberingType::CHAR_SPECIAL, 			"Bullet"},
	{NumberingType::PAGE_DESCRIPTOR, 		"Page"},
	{NumberingType::BITMAP, 				"Bitmap"},
	{NumberingType::CHARS_UPPER_LETTER_N, 	"AAA"},
	{NumberingType::CHARS_LOWER_LETTER_N, 	"aaa"}
#ifdef DEBUG
	,{20, 	"First"}
#endif
};
	static const sal_Int32 nSupported_NumberingTypes = sizeof(aSupportedTypes) / sizeof(Supported_NumberingType);
/* -----------------------------21.02.01 15:57--------------------------------

 ---------------------------------------------------------------------------*/
Sequence< sal_Int16 > DefaultNumberingProvider::getSupportedNumberingTypes(  )
				throw(RuntimeException)
{
	Sequence< sal_Int16 > aRet(nSupported_NumberingTypes);
	sal_Int16* pArray = aRet.getArray();
    for(sal_Int16 i = 0; i < nSupported_NumberingTypes; i++)
		pArray[i] = aSupportedTypes[i].nType;
	return aRet;
}
/* -----------------------------21.02.01 15:57--------------------------------

 ---------------------------------------------------------------------------*/
sal_Int16 DefaultNumberingProvider::getNumberingType( const OUString& rNumberingIdentifier )
				throw(RuntimeException)
{
    for(sal_Int16 i = 0; i < nSupported_NumberingTypes; i++)
		if(!rNumberingIdentifier.compareToAscii(aSupportedTypes[i].cSymbol))
			return aSupportedTypes[i].nType;
	throw RuntimeException();
	return -1;
}
/* -----------------------------21.02.01 15:57--------------------------------

 ---------------------------------------------------------------------------*/
sal_Bool DefaultNumberingProvider::hasNumberingType( const OUString& rNumberingIdentifier )
				throw(RuntimeException)
{
    for(sal_Int16 i = 0; i < nSupported_NumberingTypes; i++)
		if(!rNumberingIdentifier.compareToAscii(aSupportedTypes[i].cSymbol))
			return sal_True;
	return sal_False;
}
/* -----------------------------21.02.01 15:57--------------------------------

 ---------------------------------------------------------------------------*/
OUString DefaultNumberingProvider::getNumberingIdentifier( sal_Int16 nNumberingType )
				throw(RuntimeException)
{
    for(sal_Int16 i = 0; i < nSupported_NumberingTypes; i++)
		if(nNumberingType == aSupportedTypes[i].nType)
			return C2U(aSupportedTypes[i].cSymbol);
	return OUString();
}
/* -----------------------------05.07.01 13:34--------------------------------

 ---------------------------------------------------------------------------*/
OUString DefaultNumberingProvider::getImplementationName(void)
                throw( RuntimeException )
{
    return C2U("i18n_simple::DefaultNumberingProvider");
}
/* -----------------------------05.07.01 13:34--------------------------------

 ---------------------------------------------------------------------------*/
const sal_Char cDefaultNumberingProvider[] = "com.sun.star.text.DefaultNumberingProvider";
sal_Bool DefaultNumberingProvider::supportsService(const rtl::OUString& rServiceName)
                throw( RuntimeException )
{
    return !rServiceName.compareToAscii(cDefaultNumberingProvider);
}
/* -----------------------------05.07.01 13:34--------------------------------

 ---------------------------------------------------------------------------*/
Sequence< OUString > DefaultNumberingProvider::getSupportedServiceNames(void)
                throw( RuntimeException )
{
    Sequence< OUString > aRet(1);
    aRet[0] = C2U(cDefaultNumberingProvider);
    return aRet;
}

