/*************************************************************************
 *
 *  $RCSfile: ftpcntl.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mhu $ $Date: 2001/03/19 12:38:56 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Matthias Huetsch <matthias.huetsch@sun.com>
 *
 *
 ************************************************************************/

#ifndef _INET_FTPCNTL_HXX
#define _INET_FTPCNTL_HXX "$Revision: 1.2 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _RTL_STRBUF_HXX_
#include <rtl/strbuf.hxx>
#endif
#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif

#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif
#ifndef _VOS_OBJECT_HXX_
#include <vos/object.hxx>
#endif

#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#ifndef _INET_SOCKET_HXX
#include <inet/socket.hxx>
#endif

#ifndef _INETFTP_HXX
#include <inetftp.hxx>
#endif

#ifdef _USE_NAMESPACE
namespace inet {
#endif

/*======================================================================
 *
 * INetFTPCntl internals.
 *
 *====================================================================*/
struct INetFTPCntlContext;
class  INetFTPCommandStream;

#ifndef COPYCTOR_API
#define COPYCTOR_API(C) C (const C&); C& operator= (const C&)
#endif

#ifndef INETFTP_SOCKET_INVALID
#define INETFTP_SOCKET_INVALID (-osl_Socket_E_NotSocket)
#endif

#ifndef INETFTP_SOCKET_WOULDBLOCK
#define INETFTP_SOCKET_WOULDBLOCK (-osl_Socket_E_WouldBlock)
#endif

/*========================================================================
 *
 * INetFTPCntlContext interface.
 *
 *======================================================================*/
struct INetFTPCntlContext : public NAMESPACE_VOS(OMutex)
{
	/** State.
	 */
	enum State
	{
		STATE_ABORT = -2,
		STATE_ERROR = -1,
		STATE_NONE  =  0,
		STATE_RESOLVE,
		STATE_CONNECT,

		STATE_PASV,
		STATE_PORT,
		STATE_REST,

		STATE_SEND,
		STATE_RECV,
		STATE_DONE
	};

	/** StateBlock.
	 */
	struct StateBlock
	{
		State     m_ePrev;
		State     m_eState;
		sal_Int32 m_nState;

		StateBlock (void)
			: m_ePrev (STATE_NONE), m_eState (STATE_NONE), m_nState (0)
		{}

		/** State.
		 */
		State getState (void) const { return m_eState; }
		void  setState (State eState)
		{
			m_ePrev  = m_eState;
			m_eState = eState;
		}

		/** StateCode.
		 */
		sal_Int32 getStateCode (void) const { return m_nState; }
		void setStateCode (sal_Int32 nState)
		{
			m_nState = nState;
		}
	};

	/** ParamBlock.
	 */
	struct ParamBlock
	{
		rtl::OUString m_aPath;
		sal_Bool      m_bIsOpen     : 1;
		sal_Bool      m_bIsLoggedIn : 1;

		ParamBlock (void)
			: m_bIsOpen (sal_False), m_bIsLoggedIn (sal_False)
		{}

		/** isOpen.
		 */
		sal_Bool isOpen (void) const
		{
			return m_bIsOpen;
		}
		void isOpen (sal_Bool bIsOpen)
		{
			m_bIsOpen = bIsOpen;
		}

		/** isLoggedIn.
		 */
		sal_Bool isLoggedIn (void) const
		{
			return m_bIsLoggedIn;
		}
		void isLoggedIn (sal_Bool bIsLoggedIn)
		{
			m_bIsLoggedIn = bIsLoggedIn;
		}

		/** Path.
		 */
		const rtl::OUString& getPath (void) const
		{
			return m_aPath;
		}
		void setPath (const rtl::OUString &rPath)
		{
			m_aPath = rPath;
		}
		
	};

	/** Representation.
	 */
	StateBlock               m_aStateBlk;
	ParamBlock               m_aParamBlk;

	NAMESPACE_VOS(ORef)<INetActiveTCPSocket> m_xSocket;

	sal_uInt32               m_nBufSiz;
	sal_Char                *m_pBuffer;
	sal_Char                *m_pRead;
	sal_Char                *m_pWrite;

	INetFTPCallback         *m_pfnCB;
	void                    *m_pDataCB;

	/** Construction, destruction.
	 */
	INetFTPCntlContext (sal_uInt32 nBufSiz = 512);
	~INetFTPCntlContext (void);

	/** State.
	 */
	State getState (void) const
	{
		return m_aStateBlk.getState();
	}
	void setState (State eState)
	{
		NAMESPACE_VOS(OGuard) aGuard (*this);
		m_aStateBlk.setState (eState);
	}
	void setState (State eState, sal_Int32 nState)
	{
		NAMESPACE_VOS(OGuard) aGuard (*this);
		m_aStateBlk.setState (eState);
		m_aStateBlk.setStateCode (nState);
	}

	/** StateCode.
	 */
	sal_Int32 getStateCode (void) const
	{
		return m_aStateBlk.getStateCode();
	}
	void setStateCode (sal_Int32 nState)
	{
		NAMESPACE_VOS(OGuard) aGuard (*this);
		m_aStateBlk.setStateCode (nState);
	}

	/** isOpen.
	 */
	sal_Bool isOpen (void) const
	{
		return m_aParamBlk.isOpen();
	}
	void isOpen (sal_Bool bIsOpen)
	{
		NAMESPACE_VOS(OGuard) aGuard (*this);
		m_aParamBlk.isOpen (bIsOpen);
	}

	/** isLoggedIn.
	 */
	sal_Bool isLoggedIn (void) const
	{
		return m_aParamBlk.isLoggedIn();
	}
	void isLoggedIn (sal_Bool bIsLoggedIn)
	{
		NAMESPACE_VOS(OGuard) aGuard (*this);
		m_aParamBlk.isLoggedIn (bIsLoggedIn);
	}

	/** Path.
	 */
	const rtl::OUString& getPath (void) const
	{
		return m_aParamBlk.getPath();
	}
	void setPath (const rtl::OUString &rPath)
	{
		NAMESPACE_VOS(OGuard) aGuard (*this);
		m_aParamBlk.setPath (rPath);
	}

	/** Terminate callback.
	 */
	void setCallback (INetFTPCallback *pfnCB, void *pDataCB)
	{
		NAMESPACE_VOS(OGuard) aGuard (*this);
		m_pfnCB   = pfnCB;
		m_pDataCB = pDataCB;
	}

	/** Operation.
	 */
	void copy (const sal_Char *pBuffer, sal_uInt32 nLength);

	sal_Int32 send (INetFTPCommandStream *pStrm);
	sal_Int32 recv (INetFTPCommandStream *pStrm);
};

/*========================================================================
 *
 * INetFTPCommandStream interface.
 *
 *======================================================================*/
class INetFTPCommandStream : public NAMESPACE_VOS(OObject)
{
	VOS_DECLARE_CLASSINFO (VOS_NAMESPACE (INetFTPCommandStream, inet));

public:
	enum Command
	{
		CMD_OPEN,
		CMD_LOGIN,
		CMD_PASV,
		CMD_PWD,
		CMD_TYPE_ASCII,
		CMD_TYPE_IMAGE,
		CMD_OTHER
	};

	enum Reply
	{
		REPLY_OK     =  0,
		REPLY_ERROR  = -1,
		REPLY_LOADED = -2
	};

	INetFTPCommandStream (
		const rtl::OString &rCommand, Command eCommand = CMD_OTHER);
	virtual ~INetFTPCommandStream (void);

	inline Command getCommand (void) const;

	sal_Int32 read (
		sal_Char *pData, sal_uInt32 nSize, void *pCtx);

	sal_Int32 write (
		const sal_Char *pData, sal_uInt32 nSize, void *pCtx);

	inline sal_Int32       getReplyCode (void) const;
	inline const sal_Char* getReplyText (void);

protected:
	/** parseLine.
	 */
	virtual sal_Int32 parseLine (
		const sal_Char *pBuffer, sal_uInt32 nLength, void *pCtx);

private:
	/** Representation.
	 */
	Command   m_eCommand;
	sal_Char *m_pCommand;
	sal_Char *m_pRead;
	sal_Char *m_pWrite;

	SvMemoryStream     m_aBuffer;
	rtl::OStringBuffer m_aReplyBuffer;
	rtl::OString       m_aReplyText;
	sal_Int32          m_nReplyCode;
	sal_Bool           m_bFirstLine;

	/** Not implemented.
	 */
	COPYCTOR_API (INetFTPCommandStream);
};

inline INetFTPCommandStream::Command
INetFTPCommandStream::getCommand (void) const
{
	return m_eCommand;
}

inline sal_Int32 INetFTPCommandStream::getReplyCode (void) const
{
	return m_nReplyCode;
}

inline const sal_Char* INetFTPCommandStream::getReplyText (void)
{
	if (m_aReplyBuffer.getLength())
		m_aReplyText = m_aReplyBuffer.makeStringAndClear();
	if (m_aReplyText.getLength())
		return m_aReplyText.getStr();
	else
		return NULL;
}
	
/*========================================================================
 *
 * INetFTPOpenCommandStream interface.
 *
 *======================================================================*/
class INetFTPOpenCommandStream : public INetFTPCommandStream
{
	VOS_DECLARE_CLASSINFO (VOS_NAMESPACE (INetFTPOpenCommandStream, inet));

public:
	INetFTPOpenCommandStream (const rtl::OString &rCommand);
	virtual ~INetFTPOpenCommandStream (void);

private:
	/** parseLine.
	 */
	virtual sal_Int32 parseLine (
		const sal_Char *pBuffer, sal_uInt32 nLength, void *pCtx);

	/** Not implemented.
	 */
	COPYCTOR_API (INetFTPOpenCommandStream);
};

/*========================================================================
 *
 * INetFTPLoginCommandStream interface.
 *
 *======================================================================*/
class INetFTPLoginCommandStream : public INetFTPCommandStream
{
	VOS_DECLARE_CLASSINFO (VOS_NAMESPACE (INetFTPLoginCommandStream, inet));

public:
	INetFTPLoginCommandStream (const rtl::OString &rCommand);
	virtual ~INetFTPLoginCommandStream (void);

private:
	/** parseLine.
	 */
	virtual sal_Int32 parseLine (
		const sal_Char *pBuffer, sal_uInt32 nLength, void *pCtx);

	/** Not implemented.
	 */
	COPYCTOR_API (INetFTPLoginCommandStream);
};

/*========================================================================
 *
 * INetFTPPasvCommandStream interface.
 *
 *======================================================================*/
class INetFTPPasvCommandStream : public INetFTPCommandStream
{
	VOS_DECLARE_CLASSINFO (VOS_NAMESPACE (INetFTPPasvCommandStream, inet));

public:
	INetFTPPasvCommandStream (const rtl::OString &rCommand);
	virtual ~INetFTPPasvCommandStream (void);

private:
	/** parseLine.
	 */
	virtual sal_Int32 parseLine (
		const sal_Char *pBuffer, sal_uInt32 nLength, void *pCtx);

	/** Not implemented.
	 */
	COPYCTOR_API (INetFTPPasvCommandStream);
};

/*========================================================================
 *
 * INetFTPPwdCommandStream interface.
 *
 *======================================================================*/
class INetFTPPwdCommandStream : public INetFTPCommandStream
{
	VOS_DECLARE_CLASSINFO (VOS_NAMESPACE (INetFTPPwdCommandStream, inet));

public:
	INetFTPPwdCommandStream (const rtl::OString &rCommand);
	virtual ~INetFTPPwdCommandStream (void);

	inline const rtl::OUString& getcwd (void) const;

private:
	/** Representation.
	 */
	rtl::OUString m_aCWD;

	/** parseLine.
	 */
	virtual sal_Int32 parseLine (
		const sal_Char *pBuffer, sal_uInt32 nLength, void *pCtx);

	/** Not implemented.
	 */
	COPYCTOR_API (INetFTPPwdCommandStream);
};

inline const rtl::OUString& INetFTPPwdCommandStream::getcwd (void) const
{
	return m_aCWD;
}

/*========================================================================
 *
 * INetFTPTypeCommandStream interface.
 *
 *======================================================================*/
class INetFTPTypeCommandStream : public INetFTPCommandStream
{
	VOS_DECLARE_CLASSINFO (VOS_NAMESPACE (INetFTPTypeCommandStream, inet));

public:
	INetFTPTypeCommandStream (
		const rtl::OString &rCommand, Command eCommand);
	virtual ~INetFTPTypeCommandStream (void);

private:
	/** parseLine.
	 */
	virtual sal_Int32 parseLine (
		const sal_Char *pBuffer, sal_uInt32 nLength, void *pCtx);

	/** Not implemented.
	 */
	COPYCTOR_API (INetFTPTypeCommandStream);
};

/*========================================================================
 *
 * The End.
 *
 *======================================================================*/
#ifdef _USE_NAMESPACE
}
#endif

#endif /* !_INET_FTPCNTL_HXX */

