/*************************************************************************
 *
 *  $RCSfile: ftpimpl.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mhu $ $Date: 2001/03/19 12:38:56 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Matthias Huetsch <matthias.huetsch@sun.com>
 *
 *
 ************************************************************************/

#ifndef _INET_FTPIMPL_HXX
#define _INET_FTPIMPL_HXX "$Revision: 1.2 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif
#ifndef _VOS_OBJECT_HXX_
#include <vos/object.hxx>
#endif

#ifndef _INETDNS_HXX
#include <inetdns.hxx>
#endif
#ifndef _INETFTP_HXX
#include <inetftp.hxx>
#endif

#ifndef _INET_FTPCNTL_HXX
#include <ftpcntl.hxx>
#endif
#ifndef _INET_FTPDATA_HXX
#include <ftpdata.hxx>
#endif

#ifdef _USE_NAMESPACE
namespace inet {
#endif

/*========================================================================
 *
 * INetFTPConnection internals.
 *
 *======================================================================*/
struct INetFTPCommandContext_Impl;

#ifndef COPYCTOR_API
#define COPYCTOR_API(C) C (const C&); C& operator= (const C&)
#endif

/*========================================================================
 *
 * INetFTPConnection_Impl interface.
 *
 *======================================================================*/
class INetFTPConnection_Impl : public NAMESPACE_INET(INetFTPConnection)
{
	VOS_DECLARE_CLASSINFO (VOS_NAMESPACE (INetFTPConnection_Impl, inet));

public:
	/** Construction.
	 */
	INetFTPConnection_Impl (void);

	/** Open.
	 */
	virtual sal_Bool open (
		const rtl::OUString &rHost, sal_uInt16 nPort,
		INetFTPCallback *pfnCB, void *pDataCB);

	virtual sal_Bool isOpen (void) const;

	/** Login.
	 */
	virtual sal_Bool loginUsername (
		const rtl::OUString &rUsername,
		INetFTPCallback *pfnCB, void *pDataCB);

	virtual sal_Bool loginPassword (
		const rtl::OUString &rPassword,
		INetFTPCallback *pfnCB, void *pDataCB);

	virtual sal_Bool loginAccount (
		const rtl::OUString &rAccount,
		INetFTPCallback *pfnCB, void *pDataCB);

	virtual sal_Bool isLoggedIn (void) const;

	/** Close.
	 */
	virtual sal_Bool close (
		INetFTPCallback *pfnCB, void *pDataCB);

	virtual void abort (void);

	/** Noop.
	 */
	virtual sal_Bool noop (
		INetFTPCallback *pfnCB, void *pDataCB);

	/** Working directory.
	 */
	virtual sal_Bool setCurDir (
		const rtl::OUString &rPathname,
		INetFTPCallback *pfnCB, void *pDataCB);

	virtual sal_Bool getCurDir (
		INetFTPCallback *pfnCB, void *pDataCB);

	virtual const rtl::OUString& getCurDir (void) const;

	/** Directory.
	 */
	virtual sal_Bool makeDir (
		const rtl::OUString &rPathname,
		INetFTPCallback *pfnCB, void *pDataCB);

	virtual sal_Bool removeDir (
		const rtl::OUString &rPathname,
		INetFTPCallback *pfnCB, void *pDataCB);

	/** Remove.
	 */
	virtual sal_Bool remove (
		const rtl::OUString &rPathname,
		INetFTPCallback *pfnCB, void *pDataCB);

	/** Rename.
	 */
	virtual sal_Bool renameFrom (
		const rtl::OUString &rFromPath,
		INetFTPCallback *pfnCB, void *pDataCB);

	virtual sal_Bool renameTo (
		const rtl::OUString &rToPath,
		INetFTPCallback *pfnCB, void *pDataCB);

	/** Data type.
	 */
	virtual sal_Bool setTypeAscii (
		INetFTPCallback *pfnCB, void *pDataCB);

	virtual sal_Bool setTypeImage (
		INetFTPCallback *pfnCB, void *pDataCB);

	virtual DataType getDataType (void) const;

	/** Directory Listing.
	 */
	virtual sal_Bool getNameList (
		const rtl::OUString &rPathname,
		List                &rNameList,
		INetFTPCallback     *pfnCB,
		void                *pDataCB);

	virtual ListType getListType (void) const;

	/** Retrieve.
	 */
	virtual sal_Bool retrieve (
		const rtl::OUString &rFromPath,
		SvOpenLockBytes     *pToPath,
		sal_uInt32           nRestartOffset,
		INetFTPCallback     *pfnCB,
		void                *pDataCB);

	virtual sal_uInt32 getRetrieveCount (void) const;

	/** Store.
	 */
	virtual sal_Bool store (
		SvLockBytes         *pFromPath,
		const rtl::OUString &rToPath,
		sal_uInt32           nRestartOffset,
		INetFTPCallback     *pfnCB,
		void                *pDataCB);

	virtual sal_uInt32 getStoreCount (void) const;

	/** Abort data transfer (LIST|RETR|STOR) command.
	 */
	virtual sal_Bool abortTransfer (sal_Bool bSilent = sal_True);

	/** Callbacks.
	 */
	virtual sal_Bool setTransferCallback (
		INetFTPCallback *pfnCB, void *pDataCB);

	virtual sal_Bool setTerminateCallback (
		INetFTPCallback *pfnCB, void *pDataCB);

	/** Socks.
	 */
	virtual const rtl::OUString& getSocksGatewayName (void) const;
	virtual sal_uInt16 getSocksGatewayPort (void) const;

	virtual sal_Bool hasSocksGateway (void) const;
	virtual void     setSocksGateway (
		const rtl::OUString &rName, sal_uInt16 nPort);

protected:
	/** Destruction (vos::OReference::release()).
	 */
	virtual ~INetFTPConnection_Impl (void);

private:
	/** Representation.
	 */
	NAMESPACE_VOS(OMutex)       m_aMutex;
	INetFTPCommandContext_Impl *m_pCtx;

	INetFTPCntlContext          m_aCntlCtx;
	INetFTPDataContext          m_aDataCtx;

	INetCoreDNSResolver         m_aResolver;
	rtl::OUString               m_aGwName;
	sal_uInt16                  m_nGwPort;

	/** switchContext.
	 */
	INetFTPCommandContext_Impl* switchContext (
		INetFTPCommandContext_Impl *pCtx);

	/** startCommand.
	 */
	sal_Bool startCommand (
		const rtl::OString   &rCommand,
		const rtl::OUString  &rArgument,
		INetFTPCallback      *pfnCB,
		void                 *pDataCB);

	sal_Bool startCommand (
		INetFTPCommandStream *pCommand,
		INetFTPInputStream   *pSource,
		INetFTPOutputStream  *pTarget,
		INetFTPCallback      *pfnCB,
		void                 *pDataCB);

	/** completeCommand.
	 */
	void completeCommand (
		INetFTPCommandStream *pCommand);

	/** handleResolverEvent.
	 */
	virtual sal_Bool handleResolverEvent (
		sal_Int32 nStatus, INetCoreDNSHostEntry *pHostEntry);

	/** handleSocketEvent.
	 */
	virtual sal_Bool handleSocketEvent (
		const NAMESPACE_VOS(ORef)<INetSocket> &rxSocket, sal_Int32 nEvent);

	/** handleCommand (USER-PI).
	 */
	sal_Int32 handleCommand  (sal_Int32 nEvent);

	/** handleTransfer (USER-DTP).
	 */
	sal_Int32 handleTransfer (sal_Int32 nEvent);

	/** Not implemented.
	 */
	COPYCTOR_API(INetFTPConnection_Impl);
};

/*========================================================================
 *
 * The End.
 *
 *======================================================================*/
#ifdef _USE_NAMESPACE
}
#endif

#endif /* !_INET_FTPIMPL_HXX */

