/*************************************************************************
 *
 *  $RCSfile: imapscan.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:31:16 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef INET_IMAPSCAN_HXX
#define INET_IMAPSCAN_HXX

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

//============================================================================
class INetIMAPScannerToken
{
public:
	enum Type
	{
		TYPE_SPACE,
		TYPE_SPECIAL,
		TYPE_ATOM,
		TYPE_ATOM_TOO_LONG,
		TYPE_QUOTED,
		TYPE_QUOTED_BROKEN,
		TYPE_QUOTED_TOO_LONG,
		TYPE_LITERAL,
		TYPE_LITERAL_BROKEN,
		TYPE_LITERAL_TOO_LONG,
		TYPE_NEWLINE
	};

private:
	ByteString m_aText;
	Type m_eType;

public:
	inline INetIMAPScannerToken(Type eTheType);

	inline INetIMAPScannerToken(Type eTheType, sal_Char cChar);

	inline INetIMAPScannerToken(Type eTheType, ByteString const & rText);

	inline Type getType() const { return m_eType; }

	inline sal_Char getChar() const;

	inline ByteString const & getText() const;
};

inline INetIMAPScannerToken::INetIMAPScannerToken(Type eTheType):
	m_eType(eTheType)
{
	DBG_ASSERT(m_eType == TYPE_SPACE || m_eType == TYPE_NEWLINE,
			   "INetIMAPScannerToken::INetIMAPScannerToken(): Invalid type");
}

inline INetIMAPScannerToken::INetIMAPScannerToken(Type eTheType,
												  sal_Char cChar):
	m_eType(eTheType), m_aText(cChar)
{
	DBG_ASSERT(m_eType == TYPE_SPECIAL,
			   "INetIMAPScannerToken::INetIMAPScannerToken(): Invalid type");
}

inline INetIMAPScannerToken::INetIMAPScannerToken(Type eTheType,
												  ByteString const & rText):
	m_eType(eTheType), m_aText(rText)
{
	DBG_ASSERT(m_eType != TYPE_SPACE && m_eType != TYPE_SPECIAL
			   && m_eType != TYPE_NEWLINE,
			   "INetIMAPScannerToken::INetIMAPScannerToken(): Invalid type");
}

inline sal_Char INetIMAPScannerToken::getChar() const
{
	DBG_ASSERT(m_eType == TYPE_SPECIAL,
			   "INetIMAPScannerToken::getChar(): Invalid type");
	return m_aText.GetChar(0);
}

inline ByteString const & INetIMAPScannerToken::getText() const
{
	DBG_ASSERT(m_eType != TYPE_SPACE && m_eType != TYPE_NEWLINE,
			   "INetIMAPScannerToken::getText(): Invalid type");
	return m_aText;
}

//============================================================================
class INetIMAPScanner: public SvLockBytes
{
public:
	enum Mode
	{
		MODE_ATOM = 0,
		MODE_ATOM_QUOTED = 0x01,
		MODE_ATOM_LITERAL = 0x02,
		MODE_ATOM_QUOTED_LITERAL = MODE_ATOM_QUOTED | MODE_ATOM_LITERAL,
		MODE_RESTRICTED = 0x04,
		MODE_RESTRICTED_QUOTED = MODE_RESTRICTED | MODE_ATOM_QUOTED,
		MODE_RESTRICTED_LITERAL = MODE_RESTRICTED | MODE_ATOM_LITERAL,
		MODE_RESTRICTED_QUOTED_LITERAL = MODE_RESTRICTED
		                                     | MODE_ATOM_QUOTED_LITERAL,
		MODE_TEXT = 0x08,
		MODE_ABORTED = 0x10
	};

	typedef Mode (* Callback)(INetIMAPScannerToken const &, void *);

private:
	enum State { STATE_INITIAL, STATE_SPACE, STATE_ATOM, STATE_QUOTE,
				 STATE_QUOTE_ESCAPE, STATE_LITERAL_LENGTH,
				 STATE_LITERAL_CLOSE, STATE_LITERAL_CR, STATE_LITERAL_TEXT,
				 STATE_CR };

	struct Buffer
	{
		Buffer * m_pNext;
		void * m_pData;
		sal_Size m_nSize;
	};

	ByteString m_aPrefix;
	INetIMAPScanner::Callback m_pCallback;
	void * m_pCallbackData;
	Buffer * m_pBuffers;
	sal_uInt32 m_nPosition;
	sal_uInt32 m_nLiteralLength;
	INetIMAPScanner::Mode m_eMode;
	State m_eState;
	bool m_bAborted;
	bool m_bActive;

	inline bool isAtomChar(sal_Char cChar) const;

	inline void addToPrefix(void const * pBuffer, sal_uInt32 & rStart,
							sal_uInt32 nEnd);

	void clearBuffers();

public:
	inline INetIMAPScanner(Callback pCallback, void * pCallbackData,
						   Mode eMode);

	~INetIMAPScanner() { clearBuffers(); }

	void abort() { m_bAborted = true; }

	virtual ErrCode ReadAt(ULONG, void *, ULONG, ULONG *) const
	{ return ERRCODE_IO_NOTSUPPORTED; }

	virtual ErrCode WriteAt(ULONG nPos, void const * pBuffer, ULONG nCount,
							ULONG * pWritten);

	virtual ErrCode Flush() const { return ERRCODE_IO_NOTSUPPORTED; }

	virtual ErrCode SetSize(ULONG) { return ERRCODE_IO_NOTSUPPORTED; }

	virtual ErrCode LockRegion(ULONG, ULONG, LockType)
	{ return ERRCODE_IO_NOTSUPPORTED; }

	virtual ErrCode UnlockRegion(ULONG, ULONG, LockType)
	{ return ERRCODE_IO_NOTSUPPORTED; }

	virtual ErrCode Stat(SvLockBytesStat *, SvLockBytesStatFlag) const
	{ return ERRCODE_IO_NOTSUPPORTED; }
};

inline INetIMAPScanner::INetIMAPScanner(Callback pTheCallback,
										void * pTheCallbackData,
										Mode eTheMode):
	m_pCallback(pTheCallback),
	m_pCallbackData(pTheCallbackData),
	m_bAborted(false),
	m_eMode(eTheMode),
	m_nPosition(0),
	m_eState(STATE_INITIAL),
	m_bActive(false),
	m_pBuffers(0)
{}

#endif // INET_IMAPSCAN_HXX

