/*************************************************************************
 *
 *  $RCSfile: mailtest.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:31:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _VOS_MACROS_HXX_
#include <vos/macros.hxx>
#endif
#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif
#ifndef _DATETIME_HXX
#include <tools/datetime.hxx>
#endif
#ifndef _GEN_HXX
#include <tools/gen.hxx>
#endif
#ifndef _LINK_HXX
#include <tools/link.hxx>
#endif
#ifndef _LIST_HXX
#include <tools/list.hxx>
#endif
#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif
#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _SV_EDIT_HXX
#include <vcl/edit.hxx>
#endif
#ifndef _SV_HELP_HXX
#include <vcl/help.hxx>
#endif
#ifndef _SV_LSTBOX_HXX
#include <vcl/lstbox.hxx>
#endif
#ifndef _SV_TOOLBOX_HXX
#include <vcl/toolbox.hxx>
#endif
#ifndef _SV_WRKWIN_HXX
#include <vcl/wrkwin.hxx>
#endif

#ifndef _INET_MACROS_HXX
#include <inet/macros.hxx>
#endif
#ifndef _INET_MODULE_HXX
#include <inet/module.hxx>
#endif

#ifndef _INET_CONFIG_HXX
#include <inetcfg.hxx>
#endif
#ifndef _INETCOREMSG_HXX
#include <inetmsg.hxx>
#endif
#ifndef _INETMAIL_HXX
#include <inetmail.hxx>
#endif

#ifdef _USE_NAMESPACE
using namespace inet;
using namespace rtl;
#endif

#include <stdlib.h>

#if (defined(WIN) || defined(WNT) || defined(OS2))

#define INTERNET_JPG "d:/mhu/tmp/internet.jpg"
#define POP3TEST_MAI "d:/pop3test.mai"
#define NNTPTEST_MAI "d:/nntptest.mai"
#define MIMEPART_    "d:/mimepart."
#define MESSAGE_TXT  "d:/message.txt"

#elif (defined(UNX))

#define INTERNET_JPG "/tmp/internet.jpg"
#define POP3TEST_MAI "/tmp/pop3test.mai"
#define NNTPTEST_MAI "/tmp/nntptest.mai"
#define MIMEPART_    "/tmp/mimepart."
#define MESSAGE_TXT  "/tmp/message.txt"

#else

#define INTERNET_JPG "internet.jpg"
#define POP3TEST_MAI "pop3test.mai"
#define NNTPTEST_MAI "nntptest.mai"
#define MIMEPART_    "mimepart."
#define MESSAGE_TXT  "message.txt"

#endif

inline UniString S2U (const sal_Char *pszAscii)
{
	return UniString::CreateFromAscii (pszAscii);
}

inline rtl::OUString S2OU (const sal_Char *pszAscii)
{
	return rtl::OUString::createFromAscii (pszAscii);
}

/*========================================================================
 *
 * MyModule.
 *
 *======================================================================*/
class MyModule
{
public:
	MyModule (void);
	~MyModule (void);

	sal_Bool isValid (void) const;

private:
	INetModuleApi *m_pApi;
};

MyModule::MyModule (void)
	: m_pApi (INetModule_Impl::getOrCreate())
{
	if (m_pApi)
		m_pApi->acquire();
}

MyModule::~MyModule (void)
{
	if (m_pApi)
		m_pApi->release();
}

sal_Bool MyModule::isValid (void) const
{
	return (!!m_pApi);
}

/*========================================================================
 *
 * MyOutWindow interface.
 *
 *======================================================================*/
#define MYOUTWINDOW_MAXLINES 500

class MyOutWindow : public ListBox
{
public:
	MyOutWindow (Window *pParent, WinBits nWinStyle);
	~MyOutWindow (void);

	void Append (const String &rLine);
};

MyOutWindow::MyOutWindow (Window *pParent, WinBits nWinStyle)
	: ListBox (pParent, nWinStyle)
{
}

MyOutWindow::~MyOutWindow (void)
{
}

void MyOutWindow::Append (const String &rLine)
{
	String aLine (rLine);

	xub_StrLen nPos = aLine.Search ('\n');
	while (nPos != STRING_NOTFOUND)
	{
		if (GetEntryCount() >= MYOUTWINDOW_MAXLINES)
			RemoveEntry (0);
		InsertEntry (aLine.Copy (0, nPos));

		aLine.Erase (0, nPos + 1);
		nPos = aLine.Search ('\n');
	}

	if (GetEntryCount() >= MYOUTWINDOW_MAXLINES)
		RemoveEntry (0);
	InsertEntry (aLine);

	SetTopEntry (MYOUTWINDOW_MAXLINES - 1);
}

/*========================================================================
 *
 * MyWin interface.
 *
 *======================================================================*/
class MyWin : public WorkWindow
{
	enum MyRecvCmd
	{
		RECVCMD_NONE = 0,
		RECVCMD_LIST,
		RECVCMD_UIDL,
		RECVCMD_MAIL
	};

	enum MyNewsCmd
	{
		NEWSCMD_NONE = 0,
		NEWSCMD_GROUP_LIST,
		NEWSCMD_ARTICLE_LIST,
		NEWSCMD_GROUP,
		NEWSCMD_BURST_HEAD,
		NEWSCMD_OVER,
		NEWSCMD_RETR,
		NEWSCMD_POST
	};

	ToolBox                *pSendTool, *pRecvTool, *pNewsTool;
	Edit                   *pCmdEdit;

	MyOutWindow            *m_pOutWin;
	INetCoreMailer         *m_pMailer;

	INetCoreMIMEMessage    *pMsg, *pDocMsg, *pAttMsg;
	INetCoreNewsMessage    *pNewsMsg;
	List                   *pMsgList;
	SvFileStream           *pDataStream, *pAttStream;
	INetCoreNNTPGroupListEntry *pGroupEntry;

	MyRecvCmd              eRecvCmd;
	MyNewsCmd              eNewsCmd;

	void Print (const String &rOutText, BOOL bUpdate = TRUE);

	static sal_Bool SendCallback (
		INetCoreMailer *pMailer,
		sal_Int32 nReplyCode, const sal_Char *pReplyText, void *pData);

	static sal_Bool RecvCallback (
		INetCoreMailer *pMailer,
		sal_Int32 nReplyCode, const sal_Char *pReplyText, void *pData);

	static sal_Bool NewsCallback (
		INetCoreMailer *pMailer,
		sal_Int32 nReplyCode, const sal_Char *pReplyText, void *pData);

	static void HeaderToString (
		String &rText, const String &rPrefix, const String &rValue);
	static void MessageDateToString (
		String &rText, INetCoreMIMEMessage &rMsg);

	static void RecvMessageToString (
		String &rText, INetCoreMIMEMessage &rMsg);
	static void NewsMessageToString (
		String &rText, INetCoreNewsMessage &rMsg);

	static void MessageBodyToString (
		String &rText, INetCoreMIMEMessage &rMsg, INetCoreMailer *pMailer);

public:
	MyWin (Window *pParent, WinBits nWinStyle);
	~MyWin (void);

	void Resize (void);

	DECL_LINK (SendToolBarHnd, ToolBox*);
	DECL_LINK (RecvToolBarHnd, ToolBox*);
	DECL_LINK (NewsToolBarHnd, ToolBox*);
};

/*========================================================================
 *
 * MyWin implementation.
 *
 *======================================================================*/
/*
 * MyWin.
 */
MyWin::MyWin (Window *pParent, WinBits nWinStyle)
	: WorkWindow (pParent, nWinStyle)
{
	// SendTool.
	pSendTool = new ToolBox (this, WB_SVLOOK | WB_BORDER);

	pSendTool->InsertItem  (1, S2U("SendOpen"));
	pSendTool->SetHelpText (1, S2U("Open Connection to SMTP Server"));
	pSendTool->InsertSeparator();

	pSendTool->InsertItem  (2, S2U("From"));
	pSendTool->SetHelpText (
		2, S2U("Sender's Mail Address (you@this.org)"));
	pSendTool->InsertItem  (3, S2U("To"));
	pSendTool->SetHelpText (
		3, S2U("Recipient's Mail Address (someone@other.org)"));
	pSendTool->InsertItem  (4, S2U("Mail"));
	pSendTool->SetHelpText (
		4, S2U("Send your Mail to specified Recipient(s)"));
	pSendTool->InsertSeparator();

	pSendTool->InsertItem  (5, S2U("Close"));
	pSendTool->SetHelpText (5, S2U("Quit and disconnect from SMTP Server"));
	pSendTool->InsertItem  (6, S2U("Abort"));
	pSendTool->SetHelpText (6, S2U("Abort Connection with SMTP Server"));

	pSendTool->SetClickHdl (LINK (this, MyWin, SendToolBarHnd));
	pSendTool->Show();

	// RecvToolBar.
	pRecvTool = new ToolBox (this, WB_SVLOOK | WB_BORDER);

	pRecvTool->InsertItem  (1, S2U("RecvOpen"));
	pRecvTool->SetHelpText (1, S2U("Open Connection to POP3 Server"));
	pRecvTool->InsertItem  (2, S2U("Login"));
	pRecvTool->SetHelpText (2, S2U("Username:Password"));
	pRecvTool->InsertSeparator();

	pRecvTool->InsertItem  (3, S2U("List"));
	pRecvTool->SetHelpText (3, S2U("Receive Message Listing"));
	pRecvTool->InsertItem  (9, S2U("UIDL"));
	pRecvTool->SetHelpText (9, S2U("Receive UniqueID Listing"));
	pRecvTool->InsertItem  (4, S2U("Delete"));
	pRecvTool->SetHelpText (4, S2U("Delete Message"));
	pRecvTool->InsertSeparator();

	pRecvTool->InsertItem  (5, S2U("Head"));
	pRecvTool->SetHelpText (5, S2U("Retrieve Message Headers only"));
	pRecvTool->InsertItem  (6, S2U("Read"));
	pRecvTool->SetHelpText (6, S2U("Retrieve complete Message"));
	pRecvTool->InsertSeparator();

	pRecvTool->InsertItem  (7, S2U("Close"));
	pRecvTool->SetHelpText (7, S2U("Quit and disconnect from POP3 Server"));
	pRecvTool->InsertItem  (8, S2U("Abort"));
	pRecvTool->SetHelpText (8, S2U("Abort Connection with POP3 Server"));

	pRecvTool->SetClickHdl (LINK(this, MyWin, RecvToolBarHnd));
	pRecvTool->Show();

	// NewsTool.
	pNewsTool = new ToolBox (this, WB_SVLOOK | WB_BORDER);

	pNewsTool->InsertItem  ( 1, S2U("NewsOpen"));
	pNewsTool->SetHelpText ( 1, S2U("Open Connection to NNTP Server"));
	pNewsTool->InsertItem  (13, S2U("Reader"));
	pNewsTool->SetHelpText (13, S2U("Set Mode Reader"));
	pNewsTool->InsertItem  (14, S2U("Auth"));
	pNewsTool->SetHelpText (14, S2U("Username[:Password]"));
	pNewsTool->InsertSeparator();

	pNewsTool->InsertItem  ( 2, S2U("List"));
	pNewsTool->SetHelpText ( 2, S2U("Get Group Listing"));
	pNewsTool->InsertItem  ( 3, S2U("NewGrp"));
	pNewsTool->SetHelpText ( 3, S2U("Get NewGroups Listing"));
	pNewsTool->InsertItem  ( 4, S2U("NewNews"));
	pNewsTool->SetHelpText ( 4, S2U("Get NewNews Listing"));
	pNewsTool->InsertSeparator();

	pNewsTool->InsertItem  ( 5, S2U("Group"));
	pNewsTool->SetHelpText ( 5, S2U("Select a NewsGroup for Retrieval"));
	pNewsTool->InsertItem  ( 6, S2U("Burst"));
	pNewsTool->SetHelpText (
		6, S2U("Select Group followed by Burst Header Read"));
	pNewsTool->InsertItem  ( 7, S2U("XOver"));
	pNewsTool->SetHelpText ( 7, S2U("Retrieve Overview Headers"));
	pNewsTool->InsertSeparator();

	pNewsTool->InsertItem  ( 8, S2U("Head"));
	pNewsTool->SetHelpText ( 8, S2U("Retrieve Article Headers only"));
	pNewsTool->InsertItem  ( 9, S2U("Retr"));
	pNewsTool->SetHelpText ( 9, S2U("Retrieve complete Article"));
	pNewsTool->InsertSeparator();

	pNewsTool->InsertItem  (10, S2U("Post"));
	pNewsTool->SetHelpText (10, S2U("Post Article"));
	pNewsTool->InsertItem  (15, S2U("Control"));
	pNewsTool->SetHelpText (15, S2U("Post Control Message"));
	pNewsTool->InsertSeparator();

	pNewsTool->InsertItem  (11, S2U("Close"));
	pNewsTool->SetHelpText (11, S2U("Quit and disconnect from NNTP Server"));
	pNewsTool->InsertItem  (12, S2U("Abort"));
	pNewsTool->SetHelpText (12, S2U("Abort Connection with NNTP Server"));

	pNewsTool->SetClickHdl (LINK (this, MyWin, NewsToolBarHnd));
	pNewsTool->Show();

	// CmdEdit.
	pCmdEdit = new Edit (this);
	pCmdEdit->SetReadOnly (FALSE);
	pCmdEdit->Show();

	// MultiLineEdit (output work window).
	m_pOutWin = new MyOutWindow (this, WB_HSCROLL | WB_VSCROLL | WB_BORDER);
	m_pOutWin->SetReadOnly (TRUE);
	m_pOutWin->Show();

	// Mailer.
	m_pMailer = NewINetCoreMailer();

	pMsg = NULL;
	pMsgList = NULL;

	pDocMsg = NULL;
	pDataStream = NULL;

	pAttMsg = NULL;
	pAttStream = NULL;

	pNewsMsg = NULL;
	pGroupEntry = NULL;

	eRecvCmd = RECVCMD_NONE;
	eNewsCmd = NEWSCMD_NONE;
}

/*
 * ~MyWin.
 */
MyWin::~MyWin (void)
{
	delete pAttStream;
	delete pAttMsg;

	delete pNewsMsg;
	delete pGroupEntry;

	delete pDataStream;
	delete pDocMsg;

	delete pMsgList;
	delete pMsg;

	delete m_pMailer;

	delete m_pOutWin;
	delete pCmdEdit;
	delete pNewsTool;
	delete pRecvTool;
	delete pSendTool;
}

/*
 * Print.
 */
void MyWin::Print (const String &rOutText, BOOL bUpdate)
{
	if (rOutText.Len())
		m_pOutWin->Append (rOutText);
	if (bUpdate)
		m_pOutWin->Update();
}

/*
 * Resize.
 */
void MyWin::Resize (void)
{
	Size aWinSize (GetOutputSizePixel());
	int nWinW = aWinSize.Width();
	int nWinH = aWinSize.Height();

	int nSendBoxH = pSendTool->CalcWindowSizePixel().Height();
	int nRecvBoxH = pRecvTool->CalcWindowSizePixel().Height();
	int nNewsBoxH = pNewsTool->CalcWindowSizePixel().Height();

	pSendTool->SetPosSizePixel (
		Point (0, 0),
		Size (nWinW, nSendBoxH));

	pRecvTool->SetPosSizePixel (
		Point (0, nSendBoxH),
		Size  (nWinW, nRecvBoxH));

	pNewsTool->SetPosSizePixel (
		Point (0, nSendBoxH + nRecvBoxH),
		Size  (nWinW, nNewsBoxH));

	pCmdEdit->SetPosSizePixel (
		Point (0, nSendBoxH + nRecvBoxH + nNewsBoxH),
		Size  (nWinW, nNewsBoxH) );

	m_pOutWin->SetPosSizePixel (
		Point (0, nSendBoxH + nRecvBoxH + nNewsBoxH + nNewsBoxH),
		Size (nWinW, nWinH - (nSendBoxH + nRecvBoxH + nNewsBoxH + nNewsBoxH)));
}

/*
 * SendToolBarHnd: Send via SMTP.
 */
IMPL_LINK (MyWin, SendToolBarHnd, ToolBox*, pSendTool)
{
	USHORT nItemId  = pSendTool->GetCurItemId();
	String aCmdLine = pCmdEdit->GetText();

	switch (nItemId)
	{
		case 1: // Open.
			if (aCmdLine.Len())
			{
				if (m_pMailer->SendOpenConnection (
					aCmdLine, 0, SendCallback, this))
				{
					String aText (S2U("Connecting to \" "));
					aText += aCmdLine;
					aText.AppendAscii ("\" ...");
					Print (aText);
				}
				else
				{
					Print (S2U("Connect Failure."));
				}
			}
			break;

		case 2: // From.
			if (aCmdLine.Len())
			{
				if (pMsg) delete pMsg;
				pMsg = m_pMailer->CreateINetCoreMIMEMessage();
				pMsg->SetFrom (aCmdLine);
			}
			break;

		case 3: // To.
			if (aCmdLine.Len() && pMsg)
			{
				String aTo (pMsg->GetTo());
				if (aTo.Len()) aTo += sal_Unicode(',');
				aTo += aCmdLine;
				pMsg->SetTo (aTo);
			}
			break;

		case 4: // Mail.
			if (aCmdLine.Len () == 0) return 0;

			if (pDataStream) delete pDataStream;
			pDataStream = new SvFileStream;

			pDataStream->Open (aCmdLine, STREAM_READ);
			// pDataStream->Open ("d:/mhu/tmp/internet.jpg", STREAM_READ);

			if (!pDataStream->IsOpen ())
			{
				delete pDataStream;
				pDataStream = NULL;

				delete pMsg;
				pMsg = NULL;
				return 0;
			}

			if (pMsg)
			{
				// pMsg->SetCC  (S2U("asa@stardiv.de"));
				// pMsg->SetBCC (S2U("mhu@stardiv.de"));
				pMsg->SetSubject (UniString (
					"Hello (Schne Gre) MIME World",
					RTL_TEXTENCODING_ISO_8859_1));
				pMsg->SetMIMEVersion (S2U("1.0"));
/**/
				pMsg->EnableAttachChild (INETCOREMSG_MULTIPART_MIXED);
/**/
				if (pDocMsg) delete pDocMsg;
				pDocMsg = new INetCoreMIMEMessage;

				pDocMsg->SetContentType(S2U("text/plain; charset=iso-8859-1"));
				pDocMsg->SetDocumentStream (pDataStream);
				
				pMsg->AttachChild (*pDocMsg);
/**/
				if (pAttMsg) delete pAttMsg;
				pAttMsg = new INetCoreMIMEMessage;

				pAttMsg->SetContentType (S2U("image/jpeg"));

				if (pAttStream) delete pAttStream;
				pAttStream = new SvFileStream (
					S2U(INTERNET_JPG), STREAM_STD_READ);

				pAttMsg->SetDocumentStream (pAttStream);

				pMsg->AttachChild (*pAttMsg);

				if (m_pMailer->SendMail (*pMsg, SendCallback, this))
				{
				}
				else
				{
/**/
					delete pAttStream;
					pAttStream = NULL;
					delete pAttMsg;
					pAttMsg = NULL;
/**/
					delete pDataStream;
					pDataStream = NULL;
					delete pDocMsg;
					pDocMsg = NULL;
/**/
					delete pMsg;
					pMsg = NULL;
				}
			}
			break;

		case 5: // Close.
			if (m_pMailer->SendCloseConnection (SendCallback, this))
			{
			}
			else
			{
			}
			break;

		case 6: // Abort.
			m_pMailer->SendAbortConnection ();
			break;

		default: // Ignored.
			break;
	}

	return 0;
}

/*
 * SendCallback.
 */
sal_Bool MyWin::SendCallback (
	INetCoreMailer *pMailer,
	sal_Int32 nReplyCode, const sal_Char *pReplyText, void *pData)
{
	MyWin *pThis = SAL_REINTERPRET_CAST(MyWin*, pData);
	if (pThis)
	{
		NAMESPACE_VOS(OGuard) aGuard (Application::GetSolarMutex());

		String aText;
		if (nReplyCode == INETCORESMTP_REPLY_TRANSFER_WAIT)
		{
			aText.AssignAscii ("SendTransferCount: ");
			aText += UniString::CreateFromInt32 (
				pMailer->SendGetTransferCount());
		}
		else
		{
			aText.AssignAscii ("SendCallback: ReplyCode: ");
			aText += UniString::CreateFromInt32 (nReplyCode);
			aText += sal_Unicode('\n');
			aText.AppendAscii (pReplyText);
		}
		pThis->Print (aText);
	}
	return 1;
}

/*
 * RecvToolBarHnd: Recv via POP3.
 */
IMPL_LINK (MyWin, RecvToolBarHnd, ToolBox*, pRecvTool)
{
	USHORT nItemId  = pRecvTool->GetCurItemId();
	String aCmdLine = pCmdEdit->GetText();

	eRecvCmd = RECVCMD_NONE;

	switch (nItemId)
	{
		case 1: // Open.
			if (aCmdLine.Len () == 0) return 0;

			if (m_pMailer->RecvOpenConnection (
				aCmdLine, 0, RecvCallback, this))
			{
				String aText (S2U("Connecting to \" "));
				aText += aCmdLine;
				aText.AppendAscii ("\" ...");
				Print (aText);
			}
			else
			{
				Print (S2U("RecvOpenConnection Failure."));
			}
			break;

		case 2: // Login.
			if (aCmdLine.Len() == 0) return 0;
			if (aCmdLine.GetTokenCount(':') == 2)
			{
				String aUser (aCmdLine.GetToken (0, ':'));
				if (aUser.Len() == 0) return 0;

				String aPwd (aCmdLine.GetToken (1, ':'));
				if (aPwd.Len() == 0) return 0;

				if (!m_pMailer->RecvLogin (
					aUser, aPwd, RecvCallback, this))
				{
					Print (S2U("RecvLogin Failure."));
				}
			}
			break;

		case 3: // List.
			if (pMsgList) delete pMsgList;
			pMsgList = new List;

			eRecvCmd = RECVCMD_LIST;

			if (!m_pMailer->RecvMailList (*pMsgList, RecvCallback, this))
			{
				Print (S2U("RecvMailList Failure."));
			}
			break;

		case 9: // UIDL.
			if (pMsgList) delete pMsgList;
			pMsgList = new List;

			eRecvCmd = RECVCMD_UIDL;

			if (!m_pMailer->RecvUniqueIdList (*pMsgList, RecvCallback, this))
			{
				Print (S2U("RecvUniqueIdList Failure."));
			}
			break;

		case 4: // Dele.
			if (aCmdLine.Len() == 0) return 0;

			if (!m_pMailer->RecvDeleteMail (
				aCmdLine.ToInt32(), RecvCallback, this))
			{
				Print (S2U("RecvDeleteMail Failure."));
			}
			break;

		case 5: // Head.
			if (aCmdLine.Len() == 0) return 0;

			delete pMsg;
			pMsg = m_pMailer->CreateINetCoreMIMEMessage();

			eRecvCmd = RECVCMD_MAIL;

			if (!m_pMailer->RecvMailHead (
				aCmdLine.ToInt32(), *pMsg, RecvCallback, this))
			{
				Print (S2U("RecvMailHead Failure."));
			}
			break;

		case 6: // Read.
			if (aCmdLine.Len() == 0) return 0;

			delete pMsg;
			pMsg = m_pMailer->CreateINetCoreMIMEMessage();

			{
				SvFileStream *pOS = new SvFileStream (				
					S2U(POP3TEST_MAI), STREAM_TRUNC | STREAM_READWRITE);

				pOS->Seek (STREAM_SEEK_TO_BEGIN);
				pMsg->SetDocumentStream (pOS);
			}

			eRecvCmd = RECVCMD_MAIL;
			
			m_pMailer->RecvSetTransferCallback (RecvCallback, this);
			if (!m_pMailer->RecvMail (
				aCmdLine.ToInt32(), *pMsg, RecvCallback, this))
			{
				Print (S2U("RecvMail Failure."));
			}
			break;

		case 7: // Close.
			if (!m_pMailer->RecvCloseConnection (RecvCallback, this))
			{
				Print (S2U("RecvCloseConnection Failure."));
			}
			break;

		case 8: // Abort.
			m_pMailer->RecvAbortConnection ();
			break;

		default: // Ignored.
			break;
	} // switch (nItemId)

	return 0;
}

/*
 * RecvCallback.
 */
sal_Bool MyWin::RecvCallback (
	INetCoreMailer *pMailer,
	sal_Int32 nReplyCode, const sal_Char *pReplyText, void *pData)
{
	MyWin *pThis = SAL_REINTERPRET_CAST(MyWin*, pData);
	if (!pThis)
		return 0;

	NAMESPACE_VOS(OGuard) aGuard (Application::GetSolarMutex());

	if (nReplyCode == INETCOREPOP3_REPLY_TRANSFER_WAIT)
	{
		String aText (S2U("RecvTransferCount: "));
		aText += UniString::CreateFromInt32 (pMailer->RecvGetTransferCount());
		pThis->Print (aText);

		return 1;
	}
	else
	{
		String aText (S2U("RecvCallback: ReplyCode: "));
		aText += UniString::CreateFromInt32 (nReplyCode);
		aText += sal_Unicode('\n');
		aText.AppendAscii (pReplyText);

		pThis->Print (aText);
	}

	switch (pThis->eRecvCmd)
	{
		case RECVCMD_LIST:
			if (pThis->pMsgList)
			{
				ULONG i, n = pThis->pMsgList->Count();
				for (i = 0; i < n; i++)
				{
					INetCoreMailInfoListEntry *entry =
						(INetCoreMailInfoListEntry*)
						(pThis->pMsgList->GetObject(i));

					String aText (S2U("Index: "));
					aText += UniString::CreateFromInt32 (entry->m_nIndex);
					aText.AppendAscii ("\tSize: ");
					aText += UniString::CreateFromInt32 (entry->m_nSize);
					pThis->Print (aText, (i % 10 == 0));

					delete entry;
				}
				DELETEZ (pThis->pMsgList);
				pThis->Print (String());
			}
			break;

		case RECVCMD_UIDL:
			if (pThis->pMsgList)
			{
				ULONG i, n = pThis->pMsgList->Count();
				for (i = 0; i < n; i++)
				{
					OUString *entry =
						(OUString*)(pThis->pMsgList->GetObject(i));

					String aText (S2U("Index: "));
					aText += UniString::CreateFromInt32 (i + 1);
					aText.AppendAscii ("\tUniqueId: ");
					aText.Append (UniString (*entry));
					pThis->Print (aText, (i % 10 == 0));

					delete entry;
				}
				DELETEZ (pThis->pMsgList);
				pThis->Print (String());
			}
			break;

		case RECVCMD_MAIL:
			if (pThis->pMsg)
			{
				INetCoreMIMEMessage *msg = pThis->pMsg;

				String (aText);
				RecvMessageToString (aText, *msg);
				aText += sal_Unicode('\n');
				MessageBodyToString (aText, *msg, pMailer);
				pThis->Print (aText);

				DELETEZ (pThis->pMsg);
			}
			break;

		default: // _NONE, i.e. any other.
			break;
	}

	pThis->eRecvCmd = RECVCMD_NONE;
	return 1;
}

/*
 * NewsToolBarHnd: News via NNTP.
 */
IMPL_LINK (MyWin, NewsToolBarHnd, ToolBox*, pNewsTool)
{
	USHORT nItemId  = pNewsTool->GetCurItemId();
	String aCmdLine = pCmdEdit->GetText();
	String aStr;

	DateTime aSince (Date (22, 3, 1996), Time (7, 45, 0));

	eNewsCmd = NEWSCMD_NONE;

	switch (nItemId)
	{
		case 1: // Open.
			if (aCmdLine.Len ())
			{
				if (m_pMailer->NewsOpenConnection (
					aCmdLine, 0, NewsCallback, this))
				{
					String aText (S2U("Connecting to \""));
					aText += aCmdLine;
					aText.AppendAscii ("\"...");
				}
				else
					Print (S2U("NewsOpenConnection Failure."));
			}
			break;

		case 13:
			if (!m_pMailer->NewsModeReader (NewsCallback, this))
				Print (S2U("NewsModeReader Failure."));
			break;

		case 14: // Auth.
			if (aCmdLine.Len())
			{
				String aUser, aPwd;
				if (aCmdLine.GetTokenCount (':') == 2)
				{
					aUser = aCmdLine.GetToken (0, ':');
					aPwd  = aCmdLine.GetToken (1, ':');
				}
				else
				{
					aUser = aCmdLine;
					aPwd  = String();
				}

				if (!m_pMailer->NewsAuthenticate (
					aUser, aPwd, NewsCallback, this))
				{
					Print (S2U("NewsAuthenticate Failure."));
				}
			}
			break;

		case 2: // List.
			delete pMsgList;
			pMsgList = new List;

			eNewsCmd = NEWSCMD_GROUP_LIST;

			if (!m_pMailer->NewsGroupList (*pMsgList, NewsCallback, this))
				Print (S2U("NewsGroupList Failure."));
			break;

		case 3: // NewGrp.
			if (aCmdLine.Len())
			{
				delete pNewsMsg;
				pNewsMsg = m_pMailer->CreateINetCoreNewsMessage();

				DateTime aDT;
				if (pNewsMsg->ParseDateField (aCmdLine, aDT, aDT))
					aSince = aDT;
			}

			delete pMsgList;
			pMsgList = new List;

			eNewsCmd = NEWSCMD_GROUP_LIST;

			if (!m_pMailer->NewsNewGroupsList (
				aSince, *pMsgList, NewsCallback, this))
				Print (S2U("NewsNewGroupsList Failure."));
			break;

		case 4: // NewNews.
			if (aCmdLine.Len())
			{
				delete pMsgList;
				pMsgList = new List;

				eNewsCmd = NEWSCMD_ARTICLE_LIST;

				if (!m_pMailer->NewsNewNewsList (
					aCmdLine, aSince, *pMsgList, NewsCallback, this))
					Print (S2U("NewsNewNewsList Failure."));
			}
			break;

		case 5: // Group.
			if (aCmdLine.Len())
			{
				delete pGroupEntry;
				pGroupEntry = new INetCoreNNTPGroupListEntry;
				pGroupEntry->m_aGroupName = aCmdLine;
				pGroupEntry->m_nArticleCount = 0;
				pGroupEntry->m_nFirstArticleNumber = 0;
				pGroupEntry->m_nLastArticleNumber = 0;

				eNewsCmd = NEWSCMD_GROUP;

				if (!m_pMailer->NewsSelectGroup (
					*pGroupEntry, NewsCallback, this))
				{
					Print (S2U("NewsSelectGroup Failure."));
					delete pGroupEntry;
					pGroupEntry = NULL;
				}
			}
			break;

		case 6: // Burst.
			if (aCmdLine.Len())
			{
				delete pGroupEntry;
				pGroupEntry = new INetCoreNNTPGroupListEntry;
				pGroupEntry->m_aGroupName = aCmdLine;
				pGroupEntry->m_nArticleCount = 0;
				pGroupEntry->m_nFirstArticleNumber = 0;
				pGroupEntry->m_nLastArticleNumber = 0;

				eNewsCmd = NEWSCMD_BURST_HEAD;

				if (!m_pMailer->NewsSelectGroup (
					*pGroupEntry, NewsCallback, this))
				{
					Print (S2U("NewsSelectGroup Failure."));
					delete pGroupEntry;
					pGroupEntry = NULL;
				}
			}
			break;

		case 7: // XOver.
			if (aCmdLine.Len() /* && m_pMailer->NewsHasOverview() */)
			{
				ULONG nFirst = (aCmdLine.GetToken (0, '-')).ToInt32();
				ULONG nLast  = (aCmdLine.GetToken (1, '-')).ToInt32();

				delete pNewsMsg;
				pNewsMsg = m_pMailer->CreateINetCoreNewsMessage();
				pNewsMsg->SetDocumentStream (NULL);

				eNewsCmd = NEWSCMD_OVER;

				if (!m_pMailer->NewsArticleHeadOverview (
					nFirst, nLast, *pNewsMsg, NewsCallback, this))
				{
					Print (S2U("NewsArticleHeadOverview Failure."));
					delete pNewsMsg;
					pNewsMsg = NULL;
				}
			}
			break;

		case 8: // Head.
			if (aCmdLine.Len())
			{
				delete pNewsMsg;
				pNewsMsg = m_pMailer->CreateINetCoreNewsMessage();
				pNewsMsg->SetDocumentStream (NULL);

				eNewsCmd = NEWSCMD_RETR;
				ULONG nArticle = aCmdLine.ToInt32();

				BOOL bStarted;
				if (nArticle)
					bStarted = m_pMailer->NewsArticleHead (
						nArticle, *pNewsMsg, NewsCallback, this);
				else
					bStarted = m_pMailer->NewsArticleHead (
						aCmdLine, *pNewsMsg, NewsCallback, this);
				if (!bStarted)
				{
					Print (S2U("NewsArticleHead Failure."));
					delete pNewsMsg;
					pNewsMsg = NULL;
				}
			}
			break;

		case 9: // Article.
			if (aCmdLine.Len())
			{
				delete pNewsMsg;
				pNewsMsg = m_pMailer->CreateINetCoreNewsMessage();

				SvFileStream *pOS = new SvFileStream (
					S2U(NNTPTEST_MAI), STREAM_TRUNC | STREAM_READWRITE);

				pOS->Seek (STREAM_SEEK_TO_BEGIN);
				pNewsMsg->SetDocumentStream (pOS);

				eNewsCmd = NEWSCMD_RETR;
				ULONG nArticle = aCmdLine.ToInt32();

				BOOL bStarted;
				if (nArticle)
					bStarted = m_pMailer->NewsArticle (
						nArticle, *pNewsMsg, NewsCallback, this);
				else
					bStarted = m_pMailer->NewsArticle (
						aCmdLine, *pNewsMsg, NewsCallback, this);
				if (!bStarted)
				{
					Print (S2U("NewsArticle Failure."));
					delete pOS;
					delete pNewsMsg;
					pNewsMsg = NULL;
				}
			}
			break;

		case 10: // Post.
			if (aCmdLine.Len())
			{
				delete pDataStream;
				pDataStream = new SvFileStream (aCmdLine, STREAM_READ);
				if (!pDataStream->IsOpen())
				{
					DELETEZ (pDataStream);
					return 0;
				}

				delete pNewsMsg;
				pNewsMsg = m_pMailer->CreateINetCoreNewsMessage();

				pNewsMsg->SetDocumentStream (pDataStream);
				pNewsMsg->SetMIMEVersion (S2U("1.0"));
				pNewsMsg->SetContentType (S2U("text/plain"));

				pNewsMsg->SetNewsgroups (S2U("_sd.test"));
				pNewsMsg->SetFrom (S2U("mhu@stardivision.de"));
				pNewsMsg->SetSubject (S2U("Hello USENET NEWS World"));

				eNewsCmd = NEWSCMD_POST;

				if (!m_pMailer->NewsPostArticle(*pNewsMsg, NewsCallback, this))
				{
					Print (S2U("NewsPostArticle Failure."));
					DELETEZ (pDataStream);
					DELETEZ (pNewsMsg);
				}
			}
			break;

		case 15: // Control.
			if (aCmdLine.Len())
			{
				delete pNewsMsg;
				pNewsMsg = m_pMailer->CreateINetCoreNewsMessage();

				pNewsMsg->SetNewsgroups (S2U("_sd.test"));
				pNewsMsg->SetFrom (S2U("mhu@stardivision.de"));
				pNewsMsg->SetControl (aCmdLine);

				String aSubject (S2U("cmsg "));
				aSubject += aCmdLine;
				pNewsMsg->SetSubject (aSubject);

				eNewsCmd = NEWSCMD_POST;

				if (!m_pMailer->NewsPostArticle(*pNewsMsg, NewsCallback, this))
				{
					Print (S2U("NewsPostArticle Failure."));
					DELETEZ (pNewsMsg);
				}
			}
			break;

		case 11: // Close.
			if (!m_pMailer->NewsCloseConnection (NewsCallback, this))
				Print (S2U("NewsCloseConnection Failure."));
			break;

		case 12: // Abort.
			m_pMailer->NewsAbortConnection();
			break;

		default: // Ignored.
			break;
	}

	return 0;
}

/*
 * NewsCallback.
 */
sal_Bool MyWin::NewsCallback (
	INetCoreMailer *pMailer,
	sal_Int32 nReplyCode, const sal_Char *pReplyText, void *pData)
{
	MyWin *pThis = SAL_REINTERPRET_CAST(MyWin*, pData);
	if (!pThis)
		return 0;

	NAMESPACE_VOS(OGuard) aGuard (Application::GetSolarMutex());

	if (nReplyCode == INETCORENNTP_REPLY_TRANSFER_WAIT)
	{
		String aText (S2U("NewsTransferCount: "));
		aText += UniString::CreateFromInt32 (pMailer->NewsGetTransferCount());
		pThis->Print (aText);

		return 1;
	}
	else
	{
		String aText (S2U("NewsCallback: Reply Code: "));
		aText += UniString::CreateFromInt32 (nReplyCode);
		if (nReplyCode != INETCORENNTP_REPLY_TRANSFER_OVERVIEW)
		{
			aText += sal_Unicode('\n');
			aText.AppendAscii (pReplyText);
		}
		pThis->Print (aText);
	}

	switch (pThis->eNewsCmd)
	{
		case NEWSCMD_GROUP_LIST:
			if (pThis->pMsgList)
			{
				ULONG i, n = pThis->pMsgList->Count();
				for (i = 0; i < n; i++)
				{
					INetCoreNNTPGroupListEntry *entry =
						(INetCoreNNTPGroupListEntry*)
						(pThis->pMsgList->GetObject(i));

					String aText (S2U("Group: "));
					aText.Append (UniString (entry->m_aGroupName));
					aText.AppendAscii ("\tCount: ");
					aText += UniString::CreateFromInt32 (
						entry->m_nArticleCount);
					aText.AppendAscii ("\tFirst: ");
					aText += UniString::CreateFromInt32 (
						entry->m_nFirstArticleNumber);
					aText.AppendAscii ("\tLast: ");
					aText += UniString::CreateFromInt32 (
						entry->m_nLastArticleNumber);
					aText.AppendAscii ("\tFlags: ");
					aText += UniString::CreateFromInt32 (entry->m_nFlags);
					pThis->Print (aText, (i % 10 == 0));

					delete entry;
				}
				DELETEZ (pThis->pMsgList);
				pThis->Print (String());
			}
			pThis->eNewsCmd = NEWSCMD_NONE;
			break;

		case NEWSCMD_ARTICLE_LIST:
			if (pThis->pMsgList)
			{
				ULONG i, n = pThis->pMsgList->Count();
				for (i = 0; i < n; i++)
				{
					OUString *entry =
						(OUString*)(pThis->pMsgList->GetObject(i));

					String aText (S2U("Article: "));
					aText.Append (UniString (*entry));
					pThis->Print (aText, (i % 10 == 0));

					delete entry;
				}
				DELETEZ (pThis->pMsgList);
				pThis->Print (String());
			}
			pThis->eNewsCmd = NEWSCMD_NONE;
			break;

		case NEWSCMD_GROUP:
			if (pThis->pGroupEntry)
			{
				INetCoreNNTPGroupListEntry *entry = pThis->pGroupEntry;

				String aText (S2U("Group: "));
				aText.Append (UniString (entry->m_aGroupName));
				aText.AppendAscii ("\tCount: ");
				aText += UniString::CreateFromInt32 (
					entry->m_nArticleCount);
				aText.AppendAscii ("\tFirst: ");
				aText += UniString::CreateFromInt32 (
					entry->m_nFirstArticleNumber);
				aText.AppendAscii ("\tLast: ");
				aText += UniString::CreateFromInt32 (
					entry->m_nLastArticleNumber);
				pThis->Print (aText);

				DELETEZ (pThis->pGroupEntry);
			}
			pThis->eNewsCmd = NEWSCMD_NONE;
			break;

		case NEWSCMD_BURST_HEAD:
			if (pThis->pNewsMsg)
			{
				INetCoreNewsMessage *msg = pThis->pNewsMsg;

				String aText;
				HeaderToString (
					aText, S2U("Message-ID: "), msg->GetMessageID());
				MessageDateToString (aText, *msg);
				pThis->Print (aText);

				DELETEZ (pThis->pNewsMsg);
			}

			if (pThis->pGroupEntry)
			{
				INetCoreNNTPGroupListEntry *entry = pThis->pGroupEntry;

				if (entry->m_nFirstArticleNumber <=
					entry->m_nLastArticleNumber     )
				{
					delete (pThis->pNewsMsg);
					pThis->pNewsMsg = pMailer->CreateINetCoreNewsMessage();
					pThis->pNewsMsg->SetDocumentStream (NULL);

					if (!pMailer->NewsArticleHead (
						entry->m_nFirstArticleNumber, *(pThis->pNewsMsg),
						NewsCallback, pThis))
					{
						pThis->Print (S2U("NewsArticleHead Failure."));

						DELETEZ (pThis->pNewsMsg);
						DELETEZ (pThis->pGroupEntry);

						pThis->eNewsCmd = NEWSCMD_NONE;
					}
					else
					{
						entry->m_nFirstArticleNumber++;
						pThis->eNewsCmd = NEWSCMD_BURST_HEAD;
					}
				}
				else
				{
					DELETEZ (pThis->pGroupEntry);
					pThis->eNewsCmd = NEWSCMD_NONE;
				}
			}
			else
			{
				pThis->eNewsCmd = NEWSCMD_NONE;
			}
			break;

		case NEWSCMD_OVER:
			if (nReplyCode == INETCORENNTP_REPLY_TRANSFER_OVERVIEW)
			{
				INetCoreNewsMessage *msg = pThis->pNewsMsg;
				if (msg && msg->GetMessageID().Len())
				{
					String aText (S2U("Article "));
					aText += UniString::CreateFromInt32 (
						*((ULONG *)(pReplyText)));
					HeaderToString (
						aText, S2U("\tMessage-ID: "), msg->GetMessageID());
					HeaderToString (
						aText, S2U("\tBytes: "), msg->GetBytes());
					pThis->Print (aText);
				}
			}
			else
			{
				DELETEZ (pThis->pNewsMsg);
			}
			break;

		case NEWSCMD_RETR:
			if (pThis->pNewsMsg)
			{
				INetCoreNewsMessage *msg = pThis->pNewsMsg;
/* @@@
				SvFileStream *pFS = new SvFileStream (
					"d:\\msgstrm.dat", STREAM_TRUNC | STREAM_READWRITE);

				msg->SetDocumentFilename ("d:\\msgstrm.dat");
				msg->SetDocumentSize (42);

				*pFS << *msg;

				delete pFS;
 @@@ */
				// Output message.
				String aText;
				NewsMessageToString (aText, *msg);
				aText += sal_Unicode('\n');
				MessageBodyToString (aText, *msg, pMailer);
				pThis->Print (aText);

				DELETEZ (pThis->pNewsMsg);
			}
			pThis->eNewsCmd = NEWSCMD_NONE;
			break;

		case NEWSCMD_POST:
			if (pThis->pNewsMsg)
			{
				DELETEZ (pThis->pDataStream);
				DELETEZ (pThis->pNewsMsg);
			}
			pThis->eNewsCmd = NEWSCMD_NONE;
			break;

		default: // _NONE, i.e. any other.
			pThis->eNewsCmd = NEWSCMD_NONE;
			break;
	}
	return 1;
}

/*
 * HeaderToString.
 */
void MyWin::HeaderToString (
	String &rText, const String &rPrefix, const String &rValue)
{
	if (rValue.Len())
	{
		rText += rPrefix;
		rText += rValue;
	}
}

/*
 * MessageDateToString.
 */
void MyWin::MessageDateToString (
	String &rText, INetCoreMIMEMessage &rMsg)
{
	String aValue (rMsg.GetDate());
	if (aValue.Len())
	{
		HeaderToString (rText, S2U("\nDate: "), aValue);

		DateTime aDate;
		rText.AppendAscii (" (");
		if (rMsg.ParseDateField (aValue, aDate, aDate))
		{
			rText += UniString::CreateFromInt32 (aDate.GetDay());
			rText += sal_Unicode('-');
			rText += UniString::CreateFromInt32 (aDate.GetMonth());
			rText += sal_Unicode('-');
			rText += UniString::CreateFromInt32 (aDate.GetYear());
			rText += sal_Unicode(' ');
			rText += UniString::CreateFromInt32 (aDate.GetHour());
			rText += sal_Unicode(':');
			rText += UniString::CreateFromInt32 (aDate.GetMin());
			rText += sal_Unicode(':');
			rText += UniString::CreateFromInt32 (aDate.GetSec());

			rMsg.GenerateDateField (aDate, aDate, aValue);
			rText += sal_Unicode('(');
			rText += aValue;
			rText += sal_Unicode(')');
		}
		rText += sal_Unicode(')');
	}
}

/*
 * MessageBodyToString.
 */
void MyWin::MessageBodyToString (
	String &rText, INetCoreMIMEMessage &rMsg, INetCoreMailer *pMailer)
{
	// Document.
	SvStream *pStrm = rMsg.GetDocumentStream();
	if (pStrm)
	{
		if (rMsg.IsMultipart())
		{
			ULONG nCount = rMsg.GetChildCount();

			rText.AppendAscii ("\nChildCount: ");
			rText += UniString::CreateFromInt32 (nCount);
			rText += sal_Unicode('\n');

			for (ULONG i = 0; i < nCount; i++)
			{
				rText.AppendAscii ("\nPart #");
				rText += UniString::CreateFromInt32 ((i + 1));

				String aFile (S2U(MIMEPART_));
				aFile += UniString::CreateFromInt32 ((i + 1));

				SvFileStream aOS (aFile, STREAM_TRUNC | STREAM_READWRITE);

				INetCoreMIMEMessage *pAM =
					pMailer->CreateINetCoreMIMEMessage();
				pAM->SetDocumentStream (&aOS);

				if (rMsg.DetachChild (i, *pAM))
				{
					HeaderToString (
						rText, S2U("\nContent-Type: "),
						pAM->GetContentType());
					HeaderToString (
						rText, S2U("\nContent-Transfer-Encoding: "),
						pAM->GetContentTransferEncoding());
				}
				delete pAM;
			}
		}
		else if (rMsg.IsMessage())
		{
			String aFile (S2U(MESSAGE_TXT));
			SvFileStream aOS (aFile, STREAM_TRUNC | STREAM_READWRITE);

			INetCoreMIMEMessage *pAM =
				pMailer->CreateINetCoreMIMEMessage();
			pAM->SetDocumentStream (&aOS);

			if (rMsg.DetachChild (rMsg.GetChildCount() - 1, *pAM))
			{
				HeaderToString (rText, S2U("\nFrom: "),    pAM->GetFrom());
				HeaderToString (rText, S2U("\nTo: "),      pAM->GetTo());
				HeaderToString (rText, S2U("\nSubject: "), pAM->GetSubject());
			}
			delete pAM;
		}
		else
		{
			String aLine;
			pStrm->Seek (STREAM_SEEK_TO_BEGIN);
			while (!pStrm->IsEof())
			{
				pStrm->ReadByteStringLine (aLine);
				rText += aLine;
				rText += sal_Unicode('\n');
			}
		}

		// Cleanup.
		rMsg.SetDocumentStream (NULL);
		delete pStrm;
	}
}

/*
 * RecvMessageToString.
 */
void MyWin::RecvMessageToString (
	String &rText, INetCoreMIMEMessage &rMsg)
{
	//  RFC822.
	HeaderToString (rText, S2U("\nBCC: "),         rMsg.GetBCC());
	HeaderToString (rText, S2U("\nCC: "),          rMsg.GetCC());
	HeaderToString (rText, S2U("\nComments: "),    rMsg.GetComments());
	MessageDateToString (rText, rMsg);
	HeaderToString (rText, S2U("\nFrom: "),        rMsg.GetFrom());
	HeaderToString (rText, S2U("\nIn-Reply-To: "), rMsg.GetInReplyTo());
	HeaderToString (rText, S2U("\nKeywords: "),    rMsg.GetKeywords());
	HeaderToString (rText, S2U("\nMessage-ID: "),  rMsg.GetMessageID());
	HeaderToString (rText, S2U("\nReceived: "),    rMsg.GetReceived());
	HeaderToString (rText, S2U("\nReferences: "),  rMsg.GetReferences());
	HeaderToString (rText, S2U("\nReply-To: "),    rMsg.GetReplyTo());
	HeaderToString (rText, S2U("\nReturn-Path: "), rMsg.GetReturnPath());
	HeaderToString (rText, S2U("\nSubject: "),     rMsg.GetSubject());
	HeaderToString (rText, S2U("\nSender: "),      rMsg.GetSender());
	HeaderToString (rText, S2U("\nTo: "),          rMsg.GetTo());
	HeaderToString (rText, S2U("\nX-Mailer: "),    rMsg.GetXMailer());

	// MIME.
	HeaderToString (
		rText, S2U("\nMIME-Version: "),        rMsg.GetMIMEVersion());
	HeaderToString (
		rText, S2U("\nContent-Description: "), rMsg.GetContentDescription());
	HeaderToString (
		rText, S2U("\nContent-Disposition: "), rMsg.GetContentDisposition());
	HeaderToString (
		rText, S2U("\nContent-ID: "),          rMsg.GetContentID());
	HeaderToString (
		rText, S2U("\nContent-Type: "),        rMsg.GetContentType());
	HeaderToString (
		rText, S2U("\nContent-Transfer-Encoding: "),
		rMsg.GetContentTransferEncoding());
}

/*
 * NewsMessageToString.
 */
void MyWin::NewsMessageToString (
	String &rText, INetCoreNewsMessage &rMsg)
{
	// Base.
	RecvMessageToString (rText, rMsg);

	// News.
	HeaderToString (rText, S2U("\nNewsgroups: "),   rMsg.GetNewsgroups());
	HeaderToString (rText, S2U("\nPath: "),         rMsg.GetPath());
	HeaderToString (rText, S2U("\nApproved: "),     rMsg.GetApproved());
	HeaderToString (rText, S2U("\nDistribution: "), rMsg.GetDistribution());
	HeaderToString (rText, S2U("\nExpires: "),      rMsg.GetExpires());
	HeaderToString (rText, S2U("\nFollowup-To: "),  rMsg.GetFollowupTo());
	HeaderToString (rText, S2U("\nLines: "),        rMsg.GetLines());
	HeaderToString (rText, S2U("\nOrganization: "), rMsg.GetOrganization());
	HeaderToString (rText, S2U("\nSummary: "),      rMsg.GetSummary());
	HeaderToString (rText, S2U("\nXref: "),         rMsg.GetXref());
	HeaderToString (rText, S2U("\nX-Newsreader: "), rMsg.GetXNewsreader());
}

/*======================================================================
 *
 * MyApp interface.
 *
 *====================================================================*/
class MyApp : public Application
{
public:
	virtual void Main (void);
};

MyApp aMyApp;

/*========================================================================
 *
 * MyApp implementation.
 *
 *======================================================================*/
/*
 * Main.
 */
void MyApp::Main (void)
{
	MyModule aModule;
	if (aModule.isValid())
	{
		Help::EnableBalloonHelp();
		String aUserAgent (S2U("MailTest/1.24 (MIME/1.0)"));

		NAMESPACE_VOS(ORef)<INetConfig> xConfig;
		if (INetConfig::getOrCreate (xConfig))
		{
			// Setup ProxyConfig.
			INetProxyConfig aProxyCfg (xConfig->getProxyConfig());

			// aProxyCfg.setSocksProxy (S2OU("192.109.83.29"), 1080);
			aProxyCfg.setNoProxyList (S2OU("*.stardiv.de"));

			xConfig->setProxyConfig (aProxyCfg);

			// Setup additional configuration.
			// xConfig->setDomainNameServer (S2OU("192.109.83.75"));
			xConfig->setUserAgent (aUserAgent);
		}

		MyWin aMyWin (NULL, WB_APP | WB_STDWORK);
		aMyWin.SetText (aUserAgent);
		aMyWin.Show();

		Execute();
	}
}

