/*************************************************************************
 *
 *  $RCSfile: socktest.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:31:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _VOS_MACROS_HXX_
#include <vos/macros.hxx>
#endif
#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif
#ifndef _GEN_HXX
#include <tools/gen.hxx>
#endif
#ifndef _LINK_HXX
#include <tools/link.hxx>
#endif
#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif
#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#ifndef _TOOLS_INETMSG_HXX
#include <tools/inetmsg.hxx>
#endif
#ifndef _TOOLS_INETSTRM_HXX
#include <tools/inetstrm.hxx>
#endif

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _SV_EDIT_HXX
#include <vcl/edit.hxx>
#endif
#ifndef _SV_HELP_HXX
#include <vcl/help.hxx>
#endif
#ifndef _SV_LSTBOX_HXX
#include <vcl/lstbox.hxx>
#endif
#ifndef _SV_TOOLBOX_HXX
#include <vcl/toolbox.hxx>
#endif
#ifndef _SV_WRKWIN_HXX
#include <vcl/wrkwin.hxx>
#endif

#ifndef _INET_MACROS_HXX
#include <inet/macros.hxx>
#endif
#ifndef _INET_MODULE_HXX
#include <inet/module.hxx>
#endif
#ifndef _INET_CONFIG_HXX
#include <inetcfg.hxx>
#endif

#ifndef _INETDNS_HXX
#include <inetdns.hxx>
#endif
#ifndef _INETHTTP_HXX
#include <inethttp.hxx>
#endif

#include <stdio.h>

#ifdef _USE_NAMESPACE
using namespace inet;
using namespace rtl;
#endif

typedef NAMESPACE_VOS(ORef)<INetHTTPGetRequest> INetHTTPGetRequestRef;

inline UniString S2U (const sal_Char *pszAscii)
{
	return UniString::CreateFromAscii (pszAscii);
}

/*========================================================================
 *
 * MyModule.
 *
 *======================================================================*/
class MyModule
{
public:
	MyModule (void);
	virtual ~MyModule (void);

	sal_Bool isValid (void) const;

private:
	INetModuleApi *m_pApi;
};

MyModule::MyModule (void)
	: m_pApi (INetModule_Impl::getOrCreate())
{
	if (m_pApi)
		m_pApi->acquire();
}

MyModule::~MyModule (void)
{
	if (m_pApi)
		m_pApi->release();
}

sal_Bool MyModule::isValid (void) const
{
	return (!!m_pApi);
}

/*========================================================================
 *
 * MyOutWindow.
 *
 *======================================================================*/
#define MYOUTWINDOW_MAXLINES 500

class MyOutWindow : public ListBox
{
public:
	MyOutWindow (Window *pParent, WinBits nWinStyle);
	~MyOutWindow (void);

	void Append (const String &rLine);
};


MyOutWindow::MyOutWindow (Window *pParent, WinBits nWinStyle)
	: ListBox (pParent, nWinStyle | WB_AUTOHSCROLL)
{
}

MyOutWindow::~MyOutWindow (void)
{
}

void MyOutWindow::Append (const String &rLine)
{
	String aLine (rLine);

	xub_StrLen nPos = aLine.Search ('\n');
	while (nPos != STRING_NOTFOUND)
	{
		if (GetEntryCount() >= MYOUTWINDOW_MAXLINES)
			RemoveEntry(0);
		InsertEntry (aLine.Copy (0, nPos));

		aLine.Erase (0, nPos + 1);
		nPos = aLine.Search ('\n');
	}

	if (GetEntryCount() >= MYOUTWINDOW_MAXLINES)
		RemoveEntry(0);
	InsertEntry (aLine);

	SetTopEntry (MYOUTWINDOW_MAXLINES - 1);
}

/*========================================================================
 *
 * MyRequest.
 *
 *======================================================================*/
struct MyRequest
{
	INetHTTPGetRequestRef m_xRequest;
	INetHTTPMessage       m_aReqMsg;
	INetHTTPMessage       m_aResMsg;
	sal_Bool              m_bNeedHeader;

	MyRequest (void)
		: m_xRequest (NULL), m_bNeedHeader (sal_True)
	{}
	~MyRequest (void)
	{
		m_xRequest.unbind();
	}

	void load (
		const OUString          &rUrl,
		INetHTTPRequestCallback *pfnCB,
		void                    *pDataCB,
		sal_Bool                 bReload = sal_False);

	void showHeader (MyOutWindow *pOutWin);
};

/*
 * load.
 */
void MyRequest::load (
	const OUString          &rUrl,
	INetHTTPRequestCallback *pfnCB,
	void                    *pDataCB,
	sal_Bool                 bReload)
{
	// Initialize Request Message.
	NAMESPACE_VOS(ORef)<INetConfig> xConfig;
	if (INetConfig::getOrCreate (xConfig))
		m_aReqMsg.SetUserAgent (xConfig->getUserAgent());
	m_aReqMsg.SetFrom (S2U ("mhu@stardivision.de"));

	// Initialize Response Message.
	char tmp[L_tmpnam];
	m_aResMsg.SetDocumentName (S2U (tmpnam (tmp)));

	SvFileStream *pFS = new SvFileStream (
		m_aResMsg.GetDocumentName(), STREAM_READWRITE);
	m_aResMsg.SetDocumentLB (new SvAsyncLockBytes (pFS, TRUE));

	// Initialize Request.
	m_xRequest = new INetHTTPGetRequest();
	if (bReload)
		m_xRequest->reloadDocument (
			rUrl, m_aReqMsg, m_aResMsg, pfnCB, pDataCB);
	else
		m_xRequest->loadDocument (
			rUrl, m_aReqMsg, m_aResMsg, pfnCB, pDataCB);
}

/*
 * showHeader.
 */
void MyRequest::showHeader (MyOutWindow *pOutWin)
{
	if (m_bNeedHeader)
		m_bNeedHeader = sal_False;
	else
		return;

	ULONG i, n = m_aResMsg.GetHeaderCount();
	for (i = 0; i < n; i++)
	{
		UniString aText (m_aResMsg.GetHeaderName(i));
		aText.AppendAscii (": ");
		aText.Append (m_aResMsg.GetHeaderValue(i));
		pOutWin->Append (aText);
		
	}

	pOutWin->Append (UniString());
	pOutWin->Update();
}

/*========================================================================
 *
 * MyWin.
 *
 *======================================================================*/
class MyWin : public WorkWindow
{
	ToolBox             *pTool;
	Edit                *pURLEdit;

	MyOutWindow         *m_pHdrWin;
	MyOutWindow         *m_pDocWin;

	MyRequest           *m_pRequest;
	INetCoreDNSResolver *m_pResolver;

	static sal_Bool ResolverCallback (
		sal_Int32 nStatus, INetCoreDNSHostEntry *pHostEntry, void *pData);

	static sal_Bool LoadCallback (
		INetHTTPRequest *pRequest,
		sal_Int32 nReplyCode, const sal_Char *pReplyText, void *pData);
	sal_Bool LoadHandler (
		INetHTTPRequest *pRequest,
		sal_Int32 nReplyCode, const sal_Char *pReplyText);

public:
	MyWin (Window *pParent, WinBits nWinStyle);
	~MyWin (void);

	void Resize (void);
	DECL_LINK   (ToolBarHnd, ToolBox*);
};

/*
 * MyWin.
 */
MyWin::MyWin (Window *pParent, WinBits nWinStyle)
	: WorkWindow (pParent, nWinStyle),
	  m_pRequest (NULL)
{
	// ToolBar.
	pTool = new ToolBox (this, WB_SVLOOK | WB_BORDER);

	pTool->InsertItem  (1, S2U ("Clear"));
	pTool->SetHelpText (1, S2U ("Clears the Output Window"));
	pTool->InsertSeparator();

	pTool->InsertItem  (2, S2U ("Load"));
	pTool->SetHelpText (2, S2U ("Load Document. Start HTTP GET Request"));
	pTool->InsertItem  (3, S2U ("Reload"));
	pTool->SetHelpText (3, S2U ("Reload Document. Start HTTP GET Request"));
	pTool->InsertSeparator();

	pTool->InsertItem  (4, S2U ("Abort"));
	pTool->SetHelpText (4, S2U ("Abort HTTP GET Request"));
	pTool->InsertSeparator();

	pTool->InsertItem  (5, S2U ("DNS"));
	pTool->SetHelpText (5, S2U ("Perform Domain Name Server Lookup"));
	pTool->InsertSeparator();

	pTool->SetClickHdl (LINK (this, MyWin, ToolBarHnd));
	pTool->Show();

	// URL-Edit.
	pURLEdit = new Edit (this);
	pURLEdit->SetReadOnly (FALSE);
	pURLEdit->Show();

	// Header-OutputWindow.
	m_pHdrWin = new MyOutWindow (this, WB_HSCROLL | WB_VSCROLL | WB_BORDER);
	m_pHdrWin->SetReadOnly (TRUE);
	m_pHdrWin->Show();

	// Document-OutputWindow.
	m_pDocWin = new MyOutWindow (this, WB_HSCROLL | WB_VSCROLL | WB_BORDER);
	m_pDocWin->SetReadOnly (TRUE);
	m_pDocWin->Show();

	// Resolver.
	m_pResolver = new INetCoreDNSResolver();
}

/*
 * ~MyWin.
 */
MyWin::~MyWin (void)
{
	delete m_pRequest;
	delete m_pResolver;

	delete m_pDocWin;
	delete m_pHdrWin;
	delete pURLEdit;
	delete pTool;
}

/*
 * Resize.
 */
void MyWin::Resize (void)
{
	Size aWinSize (GetOutputSizePixel());
	int nWinW = aWinSize.Width();
	int nWinH = aWinSize.Height();

	int nBoxH = pTool->CalcWindowSizePixel().Height();
	pTool->SetPosSizePixel (Point (0, 0), Size (nWinW, nBoxH));

	pURLEdit->SetPosSizePixel (
		Point (    0, nBoxH),
		Size  (nWinW, nBoxH) );

	int nHdrX = 0;
	int nHdrY = nBoxH + nBoxH;
	int nHdrW = nWinW / 3;
	int nHdrH = nWinH - nHdrY;

	int nDocX = nHdrX + nHdrW;
	int nDocY = nHdrY;
	int nDocW = nWinW - nHdrW;
	int nDocH = nHdrH;

	m_pHdrWin->SetPosSizePixel (Point (nHdrX, nHdrY), Size (nHdrW, nHdrH));
	m_pDocWin->SetPosSizePixel (Point (nDocX, nDocY), Size (nDocW, nDocH));
}

/*
 * ToolBarHnd.
 */
IMPL_LINK (MyWin, ToolBarHnd, ToolBox*, pTool)
{
	USHORT nItemId = pTool->GetCurItemId();
	String aCmdLine = pURLEdit->GetText();

	switch (nItemId)
	{
		case 1: // Clear.
			m_pHdrWin->Clear();
			m_pHdrWin->Show();
			m_pDocWin->Clear();
			m_pDocWin->Show();
			break;

		case 2: // Load.
			if (aCmdLine.Len())
			{
				delete m_pRequest;
				m_pRequest = new MyRequest();
				m_pRequest->load (aCmdLine, LoadCallback, this, sal_False);
			}
			break;

		case 3: // Reload.
			if (aCmdLine.Len())
			{
				delete m_pRequest;
				m_pRequest = new MyRequest();
				m_pRequest->load (aCmdLine, LoadCallback, this, sal_True);
			}
			break;

		case 4: // Abort.
			if (m_pRequest)
			{
				delete m_pRequest;
				m_pRequest = NULL;
			}
			break;

		case 5: // DNS.
			if (aCmdLine.Len())
			{
#if 1  /* DNS */
				INetCoreDNSHostEntry *he = new INetCoreDNSHostEntry (aCmdLine);
				m_pResolver->GetHostByName (he, ResolverCallback, this);
#endif /* DNS */
#if 1  /* TEST */
				he = new INetCoreDNSHostEntry (S2U ("172.17.1.254"));
				m_pResolver->GetHostByAddress (he, ResolverCallback, this);
#endif /* TEST */
			}
			break;

		default: // ignored.
			break;
	} // switch (nItemId)

	return 0;
}

/*
 * ResolverCallback.
 */
sal_Bool MyWin::ResolverCallback (
	sal_Int32 nStatus, INetCoreDNSHostEntry *pHostEntry, void *pData)
{
	MyWin *pThis = SAL_REINTERPRET_CAST(MyWin*, pData);
	if (pThis)
	{
		if (!(nStatus == INETCOREDNS_RESOLVER_START))
		{
			NAMESPACE_VOS(OGuard) aGuard (Application::GetSolarMutex());

			String aText (S2U ("ResolverCallback: Status: "));
			aText += UniString::CreateFromInt32 (nStatus);

			if ((nStatus == INETCOREDNS_RESOLVER_SUCCESS) ||
				(nStatus == INETCOREDNS_RESOLVER_EXPIRED)    )
			{
				aText.AppendAscii ("\nHOST:  ");
				aText += UniString (pHostEntry->GetDomainName());

				aText.AppendAscii ("\nCNAME: ");
				aText += UniString (pHostEntry->GetCanonicalName());

				aText.AppendAscii ("\nADDR:  ");
				aText += UniString (pHostEntry->GetDottedDecimalName());
			}

			delete pHostEntry;

			pThis->m_pHdrWin->Append (aText);
			pThis->m_pHdrWin->Update();
		}
	}
	return 1;
}

/*
 * LoadCallback.
 */
sal_Bool MyWin::LoadCallback (
	INetHTTPRequest *pRequest,
	sal_Int32 nReplyCode, const sal_Char *pReplyText, void *pData)
{

	MyWin *pThis = SAL_REINTERPRET_CAST(MyWin*, pData);
	if (pThis)
	{
		NAMESPACE_VOS(OGuard) aGuard (Application::GetSolarMutex());
		return pThis->LoadHandler (pRequest, nReplyCode, pReplyText);
	}
	return sal_False;
}

/*
 * LoadHandler.
 */
sal_Bool MyWin::LoadHandler (
	INetHTTPRequest *pRequest,
	sal_Int32 nReplyCode, const sal_Char *pReplyText)
{
	String aText (S2U ("Status: "));
	aText += UniString::CreateFromInt32(pRequest->getStatusCode());
	aText.AppendAscii (" (Code: ");
	aText += UniString::CreateFromInt32(nReplyCode);
	aText.AppendAscii (") (Length: ");
	aText += UniString::CreateFromInt32(pRequest->getResponseDocumentLength());
	aText += sal_Unicode(')');

	m_pHdrWin->Append (aText);
	m_pHdrWin->Update();

	// Dispatch.
	if (nReplyCode < 0)
	{
		typedef INetHTTPRequest reply_t;
		switch (nReplyCode)
		{
			case reply_t::REPLY_NETWORK_ERROR:
			case reply_t::REPLY_RESOLVER_ERROR:
			case reply_t::REPLY_CONNECT_ERROR:
			case reply_t::REPLY_REQUEST_ERROR:
			case reply_t::REPLY_RESPONSE_ERROR:
				delete m_pRequest;
				m_pRequest = NULL;
				break;

			case reply_t::REPLY_RESOLVER_DONE:
				break;

			case reply_t::REPLY_CONNECT_DONE:
				break;

			case reply_t::REPLY_RESPONSE_WAIT:
				if (m_pRequest && pRequest->isResponseHeaderParsed())
					m_pRequest->showHeader (m_pHdrWin);
				break;
			default: // Ignored.
				break;
		}
	}
	else if (m_pRequest)
	{
		// Display headers.
		if (pRequest->isResponseHeaderParsed())
			m_pRequest->showHeader (m_pHdrWin);
		
		// Display document.
		char buffer[2048];
		int  nRead;

		SvStream aOStream (m_pRequest->m_aResMsg.GetDocumentLB());
		aOStream.Seek (STREAM_SEEK_TO_BEGIN);

		aText.Erase();
		while ((nRead = aOStream.Read (buffer, sizeof (buffer) - 1)) > 0)
		{
			buffer[nRead] = '\0';
			aText.AppendAscii (buffer);
		}

		m_pDocWin->Append (aText);
		m_pDocWin->Update();
	}
	return sal_True;
}

/*========================================================================
 *
 * MyApp.
 *
 *======================================================================*/
class MyApp : public Application
{
public:
    virtual void Main (void);
};

MyApp aMyApp;

/*
 * Main.
 */
void MyApp::Main (void)
{
	MyModule aModule;
	if (aModule.isValid())
	{
		Help::EnableBalloonHelp();
		String aUserAgent (S2U ("HttpTest/1.24"));

		NAMESPACE_VOS(ORef)<INetConfig> xConfig;
		if (INetConfig::getOrCreate (xConfig))
		{
			INetProxyConfig aProxyConfig (xConfig->getProxyConfig());
			// aProxyConfig.setSocksProxy (S2U("172.17.12.4"), 1080);
			aProxyConfig.setNoProxyList (S2U("*.stardiv.de"));
			xConfig->setProxyConfig (aProxyConfig);

			xConfig->setDomainNameServer (S2U("192.109.83.75"));
			xConfig->setUserAgent (aUserAgent);
		}

		MyWin aMyWin (NULL, WB_APP | WB_STDWORK);
		aMyWin.SetText (aUserAgent);
		aMyWin.Show();

		Execute();
	}
}

