/*************************************************************************
 *
 *  $RCSfile: t_base.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:31:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _VOS_THREAD_HXX_
#include <vos/thread.hxx>
#endif

#ifndef _INET_MACROS_HXX
#include <inet/macros.hxx>
#endif
#ifndef _INET_MODULE_HXX
#include <inet/module.hxx>
#endif
#ifndef _INET_CONFIG_HXX
#include <inetcfg.hxx>
#endif

#ifndef _INETDNS_HXX
#include <inetdns.hxx>
#endif

#ifdef _USE_NAMESPACE
using namespace inet;
using namespace rtl;
#endif

inline OUString S2U (const sal_Char *pszAscii)
{
	return OUString::createFromAscii (pszAscii);
}

/*========================================================================
 *
 * MyModule.
 *
 *======================================================================*/
class MyModule
{
public:
	MyModule (void);
	~MyModule (void);

	sal_Bool isValid (void) const;
	static void wait (sal_uInt32 nMilliSec);

private:
	INetModuleApi *m_pApi;
};

MyModule::MyModule (void)
	: m_pApi (INetModule_Impl::getOrCreate())
{
	if (m_pApi)
		m_pApi->acquire();
}

MyModule::~MyModule (void)
{
	if (m_pApi)
		m_pApi->release();
}

sal_Bool MyModule::isValid (void) const
{
	return (!!m_pApi);
}

void MyModule::wait (sal_uInt32 nMilliSec)
{
	TimeValue tv;
	tv.Seconds = nMilliSec / 1000;
	tv.Nanosec = 0;

	NAMESPACE_VOS(OThread)::wait (tv);
}

/*========================================================================
 *
 * MyResolverProc.
 *
 *======================================================================*/
static sal_Bool MyResolverProc (
	sal_Int32 nStatus, INetCoreDNSHostEntry *pHostEntry, void *pData)
{
	if (!(nStatus == INETCOREDNS_RESOLVER_START))
	{
		delete pHostEntry;
	}
	return sal_True;
}

/*========================================================================
 *
 * Main.
 *
 *======================================================================*/
int SAL_CALL main (int argc, char **argv)
{
	MyModule aModule;
	if (aModule.isValid())
	{
		INetCoreDNSResolver aResolver;

		aResolver.GetHostByName (
			new INetCoreDNSHostEntry (S2U ("localhost"), 1080),
			MyResolverProc, NULL);
		aModule.wait (10000);

		aResolver.GetHostByName (
			new INetCoreDNSHostEntry (S2U ("munch"), 21),
			MyResolverProc, NULL);
		aModule.wait (10000);
	}
	return 0;
}

